


FLEX(1)                   User Commands                   FLEX(1)



NNNNAAAAMMMMEEEE
     flex - fast lexical analyzer generator

SSSSYYYYNNNNOOOOPPPPSSSSIIIISSSS
     fffflllleeeexxxx [[[[----bbbbccccddddffffhhhhiiiillllnnnnppppssssttttvvvvwwwwBBBBFFFFIIIILLLLTTTTVVVV77778888++++ ----CCCC[[[[aaaaeeeeffffFFFFmmmmrrrr]]]] ----PPPPpppprrrreeeeffffiiiixxxx  ---- SSSSsssskkkkeeeelllleeee----
     ttttoooonnnn]]]] [_f_i_l_e_n_a_m_e ...]

DDDDEEEESSSSCCCCRRRRIIIIPPPPTTTTIIIIOOOONNNN
     _f_l_e_x is a  tool  for  generating  _s_c_a_n_n_e_r_s:  programs  which
     recognized  lexical  patterns in text.  _f_l_e_x reads the given
     input files, or its standard input  if  no  file  names  are
     given,  for  a  description  of  a scanner to generate.  The
     description is in the form of pairs of  regular  expressions
     and  C  code,  called  _r_u_l_e_s.  _f_l_e_x  generates as output a C
     source file, lllleeeexxxx....yyyyyyyy....cccc,,,, which defines a routine yyyyyyyylllleeeexxxx(((()))).... This
     file is compiled and linked with the ----llllffffllll library to produce
     an executable.  When the executable is run, it analyzes  its
     input  for occurrences of the regular expressions.  Whenever
     it finds one, it executes the corresponding C code.

     For full documentation, see fffflllleeeexxxxddddoooocccc((((1111)))).... This manual entry is
     intended for use as a quick reference.

OOOOPPPPTTTTIIIIOOOONNNNSSSS
     _f_l_e_x has the following options:

     ----bbbb    generate backing-up information to _l_e_x._b_a_c_k_u_p. This is
          a  list  of scanner states which require backing up and
          the input characters on which they do  so.   By  adding
          rules   one  can  remove  backing-up  states.   If  all
          backing-up states are eliminated and ----CCCCffff  or   ---- CCCCFFFF  is
          used, the generated scanner will run faster.

     ----cccc    is a do-nothing, deprecated option included for  POSIX
          compliance.

          NNNNOOOOTTTTEEEE:::: in previous releases of _f_l_e_x ----cccc specified  table-
          compression  options.   This functionality is now given
          by the ----CCCC flag.  To ease the the impact of this change,
          when  _f_l_e_x encounters ----cccc,,,, it currently issues a warning
          message and assumes that ----CCCC was  desired  instead.   In
          the future this "promotion" of ----cccc to ----CCCC will go away in
          the name of full POSIX  compliance  (unless  the  POSIX
          meaning is removed first).

     ----dddd    makes the generated scanner run in _d_e_b_u_g mode.   When-
          ever   a   pattern   is   recognized   and  the  global
          yyyyyyyy____fffflllleeeexxxx____ddddeeeebbbbuuuugggg is non-zero (which is the  default),  the
          scanner will write to _s_t_d_e_r_r a line of the form:

              --accepting rule at line 53 ("the matched text")




Version 2.4        Last change: November 1993                   1






FLEX(1)                   User Commands                   FLEX(1)



          The line number refers to the location of the  rule  in
          the  file defining the scanner (i.e., the file that was
          fed to flex).  Messages are  also  generated  when  the
          scanner backs up, accepts the default rule, reaches the
          end of its input buffer (or encounters a NUL;  the  two
          look  the  same  as far as the scanner's concerned), or
          reaches an end-of-file.

     ----ffff    specifies _f_a_s_t _s_c_a_n_n_e_r. No table compression  is  done
          and  stdio  is bypassed.  The result is large but fast.
          This option is equivalent to ----CCCCffffrrrr (see below).

     ----hhhh    generates a "help" summary of _f_l_e_x'_s options to _s_t_d_e_r_r
          and then exits.

     ----iiii    instructs _f_l_e_x to generate a _c_a_s_e-_i_n_s_e_n_s_i_t_i_v_e scanner.
          The  case  of  letters given in the _f_l_e_x input patterns
          will be ignored,  and  tokens  in  the  input  will  be
          matched  regardless of case.  The matched text given in
          _y_y_t_e_x_t will have the preserved case (i.e., it will  not
          be folded).

     ----llll    turns on maximum compatibility with the original  AT&T
          lex implementation, at a considerable performance cost.
          This option is incompatible with ----++++,,,, ----ffff,,,, ----FFFF,,,, ----CCCCffff,,,, or  ----
          CCCCFFFF.... See _f_l_e_x_d_o_c(_1) for details.

     ----nnnn    is another do-nothing, deprecated option included only
          for POSIX compliance.

     ----pppp    generates a performance report to stderr.  The  report
          consists  of  comments  regarding  features of the _f_l_e_x
          input file which will cause a loss  of  performance  in
          the resulting scanner.  If you give the flag twice, you
          will also get comments regarding features that lead  to
          minor performance losses.

     ----ssss    causes the _d_e_f_a_u_l_t _r_u_l_e (that unmatched scanner  input
          is  echoed to _s_t_d_o_u_t) to be suppressed.  If the scanner
          encounters input that does not match any of its  rules,
          it aborts with an error.

     ----tttt    instructs _f_l_e_x to write the scanner  it  generates  to
          standard output instead of lllleeeexxxx....yyyyyyyy....cccc....

     ----vvvv    specifies that _f_l_e_x should write to _s_t_d_e_r_r  a  summary
          of statistics regarding the scanner it generates.

     ----wwww    suppresses warning messages.

     ----BBBB    instructs _f_l_e_x to generate a _b_a_t_c_h scanner instead  of
          an  _i_n_t_e_r_a_c_t_i_v_e scanner (see ----IIII below).  See _f_l_e_x_d_o_c(_1)



Version 2.4        Last change: November 1993                   2






FLEX(1)                   User Commands                   FLEX(1)



          for details.  Scanners using ----CCCCffff or   ---- CCCCFFFF  compression
          options automatically specify this option, too.

     ----FFFF    specifies that the _f_a_s_t scanner  table  representation
          should  be used (and stdio bypassed).  This representa-
          tion is about as fast as the full table  representation
          ((((----ffff)))),,,,  and  for some sets of patterns will be consider-
          ably smaller (and for others, larger).   It  cannot  be
          used  with  the   ---- ++++  option.  See fffflllleeeexxxxddddoooocccc((((1111)))) for more
          details.

          This option is equivalent to ----CCCCFFFFrrrr (see below).

     ----IIII    instructs _f_l_e_x to  generate  an  _i_n_t_e_r_a_c_t_i_v_e  scanner,
          that  is, a scanner which stops immediately rather than
          looking ahead if it knows that  the  currently  scanned
          text  cannot be part of a longer rule's match.  This is
          the opposite of _b_a_t_c_h scanners (see  ---- BBBB  above).   See
          fffflllleeeexxxxddddoooocccc((((1111)))) for details.

          Note, ----IIII cannot be used in  conjunction  with  _f_u_l_l  or
          _f_a_s_t  _t_a_b_l_e_s, i.e., the ----ffff,,,, ----FFFF,,,, ----CCCCffff,,,, or ----CCCCFFFF flags.  For
          other table compression options, ----IIII is the default.

     ----LLLL    instructs _f_l_e_x not to  generate  ####lllliiiinnnneeee  directives  in
          lllleeeexxxx....yyyyyyyy....cccc.... The default is to generate such directives so
          error messages in the actions will be correctly located
          with  respect  to the original _f_l_e_x input file, and not
          to the fairly meaningless line numbers of lllleeeexxxx....yyyyyyyy....cccc....

     ----TTTT    makes _f_l_e_x run in _t_r_a_c_e mode.  It will generate a  lot
          of  messages to _s_t_d_e_r_r concerning the form of the input
          and the resultant non-deterministic  and  deterministic
          finite  automata.   This  option  is  mostly for use in
          maintaining _f_l_e_x.

     ----VVVV    prints the version number to _s_t_d_e_r_r and exits.

     ----7777    instructs _f_l_e_x to generate a 7-bit scanner, which  can
          save  considerable table space, especially when using ----
          CCCCffff or ----CCCCFFFF (and, at most sites, ----7777 is on by default  for
          these  options.  To see if this is the case, use the ----vvvv
          verbose flag and check the flag summary it reports).

     ----8888    instructs _f_l_e_x to generate an 8-bit scanner.  This  is
          the  default  except  for  the  ----CCCCffff and ----CCCCFFFF compression
          options, for which the default is  site-dependent,  and
          can be checked by inspecting the flag summary generated
          by the ----vvvv option.

     ----++++    specifies that you want flex to generate a C++ scanner
          class.   See  the section on Generating C++ Scanners in



Version 2.4        Last change: November 1993                   3






FLEX(1)                   User Commands                   FLEX(1)



          _f_l_e_x_d_o_c(_1) for details.

     ----CCCC[[[[aaaaeeeeffffFFFFmmmmrrrr]]]]
          controls the degree of table  compression  and  scanner
          optimization.

          ----CCCCaaaa trade off larger tables in  the  generated  scanner
          for  faster  performance  because  the  elements of the
          tables are better aligned for memory access and  compu-
          tation.   This option can double the size of the tables
          used by your scanner.

          ----CCCCeeee directs  _f_l_e_x  to  construct  _e_q_u_i_v_a_l_e_n_c_e  _c_l_a_s_s_e_s,
          i.e.,  sets  of characters which have identical lexical
          properties.  Equivalence classes usually give  dramatic
          reductions  in the final table/object file sizes (typi-
          cally  a  factor  of  2-5)   and   are   pretty   cheap
          performance-wise   (one  array  look-up  per  character
          scanned).

          ----CCCCffff specifies that the _f_u_l_l scanner  tables  should  be
          generated - _f_l_e_x should not compress the tables by tak-
          ing advantages of similar transition functions for dif-
          ferent states.

          ----CCCCFFFF specifies that the alternate fast scanner represen-
          tation  (described in fffflllleeeexxxxddddoooocccc((((1111)))))))) should be used.  This
          option cannot be used with ----++++....

          ----CCCCmmmm directs _f_l_e_x to construct _m_e_t_a-_e_q_u_i_v_a_l_e_n_c_e _c_l_a_s_s_e_s,
          which  are  sets of equivalence classes (or characters,
          if equivalence classes are not  being  used)  that  are
          commonly  used  together.  Meta-equivalence classes are
          often a big win when using compressed tables, but  they
          have  a  moderate  performance  impact (one or two "if"
          tests and one array look-up per character scanned).

          ----CCCCrrrr causes the generated scanner to _b_y_p_a_s_s using  stdio
          for  input.   In general this option results in a minor
          performance gain only worthwhile if used in conjunction
          with   ---- CCCCffff or ----CCCCFFFF.... It can cause surprising behavior if
          you use stdio yourself to read from _y_y_i_n prior to  cal-
          ling the scanner.

          A lone ----CCCC specifies that the scanner tables  should  be
          compressed  but  neither  equivalence classes nor meta-
          equivalence classes should be used.

          The options ----CCCCffff or ----CCCCFFFF and   ---- CCCCmmmm  do  not  make  sense
          together - there is no opportunity for meta-equivalence
          classes if the table is not being  compressed.   Other-
          wise the options may be freely mixed.



Version 2.4        Last change: November 1993                   4






FLEX(1)                   User Commands                   FLEX(1)



          The default setting is ----CCCCeeeemmmm,,,, which specifies that  _f_l_e_x
          should   generate   equivalence   classes   and   meta-
          equivalence classes.  This setting provides the highest
          degree   of  table  compression.   You  can  trade  off
          faster-executing scanners at the cost of larger  tables
          with the following generally being true:

              slowest & smallest
                    -Cem
                    -Cm
                    -Ce
                    -C
                    -C{f,F}e
                    -C{f,F}
                    -C{f,F}a
              fastest & largest


          ----CCCC options are cumulative.

     ----PPPPpppprrrreeeeffffiiiixxxx
          changes the default _y_y prefix used by _f_l_e_x to be _p_r_e_f_i_x
          instead.   See  _f_l_e_x_d_o_c(_1) for a description of all the
          global variables and file names that this affects.

     ----SSSSsssskkkkeeeelllleeeettttoooonnnn____ffffiiiilllleeee
          overrides the default skeleton  file  from  which  _f_l_e_x
          constructs its scanners.  You'll never need this option
          unless you are doing _f_l_e_x maintenance or development.

SSSSUUUUMMMMMMMMAAAARRRRYYYY OOOOFFFF FFFFLLLLEEEEXXXX RRRREEEEGGGGUUUULLLLAAAARRRR EEEEXXXXPPPPRRRREEEESSSSSSSSIIIIOOOONNNNSSSS
     The patterns in the input are written using an extended  set
     of regular expressions.  These are:

         x          match the character 'x'
         .          any character except newline
         [xyz]      a "character class"; in this case, the pattern
                      matches either an 'x', a 'y', or a 'z'
         [abj-oZ]   a "character class" with a range in it; matches
                      an 'a', a 'b', any letter from 'j' through 'o',
                      or a 'Z'
         [^A-Z]     a "negated character class", i.e., any character
                      but those in the class.  In this case, any
                      character EXCEPT an uppercase letter.
         [^A-Z\n]   any character EXCEPT an uppercase letter or
                      a newline
         r*         zero or more r's, where r is any regular expression
         r+         one or more r's
         r?         zero or one r's (that is, "an optional r")
         r{2,5}     anywhere from two to five r's
         r{2,}      two or more r's
         r{4}       exactly 4 r's



Version 2.4        Last change: November 1993                   5






FLEX(1)                   User Commands                   FLEX(1)



         {name}     the expansion of the "name" definition
                    (see above)
         "[xyz]\"foo"
                    the literal string: [xyz]"foo
         \X         if X is an 'a', 'b', 'f', 'n', 'r', 't', or 'v',
                      then the ANSI-C interpretation of \x.
                      Otherwise, a literal 'X' (used to escape
                      operators such as '*')
         \123       the character with octal value 123
         \x2a       the character with hexadecimal value 2a
         (r)        match an r; parentheses are used to override
                      precedence (see below)


         rs         the regular expression r followed by the
                      regular expression s; called "concatenation"


         r|s        either an r or an s


         r/s        an r but only if it is followed by an s.  The
                      s is not part of the matched text.  This type
                      of pattern is called as "trailing context".
         ^r         an r, but only at the beginning of a line
         r$         an r, but only at the end of a line.  Equivalent
                      to "r/\n".


         <s>r       an r, but only in start condition s (see
                    below for discussion of start conditions)
         <s1,s2,s3>r
                    same, but in any of start conditions s1,
                    s2, or s3
         <*>r       an r in any start condition, even an exclusive one.


         <<EOF>>    an end-of-file
         <s1,s2><<EOF>>
                    an end-of-file when in start condition s1 or s2

     The regular expressions listed above are  grouped  according
     to  precedence, from highest precedence at the top to lowest
     at the bottom.   Those  grouped  together  have  equal  pre-
     cedence.

     Some notes on patterns:

     -    Negated character classes _m_a_t_c_h  _n_e_w_l_i_n_e_s  unless  "\n"
          (or  an equivalent escape sequence) is one of the char-
          acters explicitly  present  in  the  negated  character
          class (e.g., "[^A-Z\n]").



Version 2.4        Last change: November 1993                   6






FLEX(1)                   User Commands                   FLEX(1)



     -    A rule can have at most one instance of  trailing  con-
          text (the '/' operator or the '$' operator).  The start
          condition, '^', and "<<EOF>>" patterns can  only  occur
          at the beginning of a pattern, and, as well as with '/'
          and '$', cannot be  grouped  inside  parentheses.   The
          following are all illegal:

              foo/bar$
              foo|(bar$)
              foo|^bar
              <sc1>foo<sc2>bar


SSSSUUUUMMMMMMMMAAAARRRRYYYY OOOOFFFF SSSSPPPPEEEECCCCIIIIAAAALLLL AAAACCCCTTTTIIIIOOOONNNNSSSS
     In addition to arbitrary C code, the following can appear in
     actions:

     -    EEEECCCCHHHHOOOO copies yytext to the scanner's output.

     -    BBBBEEEEGGGGIIIINNNN followed by the name of a start condition  places
          the scanner in the corresponding start condition.

     -    RRRREEEEJJJJEEEECCCCTTTT directs the scanner to proceed on to the "second
          best"  rule which matched the input (or a prefix of the
          input).  yyyyyyyytttteeeexxxxtttt and yyyyyyyylllleeeennnngggg are  set  up  appropriately.
          Note that RRRREEEEJJJJEEEECCCCTTTT is a particularly expensive feature in
          terms scanner performance; if it is used in _a_n_y of  the
          scanner's   actions  it  will  slow  down  _a_l_l  of  the
          scanner's matching.  Furthermore, RRRREEEEJJJJEEEECCCCTTTT cannot be used
          with the ----ffff or ----FFFF options.

          Note also that unlike the other special actions, RRRREEEEJJJJEEEECCCCTTTT
          is  a  _b_r_a_n_c_h;  code  immediately  following  it in the
          action will _n_o_t be executed.

     -    yyyyyyyymmmmoooorrrreeee(((()))) tells  the  scanner  that  the  next  time  it
          matches  a  rule,  the  corresponding  token  should be
          _a_p_p_e_n_d_e_d onto the current value of yyyyyyyytttteeeexxxxtttt  rather  than
          replacing it.

     -    yyyyyyyylllleeeessssssss((((nnnn)))) returns all but the first _n characters of the
          current token back to the input stream, where they will
          be rescanned when the scanner looks for the next match.
          yyyyyyyytttteeeexxxxtttt  and  yyyyyyyylllleeeennnngggg  are  adjusted appropriately (e.g.,
          yyyyyyyylllleeeennnngggg will now be equal to _n ).

     -    uuuunnnnppppuuuutttt((((cccc)))) puts the  character  _c  back  onto  the  input
          stream.  It will be the next character scanned.

     -    iiiinnnnppppuuuutttt(((()))) reads the next character from the input  stream
          (this  routine  is  called  yyyyyyyyiiiinnnnppppuuuutttt(((()))) if the scanner is
          compiled using CCCC++++++++))))....



Version 2.4        Last change: November 1993                   7






FLEX(1)                   User Commands                   FLEX(1)



     -    yyyyyyyytttteeeerrrrmmmmiiiinnnnaaaatttteeee(((()))) can be used in lieu of a return statement
          in  an action.  It terminates the scanner and returns a
          0 to the scanner's caller, indicating "all done".

          By default, yyyyyyyytttteeeerrrrmmmmiiiinnnnaaaatttteeee(((()))) is also called when  an  end-
          of-file is encountered.  It is a macro and may be rede-
          fined.

     -    YYYYYYYY____NNNNEEEEWWWW____FFFFIIIILLLLEEEE is an  action  available  only  in  <<EOF>>
          rules.   It  means "Okay, I've set up a new input file,
          continue scanning".  It is no longer required; you  can
          just  assign _y_y_i_n to point to a new file in the <<EOF>>
          action.

     -    yyyyyyyy____ccccrrrreeeeaaaatttteeee____bbbbuuuuffffffffeeeerrrr(((( ffffiiiilllleeee,,,, ssssiiiizzzzeeee )))) takes a _F_I_L_E pointer and
          an integer _s_i_z_e. It returns a YY_BUFFER_STATE handle to
          a new input buffer  large  enough  to  accomodate  _s_i_z_e
          characters and associated with the given file.  When in
          doubt, use YYYYYYYY____BBBBUUUUFFFF____SSSSIIIIZZZZEEEE for the size.

     -    yyyyyyyy____sssswwwwiiiittttcccchhhh____ttttoooo____bbbbuuuuffffffffeeeerrrr((((   nnnneeeewwww____bbbbuuuuffffffffeeeerrrr   ))))   switches    the
          scanner's  processing to scan for tokens from the given
          buffer, which must be a YY_BUFFER_STATE.

     -    yyyyyyyy____ddddeeeelllleeeetttteeee____bbbbuuuuffffffffeeeerrrr(((( bbbbuuuuffffffffeeeerrrr )))) deletes the given buffer.

VVVVAAAALLLLUUUUEEEESSSS AAAAVVVVAAAAIIIILLLLAAAABBBBLLLLEEEE TTTTOOOO TTTTHHHHEEEE UUUUSSSSEEEERRRR
     -    cccchhhhaaaarrrr ****yyyyyyyytttteeeexxxxtttt holds the text of the current  token.   It
          may  be  modified but not lengthened (you cannot append
          characters to the end).  Modifying the  last  character
          may  affect  the  activity  of rules anchored using '^'
          during the next scan; see fffflllleeeexxxxddddoooocccc((((1111)))) for details.

          If the special directive %%%%aaaarrrrrrrraaaayyyy appears  in  the  first
          section  of  the  scanner  description,  then yyyyyyyytttteeeexxxxtttt is
          instead declared cccchhhhaaaarrrr yyyyyyyytttteeeexxxxtttt[[[[YYYYYYYYLLLLMMMMAAAAXXXX]]]],,,, where YYYYYYYYLLLLMMMMAAAAXXXX is a
          macro  definition  that  you  can redefine in the first
          section if you don't like the default value  (generally
          8KB).    Using   %%%%aaaarrrrrrrraaaayyyy   results  in  somewhat  slower
          scanners, but the value of  yyyyyyyytttteeeexxxxtttt  becomes  immune  to
          calls to _i_n_p_u_t() and _u_n_p_u_t(), which potentially destroy
          its value when yyyyyyyytttteeeexxxxtttt  is  a  character  pointer.   The
          opposite of %%%%aaaarrrrrrrraaaayyyy is %%%%ppppooooiiiinnnntttteeeerrrr,,,, which is the default.

          You cannot  use  %%%%aaaarrrrrrrraaaayyyy  when  generating  C++  scanner
          classes (the ----++++ flag).

     -    iiiinnnntttt yyyyyyyylllleeeennnngggg holds the length of the current token.

     -    FFFFIIIILLLLEEEE ****yyyyyyyyiiiinnnn is the file  which  by  default  _f_l_e_x  reads
          from.   It  may  be  redefined  but doing so only makes
          sense before scanning begins or after an EOF  has  been



Version 2.4        Last change: November 1993                   8






FLEX(1)                   User Commands                   FLEX(1)



          encountered.  Changing it in the midst of scanning will
          have unexpected results since _f_l_e_x buffers  its  input;
          use  yyyyyyyyrrrreeeessssttttaaaarrrrtttt(((())))  instead.   Once  scanning  terminates
          because an end-of-file has been seen,  yyyyoooouuuu  ccccaaaannnn  aaaassssssssiiiiggggnnnn
          _y_y_i_n  at  the  new input file and then call the scanner
          again to continue scanning.

     -    vvvvooooiiiidddd yyyyyyyyrrrreeeessssttttaaaarrrrtttt(((( FFFFIIIILLLLEEEE ****nnnneeeewwww____ffffiiiilllleeee )))) may be called to point
          _y_y_i_n at the new input file.  The switch-over to the new
          file is immediate (any previously buffered-up input  is
          lost).   Note  that calling yyyyyyyyrrrreeeessssttttaaaarrrrtttt(((()))) with _y_y_i_n as an
          argument thus throws away the current input buffer  and
          continues scanning the same input file.

     -    FFFFIIIILLLLEEEE ****yyyyyyyyoooouuuutttt is the file to which EEEECCCCHHHHOOOO actions are done.
          It can be reassigned by the user.

     -    YYYYYYYY____CCCCUUUURRRRRRRREEEENNNNTTTT____BBBBUUUUFFFFFFFFEEEERRRR returns a YYYYYYYY____BBBBUUUUFFFFFFFFEEEERRRR____SSSSTTTTAAAATTTTEEEE  handle  to
          the current buffer.

     -    YYYYYYYY____SSSSTTTTAAAARRRRTTTT returns an integer value corresponding to  the
          current start condition.  You can subsequently use this
          value with BBBBEEEEGGGGIIIINNNN to return to that start condition.

MMMMAAAACCCCRRRROOOOSSSS AAAANNNNDDDD FFFFUUUUNNNNCCCCTTTTIIIIOOOONNNNSSSS YYYYOOOOUUUU CCCCAAAANNNN RRRREEEEDDDDEEEEFFFFIIIINNNNEEEE
     -    YYYYYYYY____DDDDEEEECCCCLLLL controls how the scanning routine is  declared.
          By  default, it is "int yylex()", or, if prototypes are
          being used, "int yylex(void)".  This definition may  be
          changed  by  redefining the "YY_DECL" macro.  Note that
          if you give arguments to the scanning routine  using  a
          K&R-style/non-prototyped function declaration, you must
          terminate the definition with a semi-colon (;).

     -    The nature of how the scanner gets  its  input  can  be
          controlled    by   redefining   the   YYYYYYYY____IIIINNNNPPPPUUUUTTTT   macro.
          YY_INPUT's         calling         sequence          is
          "YY_INPUT(buf,result,max_size)".    Its  action  is  to
          place up to _m_a_x__s_i_z_e characters in the character  array
          _b_u_f  and  return  in the integer variable _r_e_s_u_l_t either
          the number of characters read or the  constant  YY_NULL
          (0  on  Unix  systems)  to  indicate  EOF.  The default
          YY_INPUT reads from the global file-pointer "yyin".   A
          sample  redefinition  of  YY_INPUT  (in the definitions
          section of the input file):

              %{
              #undef YY_INPUT
              #define YY_INPUT(buf,result,max_size) \
                  { \
                  int c = getchar(); \
                  result = (c == EOF) ? YY_NULL : (buf[0] = c, 1); \
                  }



Version 2.4        Last change: November 1993                   9






FLEX(1)                   User Commands                   FLEX(1)



              %}


     -    When the scanner  receives  an  end-of-file  indication
          from  YY_INPUT,  it  then  checks the function yyyyyyyywwwwrrrraaaapppp(((())))
          function.  If yyyyyyyywwwwrrrraaaapppp(((()))) returns false (zero), then it is
          assumed  that  the  function  has gone ahead and set up
          _y_y_i_n to point to another input file, and scanning  con-
          tinues.   If  it  returns  true  (non-zero),  then  the
          scanner terminates, returning 0 to its caller.

          The default yyyyyyyywwwwrrrraaaapppp(((()))) always returns 1.

     -    YY_USER_ACTION can be redefined to  provide  an  action
          which  is  always  executed prior to the matched rule's
          action.

     -    The macro YYYYYYYY____UUUUSSSSEEEERRRR____IIIINNNNIIIITTTT may be redefined to  provide  an
          action which is always executed before the first scan.

     -    In the generated scanner, the actions are all  gathered
          in  one  large  switch  statement  and  separated using
          YYYYYYYY____BBBBRRRREEEEAAAAKKKK,,,, which may be redefined.  By  default,  it  is
          simply  a  "break", to separate each rule's action from
          the following rule's.

FFFFIIIILLLLEEEESSSS
     ----llllffffllll  library with which to  link  scanners  to  obtain  the
          default versions of _y_y_w_r_a_p() and/or _m_a_i_n().

     _l_e_x._y_y._c
          generated scanner (called _l_e_x_y_y._c on some systems).

     _l_e_x._y_y._c_c
          generated C++ scanner class, when using ----++++....

     <_F_l_e_x_L_e_x_e_r._h>
          header file defining the C++ scanner base class,  FFFFlllleeeexxxx----
          LLLLeeeexxxxeeeerrrr,,,, and its derived class, yyyyyyyyFFFFlllleeeexxxxLLLLeeeexxxxeeeerrrr....

     _f_l_e_x._s_k_l
          skeleton scanner.  This file is only used when building
          flex, not when flex executes.

     _l_e_x._b_a_c_k_u_p
          backing-up information for ----bbbb flag (called  _l_e_x._b_c_k  on
          some systems).

SSSSEEEEEEEE AAAALLLLSSSSOOOO
     flexdoc(1), lex(1), yacc(1), sed(1), awk(1).





Version 2.4        Last change: November 1993                  10






FLEX(1)                   User Commands                   FLEX(1)



     M. E. Lesk and E. Schmidt, _L_E_X - _L_e_x_i_c_a_l _A_n_a_l_y_z_e_r _G_e_n_e_r_a_t_o_r

DDDDIIIIAAAAGGGGNNNNOOOOSSSSTTTTIIIICCCCSSSS
     _r_e_j_e_c_t__u_s_e_d__b_u_t__n_o_t__d_e_t_e_c_t_e_d _u_n_d_e_f_i_n_e_d or

     _y_y_m_o_r_e__u_s_e_d__b_u_t__n_o_t__d_e_t_e_c_t_e_d _u_n_d_e_f_i_n_e_d -  These  errors  can
     occur  at compile time.  They indicate that the scanner uses
     RRRREEEEJJJJEEEECCCCTTTT or yyyyyyyymmmmoooorrrreeee(((()))) but that _f_l_e_x failed to notice the  fact,
     meaning that _f_l_e_x scanned the first two sections looking for
     occurrences of these actions and failed  to  find  any,  but
     somehow  you  snuck  some in (via a #include file, for exam-
     ple).  Make an explicit reference to the action in your _f_l_e_x
     input   file.    (Note  that  previously  _f_l_e_x  supported  a
     %%%%uuuusssseeeedddd////%%%%uuuunnnnuuuusssseeeedddd mechanism for dealing with this problem;  this
     feature  is  still supported but now deprecated, and will go
     away soon unless the author hears from people who can  argue
     compellingly that they need it.)

     _f_l_e_x _s_c_a_n_n_e_r _j_a_m_m_e_d - a scanner compiled with ----ssss has encoun-
     tered  an  input  string  which wasn't matched by any of its
     rules.

     _w_a_r_n_i_n_g, _r_u_l_e _c_a_n_n_o_t _b_e _m_a_t_c_h_e_d  indicates  that  the  given
     rule  cannot  be matched because it follows other rules that
     will always match the same text as it.  See  _f_l_e_x_d_o_c(_1)  for
     an example.

     _w_a_r_n_i_n_g, ----ssss _o_p_t_i_o_n _g_i_v_e_n _b_u_t _d_e_f_a_u_l_t  _r_u_l_e  _c_a_n  _b_e  _m_a_t_c_h_e_d
     means  that  it  is  possible  (perhaps only in a particular
     start condition) that the default  rule  (match  any  single
     character)  is  the  only  one  that will match a particular
     input.  Since

     _s_c_a_n_n_e_r _i_n_p_u_t _b_u_f_f_e_r _o_v_e_r_f_l_o_w_e_d -  a  scanner  rule  matched
     more text than the available dynamic memory.

     _t_o_k_e_n _t_o_o _l_a_r_g_e, _e_x_c_e_e_d_s _Y_Y_L_M_A_X - your scanner  uses  %%%%aaaarrrrrrrraaaayyyy
     and one of its rules matched a string longer than the YYYYYYYYLLLLMMMMAAAAXXXX
     constant (8K bytes by default).  You can increase the  value
     by  #define'ing  YYYYYYYYLLLLMMMMAAAAXXXX  in  the definitions section of your
     _f_l_e_x input.

     _s_c_a_n_n_e_r _r_e_q_u_i_r_e_s -_8 _f_l_a_g _t_o _u_s_e _t_h_e  _c_h_a_r_a_c_t_e_r  '_x'  -  Your
     scanner specification includes recognizing the 8-bit charac-
     ter '_x' and you did not  specify  the  - 8  flag,  and  your
     scanner  defaulted  to 7-bit because you used the ----CCCCffff or ----CCCCFFFF
     table compression options.

     _f_l_e_x _s_c_a_n_n_e_r _p_u_s_h-_b_a_c_k _o_v_e_r_f_l_o_w - you used uuuunnnnppppuuuutttt(((())))  to  push
     back  so  much text that the scanner's buffer could not hold
     both the pushed-back text and the current token  in  yyyyyyyytttteeeexxxxtttt....
     Ideally  the scanner should dynamically resize the buffer in



Version 2.4        Last change: November 1993                  11






FLEX(1)                   User Commands                   FLEX(1)



     this case, but at present it does not.

     _i_n_p_u_t _b_u_f_f_e_r _o_v_e_r_f_l_o_w, _c_a_n'_t _e_n_l_a_r_g_e _b_u_f_f_e_r _b_e_c_a_u_s_e  _s_c_a_n_n_e_r
     _u_s_e_s  _R_E_J_E_C_T  -  the  scanner  was  working  on  matching an
     extremely large token and needed to expand the input buffer.
     This doesn't work with scanners that use RRRREEEEJJJJEEEECCCCTTTT....

     _f_a_t_a_l _f_l_e_x _s_c_a_n_n_e_r _i_n_t_e_r_n_a_l _e_r_r_o_r--_e_n_d _o_f  _b_u_f_f_e_r  _m_i_s_s_e_d  -
     This  can  occur  in  an  scanner which is reentered after a
     long-jump has jumped out (or over) the scanner's  activation
     frame.  Before reentering the scanner, use:

         yyrestart( yyin );

     or use C++ scanner classes (the ----++++ option), which are  fully
     reentrant.

AAAAUUUUTTTTHHHHOOOORRRR
     Vern Paxson, with the help of many ideas and  much  inspira-
     tion from Van Jacobson.  Original version by Jef Poskanzer.

     See flexdoc(1) for additional credits  and  the  address  to
     send comments to.

DDDDEEEEFFFFIIIICCCCIIIIEEEENNNNCCCCIIIIEEEESSSS //// BBBBUUUUGGGGSSSS
     Some trailing context patterns cannot  be  properly  matched
     and  generate  warning  messages  ("dangerous  trailing con-
     text").  These are patterns where the ending  of  the  first
     part  of  the rule matches the beginning of the second part,
     such as "zx*/xy*", where the 'x*' matches  the  'x'  at  the
     beginning  of  the  trailing  context.  (Note that the POSIX
     draft states that the text matched by such patterns is unde-
     fined.)

     For some trailing context rules, parts  which  are  actually
     fixed-length  are  not  recognized  as  such, leading to the
     abovementioned performance loss.  In particular, parts using
     '|'   or  {n}  (such  as  "foo{3}")  are  always  considered
     variable-length.

     Combining trailing context with the special '|'  action  can
     result  in _f_i_x_e_d trailing context being turned into the more
     expensive _v_a_r_i_a_b_l_e trailing context.  For  example,  in  the
     following:

         %%
         abc      |
         xyz/def


     Use of uuuunnnnppppuuuutttt(((()))) or iiiinnnnppppuuuutttt(((())))  invalidates  yytext  and  yyleng,
     unless the %%%%aaaarrrrrrrraaaayyyy directive or the ----llll option has been used.



Version 2.4        Last change: November 1993                  12






FLEX(1)                   User Commands                   FLEX(1)



     Use of unput() to push back more text than was  matched  can
     result  in the pushed-back text matching a beginning-of-line
     ('^') rule even though it didn't come at  the  beginning  of
     the line (though this is rare!).

     Pattern-matching  of  NUL's  is  substantially  slower  than
     matching other characters.

     Dynamic resizing of the input buffer is slow, as it  entails
     rescanning  all the text matched so far by the current (gen-
     erally huge) token.

     _f_l_e_x does not generate correct  #line  directives  for  code
     internal  to the scanner; thus, bugs in _f_l_e_x._s_k_l yield bogus
     line numbers.

     Due to both buffering of input and  read-ahead,  you  cannot
     intermix  calls to <stdio.h> routines, such as, for example,
     ggggeeeettttcccchhhhaaaarrrr(((()))),,,, with _f_l_e_x rules and  expect  it  to  work.   Call
     iiiinnnnppppuuuutttt(((()))) instead.

     The total table entries listed by the ----vvvv flag  excludes  the
     number  of  table  entries needed to determine what rule has
     been matched.  The number of entries is equal to the  number
     of  DFA states if the scanner does not use RRRREEEEJJJJEEEECCCCTTTT,,,, and some-
     what greater than the number of states if it does.

     RRRREEEEJJJJEEEECCCCTTTT cannot be used with the ----ffff or ----FFFF options.

     The _f_l_e_x internal algorithms need documentation.

























Version 2.4        Last change: November 1993                  13



