;;; 91/10/22 modified for Demacs 1.1.2 by Manabu Higashida

;;;  Fill Commands for Egg on Nemacs
;;;  Modified by Satoru Tomura (tomura@etl.go.jp)

;;;  Ver.18.55    modified by S. Tomura 89-Nov-15,17
;;;  Ver.18.55    created by S. Tomura 89-Nov-15
;;;  Nemacs Ver. 3.2
;;;  Ver.18.52c   modified by S. Tomura 89-Oct-19
;;;  Ver.18.52b   modified by S. Tomura 89-Oct-2
;;;  Ver.18.52a   modified by S. Tomura 89-Aug-30
;;;               kanji-kanji-* are corrected.
;;;  Ver.18.52    created  by S. Tomura 89-Mar-16
;;;  Ver.18.50f   modified by S. Tomura 88-Aug-25
;;;               See ;; 88-Aug-25
;;;  Ver.18.50e   modified by S. Tomura 88-Aug-24
;;;               constant hiragana-char and katakana-char corrected.
;;;  Ver.18.50d   modified by S. Tomura 88-Jun-30
;;;  Ver.18.50c   modified by S. Tomura 88-Jun-21
;;;  Ver.18.50b   modified by S. Tomura 88-Jun-20
;;;  Ver.18.50a   modified by S. Tomura 88-Jun-16
;;;  Ver.18.50    created by S. Tomura 88-Jun-11
;;;  Nemacs Ver.2.1
;;;  Ver.18.47e   modified by S. Tomura 88-Jun-7
;;;               Kanji justification added.
;;;  Ver.18.47d   modified by S. Tomura 88-Jun-2
;;;               In kanji-mode a space after an English word preserved.
;;;               Some codes become simpler and clearer.
;;;               Same method as simple.el adapted.
;;;  Ver.18.47c   modified by S. Tomura 88-May-25
;;;  Ver.18.47b   modified by S. Tomura 88-Feb-9
;;;; Ver.18.47a   modified by S. Tomura 88-Feb-5
;;;;              Kanji fill region added.

;; Fill commands for Emacs
;; Copyright (C) 1985, 1986 Free Software Foundation, Inc.

;; This file is part of GNU Emacs.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU Emacs General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; GNU Emacs, but only under the conditions described in the
;; GNU Emacs General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU Emacs so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.


(defun set-fill-prefix ()
  "Set the fill-prefix to the current line up to point.
Filling expects lines to start with the fill prefix
and reinserts the fill prefix in each resulting line."
  (interactive)
  (setq fill-prefix (buffer-substring
		     (save-excursion (beginning-of-line) (point))
		     (point)))
  (if (equal fill-prefix "")
      (setq fill-prefix nil))
  (if fill-prefix
      (message "fill-prefix: \"%s\"" fill-prefix)
    (message "fill-prefix cancelled")))

(defun fill-region-as-paragraph (from to &optional justify-flag)
  "Fill region as one paragraph: break lines to fit fill-column.
Prefix arg means justify too.
From program, pass args FROM, TO and JUSTIFY-FLAG."
  (interactive "r\nP")
  (save-restriction
    (narrow-to-region from to)
    (goto-char (point-min))
    (skip-chars-forward "\n")
    (narrow-to-region (point) (point-max))
    (setq from (point))
    (let ((fpre (and fill-prefix (not (equal fill-prefix ""))
		     (regexp-quote fill-prefix))))
      ;; Delete the fill prefix from every line except the first.
      ;; The first line may not even have a fill prefix.
      (and fpre
	   (progn
	     (if (>= (length fill-prefix) fill-column)
		 (error "fill-prefix too long for specified width"))
	     (goto-char (point-min))
	     (forward-line 1)
	     (while (not (eobp))
	       (if (looking-at fpre)
		   (delete-region (point) (match-end 0)))
	       (forward-line 1))
	     (goto-char (point-min))
	     (and (looking-at fpre) (forward-char (length fill-prefix)))
	     (setq from (point)))))
    ;; from is now before the text to fill,
    ;; but after any fill prefix on the first line.

    ;; Make sure sentences ending at end of line get an extra space.
    (goto-char from)
    ;;;; patch by S.Tomura 88-Jun-30
    ;;
    ;; . + CR             ==> . + SPC + SPC 
    ;; . + SPC + CR +     ==> . + SPC + 
    ;;(while (re-search-forward "[.?!][])""']*$" nil t)
    ;;  (insert ? ))
    (while (re-search-forward "[.?!][])""']*$" nil t)
      (if (eobp)
	  nil
      (delete-char 1)
      (insert "  "))) ;;; replace CR by two spaces.
    ;;; end of patch
    ;; The change all newlines to spaces.
    ;;; patched by S.Tomura 87-Dec-7
    ;;; bug fixed by S.Tomura 88-May-25
    ;;; modified by  S.Tomura 88-Jun-21
    ;;;(subst-char-in-region from (point-max) ?\n ?\ )
    ;;;ܸθθˤ϶Ϥʤ
    (goto-char from)
    (end-of-line)
    (while (not (eobp))
      (delete-char 1)
      (if (and (< ?  (preceding-char)) ;;; + SPC + CR + X ==> + SPC + X
	       (< (preceding-char) 128)
	       (<= ?  (following-char))
	       (< (following-char) 128))
	   (insert ?\  ))
      (end-of-line))
    ;;; νʸˤtwo spacesꡢʳsingle spaceˤʤäƤ롣
    ;;; end of patch
    ;; Flush excess spaces, except in the paragraph indentation.
    (goto-char from)
    (skip-chars-forward " \t")
    (while (re-search-forward "   *" nil t)
      (delete-region
       (+ (match-beginning 0)
	  (if (save-excursion
	       (skip-chars-backward " ])\"'")
	       (memq (preceding-char) '(?. ?? ?!)))
	      2 1))
       (match-end 0)))
    (goto-char (point-max))
    (delete-horizontal-space)
    (insert "  ")
    (goto-char (point-min))
    (let ((prefixcol 0))
      (while (not (eobp))
	;;; patched by S.Tomura 88-Jun-2
	;;;(move-to-column (1+ fill-column))
	(move-to-column fill-column)
	;;; end of patch
	;;; patched by S.Tomura 88-Jun-16, 89-Oct-2, 89-Oct-19
	;;; ɤξˤfill-column礭ʤ뤳Ȥ롣
	(or (>= fill-column (current-column)) (backward-char 1))
	;;; end of patch
	(if (eobp)
	    nil
	  ;;; patched by S.Tomura 87-Jun-2
	  ;;;(skip-chars-backward "^ \n")
	  ;;;(if (if (zerop prefixcol) (bolp) (>= prefixcol (current-column)))
	  ;;;    (skip-chars-forward "^ \n")
	  ;;;  (forward-char -1)))
	  ;;; §Ȥfill-column꺸¦ʬõ
	  ;;; Find a point to break lines
	     (skip-chars-backward " \t") ;; skip SPC and TAB
	     (if (or (<= 128 (preceding-char))
		     (<= 128 (following-char)) ;;; 88-Aug-25
		     (= (following-char) ? )
		     (= (following-char) ?\t))
		 (if (boundp 'NEMACS) (kinsoku-shori))
	       (if(re-search-backward "[ \t\n]\\|\\z" ;;; 89-Nov-17
				      (point-min) (point-min))
		   (forward-char 1))
	       (skip-chars-backward " \t")
	       (if (boundp 'NEMACS) (kinsoku-shori)))
	     ;;; prifixcol걦¦ʬõ
	     ;;; ξʬfill-column걦¦ˤʤ롣
	     (if (>= prefixcol (current-column))
		 (progn
		   (move-to-column prefixcol)
		   (if (re-search-forward "[ \t]\\|\\z" ;;; 89-Nov-17
					  (point-max) (point-max))
		       (backward-char 1))
		   (skip-chars-backward " \t")
		   (if (boundp 'NEMACS) (kinsoku-shori))
		   ;;; ܤʤʬ롣
		   (if (>= prefixcol (current-column)) (goto-char (point-max))))))
	;;; end of patch S.Tomura
	;;; patch by S. Tomura 88-Jun-20
	;;;(delete-horizontal-space)
        ;;;ʬ
        ;;;  | SPC + SPC   -->  + SPC + CR
	;;; | SPC + SPC* +   --> SPC  + CR + 
        ;;; . | SPC + SPC +      --> . + CR
        ;;; . | SPC + nonSPC     --> . + SPC + CR + nonSPC
        ;;;
        ;;; . | Ⱦ             --> ʬ䤷ʤ
        ;;; . |              --> ʬ䤷ʤ
	(if (and (boundp 'kanji-flag)
		 (not kanji-flag)) (delete-horizontal-space)
	  (let ((start) (end))
	    (skip-chars-backward " \t")
	    (setq start (point))
	    (skip-chars-forward  " \t")
	    (setq end (point))
	    (delete-region start end)
	    (if (and (not
		      (and (save-excursion
			     (skip-chars-backward " ])\"'")
			     (memq (preceding-char) '(?. ?? ?!)))
			   (= end (+ start 2))))
		     (or (and (or (<= 128 (preceding-char))
				  (<= 128 (following-char)))
			      (< start end)
			      (not (eobp)))
			 (and (memq (preceding-char) '(?. ?? ?!))
			      (= (1+ start) end)
			      (not (eobp)))))
		(insert ?  ))))
	;;; end of patch
	(insert ?\n)
	(and (not (eobp)) fill-prefix (not (equal fill-prefix ""))
	     (progn
	       (insert fill-prefix)
	       (setq prefixcol (current-column))))
	(and justify-flag (not (eobp))
	     (progn
	       (forward-line -1)
	       (justify-current-line)
	       (forward-line 1)))))))

(defun fill-paragraph (arg)
  "Fill paragraph at or after point.
Prefix arg means justify as well."
  (interactive "P")
  (save-excursion
    (forward-paragraph)
    (or (bolp) (newline 1))
    (let ((end (point)))
      (backward-paragraph)
      (fill-region-as-paragraph (point) end arg))))

(defun fill-region (from to &optional justify-flag)
  "Fill each of the paragraphs in the region.
Prefix arg (non-nil third arg, if called from program)
means justify as well."
  (interactive "r\nP")
  (save-restriction
   (narrow-to-region from to)
   (goto-char (point-min))
   (while (not (eobp))
     (let ((initial (point))
	   (end (progn
		 (forward-paragraph 1) (point))))
       (forward-paragraph -1)
       (if (>= (point) initial)
	   (fill-region-as-paragraph (point) end justify-flag)
	 (goto-char end))))))

;;; patch by S.Tomura 88-Jun-2, 89-Nov-15
;;; ܸjustificationǤϡȾѶ
;;; ""θ
;;; ""
;;; ñܸȤδ
;;; Ǥ롣

(defvar ascii-char "[\40-\176]")

(defvar ascii-space "[ \t]")
(defvar ascii-symbols "[\40-\57\72-\100\133-\140\173-\176]")
(defvar ascii-numeric "[\60-\71]")
(defvar ascii-English-Upper "[\101-\132]")
(defvar ascii-English-Lower "[\141-\172]")

(defvar ascii-alphanumeric "[\60-\71\101-\132\141-\172]")

(defvar kanji-char "\\z")
(defvar kanji-space "")
(defvar kanji-symbols "\\cs")
(defvar kanji-numeric "[-]")
(defvar kanji-English-Upper "[-]")
(defvar kanji-English-Lower  "[-]")
;;; Bug fixed by Yoshida@CSK on 88-AUG-24
(defvar kanji-hiragana "[-]")
(defvar kanji-katakana "[-]")
;;;
(defvar kanji-Greek-Upper "[-]")
(defvar kanji-Greek-Lower "[-]")
(defvar kanji-Russian-Upper "[-]")
(defvar kanji-Russian-Lower "[-]")
(defvar kanji-Kanji-1st-Level  "[-]")
(defvar kanji-Kanji-2nd-Level  "[С-]")

(defvar kanji-kanji-char "\\(\\ch\\|\\ck\\|\\cc\\)")

(defvar aletter (concat "\\(" ascii-char "\\|" kanji-char "\\)"))

(defvar kanji-space-insertable (concat 
	   "" aletter                   "\\|"
	   "" aletter                   "\\|"
	   aletter ""                   "\\|"
	   "" aletter                   "\\|"
	   ascii-alphanumeric  kanji-kanji-char "\\|"
	   kanji-kanji-char    ascii-alphanumeric ))

(defvar space-insertable (concat
	  " " aletter                     "\\|"
	  kanji-space-insertable))

(defun find-space-insertable-point ()
  (if (re-search-backward space-insertable nil t)
      (progn (forward-char 1)
	     t)
    nil))
;;; end of patch

(defun justify-current-line ()
  "Add spaces to line point is in, so it ends at fill-column."
  (interactive)
  (save-excursion
   (save-restriction
    (let (ncols beg)
      (beginning-of-line)
      (forward-char (length fill-prefix))
      (skip-chars-forward " \t")
      (setq beg (point))
      (end-of-line)
      (narrow-to-region beg (point))
      (goto-char beg)
      (while (re-search-forward "   *" nil t)
	(delete-region
	 (+ (match-beginning 0)
	    (if (save-excursion
		 (skip-chars-backward " ])\"'")
		 (memq (preceding-char) '(?. ?? ?!)))
		2 1))
	 (match-end 0)))
      (goto-char beg)
      (while (re-search-forward "[.?!][])""']*\n" nil t)
	(forward-char -1)
	(insert ? ))
      (goto-char (point-max))
      (setq ncols (- fill-column (current-column)))
      ;;; patch by S.Tomura 88-Jun-7
      ;;;(if (search-backward " " nil t)
      (if (find-space-insertable-point)
      ;;; end of patch
	  (while (> ncols 0)
	    (let ((nmove (+ 3 (% (random) 3))))
	      (while (> nmove 0)
		;;; patch by S.Tomura 88-Jun-7
		;;;(or (search-backward " " nil t)
		(or (find-space-insertable-point)
		;;; end of patch
		    (progn
		     (goto-char (point-max))
		     ;;; patch by S.Tomura 88-Jun-7
		     ;;;(search-backward " ")))
		     (find-space-insertable-point)))
		     ;;; end of patch
		(skip-chars-backward " ")
		(setq nmove (1- nmove))))
	    (insert " ")
	    (skip-chars-backward " ")
	    (setq ncols (1- ncols))))))))

(defun fill-individual-paragraphs (min max &optional justifyp mailp)
  "Fill each paragraph in region according to its individual fill prefix.
Calling from a program, pass range to fill as first two arguments.
Optional third and fourth arguments JUSTIFY-FLAG and MAIL-FLAG:
JUSTIFY-FLAG to justify paragraphs (prefix arg),
MAIL-FLAG for a mail message, i. e. don't fill header lines."
  (interactive "r\nP")
  (let (fill-prefix)
    (save-restriction
      (save-excursion
	(narrow-to-region min max)
	(goto-char (point-min))
	(while (progn
		 (skip-chars-forward " \t\n")
		 (not (eobp)))
	  (setq fill-prefix (buffer-substring (point) (progn (beginning-of-line) (point))))
	  (let ((fin (save-excursion (forward-paragraph) (point)))
		(start (point)))
	    (if mailp
		(while (re-search-forward "[ \t]*[^ \t\n]*:" fin t)
		  (forward-line 1)))
	    (cond ((= start (point))
		   (fill-region-as-paragraph (point) fin justifyp)
		   (goto-char fin)))))))))

