/* --------------------------------------------------------------------------
   Project S.W.O.R.D
   V2.10

   SubSystem : Samples programs : Using Color features
   File      : Samples/Colors/Colors.CC
   Author    : Eric NICOLAS
   Overview  : Colors sample program main file
   UpDate    : Apr 06, 1996

** Copyright (C) 1993-1996 Eric NICOLAS
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#include "Sword.H"
#include "ColPal.H"

#define cmDialogColor      10000
#define cmPhysicalPalette  10001
#define cmTrueColorPalette 10002

// ==== APPLICATION OBJECT ==================================================

// This object is the application object. Construct the dialog, and
// wait for cmOK command for exiting the application

class TColorsApp : public TApp
{ DECLARE(TColorsApp);
  DECLARE_EVENTS_TABLE;
  // --- Functions
  public:
  // Public constructors
    TColorsApp(void);
    TColorsApp(char *argv0);
  // Construction
            void    Init(char *argv0);
  // Overridables
    virtual void    CreateMenuChoices(TMenu *Menu);
    virtual boolean CanClose(void);
  // Events treatments
            boolean doDialogColor(void);
            boolean doPhysicalPalette(void);
            boolean doTrueColorPalette(void);
};

DEFINE(TColorsApp)

DEFINE_EVENTS_TABLE(TColorsApp,TApp)
  COMMAND(cmDialogColor,     doDialogColor)
  COMMAND(cmPhysicalPalette, doPhysicalPalette)
  COMMAND(cmTrueColorPalette,doTrueColorPalette)
END_EVENTS_TABLE

TColorsApp::TColorsApp(void)
{ Defaults();
}

TColorsApp::TColorsApp(char *argv0)
{ Defaults();
  Init(argv0);
}

void TColorsApp::Init(char *argv0)
{ // Derived Initializations
  TApp::Init(argv0);
  // New Initializations
  RegisterObject(new TPhysicalPaletteView(),  &RegTPhysicalPaletteView);
  RegisterObject(new TTrueColorPaletteView(), &RegTTrueColorPaletteView);
}

void TColorsApp::CreateMenuChoices(TMenu *Menu)
{ Menu->Insert(new TMenuChoice("&Edit color",0,cmDialogColor));
  Menu->Insert(new TMenuChoice("&Physical Palette",0,cmPhysicalPalette));
  Menu->Insert(new TMenuChoice("&TrueColor Palette",0,cmTrueColorPalette));
  Menu->Insert(new TMenuChoice());
  Menu->Insert(new TMenuChoice("&Quit",ScanAltQ,cmQuit));
}

boolean TColorsApp::CanClose(void)
{ if (MessageBox("Confirmation","Are you sure that you want to quit",
                 "this marvellous sample program from SWORD package ?",
                 mbYes | mbNo)==cmYes) return TRUE;
  else return FALSE;
}

boolean TColorsApp::doDialogColor(void)
{ byte r,g,b;
  r=g=b=128;
  EditRGBColor(100,100,r,g,b);
  return TRUE;
}

boolean TColorsApp::doPhysicalPalette(void)
{ // Create a window that cannot be resized, and that can be closed
  TStdWindow *W=new TStdWindow(100,150,256+10,50+31,"Physical Palette",opWinCloseBox);
  // Create the palette viewer
  TPhysicalPaletteView *P=new TPhysicalPaletteView(W->Inside.X1(),W->Inside.Y1());
  W->Insert(P);
  // Show this window
  Desktop->Insert(W);
  return TRUE;
}

boolean TColorsApp::doTrueColorPalette(void)
{ // Create a window that cannot be resized, and that can be closed
  TStdWindow *W=new TStdWindow(100,150,384+10,64+31,"TrueColor Palette",opWinCloseBox);
  // Create the palette viewer
  TTrueColorPaletteView *P=new TTrueColorPaletteView(W->Inside.X1(),W->Inside.Y1());
  W->Insert(P);
  // Show this window
  Desktop->Insert(W);
  return TRUE;
}

// ==== MAIN PROGRAMM =======================================================

int main(char , char *argv[])
{ TColorsApp *MyColorsApp;

  // Application identification
  ShortVersion="Colors";
  LongVersion ="Colors Sample. Copyright (C) 1993-1996 The SWORD Group";

  // Execute Application
  MyColorsApp=new TColorsApp(argv[0]);
  MyColorsApp->Run();
  delete MyColorsApp;

  return 0;
}

