/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Little usefull graphical objects
	File      : Include/Gadgets/TitleBox.H
	Author    : Eric NICOLAS
	Overview  : TitleBox... : Boxes for title bar
	UpDate    : Mar 01, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _GADGETS_TITLEBOX_H_
#define _GADGETS_TITLEBOX_H_

class TTitleBox;
class TCloseBox;
class TMinimizeBox;

// --- Obejct TTitleBox

extern short RegTTitleBox;
extern char *IdentTTitleBox;

class TTitleBox : public TStdButton
{ DECLARE(TTitleBox);
  // --- Datas
  protected:
    TWindow *Window;
  // --- Functions
  public:
  // Public constructors
            TTitleBox(void);
            TTitleBox(int X, int Y, TWindow *W, int Command, int ScanCode, TMapping *_Mapp);
  // Construction / Destruction
            void Defaults(void);
            void Init(int X, int Y, TWindow *W, int Command, int ScanCode, TMapping *_Mapp);
  //
    virtual void Action(void);
};

//

class TCloseBox : public TTitleBox
{ public:
    TCloseBox(int X, int Y, TWindow *W);
};

class TMinimizeBox : public TTitleBox
{ public:
    TMinimizeBox(int X, int Y, TWindow *W);
};

struct TMaximizeBox : TTitleBox
{ TMaximizeBox(int X, int Y, TWindow *W);
};

#endif // _GADGETS_TITLEBOX_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   21/02/96 :EN: First History remark. Copying code V2.00->V2.10
**   01/03/96 :EN: Moving from struct to class. Adding Defaults() method
** ------------------------------------------------------------------------*/
