/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem  : Little usefull graphical objects
   CommandNos : 3400..3499
	File       : Include/Gadgets/Edition.H
	Author     : Eric NICOLAS
	Overview   : EditLine objects
	UpDate     : Apr 08, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _GADGETS_EDITION_H_
#define _GADGETS_EDITION_H_

class TEditLine;
class TEditReal;
class TEditInteger;

// Possible data types edited in TEditInteger
// :: Signed data types (bit0==0)
#define dt_char     0
#define dt_int16    2
#define dt_int32    4
// :: Unsigned data types (bit0==1)
#define dt_byte     1
#define dt_word16   3
#define dt_word32   5

// Notitifaction message from TEditXXX
#define cmEditChanged 3400

// ----- Object TEditLine

extern short RegTEditLine;
extern char *IdentTEditLine;

class TEditLine : public TZone
{ DECLARE(TEditLine);
  DECLARE_EVENTS_TABLE;
  // --- Datas
  public:
    // Public text Buffer
    char*     Text;
  protected:
    // Private text buffers
    char*     NewText;
    char*     TempText;
    // Cursor managment
    char      LengthText;
    char      LengthDraw;
    char      BegText;
    char      Cursor;
    char      Deplacement;
    // Drawing managment
    int       DrawLength,DrawHeight;
    int       DrawX,DrawY;
    int       BackColor,TextColor;
    // Selection management
    int       BeginSelect;
    int       EndSelect;
    int       BaseSelect;
  // --- Functions
  public:
  // Public constructor
          TEditLine(void);
          TEditLine(int X, int Y, int L, char Lt, char Dpl, boolean Border=TRUE);
          TEditLine(TRect R, char Lt, char Dpl, boolean Border=TRUE);
  // Construction / Destruction
          void Defaults(void);
          void Init(int X, int Y, int L, char Lt, char Dpl, boolean Border);
          void Done(void);
  // Drawings
  virtual void Draw(TRect Clip);
          void DrawText(void);
          void DrawCursor(void);
          void DoDrawCursor(void);
          void SetColors(int Background, int Text);
  // Data exchange
  virtual void SetData(void *Ptr);
  virtual void GetData(void *Ptr);
  virtual long DataSize(void);
          void TextChanged(void);
  // Selection
          void     NoSelection(void);
          boolean  IsSelection(void);
  // Events handling
  virtual boolean  KeyDown(int ScanCode, int Toggle);
  virtual boolean  MouseLDown(TPoint Where, int Buttons);
  virtual boolean  MouseDblClk(TPoint Where, int Buttons);
  virtual boolean  MouseMove(TPoint Where, int Buttons);
          boolean  doChangeSelect(void);
  virtual void     SizeChanged(void);
  // Entry validation
  virtual int  ValidInput(int& ScanCode);
  virtual int  ValidResult(void);
  // Actions of keyboard
  // :: Left arrow
  void CursorLeft(boolean Shift);
  void CursorCtrlLeft(boolean Shift);
  // :: Right arrow
  void CursorRight(boolean Shift);
  void CursorCtrlRight(boolean Shift);
  // :: Home/End
  void CursorHome(boolean Shift);
  void CursorEnd(boolean Shift);
  // :: Others
  void Insertion(char C);
  void Recover(char C);
  void BackSpace(void);
  void Delete(void);
  void ReplaceSelection(char C);
  // :: ClipBoard
  void Cut(void);
  void Copy(void);
  void Paste(void);
  //
  boolean MakeCursorVisible(void);
  virtual void Modified(void);
};

// ----- Object TEditReal

extern short RegTEditReal;
extern char *IdentTEditReal;

class TEditReal : public TEditLine
{ DECLARE(TEditReal);
  // --- Datas
  protected:
  // --- Functions
  public:
  // Public Constructor
            TEditReal(void);
            TEditReal(int X, int Y, int L, boolean Border=TRUE);
            TEditReal(TRect R, boolean Border=TRUE);
  // Construction / Destruction
            void Defaults(void);
            void Init(int X, int Y, int L, boolean Border);
  // Data exchange
    virtual void SetData(void *Ptr);
    virtual void GetData(void *Ptr);
    virtual long DataSize(void);
  // Entry validation
    virtual int  ValidInput(int& ScanCode);
    virtual int  ValidResult(void);
};

// ----- Object TEditInteger

extern short RegTEditInteger;
extern char *IdentTEditInteger;

class TEditInteger : public TEditLine
{ DECLARE(TEditInteger);
  // --- Datas
  protected:
    int DataType;
  // --- Functions
  public:
  // Public constructors
            TEditInteger(void);
            TEditInteger(int X, int Y, int L, int _DataType, boolean Border=TRUE);
            TEditInteger(TRect R, int _DataType, boolean Border=TRUE);
  // Construction / Destruction
            void Defaults(void);
            void Init(int X, int Y, int L, int _DataType, boolean Border);
  // Data exchange
    virtual void SetData(void *Ptr);
    virtual void GetData(void *Ptr);
    virtual long DataSize(void);
  // Entry validation
    virtual int  ValidInput(int& ScanCode);
    virtual int  ValidResult(void);
};

// Expansion of inline functions

inline void TEditLine::SetColors(int Background, int Text)
{ BackColor=Background;
  TextColor=Text;
}

#endif // _GADGETS_EDITION_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   21/02/96 :EN: First History remark. Copying code V2.00->V2.10
**   29/02/96 :EN: Moving from struct to class. Adding Defaults() method.
**   01/04/96 :EN: Adding DECLARE_COMMAND... macros
**   03/04/96 :EN: Adding multiple integer type in TEditInteger
**   08/04/96 :EN: Changing from DECLARE_COMMAND... to DECLARE_EVENTS...
** ------------------------------------------------------------------------*/
