/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Drivers for hardware and OS access
	File      : Include/Drivers/Time.H
	Author    : Eric NICOLAS
	Overview  : Functions for Time and Date access (TTimeDate object)
	UpDate    : Mar 13, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _DRIVERS_TIME_H_
#define _DRIVERS_TIME_H_

#include <time.h>

// All format specifications are NOT case sensitive, but
// 'other characters' are copied without case change.

// TimeFormat is a string which can contain :
//    H   : Hour
//    HH  : Hour with a leading 0
//    M   : Minute
//    MM  : Minute with a leading 0
//    S   : Second
//    SS  : Second with a leading 0
//    Other characters : moved 'as this' into destination string

// DateFormat is a string which can contain :
//    DT    : Day in text, short form (3 chars : 'mon'...)
//    DDT   : Day in text, long form ('monday'...)
//    D     : Day
//    DD    : Day with a leading 0
//    E     : 'st' 'nd' 'rd' 'th' Extension to day number
//    M     : Month
//    MM    : Month with a leading 0
//    MT    : Month in text, short form (3 chars : 'jan'...)
//    MMT   : Month in text, long form ('monday'...)
//    Y     : year, short form (95, 96 ...)
//    YY    : year, long form (1995, 1996 ...)
//    Other characters : moved 'as this' into destination string

class TTimeDate
{ // Datas
  public:
    int  Hour;                   // Hour        0..23
    int  Minute;                 // Minute      0..59
    int  Second;                 // Second      0..59
    int  Year;                   // Year
    int  Month;                  // Month       1..12
    int  Day;                    // Day         1..31
    int  DayInWeek;              // Day In Week 0..6   (0=Sunday)
  protected:
    char TimeFormat[50];
    char DateFormat[50];
  // Functions
  public:
    // Construction
    TTimeDate();                 // Set to system time
    TTimeDate(TTimeDate& T);     // Copy constructor
    // Format, Text output
    void  SetTimeFormat(char *TF);
    void  SetDateFormat(char *DF);
    void  WriteTime(char *Dest);
    void  WriteDate(char *Dest);
    // Conversions
    void  SetFromSystemTime(time_t T);
};

#endif // _DRIVERS_TIME_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   13/03/96 :EN: Creation
** ------------------------------------------------------------------------*/
