// Associated include file : Tools\CmdWin.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/graphics.h"
#include "gadgets/gadgets.h"
#include "tools/cmdwin.h"

static char Temp[200];
static char Command[80];

// --- TCommandViewer

DEFINE(TCommandViewer);

short RegTCommandViewer;
char *IdentTCommandViewer = "TCommandViewer";

TCommandViewer::TCommandViewer()
{ Defaults();
}

TCommandViewer::TCommandViewer(int X, int Y, int L, int H, TLift *_Vert)
{ Defaults();
  Init(X,Y,L,H,_Vert);
}


TCommandViewer::TCommandViewer(TRect R, TLift *_Vert)
{ Defaults();
  Init(R.X1(),R.Y1(),R.Width(),R.Height(),_Vert);
}

void TCommandViewer::Defaults(void)
{ // Object identification
  Register=RegTCommandViewer;
  Ident=IdentTCommandViewer;
  // Other default values
}

void TCommandViewer::Init(int X, int Y, int L, int H, TLift *_Vert)
{ // Herited constructions
  TTextScroller::Init(X,Y,L,H,NULL,_Vert);
  // New constructions
  SetTextSize(80,SpyCurrentLine);
}

char *TCommandViewer::GetText(int Line)
{ if (Line<SpyCurrentLine)
  { SpyGetLine(Line, Temp);
    return Temp;
  }
  return NULL;
}

// --- TCommandEdit

short RegTCommandEdit;
char *IdentTCommandEdit = "TCommandEdit";

TCommandEdit::TCommandEdit()
{ Defaults();
}

TCommandEdit::TCommandEdit(int X, int Y, int L)
{ Defaults();
  Init(X,Y,L);
}

void TCommandEdit::Defaults(void)
{ // Object Identification
  Register=RegTCommandEdit;
  Ident=IdentTCommandEdit;
  // Other defaults values
  SetOptions(opCSHiX | opCSHiY | opCSLoY);
  SetColors(Black,LightGray);
}

void TCommandEdit::Init(int X, int Y, int L)
{ // Herited constructions
  TEditLine::Init(X,Y,L,80,10,TRUE);
  // New constructions
}

boolean TCommandEdit::KeyDown(int ScanCode, int Toggle)
{ if (TEditLine::KeyDown(ScanCode,Toggle)) return TRUE;
  switch(ScanCode)
  { case ScanReturn :
      strcpy(Command,Text);
      *Text=0;
      Cursor=0;
      BegText=0;
      Invalidate();
      // Tell the application that there is a new command
      CmdWin->ExecuteCommand();
      break;
  }
  return FALSE;
}

// --- TCommandWindow

DEFINE(TCommandWindow);

short RegTCommandWindow;
char *IdentTCommandWindow = "TCommandWindow";

TCommandWindow::TCommandWindow()
{ Defaults();
}

TCommandWindow::TCommandWindow(char *Title)
{ Defaults();
  Init(5, GrMaxY()-204, GrMaxX()-9, 200,Title);
}

TCommandWindow::TCommandWindow(int X, int Y, int L, int H, char *Title)
{ Defaults();
  Init(X,Y,L,H,Title);
}

void TCommandWindow::Defaults(void)
{ // Object identification
  Register=RegTCommandWindow;
  Ident=IdentTCommandWindow;
  // Other default values
}

void TCommandWindow::Init(int X, int Y, int L, int H, char *Title)
{ // Herited constructions
  TStdWindow::Init(X,Y,L,H,Title,opWinSizeable);
  // New constructions
  Insert(Editor=new TCommandEdit(Inside.X1(),Inside.Y2()-21,Inside.Width()));
  Editor->CmdWin=this;
  Inside.Y2()=Inside.Y2()-22;
  Insert(new TWindowIFrame(Inside));
  Insert(VLift=new TLift(Inside,FALSE));
  Insert(Viewer=new TCommandViewer(Inside,VLift));
}

void TCommandWindow::ExecuteCommand(void)
{ TEvent Event;
  // Add the command to the spy file
  SpyAppendLine(">> %s",Command);
  // Execute the command
  Event.What=evCommand;
  Event.Command=cmCommand;
  Event.InfoPtr=Command;
  Application->HandleEvent(&Event);
  // Setup the SpyFile viewer
  Viewer->SetTextSize(80,SpyCurrentLine,FALSE);
  Viewer->SetCharVisible(0,SpyCurrentLine+1);
  Viewer->Invalidate();
}