// Associated include file : Mecanism/Spy.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/spy.h"

// Fichier Espion : SpyFile
//    Les lignes de ce fichier sont numrotes de 0  SpyCurrentLine-1
//    SpyLinesOffset contient l'offset dans le fichier du DEBUT de chaque
//    ligne disponible. SysLinesOffset[SpyCurrentLine] contient la position
//    du DEBUT de la future nouvelle ligne

int SpyCurrentLine;

// ===== Variables locales ==================================================

static char *Messages[2] =
		  { // Anglais
			 "Impossible to create the spy file SPY.LOG",
			 "Impossible to open the spy file SPY.LOG"
		  };

int 	SpyAvailLines;
word	*SpyLinesOffset;
FILE	*SpyFile;
char	SpyFName[260];

// ===== Fonctions globales =================================================

//---------------------------------------------------------------------------
// CreateSpy

void CreateSpy(void)
{ SpyFile=fopen(SpyFName,"wt");
  if (SpyFile==NULL) Error=erCreateSpyFile;
}

//---------------------------------------------------------------------------
// OpenSpy

void OpenSpy(void)
{ SpyFile=fopen(SpyFName,"r+t");
  if (SpyFile==NULL) Error=erOpenSpyFile;
}

//---------------------------------------------------------------------------
// CloseSpy

void CloseSpy(void)
{ fclose(SpyFile);
}

//---------------------------------------------------------------------------
// Positionne
//    Positionne le pointeur de fichier de SpyFile AVANT la ligne NLine

void Positionne(int NLine)
{ fseek(SpyFile,SpyLinesOffset[NLine],SEEK_SET);
}

//---------------------------------------------------------------------------
// OneMoreLine

void OneMoreLine(void)
{ word *NewSpyLinesOffset;

  SpyCurrentLine++;
  if (SpyCurrentLine>=SpyAvailLines)
  { // Alloue la mmoire pour plus de lignes
	 SafeNew(NewSpyLinesOffset,word[SpyAvailLines+50]);
	 if (Error) return;
	 // Transfert les index vers les lignes existantes
	 memcpy(NewSpyLinesOffset,SpyLinesOffset,SpyAvailLines*sizeof(word));
	 // Dtruit la mmoire d'avant
	 SafeDelete(SpyLinesOffset);
	 // Conserve l'adresse de la nouvelle mmoire
	 SpyLinesOffset=NewSpyLinesOffset;
	 // Indique le changement de lignes disponibles
	 SpyAvailLines+=50;
  }
}

//---------------------------------------------------------------------------
// SpyAppendLine

void SpyAppendLine(va_list arg_list, ...)
{ va_list       arg_ptr;
  char         *format;
#ifdef _TURBOC_
			  long Pos;
#else
  unsigned long Pos;
#endif
  OpenSpy();
  Positionne(SpyCurrentLine);
  OneMoreLine();
  va_start(arg_ptr, arg_list);
  format = (char*)arg_list;
  vfprintf(SpyFile,format,arg_ptr);
  fprintf(SpyFile,"\n");
  fgetpos(SpyFile,&Pos);
  SpyLinesOffset[SpyCurrentLine]=(word)Pos;
  CloseSpy();
}

//---------------------------------------------------------------------------
// SpyGetLine

void SpyGetLine(int NLine, char *S)
{ OpenSpy();
  Positionne(NLine);
  fgets(S,200,SpyFile);
  // Enleve le retour chariot a la fin
  if (S[strlen(S)-1]=='\n') S[strlen(S)-1]=0;
  CloseSpy();
}

// ===== Gestion loacle des erreurs ===========================================

static boolean ErrorMessages(char *Message)
{ int MessageNo;
  switch(Error)
  { case erCreateSpyFile:     MessageNo=0;   break;
	 case erOpenSpyFile:       MessageNo=1;   break;
	 default:
		return FALSE;
  }
  strcpy(Message,Messages[MessageNo]);
  return TRUE;
}

// ===== Init/Done unit Spy ================================================

//---------------------------------------------------------------------------
// InitSpy

void InitSpy(boolean Continue)
{ FILE *Recover;
  char Lgn[200],Buffer[300];
  word Pos;
  // Initalise le systme de gestion d'erreur
  AddErrorHandler(ErrorMessages);
  // Initialise les donnes du fichier espions
  SpyAvailLines=50;
  SafeNew(SpyLinesOffset,word[SpyAvailLines]);
  if (Error) FatalError();
  SpyCurrentLine=0;
  SpyLinesOffset[0]=0;
  // Positionne le nom du fichier espion }
  sprintf(SpyFName,"%sSPY.LOG",AppPath);
  FixPath(Buffer,SpyFName,300);
  if (Continue)
  {   //  Il faut rcuprer les donnes de l'ancien fichier espion
		// :: Ouvre le fichier espion en lecture
		Recover=fopen(Buffer,"rt");
		if (Recover==NULL)
		{ Error=erOpenSpyFile;
		  FatalError();
		}
		// :: Lit les lignes et garde leur position dans le fichier
		Pos=0;
		while(!feof(Recover))
		{ fgets(Lgn,200,Recover);
		  Pos+=strlen(Lgn);
		  OneMoreLine();
		  SpyLinesOffset[SpyCurrentLine+1]=Pos;
		}
		fclose(Recover);
  }
  else
  { // Tente la cration du fichier espion, pour voir si tout est OK
	 CreateSpy();
	 if (Error) FatalError();
	 CloseSpy();
  }
}

//---------------------------------------------------------------------------
// DoneSpy

void DoneSpy()
{ SafeDelete(SpyLinesOffset);
  if (Error) FatalError();
}
