// Associated include file : Mecanism/SetUp.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/setup.h"
#include <dos.h>

TSetUp SetUp;

void InitSetUp(void)
{ TDisk     *FileIn;
  char       FileName[200];
  // Build the full name for the SWORD2.CFG setup file
  sprintf(FileName,"%s/sword.cfg",SwordPath);
  // Try to open and readthis file
  FileIn=new TDisk(FileName,stOpen);
  FileIn->Read(SetUp.SystemFontName,22);
  FileIn->Read(&SetUp.ScreenX,sizeof(int16));
  FileIn->Read(&SetUp.ScreenY,sizeof(int16));
  FileIn->Read(&SetUp.ScreenColors,sizeof(int32));
  // Check an error in openning and reading the file
  if (Error)
  { // If the file is not available, set default values
    Error=0;
    // :: System Font = Helvetica, 14pts
    strcpy(SetUp.SystemFontName,"HELV14");
    // :: Screen Parameters
    SetUp.ScreenX=640;
    SetUp.ScreenY=480;
    SetUp.ScreenColors=16;
    // :: Write this default SetUp file
    WriteSetUp();
  }
  // Close the setup file
  delete FileIn;
  Error=0;
  // Force graphic mode to 640x480x16 if TurboC version
#ifdef _TURBOC_
  SetUp.ScreenX=640;
  SetUp.ScreenY=480;
  SetUp.ScreenColors=16;
#endif
  // Write the actual setup to Debugging file
  Debug("  SETUP...     System Font    = %s\n"
		  "               Screen Size    = (%d,%d) %d colors\n",

		  SetUp.SystemFontName,
		  (int)(SetUp.ScreenX),(int)(SetUp.ScreenY),
		  (int)(SetUp.ScreenColors));
  // Write the actual setup to the initialisation text screen
  printf("Current SetUp         : System Font    = %s\n"
			"                        Screen Size    = (%d,%d) %d colors\n",
			SetUp.SystemFontName,
			(int)(SetUp.ScreenX),(int)(SetUp.ScreenY),
			(int)(SetUp.ScreenColors));
  printf("\n");
}

void WriteSetUp(void)
{ TDisk *FileOut;
  char   FileName[200];
  // Build the full name for the SWORD2.CFG setup file
  sprintf(FileName,"%s/sword.cfg",SwordPath);
  // Try to open this file
  FileOut=new TDisk(FileName,stCreate);
  // Write the setup into the file
  FileOut->Write(SetUp.SystemFontName,22);
  FileOut->Write(&SetUp.ScreenX,sizeof(int16));
  FileOut->Write(&SetUp.ScreenY,sizeof(int16));
  FileOut->Write(&SetUp.ScreenColors,sizeof(int32));
  // Close the setup file
  delete FileOut;
}

void DoneSetUp(void)
{ }
