// Associated include file : Mecanism/Object.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/atom.h"
#include "mecanism/point.h"
#include "mecanism/event.h"
#include "mecanism/keyboard.h"
#include "mecanism/object.h"

DEFINE(TObject);

// Global variables

short RegTObject;
char *IdentTObject = "TObject";

// Constructor, Destructor

TObject::TObject(void)
{ Defaults();
}

void TObject::Defaults(void)
{ // Object Identification
  Register=RegTObject;
  Ident=IdentTObject;
  // Other default values
  Options=Status=0;
}

void TObject::InitAfterInsert(void)
{ }

// Events

void TObject::DealEvent(TEvent* Event)
{ TObject *O,*Od;
  int      S=Event->Options & evOpBackward;
  if (Son()!=NULL)
  { Od=Son();
    if (S) Od=Od->Last();
    if (Event->What & evFocused)
    { // It the event is a 'evFocus' one, Deal it only to
      // sons that own the focus
	   O=Od;
		while((O!=NULL) && (Event->What!=evNothing))
	   { if (O->Focus()) O->HandleEvent(Event);
	     if (S) O=O->Previous(); else O=O->Next();
	   }
	   // Then, deal it to sons that do not own the focus, but
       // that must receive all events
	   O=Od;
	   while((O!=NULL) && (Event->What!=evNothing))
	   { if (O->GetOptions(opGetAllEvents))
           if (!(O->Focus())) O->HandleEvent(Event);
	     if (S) O=O->Previous(); else O=O->Next();
	   }
    }
    else
    { // For other kind of event, Deal it to all sons
      O=Od;
	   while((O!=NULL) & (Event->What!=evNothing))
	   { O->HandleEvent(Event);
	     if (S) O=O->Previous(); else O=O->Next();
	   }
    }
  }
}

void TObject::TreatEvent(TEvent *Event)
{ if (Event->What != evNothing)
  { // The event that is going to be treated is this one
    CurrentEvent=*Event;
    // Dispatch the event in treatment functions
    if (DispatchEvent(Event)) ClearEvent(Event);
  }
}

void TObject::HandleEvent(TEvent* Event)
{ // Deal event to sons
  DealEvent(Event);
  // Treat the event
  TreatEvent(Event);
}

boolean TObject::DispatchEvent(TEvent *Event)
{ if (Event->What==evKeyDown)
    return KeyDown(Event->ScanCode,Event->KbStat);
  return FALSE;
}

void TObject::ClearEvent(TEvent *Event)
{ Event->What=evNothing;
  Event->InfoPtr=this;
}

void TObject::SetEvent(TEvent* Event)
{ if (Father()!=NULL) Father()->SetEvent(Event);
}

void TObject::GetEvent(TEvent* Event)
{ if (Father()!=NULL) Father()->GetEvent(Event);
                 else Event->What=evNothing;
}

long TObject::Exec(void)
{ //return Shell->EventsLoop(this);
  return 0;
}

void TObject::SetCommand(long Command)
{ TEvent Event;
  Event.What=evCommand;
  Event.Command=Command;
  SetEvent(&Event);
}

void TObject::SetCommand(long Command, char Info08b)
{ TEvent Event;
  Event.What=evCommand;
  Event.Command=Command;
  Event.Info08b=Info08b;
  SetEvent(&Event);
}

void TObject::SetCommand(long Command, short Info16b)
{ TEvent Event;
  Event.What=evCommand;
  Event.Command=Command;
  Event.Info16b=Info16b;
  SetEvent(&Event);
}

void TObject::SetCommand(long Command, long Info32b)
{ TEvent Event;
  Event.What=evCommand;
  Event.Command=Command;
  Event.Info32b=Info32b;
  SetEvent(&Event);
}

void TObject::SetCommand(long Command, void *InfoPtr)
{ TEvent Event;
  Event.What=evCommand;
  Event.Command=Command;
  Event.InfoPtr=InfoPtr;
  SetEvent(&Event);
}

boolean TObject::KeyDown(int ScanCode, int )
{ if (GetStatus(sfSelected))
    switch(ScanCode)
    { case ScanTab      :
        SelectNext();
        return TRUE;
      case ScanShiftTab :
	     SelectPrevious();
        return TRUE;
    }
  return FALSE;
}

// Selections

void TObject::Select(void)
{ TObject* O;
  if (GetOptions(opSelectable))
    if (!GetStatus(sfSelected))
    { // UnSelect other objects in the current list
      O=First();
      while (O!=NULL)
      { O->UnSelect();
        O=O->Next();
      }
      // Put the sfSelected bit
      SetStatus(sfSelected);
      // Tell to himself and to all sons that we are now selected
      TEvent Event;
      Event.What=evCommand;
      Event.Command=cmSelect;
      HandleEvent(&Event);
    }
}

void TObject::UnSelect(void)
{ if (GetOptions(opSelectable))
  { if (GetStatus(sfSelected))
    { // Tell to himself and to all sons that we will be no more selected
      TEvent Event;
      Event.What=evCommand;
      Event.Command=cmUnSelect;
      HandleEvent(&Event);
      // Clear the sfSelected bit
      ClearStatus(sfSelected);
    }
  }
}

void TObject::SelectNext(void)
{ TObject* O=this;
  do
  { O=O->Next();
    if (O==NULL) O=First();
  } while(  (!O->GetOptions(opSelectable))  ||
            (O->GetStatus(sfDisabled))
         );
  O->Select();
}

void TObject::SelectPrevious(void)
{ TObject* O=this;
  do
  { O=O->Previous();
    if (O==NULL) O=Last();
  } while( (!O->GetOptions(opSelectable)) ||
           (O->GetStatus(sfDisabled))
         );
  O->Select();
}

boolean TObject::Focus(void)
{ if (GetStatus(sfSelected)) return Father()->Focus();
                        else return FALSE;
}

// Linked lists

void TObject::Insert(TAtom* A)
{ TAtom::Insert(A);
  ((TObject*)A)->InitAfterInsert();
  ((TObject*)A)->Select();
}

// Objects streams

void TObject::Read(TDisk *file)
{ TAtom::Read(file);
  ReadInt(file,&Status);
  ReadInt(file,&Options);
  ClearStatus(sfSelected);
}

void TObject::Write(TDisk *file)
{ TAtom::Write(file);
  WriteInt(file,Status);
  WriteInt(file,Options);
}

// Data exchange

long TObject::DataSize(void)
{ long     Result=0;
  TObject *O=Son();
  while(O!=NULL)
  { Result+=O->DataSize();
    O=O->Next();
  }
  return Result;
}

void TObject::GetData(void *Ptr)
{ TObject *O=Son();
  char    *P=(char*)Ptr;
  while(O!=NULL)
  { O->GetData(P);
	 P+=(int)O->DataSize();
    O=O->Next();
  }
}

void TObject::SetData(void *Ptr)
{ TObject *O=Son();
  char    *P=(char*)Ptr;
  while(O!=NULL)
  { O->SetData(P);
	 P+=(int)O->DataSize();
    O=O->Next();
  }
}
