/*
    Run-time dynamic linking of DLL functions

    Emx 0.9c does not understand WINAPI inside a typedef definition (stack).
    The functions save_access and save_stat restores the stack.

    NT09c does not contain this error.
*/

#define STRICT
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdio.h>
#include "dlltest.h"

typedef int WINAPI (*DLLFUNC) (int, int);

int save_stdcall(DLLFUNC func, int a, int b)
{
    return (*func) (a,b);
}

int WINAPI WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow)
{
    HINSTANCE hLib;
    DLLFUNC lpfnMin, lpfnMax;
    int x1, x2, x3;
    char buf[260];

    hLib = LoadLibrary("dlltest.dll");
    if (!hLib) {
	DWORD err = GetLastError();
        sprintf(buf, "Cannot load dll fails err=0x%lX = %ld", err, err);
	MessageBox(NULL, buf, NULL, MB_OK);
        return(1);
    }
    lpfnMax = (DLLFUNC) GetProcAddress(hLib, "Maximum");
    if (!lpfnMax) {
	sprintf(buf, "Error: GetProcAddress(Maximum)");
	MessageBox(NULL, buf, NULL, MB_OK);
        return(1);
    }
    lpfnMin = (DLLFUNC) GetProcAddress(hLib, "Minimum");
    if (!lpfnMin) {
	sprintf(buf, "Error: GetProcAddress(Minimum)");
	MessageBox(NULL, buf, NULL, MB_OK);
        return(1);
    }

    x1 = 2;
    x2 = 3;

    x3 = save_stdcall(lpfnMax, x1, x2);
    sprintf(buf, "Maximum (%d,%d) = %d\n", x1, x2, x3);
    MessageBox(NULL, buf, "dll Minimum", MB_OK);

    x3 = save_stdcall(lpfnMin, x1, x2);
    sprintf(buf, "Minimum (%d,%d) = %d\n", x1, x2, x3);
    MessageBox(NULL, buf, "dll Minimum", MB_OK);

    FreeLibrary(hLib);

    return 0;
}
