/***************************************************************************\
*                                                                           *
*   WINKEYB.H                                                               *
*                                                                           *
*   Some headers are used from the cygnus project                           *
*   Modified by:                                                            *
*    kiefer@isys.de                                                         *
*    rainer@mathematik.uni-bielefeld.de                                     *
*									    *
\***************************************************************************/

#if !defined (_WINKEYB_H)
#define _WINKEYB_H

#ifdef __cplusplus
extern "C" {
#endif

#define VK_LBUTTON	0x01
#define VK_RBUTTON    0x02
#define VK_CANCEL       0x03
#define VK_MBUTTON   0x04
#define VK_BACK           	0x08
#define VK_TAB            	0x09
#define VK_CLEAR          0x0C
#define VK_RETURN       0x0D
#define VK_SHIFT          	0x10
#define VK_CONTROL    0x11
#define VK_MENU           0x12
#define VK_PAUSE          0x13
#define VK_CAPITAL      0x14
#define VK_ESCAPE  	0x1B
#define VK_SPACE          0x20
#define VK_PRIOR  	0x21
#define VK_NEXT           	0x22
#define VK_END            	0x23
#define VK_HOME           0x24
#define VK_LEFT           	0x25
#define VK_UP             	0x26
#define VK_RIGHT          	0x27
#define VK_DOWN          0x28
#define VK_SELECT        0x29
#define VK_PRINT          	0x2A
#define VK_EXECUTE     0x2B
#define VK_SNAPSHOT  0x2C
#define VK_INSERT         0x2D
#define VK_DELETE        0x2E
#define VK_HELP           	0x2F

/* VK_0 thru VK_9 are the same as ASCII '0' thru '9' (0x30 - 0x39) */
/* VK_A thru VK_Z are the same as ASCII 'A' thru 'Z' (0x41 - 0x5A) */

#define VK_LWIN       	0x5B
#define VK_RWIN           	0x5C
#define VK_APPS           	0x5D
#define VK_NUMPAD0   0x60
#define VK_NUMPAD1   0x61
#define VK_NUMPAD2   0x62
#define VK_NUMPAD3   0x63
#define VK_NUMPAD4   0x64
#define VK_NUMPAD5   0x65
#define VK_NUMPAD6   0x66
#define VK_NUMPAD7   0x67
#define VK_NUMPAD8   0x68
#define VK_NUMPAD9   0x69
#define VK_MULTIPLY   0x6A
#define VK_ADD            	0x6B
#define VK_SEPARATOR      0x6C
#define VK_SUBTRACT  0x6D
#define VK_DECIMAL    0x6E
#define VK_DIVIDE         0x6F
#define VK_F1             	0x70
#define VK_F2             	0x71
#define VK_F3             	0x72
#define VK_F4             	0x73
#define VK_F5             	0x74
#define VK_F6             	0x75
#define VK_F7             	0x76
#define VK_F8             	0x77
#define VK_F9             	0x78
#define VK_F10            	0x79
#define VK_F11            	0x7A
#define VK_F12            	0x7B
#define VK_F13            	0x7C
#define VK_F14            	0x7D
#define VK_F15            	0x7E
#define VK_F16            	0x7F
#define VK_F17            	0x80
#define VK_F18            	0x81
#define VK_F19            	0x82
#define VK_F20            	0x83
#define VK_F21            	0x84
#define VK_F22            	0x85
#define VK_F23            	0x86
#define VK_F24            	0x87
#define VK_NUMLOCK  0x90
#define VK_SCROLL       0x91
#define VK_LSHIFT         0xA0
#define VK_RSHIFT         0xA1
#define VK_LCONTROL       0xA2
#define VK_RCONTROL       0xA3
#define VK_LMENU          0xA4
#define VK_RMENU          0xA5
#define VK_PROCESSKEY     0xE5
#define VK_ATTN           0xF6
#define VK_CRSEL          0xF7
#define VK_EXSEL          0xF8
#define VK_EREOF          0xF9
#define VK_PLAY           0xFA
#define VK_ZOOM           0xFB
#define VK_NONAME         0xFC
#define VK_PA1            0xFD
#define VK_OEM_CLEAR      0xFE

#if !defined(RC_INVOKED)
UINT WINAPI GetKBCodePage(VOID);
SHORT WINAPI GetKeyState(int nVirtKey);
SHORT WINAPI GetAsyncKeyState(int vKey);
BOOL WINAPI GetKeyboardState(PBYTE lpKeyState);
BOOL WINAPI SetKeyboardState(LPBYTE lpKeyState);
#define GetKeyNameText TFUNCT(GetKeyNameText)
int WINAPI GetKeyNameText(LONG lParam, LPTSTR lpString, int nSize);
int WINAPI GetKeyboardType(int nTypeFlag);
int WINAPI ToAscii(UINT uVirtKey, UINT uScanCode, PBYTE lpKeyState,
	LPWORD lpChar, UINT uFlags);
int WINAPI ToAsciiEx(UINT uVirtKey,  UINT uScanCode, PBYTE lpKeyState,
	LPWORD lpChar, UINT uFlags, HKL dwhkl);
int WINAPI ToUnicode(UINT wVirtKey, UINT wScanCode, PBYTE lpKeyState,
	LPWSTR pwszBuff, int cchBuff, UINT wFlags);
int WINAPI ToUnicodeEx(UINT wVirtKey, UINT wScanCode, PBYTE lpKeyState,
	LPWSTR pwszBuff, int cchBuff, UINT wFlags, HKL dwhkl);
DWORD WINAPI OemKeyScan(WORD wOemChar);
#define VkKeyScan TFUNCT(VkKeyScan)
SHORT WINAPI VkKeyScan(TCHAR ch);
#define VkKeyScanEx TFUNCT(VkKeyScanEx)
SHORT WINAPI VkKeyScanEx(TCHAR  ch, HKL   dwhkl);

#define HKL_PREV            0
#define HKL_NEXT            1

#define KLF_ACTIVATE        0x00000001
#define KLF_SUBSTITUTE_OK   0x00000002
#define KLF_UNLOADPREVIOUS  0x00000004
#define KLF_REORDER         0x00000008
#define KLF_REPLACELANG     0x00000010
#define KLF_NOTELLSHELL     0x00000080

#define KL_NAMELENGTH       9

#define LoadKeyboardLayout TFUNCT(LoadKeyboardLayout)
HKL WINAPI LoadKeyboardLayout(LPCTSTR pwszKLID, UINT Flags);
HKL WINAPI ActivateKeyboardLayout(HKL hkl, UINT Flags);
BOOL WINAPI UnloadKeyboardLayout(HKL hkl);
#define GetKeyboardLayoutName TFUNCT(GetKeyboardLayoutName)
BOOL WINAPI GetKeyboardLayoutName(LPTSTR pwszKLID);
int WINAPI GetKeyboardLayoutList(int nBuff, HKL *lpList);
HKL WINAPI GetKeyboardLayout(DWORD dwLayout);

#define KEYEVENTF_EXTENDEDKEY 0x0001
#define KEYEVENTF_KEYUP       0x0002

VOID WINAPI keybd_event(BYTE bVk, BYTE bScan, DWORD dwFlags,
	DWORD dwExtraInfo);
#endif /* RC_INVOKED */

#ifdef __cplusplus
}
#endif

#endif /* !defined (_WINKEYB_H) */
