//  example9.cc - Demontrates use of Events under C++ PDMLWP
//  Copyright (C) 1997 Paolo De Marino
//
//  This program is free software; you can redistribute it and/or modify
//  it freely; basically you can do whatever you want with it.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING. If not, write to the
//  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//  For contacting the author send electronic mail to
//     pdemarin@mbx.idn.it
//
//  Or paper mail to
//
//     Paolo De Marino
//     Via Donizetti 1/E
//     80127 Naples
//     Italy
#include <stdio.h>
#include <conio.h>
#include "lwp.h"
#include <dos.h>
#include <stdlib.h>
#include "threads.h"

Event theEvent;

class eventWaiterThread : public Thread
{
public:
       eventWaiterThread(unsigned stacksize) : Thread(stacksize) { };

       void execute(void)
       {
        while(1)
        {
         theEvent.Wait();
         printf("Event received!\n");
        }
       }
};

int main(int, char *[])
{
    InitLwp(RTC128);
    printf("Starting...\n");
    printf("Current Thread=%p\n",&Thread::currentThread());

    eventWaiterThread waiter(8192);

    waiter.start();

    while(1)
    {
     if(!kbhit()) lwp_yield();
     theEvent.Raise();
     if(getch()=='Q') break;
    }
    waiter.kill();

    printf("Task killed...\n");
    waiter.waitCompletion();

    DoneLwp();
    return 0;
}
