/************************************************************************
// File lwpstdio.h - INCOMPLETE patch to stdio.h
// Copyright (C) 1997 Paolo De Marino
//
// Original Source Code by Sengan Short (sengan.short@durham.ac.uk)
// and Josh Turpen (snarfy@goodnet.com).
//
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version,
//  with the only exception that all the people in the THANKS file
//  must receive credit.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//
//  You should have received a copy of the GNU Library General Public
//  License along with this library; see the file COPYING.LIB.
//  If not, write to the Free Software Foundation, Inc., 675 Mass Ave,
//  Cambridge, MA 02139, USA.
//
//  For contacting the author send electronic mail to
//     pdemarin@mbx.idn.it
//
//  Or paper mail to
//
//     Paolo De Marino
//     Via Donizetti 1/E
//     80127 Naples
//     Italy
//
// History:
// Who knows?           Original code by Sengan Short and Josh Turpen
************************************************************************/
/* LWP STDIO: An interim solution until we rewrite libc */
/* Must be placed AFTER all #include <...> in any file */
/* Does not garantee re-entrancy of other files */

/*  Simply switching the transfer buffer does not garantee reentrancy until   */
/*  we've checked through the libc to be sure nothing else is non-reentrant!  */

#ifndef __lwp_include_stdio_h_
#define __lwp_include_stdio_h_
#include <stdio.h>
#include <stdarg.h>
extern int _lwp_enable;
#ifdef __cplusplus
extern "C" {
#endif

__inline__ static void _lwp_clearerr(FILE *_stream)
{
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  clearerr(_stream);
  _lwp_enable = tmp;
  }
#define clearerr _lwp_clearerr

__inline__ static int _lwp_fclose(FILE *_stream)
{ 
  volatile int result;
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = fclose(_stream);
  _lwp_enable = tmp;
  return result; }
#define fclose _lwp_fclose

__inline__ static int _lwp_feof(FILE *_stream)
{
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = feof(_stream);
  _lwp_enable = tmp;
  return result;
 }
#define feof _lwp_feof

__inline__ static int _lwp_ferror(FILE *_stream)
{
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = ferror(_stream);
  _lwp_enable = tmp;
  return result; 
}
#define ferror _lwp_ferror

__inline__ static int _lwp_fflush(FILE *_stream)
{
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = fflush(_stream);
  _lwp_enable = tmp;
  return result;
}
#define fflush _lwp_fflush

__inline__ static int _lwp_fgetc(FILE *_stream)
{
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = fgetc(_stream);
  _lwp_enable = tmp;
  return result;
}
#define fgetc _lwp_fgetc

__inline__ static int _lwp_fgetpos(FILE *_stream, fpos_t *_pos)
{ 
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  result = fgetpos(_stream, _pos);
  _lwp_enable = tmp;
  return result;
}
#define fgetpos _lwp_fgetpos

__inline__ static char* _lwp_fgets(char *_s, int _n, FILE *_stream)
{ 
  volatile int tmp;
  char *result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = fgets(_s, _n, _stream);
  _lwp_enable = tmp;
  return result;
}
#define fgets _lwp_fgets

__inline__ static FILE*	_lwp_fopen(const char *_filename, const char *_mode)
{ 
  volatile int tmp;
  FILE *result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = fopen(_filename, _mode);
  _lwp_enable = tmp;
  return result;
}
#define fopen _lwp_fopen

static int _lwp_fprintf(FILE *, const char *, ...) __attribute__((unused));
static int _lwp_fprintf(FILE *_stream, const char *_format, ...)
{ 
  volatile int tmp;
  volatile int result;
  volatile va_list argptr;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  va_start( argptr, _format );
  result = vfprintf(_stream, _format, argptr);
  va_end(argptr);
  _lwp_enable = tmp;
  return result;
}
#define fprintf _lwp_fprintf

__inline__ static int _lwp_fputc(int _c, FILE *_stream)
{
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = fputc(_c, _stream);
  _lwp_enable = tmp;
  return result;
}
#define fputc _lwp_fputc

__inline__ static int _lwp_fputs(const char *_s, FILE *_stream)
{
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = fputs(_s, _stream);
  _lwp_enable = tmp;
  return result;
}
#define fputs _lwp_fputs

__inline__ static
     size_t _lwp_fread(void *_ptr, size_t _size, size_t _nelem, FILE *_stream)
{ 
  volatile int tmp;
  volatile size_t result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = fread(_ptr, _size, _nelem, _stream);
  _lwp_enable = tmp;
  return result; 
}
#define fread _lwp_fread

__inline__ static
  FILE* _lwp_freopen(const char *_filename, const char *_mode, FILE *_stream)
{ 
  volatile int tmp;
  FILE* result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = freopen(_filename, _mode, _stream);
  _lwp_enable = tmp;
  return result; 
}
#define freopen _lwp_freopen

#define fscanf #error "Not simulated by lwp fscanf!"
/* int	fscanf(FILE *_stream, const char *_format, ...); */
/* We can't know the number of arguments unless we start doing some complex
   stuff... in which case just as well rewrite the thing! Maybe we can use
   _do_scanf */

__inline__ static int _lwp_fseek(FILE *_stream, long _offset, int _mode)
{ 
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = fseek(_stream, _offset, _mode);
  _lwp_enable = tmp;
  return result;
}
#define fseek _lwp_fseek

__inline__ static int _lwp_fsetpos(FILE *_stream, const fpos_t *_pos)
{
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = fsetpos(_stream, _pos);
  _lwp_enable = tmp;
  return result;
}
#define fsetpos _lwp_fsetpos

__inline__ static long _lwp_ftell(FILE *_stream)
{ 
  volatile int tmp;
  volatile long result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = ftell(_stream);
  _lwp_enable = tmp;
  return result;
}
#define ftell _lwp_ftell

__inline__ static size_t
     _lwp_fwrite(const void *_ptr, size_t _size, size_t _nelem, FILE *_stream)
{ 
  volatile int tmp;
  volatile size_t result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = fwrite(_ptr, _size, _nelem, _stream);
  _lwp_enable = tmp;
  return result;
}
#define fwrite _lwp_fwrite

__inline__ static int _lwp_getc(FILE *_stream)
{ 
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = getc(_stream);
  _lwp_enable = tmp;
  return result;
}
#define getc _lwp_getc

__inline__ static int _lwp_getchar(void)
{ 
 volatile  int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = getchar();
  _lwp_enable = tmp;
  return result;
}
#define getchar _lwp_getchar

__inline__ static char* _lwp_gets(char *_s)
{ 
  volatile int tmp;
  char* result;
  tmp = _lwp_enable;
  result = gets(_s);
  _lwp_enable = tmp;
  return result;
}
#define gets _lwp_gets
  
__inline__ static void _lwp_perror(const char *_s)
{ 
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
 perror(_s);
  _lwp_enable = tmp;
}
#define perror _lwp_perror
  
static int  _lwp_printf(const char *, ...) __attribute__((unused));
static int  _lwp_printf(const char *_format, ...)
{ 
  volatile int tmp;
  volatile int result;
  volatile va_list argptr;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  va_start( argptr, _format );
  result = vprintf(_format, argptr);
  va_end(argptr);
  _lwp_enable = tmp;
  return result;
}
#define printf _lwp_printf

__inline__ static int _lwp_putc(int _c, FILE *_stream)
{
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = putc(_c, _stream);
  _lwp_enable = tmp;
  return result;
}
#define putc _lwp_putc

__inline__ static int _lwp_putchar(int _c)
{ 
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = putchar(_c);
  _lwp_enable = tmp;
  return result;
}
#define putchar _lwp_putchar

__inline__ static int _lwp_puts(const char *_s)
{ 
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = puts(_s);
  _lwp_enable = tmp;
  return result; 
}
#define puts _lwp_puts

__inline__ static int _lwp_remove(const char *_filename)
{
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = remove(_filename);
  _lwp_enable = tmp;
  return result; 
}
#define remove _lwp_remove

__inline__ static int _lwp_rename(const char *_old, const char *_new)
{ 
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = rename(_old, _new);
  _lwp_enable = tmp;
  return result; 
}
#define rename _lwp_rename

__inline__ static void _lwp_rewind(FILE *_stream)
{ 
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  rewind(_stream); 
  _lwp_enable = tmp;
}
#define rewind _lwp_rewind

/* #define scanf #error "Not simulated by lwp scanf!"*/
/* Be careful that only one task uses scanf */
 int scanf(const char *_format, ...); 

__inline__ static void _lwp_setbuf(FILE *_stream, char *_buf)
{ 
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
 setbuf(_stream,_buf); 
  _lwp_enable = tmp;
}
#define setbuf _lwp_setbuf

__inline__ static
         int _lwp_setvbuf(FILE *_stream, char *_buf, int _mode, size_t _size)
{ 
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = setvbuf(_stream, _buf, _mode, _size);
  _lwp_enable = tmp;
  return result;
}
#define setvbuf _lwp_setvbuf

static int  _lwp_sprintf(char *, const char *, ...) __attribute__((unused));
static int  _lwp_sprintf(char *_s, const char *_format, ...)
{ 
  volatile int tmp;
  volatile int result;
  volatile va_list argptr;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  va_start( argptr, _format );
  result = vsprintf(_s, _format, argptr);
  va_end(argptr);
  _lwp_enable = tmp;
  return result; 
}
#define sprintf _lwp_sprintf

#define sscanf #error "Not simulated by lwp scanf!"
/* int	sscanf(const char *_s, const char *_format, ...); */

__inline__ static FILE* _lwp_tmpfile(void)
{ 
  volatile int tmp;
  FILE* result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = tmpfile();
  _lwp_enable = tmp;
  return result;
}
#define tmpfile _lwp_tmpfile

__inline__ static char* _lwp_tmpnam(char *_s)
{ 
  volatile int tmp;
  char* result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = tmpnam(_s);
  _lwp_enable = tmp;
  return result; 
}
#define tmpnam _lwp_tmpnam

__inline__ static int _lwp_ungetc(int _c, FILE *_stream)
{ 
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = ungetc(_c, _stream);
  _lwp_enable = tmp;
  return result; 
}
#define ungetc _lwp_ungetc

__inline__ static
            int _lwp_vfprintf(FILE *_stream, const char *_format, va_list _ap)
{ 
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = vfprintf(_stream, _format, _ap);
  _lwp_enable = tmp;
  return result; 
}
#define vfprintf _lwp_vfprintf

__inline__ static int _lwp_vprintf(const char *_format, va_list _ap)
{ 
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = vprintf(_format, _ap);
  _lwp_enable = tmp;
  return result;
}
#define vprintf _lwp_vprintf

__inline__ static int _lwp_vsprintf(char *_s, const char *_format, va_list _ap)
{ 
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = vsprintf( _s, _format, _ap);
  _lwp_enable = tmp;
  return result; 
}
#define vsprintf _lwp_vsprintf

#ifndef __STRICT_ANSI__

__inline__ static int _lwp_fileno(FILE *_stream)
{ 
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = fileno( _stream);
  _lwp_enable = tmp;
  return result; 
}
#define fileno _lwp_fileno

__inline__ static FILE * _lwp_fdopen(int _fildes, const char *_type)
{ 
  volatile int tmp;
  FILE *result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = fdopen(_fildes, _type);
  _lwp_enable = tmp;
  return result;
}
#define fdopen _lwp_fdopen

__inline__ static int _lwp_pclose(FILE *_pf)
{ 
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = pclose( _pf);
  _lwp_enable = tmp;
  return result; 
}
#define pclose _lwp_pclose

__inline__ static FILE * _lwp_popen(const char *_command, const char *_mode)
{ 
  volatile int tmp;
  FILE *result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = popen(_command, _mode);
  _lwp_enable = tmp;
  return result; 
}
#define popen _lwp_popen

#ifndef _POSIX_SOURCE

__inline__ static void _lwp__djstat_describe_lossage(FILE *_to_where)
{ 
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  _djstat_describe_lossage(_to_where);
  _lwp_enable = tmp;
}
#define _djstat_describe_lossage _lwp__djstat_describe_lossage

__inline__ static int _lwp__doprnt(const char *_fmt, va_list _args, FILE *_f)
{ 
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = _doprnt(_fmt, _args, _f);
  _lwp_enable = tmp;
  return result; 
}
#define _doprnt _lwp__doprnt

__inline__ static int _lwp__doscan(FILE *_f, const char *_fmt, void **_argp)
{ 
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = _doscan(_f, _fmt, _argp);
  _lwp_enable = tmp;
  return result; 
}
#define _doscan _lwp__doscan

/* NOTE: not exactly the same protoype as stdio.h */
__inline__ static int _lwp__doscan_low(FILE *_f, int (*_get)(FILE *), int (*_unget)(int, FILE *), const char *_fmt, void **_argp)
{ 
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = _doscan_low(_f, _get, _unget, _fmt, _argp);
  _lwp_enable = tmp;
  return result; 
}
#define _doscan_low _lwp__doscan_low

__inline__ static int _lwp_fpurge(FILE *_f)
{ 
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = fpurge( _f);
  _lwp_enable = tmp;
  return result; 
}
#define fpurge _lwp_fpurge

__inline__ static int _lwp_getw(FILE *_f)
{ 
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = getw( _f);
  _lwp_enable = tmp;
  return result; 
}
#define getw _lwp_getw

__inline__ static int _lwp_mkstemp(char *_template)
{ 
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = mkstemp( _template);
  _lwp_enable = tmp;
  return result; 
}
#define mkstemp _lwp_mkstemp

__inline__ static char *_lwp_mktemp(char *_template)
{ 
  volatile int tmp;
  char *result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = mktemp( _template);
  _lwp_enable = tmp;
  return result; 
}
#define mktemp _lwp_mktemp

__inline__ static int _lwp_putw( int _v, FILE *_f)
{ 
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = putw( _v, _f);
  _lwp_enable = tmp;
  return result; 
}
#define putw _lwp_putw

__inline__ static void _lwp_setbuffer(FILE *_f, void *_buf, int _size)
{ 
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  setbuffer(_f, _buf, _size); 
  _lwp_enable = tmp;
}
#define setbuffer _lwp_setbuffer

__inline__ static void _lwp_setlinebuf(FILE *_f)
{ 
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
 setlinebuf(_f); 
  _lwp_enable = tmp;
}
#define setlinebuf _lwp_setlinebuf

__inline__ static char *_lwp_tempnam(const char *_dir, const char *_prefix)
{ 
  volatile int tmp;
  char *result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = tempnam(_dir, _prefix);
  _lwp_enable = tmp;
  return result; 
}
#define putw _lwp_putw

__inline__ static int _lwp__rename(const char *_old, const char *_new)
{ 
  volatile int tmp;
  volatile int result;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = _rename( _old, _new);
  _lwp_enable = tmp;
  return result; 
}
#define _rename _lwp__rename

#endif /* !_POSIX_SOURCE */
#endif /* !__STRICT_ANSI__ */


#ifdef __cplusplus
}
#endif

#endif /* !__lwp_include_stdio_h_ */
