/************************************************************************
// File lwp.h - Headers for lwp.c
// Copyright (C) 1997 Paolo De Marino
//
// Original Source Code by Sengan Short (sengan.short@durham.ac.uk)
// and Josh Turpen (snarfy@goodnet.com).
//
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version,
//  with the only exception that all the people in the THANKS file
//  must receive credit.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//
//  You should have received a copy of the GNU Library General Public
//  License along with this library; see the file COPYING.LIB.
//  If not, write to the Free Software Foundation, Inc., 675 Mass Ave,
//  Cambridge, MA 02139, USA.
//
//  For contacting the author send electronic mail to
//     pdemarin@mbx.idn.it
//
//  Or paper mail to
//
//     Paolo De Marino
//     Via Donizetti 1/E
//     80127 Naples
//     Italy
//
// History:
// Who knows?           Original code by Sengan Short and Josh Turpen
//
// May 18th, 1997       Modified lwpasm.S to call back a new function,
// (more or less)       lwp_findnext(), to implement semaphores and
//                      waiting threads.
//                      Added ex novo lwp_wait_true,lwp_wait_false,
//                      lwp_wait_semaphore,lwp_release_semaphore,
//                      and related data types (lwp_semaphore,
//                      lwp_time). Minor modifications to _lwp_dead_thread.
//
// May 22nd, 1997       C++ Support added
************************************************************************/

#ifndef _LWP_H
#define _LWP_H

#include <dpmi.h>
#include <signal.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#define LWP_MAIN -1
/* for programming IRQ8 */
#define RTC2            0xF
#define RTC4            0xE
#define RTC8            0xD
#define RTC16           0xC
#define RTC32           0xB
#define RTC64           0xA
#define RTC128          0x9
#define RTC256          0x8
#define RTC512          0x7
#define RTC1024         0x6
#define RTC2048         0x5
#define RTC4096         0x4
#define RTC8192         0x3
#ifdef __cplusplus
extern "C" {
#endif
/* Don't change this struct.  The scheduler needs to know their positions. */
/* If you have to add anything, add it AFTER stack */

typedef volatile struct {
        int owned;     // Is it owned or not?
        int owner_id;  // If yes, by whom?
} lwp_semaphore;

typedef struct
{
   time_t   secs;          // Seconds from 0:0:0 1/1/70 GMT
   short    msecs;         // As from uclock()
} lwp_time;

typedef struct lwp_struct {
int lwpid;
struct lwp_struct *next;
int stklen;
unsigned int *stack;

enum { RUNNING,SLEEPING,WAIT_SEMAPHORE,WAIT_TRUE,WAIT_FALSE } status;
union { lwp_semaphore *what_sema;  // If status== WAIT_SEMAPHORE
        volatile int  *what_int;   // If status==WAIT_TRUE|WAIT_FALSE
        lwp_time      wakeup_time; // If status==SLEEPING
      } waiting;

void *userptr;                 // User per-task pointer
} lwp;

/* User functions */
int lwp_init(int irq, int speed);
int lwp_spawn(void (*proc)(void), int stack_length);
int lwp_kill(volatile int lwpid);
int lwp_getpid(void);
void lwp_setuserptr(void *usrdata);
void *lwp_getuserptr(void);
void lwp_yield(void);

void lwp_sleep(unsigned int secs,unsigned short msecs);
void lwp_wait_true(volatile int *what);   // Wait until what != 0
void lwp_wait_false(volatile int *what);  // Wait until what == 0
void lwp_pulse_true(volatile int *what);  // Free all the tasks waiting for
void lwp_pulse_false(volatile int *what); // what to become true/false
void lwp_wait_semaphore(lwp_semaphore *sema);
int lwp_release_semaphore(lwp_semaphore *sema);
void lwp_init_semaphore(lwp_semaphore *sema);

extern void _lwp_pm_irq8_timer_hook(void);
extern void _lwp_pm_irq0_timer_hook(void);

/* for locking critical code */
extern long  _lwpasm_start;
extern long  _lwpasm_end;
int _lwp_lock_data( void *lockaddr, unsigned long locksize );
int _lwp_unlock_data( void *lockaddr, unsigned long locksize );
int _lwp_lock_code( void *lockaddr, unsigned long locksize );
int _lwp_unlock_code( void *lockaddr, unsigned long locksize );

extern lwp *_lwp_cur;

/* for blocking a task switch */
volatile void lwp_thread_enable( void );
volatile void lwp_thread_disable( void );

#ifdef __cplusplus
}
#endif

#include "lwpconio.h"
#include "lwpstdio.h"
#include "lwppc.h"
#include "lwpstdlib.h"
#endif
