/*             General type definitions for standard types.
               ============================================

               Copyright (c) 1996 Grafik Software by Malcolm Taylor
*/

#ifndef _types_h
#define _types_h

#if defined(__cplusplus) && defined(__GNUC__)
#  define MAX(a,b) ((a)>?(b))
#  define MIN(a,b) ((a)<?(b))
#else
#  define MAX(a,b) ((a)>(b)?(a):(b))
#  define MIN(a,b) ((a)<(b)?(a):(b))
#endif

#define TRUE   1
#define FALSE  0

typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned long DWORD;
typedef signed char SBYTE;
typedef signed short SWORD;
typedef signed long SDWORD;

typedef int BOOL;

#endif
