/*************************************************************
 ***************    ===The Window System===    ***************
 *************************************************************
				Copyright (c)1995,1996 Malcolm Taylor

 -> RESOURCE.H
 -> Resource file management class declarations.
*/

#ifndef _resource_h
#define _resource_h

#include <types.h>
#include <stdio.h>

/*
	The Resource file format:
		ResourceBlocks - Each resource is a solid block of data.
		ResourceTable - An index table for the constituent resources.
		ResourceHeader - Contains general file information.
*/

typedef struct {
	char name[256];         // Name (up to 255 characters).
	int pos;                // Position in file.
	int length;             // Length of resource.
	BYTE flags;             // Flags for the entry (eg compression method).
} TableEntry;

class ResourceManager {
	public:
		ResourceManager();
		~ResourceManager();
					// Cleans up but leaves all memory allocated, so remove all
					// resources before destroying the ResourceManager object.
		int RegisterResourceFile(char *filename);
					// Registers a resource file,returns FALSE on error.
		int RemoveResourceFile(char *filename);
					// Removes a resource file,returns FALSE on error.
		BYTE *GetResource(char *name);
					// Gets the named resource.
		int GetResourceNumber(char *name);
					// Returns the number of the given resource.
		char *GetResourceFile(char *name);
					// Returns the resource file that name is from.
		int GetNumberOfResources(char *resfilename);
					// Gets the number of entries in the table.
		char *GetResourceName(char *resfilename,int n);
					// Returns the name of the nth resource in resfilename.
		int GetResourceLength(char *resfilename,int n);
					// Gets the actual length of the resource.
		int GetCompressedResourceLength(char *resfilename,int n);
					// Gets the length of the compressed resource.

	protected:

		int *nentries;             // The number of entries in each table.
		TableEntry **FileTables;   // Pointers to the tables of the resources.
		int *offsets;              // Offsets to the starting position in the files.
		char **FileNames;          // Filenames of the registered resource files.
		FILE **files;              // File handles of the resource files.
};

#ifdef __cplusplus
extern "C" {
#endif

int CreateResourceFile(char *filename);         
									/* Creates a resource file. */
int AddResource(char *filename,char *resname,BYTE *resource,int len);
									/* Adds resname to filename. */
int AddResourceCompressed(char *filename,char *resname,BYTE *resource,int len);
									/* Adds resname compressed to filename. */
int DeleteResource(char *filename,char *resname);
									/* Removes resname from filename.*/

#ifdef __cplusplus
}
#endif



#endif
