/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: _wcinit.c,v 1.2 1996/10/27 13:23:46 jack Exp $ */

#include <locale.h>
#include <stddef.h>
#include <string.h>
#include <wcprvt.h>

void
__wcinit (int category, const char *locale)
{
  if (locale == NULL || *locale == '\0')
    return;

  if (strcmp (locale, "C") == 0)
    {
      if (category == LC_CTYPE || category == LC_ALL)
	{
	  __wcprops = &__wcprops_c[0];
	  __wcprops_trans = &__wcprops_trans_c[0];
	  __wcprops_num = __wcprops_c_num;
	  __wcprops_trans_num = __wcprops_trans_c_num;
	}
    }
  else if (strcmp (locale, "ja_JP.SJIS") == 0)
    {
      if (category == LC_CTYPE || category == LC_ALL)
	{
	  __wcprops = &__wcprops_ja_jp_sjis[0];
	  __wcprops_trans = &__wcprops_trans_ja_jp_sjis[0];
	  __wcprops_num = __wcprops_ja_jp_sjis_num;
	  __wcprops_trans_num = __wcprops_trans_ja_jp_sjis_num;
	}
    }
}
