/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: wcschr.c,v 1.1 1996/07/09 10:05:37 jack Exp $ */

#include <wchar.h>

wchar_t *
wcschr (const wchar_t *ws, wint_t wc)
{
  wchar_t *wp = NULL;

  while (1)
    {
      if (*ws == wc)
	{
	  wp = (wchar_t *) ws;
	  break;
	}
      else if (*ws++ == 0)
	break;
    }

  return wp;
}
