/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: wchar.h,v 1.3 1996/07/16 15:32:27 jack Exp $ */

#ifndef __wchar_h__
#define __wchar_h__

/* for NULL, wchar_t, size_t */
#include <stddef.h>
/* for FILE */
#include <stdio.h>

#ifndef __wint_t_defined__
#define __wint_t_defined__
typedef int wint_t;

#ifndef __mbstate_t_defined__
#define __mbstate_t_defined__
typedef struct
{
  int state;
} mbstate_t;
#endif
#endif

#ifndef WEOF
#define WEOF ((wint_t) (-1L))
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* functions */
extern wchar_t *wcscat (wchar_t *wd, const wchar_t *ws);
extern wchar_t *wcschr (const wchar_t *ws, wint_t wc);
extern int wcscmp (const wchar_t *ws1, const wchar_t *ws2);
extern wchar_t *wcscpy (wchar_t *wd, const wchar_t *ws);
extern size_t wcscspn (const wchar_t *ws1, const wchar_t *ws2);
extern size_t wcslen (const wchar_t *ws);
extern wchar_t *wcsncat (wchar_t *wd, const wchar_t *ws, size_t n);
extern int wcsncmp (const wchar_t *ws1, const wchar_t *ws2, size_t n);
extern wchar_t *wcsncpy (wchar_t *wd, const wchar_t *ws, size_t n);
extern wchar_t *wcspbrk (const wchar_t *ws1, const wchar_t *ws2);
extern wchar_t *wcsrchr (const wchar_t *ws, wint_t wc);
extern size_t wcsspn (const wchar_t *ws1, const wchar_t *ws2);
extern wchar_t *wcsstr (const wchar_t *ws1, const wchar_t *ws2);
extern wchar_t *wcstok (wchar_t *ws, const wchar_t *dlm);

extern int fwprintf (FILE *stream, const wchar_t *format, ...);
extern int wprintf (const wchar_t *format, ...);
extern int swprintf (wchar_t *s, const wchar_t *format, ...);
extern int vfwprintf (FILE *stream, const wchar_t *format, va_list ap);
extern int vwprintf (const wchar_t *format, va_list ap);
extern int vswprintf (wchar_t *s, const wchar_t *format, va_list ap);

extern wint_t fgetwc (FILE *fp);
extern wchar_t *fgetws (wchar_t *ws, int n, FILE *fp);
extern wint_t fputwc (wint_t wc, FILE *fp);
extern int fputws (const wchar_t *ws, FILE *fp);
extern wint_t getwc (FILE *fp);
extern wint_t getwchar (void);
extern wchar_t *getws (wchar_t *ws);
extern wint_t putwc (wint_t wc, FILE *fp);
extern wint_t putwchar (wint_t wc);
extern wint_t putws (const wchar_t *ws);
extern wint_t ungetwc (wint_t wc, FILE *fp);

extern double wcstod (const wchar_t *ws, wchar_t **endptr);
extern long int wcstol (const wchar_t *ws, wchar_t **endptr, int base);
extern unsigned long int wcstoul (const wchar_t *ws, wchar_t **endptr, int base);

/* the following restartable functions are not supported shift state */
extern int mbrlen (const char *s, size_t n, mbstate_t *ps);
extern int mbrtowc (wchar_t *pwc, const char *s, size_t n, mbstate_t *ps);
extern int wcrtomb (char *s, wchar_t wc, mbstate_t *ps);
extern size_t mbsrtowcs (wchar_t *pwcs, const char *s, size_t n, mbstate_t *ps);
extern size_t wcsrtombs (char *s, const wchar_t *pwcs, size_t n, mbstate_t *ps);

/* inline macros */
#define getwc(fp) (fgetwc ((fp)))
#define getwchar() (fgetwc ((stdin)))
#define putwc(wc,fp) (fputwc ((wc), (fp)))
#define putwchar(wc) (fputwc ((wc), (stdout)))

#ifdef __cplusplus
}
#endif

#endif /* !__wchar_h__ */
