/*
 *  libsocket - BSD socket like library for DJGPP
 *  Copyright 1997, 1998 by Indrek Mandre
 *  Copyright 1997, 1998 by Richard Dawe
 *
 *  This library is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU Library General Public License as published
 *  by the Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 * 
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* INFO: Comments starting with 'IM' indicate that Indrek Mandre made changes.
   Comments starting wiht 'RD' indicate that Richard Dawe made changes. If no
   comment is given, then the code was written by Indrek Mandre. */

#include <stdio.h>
#include <stdlib.h>
#include <sys/farptr.h>
#include <sys/segments.h>
#include <dpmi.h>
#include <time.h>
#include <sys/fsext.h>
#include <io.h>
#include <unistd.h>
#include <fcntl.h>

#include "ws.h"
#include "winsock.h"
#include "glob.h"
#include "wsock.h"
#include "farptrx.h"

/* RD: Added to cope with malloc() failing in socket() */
int closesocket_WS (void *_Socket);

/* RD: Moved this function to fsext.c -> func. decl. here */
int sock_functions(__FSEXT_Fnumber func_number, int *rv, va_list args);

wsocket *WSdescr[256];
/*int WS_initialized = 0;*//* RD: Superceded by WS_init's return value */

int socket ( int domain, int type, int protocol )
{
    int s;
    WSOCK_SOCKET_PARAMS params;
    time_t now;

    time ( &now );

    /* RD: Fail if we can't initialise */
    /*if ( ! WS_initialized ) WS_init ();*/
    if (!WS_init()) {
        errno = EPROTONOSUPPORT;    /* RD: Protocol not supported */
        return(-1);
    }

    s = __FSEXT_alloc_fd ( sock_functions );

    if ( s < 0 ) {
        errno = EMFILE;             /* RD: No free file descriptors? */
        return (-1);
    }

    setmode ( s, O_BINARY );

    params.AddressFamily = domain;
    params.SocketType = type;
    params.Protocol = protocol;
    params.NewSocket = 0;
    params.NewSocketHandle = (int)now; /* IM: accoring to Alfons Hoogervorst
                                          here must be a uniqe value */

    _farpokex ( SocketP, 0, &params, sizeof ( WSOCK_SOCKET_PARAMS ) );

    CallVxD ( WSOCK_SOCKET_CMD );

    _farpeekx ( SocketP, 0, &params, sizeof ( WSOCK_SOCKET_PARAMS ) );

    /* RD: Unnecessary - this is done by WS_init() in init_net.c */
    /*WSdescr[s] = NULL;*/

    if ( _VXDError && (_VXDError != 0xffff) ) {
        close ( s );
        return -1;
    }

    if ( WSdescr[s] != NULL ) free ( WSdescr[s] );
    WSdescr[s] = malloc ( sizeof ( wsocket ) );

    /* RD: malloc failed! */
    if (WSdescr[s] == NULL) {
        closesocket_WS((void *) params.NewSocket);
        return(-1);
    }

    WSdescr[s]->_Socket = (int) params.NewSocket;
    WSdescr[s]->_SocketHandle = params.NewSocketHandle;

    WSdescr[s]->AddressFamily = domain;
    WSdescr[s]->SocketType = type;
    WSdescr[s]->Protocol = protocol;
    WSdescr[s]->flags = FLAG_BLOCKING;

    return(s);
}

