/*
 *  libsocket - BSD socket like library for DJGPP
 *  Copyright 1997, 1998 by Indrek Mandre
 *  Copyright 1997, 1998 by Richard Dawe
 *
 *  This library is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU Library General Public License as published
 *  by the Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 * 
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Originally by Indrek Mandre (IM), modifications by Richard Dawe (RD) */

#include <stdio.h>
#include <stdlib.h>
#include <sys/farptr.h>
#include <sys/segments.h>
#include <dpmi.h>
#include <pc.h>

#include "ws.h"
#include "winsock.h"
#include "glob.h"
#include "wsock.h"
#include "farptrx.h"

/* ------------------
   - closesocket_WS -
   ------------------ */

/* Added by RD */

/* This closes a socket given its Winsock handle - this is so socket() can
   exit gracefully if malloc() fails. */

inline int closesocket_WS (void *_Socket)
{
    WSOCK_CLOSESOCKET_PARAMS params;

    params.Socket = _Socket;
    _farpokex (SocketP, 0, &params, sizeof(WSOCK_CLOSESOCKET_PARAMS));
    CallVxD (WSOCK_CLOSESOCKET_CMD);

    if (_VXDError && (_VXDError != 0xFFFF)) return(-1);

    return(0);
}

/* ---------------
   - closesocket -
   --------------- */

/* IM's original code */

int closesocket (int s)
{
    /*WSOCK_CLOSESOCKET_PARAMS params;*/
    int saved_s = s;

    if (WSdescr[s] == NULL) return(-1);

    /* RD: Use closesocket_WS() instead now, to save duplication of code */
    /*params.Socket = (void *) WSdescr[s]->_Socket;
    _farpokex (SocketP, 0, &params, sizeof(WSOCK_CLOSESOCKET_PARAMS));
    CallVxD (WSOCK_CLOSESOCKET_CMD);

    if (_VXDError && (_VXDError != 0xFFFF)) return(-1);*/

    if (closesocket_WS((void *) WSdescr[s]->_Socket) == -1) return(-1);

    /* RD: Using saved_s may look strange, but I think s gets mangled by this
       free call! */
    free (WSdescr[s]);
    WSdescr[saved_s] = NULL;

    return(0);
}

