/*
 *  libsocket - BSD socket like library for DJGPP
 *  Copyright 1997, 1998 by Indrek Mandre
 *  Copyright 1997, 1998 by Richard Dawe
 *
 *  This library is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU Library General Public License as published
 *  by the Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 * 
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/farptr.h>
#include <sys/segments.h>
#include <dpmi.h>
#include <pc.h>
#include <sys/fsext.h>
#include <io.h>
#include <errno.h>
#include <fcntl.h>
#include <time.h>

#include "ws.h"
#include "winsock.h"
#include "glob.h"
#include "wsock.h"
#include "farptrx.h"

int sock_functions(__FSEXT_Fnumber func_number, int *rv, va_list args);

int accept ( int s, struct sockaddr *addr, int *addrlen )
{
 int n;
 WSOCK_ACCEPT_PARAMS params;
 time_t now;

 time ( &now );

 if ( WSdescr[s] == NULL ) {
 	errno = EBADF;
 	return -1;
 }

 if ( WSdescr[s]->SocketType != SOCK_STREAM ) {
 	errno = EOPNOTSUPP;
 	return -1;
 }

 params.Address = (void *) ( (SocketP << 16) + (7 * 4) );
 params.ListeningSocket = (void *)WSdescr[s]->_Socket;
 params.ConnectedSocket = NULL;
 params.AddressLength = *addrlen;
 params.ConnectedSocketHandle = (int)now;
 params.ApcRoutine = 0;
 params.ApcContext = 0;

 if ( WSdescr[s]->flags & FLAG_BLOCKING )
     if ( sockselect_wait ( s, FD_ACCEPT ) == -1 ) return -1;

 _farpokex ( SocketP, 0, &params, sizeof ( WSOCK_ACCEPT_PARAMS ) );

 CallVxD ( WSOCK_ACCEPT_CMD );

 if ( _VXDError && _VXDError != 0xffff )
	return -1;

 _farpeekx ( SocketP, 0, &params, sizeof ( WSOCK_ACCEPT_PARAMS ) );

 if ( params.ConnectedSocket == NULL ) return -1;

 *addrlen = params.AddressLength;

 _farpeekx ( SocketP, 7 * 4, addr, *addrlen );

 n = __FSEXT_alloc_fd ( sock_functions );

 if ( n < 0 ) return -1;

 setmode ( n, O_BINARY );

 if ( WSdescr[n] != NULL ) free ( WSdescr[n] );
 WSdescr[n] = malloc ( sizeof ( wsocket ) );

 /* RD: Check for malloc() failing! */
 if (WSdescr[n] == NULL) {
    errno = ENOBUFS;
    return(-1);
 }

 WSdescr[n]->_Socket = (int) params.ConnectedSocket;
 WSdescr[n]->_SocketHandle = params.ConnectedSocketHandle;

 WSdescr[n]->AddressFamily = WSdescr[s]->AddressFamily;
 WSdescr[n]->SocketType = WSdescr[s]->SocketType;
 WSdescr[n]->Protocol = WSdescr[s]->Protocol;
 WSdescr[n]->flags = FLAG_BLOCKING;

 memcpy ( &WSdescr[n]->inet, addr, *addrlen );

 return n;

}

