/*
   netsetup.c
   Networking parameters set-up program for libsocket, Version 1.02
   Copyright 1997 by Richard Dawe
*/

/*
   Bugfixes
   ========

   1997-1-11 - Fixed bug in creation of 'hosts.eg' where the order of the host
   name and IP address was wrong (thanks to Reuben Collver for noticing). Also
   corrected formatting error in message about 'hosts.eg'.

   1997-5-12 - Fixed bug in order output - When no DNS server is present it
   should *not* output "order hosts, bind"; it should output "order hosts".
*/

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>

#define TRUE -1
#define FALSE 0

int main (void)
{
	int  res;				/* General result						*/
	int  dns_present;		/* Boolean								*/
	char dns_ip[256];		/* 256 chars is probably long enough	*/
	char domain_name[256];	/* Domain name							*/
	char pc_name[256];		/* PC's name address					*/
	char pc_ip[256];		/* PC's IP address						*/

	FILE *fOut;				/* Output file handle					*/

	/* Banner */
    printf ("Netsetup Version 1.01, libsocket networking set-up\nCopyright 1997 by Richard Dawe\n");
	printf ("libsocket Copyright 1997 by Indrek Madre\n");
	printf ("\n");

	/* --- Ask the questions --- */
	fflush(stdin);

	/* Computer's details */
	printf("Please enter your computer's name: ");
	fflush(stdout);
	scanf("%255s", pc_name);

	printf("Please enter your computer's IP address: ");
	fflush(stdout);
	scanf("%255s", pc_ip);

	/* Domain name */
	printf("Please enter your domain name: ");
	fflush(stdout);
	scanf("%255s", domain_name);

	/* DNS details */
	printf("Do you have a DNS server [Yn]? ");
	fflush(stdout);
	res = getch();

	if ((res == 'y') || (res == 'y') || (res == '\r'))
	{
		printf("y\n");
		dns_present = TRUE;
	}
	else
	{
		printf("n\n");
		dns_present = FALSE;
	}

	if (dns_present == TRUE)
	{
		printf ("Please enter the IP address of your DNS server: ");
		fflush(stdout);
		scanf("%255s", dns_ip);
	}

	/* --- Create the files --- */

	/* host.conf */
	fOut = fopen("host.conf", "wt");
	if (fOut == NULL)
	{
		fprintf(stderr,  "Unable to open 'host.conf'!\n");
		exit(0);
	}

	printf("Writing host.conf...");

	if (dns_present == TRUE)
		fprintf(fOut, "order bind, hosts\n");	/* Assume DNS up-to-date */
    else {
        /* RD: Bugfix: No! No DNS => don't output "bind" */
        /*fprintf(fOut, "order hosts, bind\n");*/
        fprintf(fOut, "order hosts");
    }

	printf("done\n");
	fclose(fOut);

	/* resolv.conf */
	fOut = fopen("resolv.conf", "wt");
	if (fOut == NULL)
	{
		fprintf(stderr,  "Unable to open 'host.conf'!\n");
		exit(0);
	}

	printf("Writing resolv.conf...");

	fprintf(fOut, "domain %s\n", domain_name);
	if (dns_present == TRUE) fprintf(fOut, "nameserver %s\n", dns_ip);

	printf("done\n");
	fclose(fOut);

	/* hosts.eg */
	fOut = fopen("hosts.eg", "wt");
	if (fOut == NULL)
	{
		fprintf(stderr,  "Unable to open 'host.conf'!\n");
		exit(0);
	}

	printf ("Writing hosts.eg (an example hosts file)...");

	fprintf(fOut, "# hosts.eg\n# An example hosts file\n");
	fprintf(fOut, "# Please edit this to suit your site\n\n");
    fprintf(fOut, "127.0.0.1\tlocalhost\n");
    fprintf(fOut, "%s\t%s\n", pc_ip, pc_name);

	printf("done\n");
	fclose(fOut);

	/* Installation message */
	printf("\n");
	printf("Please copy the files 'hosts.eg', 'host.conf', 'resolv.conf' into your");
    printf(" Windows\ndirectory. 'hosts.eg' should be renamed to 'hosts', but check");
    printf(" that this file\n doesn't already exist.\n");

	/* Success */
/*	return(1); IM: 1 is wrong */
	return (0);
}
