/*
    internal.c
    Copyright 1998 by Richard Dawe

    This file illustrates some of the internal functions of libsocket. These
    should not be used in normal programs. They may give some insight into
    whether libsocket is detecting all the DNS servers configured and where
    it is looking for its configuration files. It should be useful in finding
    out whether libsocket is configured properly.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/socket.h>
#include <netinet/in.h>

extern char *ls_config_getdir (void);
extern char **ls_getdnsaddrs (void);

extern int vdhcp_init (void);
extern int vdhcp_entry[];

int main (void)
{
    char **p = NULL;

    printf("Configuration directory: %s\n", ls_config_getdir());

    p = ls_getdnsaddrs();
    if (p != NULL) while (*p != NULL) { printf("DNS address: %s\n", *p), p++; }

    return(1);
}
