/* LWP 1.3  */
#ifndef _LWP_
#define _LWP_

/* for programming IRQ8 */

#define RTC2		0xF	
#define RTC4		0xE	
#define RTC8		0xD
#define RTC16		0xC
#define RTC32		0xB
#define RTC64		0xA
#define RTC128		0x9
#define RTC256		0x8
#define RTC512		0x7
#define RTC1024		0x6
#define RTC2048		0x5
#define RTC4096		0x4
#define RTC8192		0x3


/* User functions */

#ifdef __cplusplus
extern "C" {
#endif

int lwp_init(int irq, int speed);
int lwp_spawn(void (*proc)(void), int stack_length, int priority);
int lwp_kill(volatile int lwpid);
int lwp_getpid();
int lwp_thread_count();
void lwp_yield();
void lwp_thread_enable( void );
void lwp_thread_disable( void );

#ifdef __cplusplus
}
#endif


/* Modified include files */

#include "conio.h" 
#include "stdio.h"
#include "pc.h"


#endif   /* _LWP_ */
