#include "lwp.h"
#define MAX_PROC 4 
void proc1(void)
{
	volatile int i = 0;
	while(1)
		{
		printf("PROC 1\n");	/* Printf disables task switching */	
					/* and this loop is too tight to  */
					/* pre-empt away from.		*/

		for(i=0;i<1000;i++);	/* delay so we CAN pre-empt.	*/

					/* This isn't need if your	*/ 
					/* function actually does       */
					/* something, and it wouldn't   */
					/* be needed here if printf was	*/
					/* re-entrant.			*/
     		}
}

void proc2(void)
{
	volatile int i = 0;
	while(1)
		{
		printf("PROC 2\n");
		for(i=0;i<1000;i++);
		}
}

void proc3(void)
{
	volatile int i = 0;
	while(1)
		{
		printf("PROC 3\n");
		for(i=0;i<1000;i++);
		}
}

void proc4(void)
{
	volatile int i = 0;
	while(1)
	{
	printf("PROC 4\n");
	for(i=0;i<1000;i++);
	}
}

int main()
{
	volatile int i;
	int ids[MAX_PROC];
	clrscr();
	printf("\nLWP: Example1.\n");
	printf("This program spawns 4 threads that each print a message.\n");
	printf("Press any key to start....");
	fflush(stdout);
	getch();
	if(lwp_init(8, RTC1024)) 
	{
	ids[0] = lwp_spawn(proc1, 4096,1);
	ids[1] = lwp_spawn(proc2, 4096,1);
	ids[2] = lwp_spawn(proc3, 4096,1);
	ids[3] = lwp_spawn(proc4, 4096,1);
	while(!kbhit()) 
		{
		printf("MAIN\n");
		for(i=0;i<1000;i++);
		}
	getch();
	lwp_kill(ids[0]);
	lwp_kill(ids[1]);
	lwp_kill(ids[2]);
	lwp_kill(ids[3]);
	}
	return(0);
}
