/* LWP 1.0 :) */
#ifndef _LWP_
#define _LWP_
#include <string.h>
#include <stdlib.h>     
#include <stdio.h>
#define LWP_MAIN -1
#ifdef __cplusplus
extern "C" {
#endif

typedef struct lwp_struct {
int lwpid;
struct lwp_struct *next;
int stklen;
unsigned long *stack;
int priority;
int pcount;
} lwp;

/* User functions */
int lwp_init(void);
int lwp_spawn(void (*proc)(void), int stack_length, int priority);
int lwp_kill(int lwpid);
int lwp_getpid();
int lwp_thread_count();
void lwp_yield();


/* for locking critical code */
int _lwp_lock_data( void *lockaddr, unsigned long locksize );
int _lwp_unlock_data( void *lockaddr, unsigned long locksize );
int _lwp_lock_code( void *lockaddr, unsigned long locksize );
int _lwp_unlock_code( void *lockaddr, unsigned long locksize );

extern lwp *_lwp_cur;

#ifdef __cplusplus
}
#endif

#endif   /* _LWP_ */
