#include "lwp.h"
#ifdef _LWP_

/*  Global Variables */

lwp *_lwp_cur;
static volatile int _lwp_count;
static volatile int _lwp_pid_count;
void lwp_deinit(void);
extern int _lwp_init_flags(void);
extern void _lwp_init_fpu();
extern void _lwp_dead_yield();
extern int _stktop;
static int _lwp_flags;
char _lwp_fpu_state[108];

static volatile void _lwp_dead_thread(void) 
{ 
lwp_kill(_lwp_cur->lwpid); 
printf("PANIC!\n"); /* should never get here */
exit(-1);
}

int lwp_init(void)
{ 
   if(atexit(lwp_deinit))
	return(0);
   if((_lwp_cur = (lwp *) malloc(sizeof(lwp))) == NULL)
      {
      #ifdef __DEBUG__
      printf("ERROR:  Couldn't malloc _lwp_cur\n");
      #endif
      return(0);
      }
   _lwp_cur->stack = NULL;	
   _lwp_cur->lwpid = LWP_MAIN;
   _lwp_cur->next = _lwp_cur;
   _lwp_cur->priority = 1;
   _lwp_cur->pcount = 1;
   _lwp_count = 0;
   _lwp_pid_count = 0;
   _lwp_flags = _lwp_init_flags();
   _lwp_init_fpu();   
    return(1);
}

int lwp_getpid(void)
{  
   return(_lwp_cur->lwpid);
}

int lwp_thread_count(void)
{
   return(_lwp_count);
}
/* spawns a light weight process.  Returns the lwpid of the proc or 0 on fail*/

int lwp_spawn(void (*proc)(void), int stack_length, int priority)
{
  lwp *tmp;
  if((proc == NULL) || (stack_length < 256))
	{
      	return(-1);
     	}
  if((tmp = (lwp *) malloc(sizeof(lwp))) == NULL)
	{
       	return(-1);
	}

  if((stack_length % 2) != 0) 
	{
	stack_length++; /* make the stack even */
	}	

  if((stack_length %4) != 0) 
       {
       stack_length+=2; /* make the stack divisible by 4 */
       }
	
  if((tmp->stack = (unsigned long *) malloc(stack_length)) == NULL)
	{
       	return(-1);
	}

  if(priority == 0)  /* 0 priority = ultimate priority! */ 
	{
	return(-1);
	}

 /* 8 regs +flags */

 tmp->stack[(stack_length/4) - 1] = (long) _lwp_dead_thread;
 tmp->stack[(stack_length/4) - 2] = (long) proc;
 tmp->stack[(stack_length/4) - 3] = 0; 
 tmp->stack[(stack_length/4) - 4] = 0;
 tmp->stack[(stack_length/4) - 5] = 0;  /* regs */
 tmp->stack[(stack_length/4) - 6] = 0;
 tmp->stack[(stack_length/4) - 7] = 0;
 tmp->stack[(stack_length/4) - 8] = 0;
 tmp->stack[(stack_length/4) - 9] = 0;
 tmp->stack[(stack_length/4) -10] = (long) _lwp_flags; /* flags */

memcpy(tmp->stack + (stack_length/4) - 38, _lwp_fpu_state, 108);

  tmp->stack = tmp->stack + (stack_length/4) - 38;

  tmp->priority = priority;
  tmp->pcount = priority;
  tmp->lwpid = ++_lwp_pid_count; 
  tmp->next = _lwp_cur->next;
  _lwp_cur->next = tmp; 
  _lwp_count++;
  return(tmp->lwpid);
}

/* Kills a lwp (takes it out of the linked list of lwp's) , or 0 if it fails */
int lwp_kill(int lwpid)
{
  int i = 0;
  lwp *tmp1,*tmp2, tmp3;
  tmp1 = _lwp_cur->next;
  tmp2 = _lwp_cur;
  tmp3 = *_lwp_cur; /* save for later, gets nuked here */
  if((tmp1 == NULL) || (tmp2 == NULL))
	return(0);
  if(lwpid == LWP_MAIN)
	{
	printf("PANIC tried to kill main()!\n");
	exit(-1);
	}
/* special case for _lwp_cur */
  if(lwpid == _lwp_cur->lwpid)
	{
	tmp1 = _lwp_cur;
	while(tmp1->next != _lwp_cur) tmp1 = tmp1->next;
	tmp1->next = _lwp_cur->next; 	
	free(_lwp_cur->stack);
	free(_lwp_cur);
	_lwp_cur = tmp1->next;
	_lwp_count--;
	_lwp_dead_yield();
	printf("PANIC!\n"); /* should never get here */
	exit(-1);  
	}

  while((i<= _lwp_count+1) && (tmp1->lwpid != lwpid))
         {
         i++;
         tmp1 = tmp1->next;
         tmp2 = tmp2->next;
         }
  /* went through all of them and wasn't found */
  if(tmp1->lwpid != lwpid) 
     return(0);
  /* now tmp IS the right one to kill */
  tmp2->next = tmp1->next;
  free(tmp1->stack);
  free(tmp1);
  *_lwp_cur = tmp3;
  return(1);
}



void lwp_deinit(void)
{
	free(_lwp_cur);
}
#endif /* _LWP_ */ 
