// EZdemo - a demonstration program for the EZVGA graphics
// library for DJGPP.
// Note : To get this demo to compile on your machine, copy the EZDJVGA.h
// header file to your DJGPP 'include' directory.

// All code (c) Copyright Matthew Bentley 1996-1998

// Include the EZ-VGA DJGPP graphics library :
#include <ezvgadj.h>

// Other standard libraries :
#include <time.h>  // For time functions.
#include <ctype.h> // For converting lower case to upper case.
#include <iostream.h> // For writing ON the SCREEN.
#include <stdlib.h> // For random functions.
#include <conio.h> // For keyboard rountines & wrinting to the SCREEN.
#include <dos.h> // For sound routines & delay routines.

// Declare global variables :
unsigned char pals[770];
unsigned char array1[64004U];
unsigned char array2[64004U];

// Function to fade-in the vga palette :
void fadein(unsigned char *palette)
{
	// Fade in the vga palette :
	char r, g, b, countera;
	int counterb;
	for (countera = 63; countera != -1; countera--)
	{
		for (counterb = 0; counterb != 256; counterb++)
		{
			r = palette[counterb * 3] - countera;
			g = palette[counterb * 3 + 1] - countera;
			b = palette[counterb * 3 + 2] - countera;

			if (r < 0)
				r = 0;
			if (g < 0)
				g = 0;
			if (b < 0)
				b = 0;

			setpal(counterb, r, g, b);
		}
		delay(15);
	}
}

// Function to fade out the vga palette :
void fadeout(unsigned char *palette)
{
	// Fade out the palette:
	char r, g, b, countera;
	int counterb;
	for (countera = 0; countera != 64; countera++)
	{
		for (counterb = 0; counterb != 256; counterb++)
		{
			r = palette[counterb * 3] - countera;
			g = palette[counterb * 3 + 1] - countera;
			b = palette[counterb * 3 + 2] - countera;

			if (r < 0)
				r = 0;
			if (g < 0)
				g = 0;
			if (b < 0)
				b = 0;

			setpal(counterb, r, g, b);
		}
		delay(15);
	}
}

// Check whether the new SCREEN needs to be scrolled ON :
void scrollcheck(unsigned char *pic1, unsigned char *pic2, const unsigned char &placenew, unsigned char &placeold)
{
	int xpos;

	if (placenew != placeold)
	{
		mousecursor(OFF);
		if (placenew > placeold)
		// Scroll to the left :
		{
			for (xpos = 310; xpos != -10; xpos -= 10)
			{
				putpic(xpos - 320, 0, pic2);
				putpic(xpos, 0, pic1);
				delay(1);
			}
		}

		if (placenew < placeold)
		// Scroll to the right :
		{
			for (xpos = 10; xpos != 330; xpos += 10)
			{
				putpic(xpos - 320, 0, pic1);
				putpic(xpos, 0, pic2);
				delay(1);
			}
		}
		mousecursor(ON);
		placeold = placenew;
	}
}

// Introduction to EZ-VGA :
void intro()
{
	int mx, my;
	unsigned char posnew = 1, posold = 1, buttons = 0, key = 0;

	loadpcx("intro1.pcx", VIDEO, pals);
	mousecursor(ON);
	fadein(pals);

	while(posnew != 6)
	{
		if (posnew == 1)
		{
			loadpcx("intro1.pcx", array1, pals);
			scrollcheck(array1, array2, posnew, posold);
			mousecursor(ON);

			while(posnew == 1)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				if (buttons != 0)
				{
					if (mx >= 106 && my >= 141 && mx <= 205 && my <= 170)
						posnew++;
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew += 2;
				}

				// Check for keyboard press :
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 6;
					if (key == 77)
						posnew += 2;
				}
			}
			loadpcx("intro1.pcx", array2, pals);
		}

		if (posnew == 2)
		{
			loadpcx("intro2.pcx", array1, pals);
			scrollcheck(array1, array2, posnew, posold);
			mousecursor(ON);

			while(posnew == 2)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				if (buttons != 0)
				{
					if (mx >= 9 && my >= 159 && mx <= 33 && my <= 192)
						posnew--;
				}

				// Check for keyboard press :
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 6;
					if (key == 75)
						posnew--;
				}
			}
			loadpcx("intro2.pcx", array2, pals);
		}

		if (posnew == 3)
		{
			loadpcx("intro3.pcx", array1, pals);
			scrollcheck(array1, array2, posnew, posold);
			mousecursor(ON);

			while(posnew == 3)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				if (buttons != 0)
				{
					if (mx >= 9 && my >= 159 && mx <= 33 && my <= 192)
						posnew -= 2;
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;
				}

				// Check for keyboard press :
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 6;
					if (key == 75)
						posnew -= 2;
					if (key == 77)
						posnew++;
				}
			}
			loadpcx("intro3.pcx", array2, pals);
		}

		if (posnew == 4)
		{
			loadpcx("intro4.pcx", array1, pals);
			scrollcheck(array1, array2, posnew, posold);
			mousecursor(ON);

			while(posnew == 4)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				if (buttons != 0)
				{
					if (mx >= 9 && my >= 159 && mx <= 33 && my <= 192)
						posnew--;
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;
				}

				// Check for keyboard press :
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 6;
					if (key == 75)
						posnew--;
					if (key == 77)
						posnew++;
				}
			}
			loadpcx("intro4.pcx", array2, pals);
		}

		if (posnew == 5)
		{
			loadpcx("intro5.pcx", array1, pals);
			scrollcheck(array1, array2, posnew, posold);
			mousecursor(ON);

			while(posnew == 5)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				if (buttons != 0)
				{
					if (mx >= 9 && my >= 159 && mx <= 33 && my <= 192)
						posnew--;
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;
				}

				// Check for keyboard press :
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 6;
					if (key == 75)
						posnew--;
					if (key == 77)
						posnew++;
				}
			}
			loadpcx("intro5.pcx", array2, pals);
		}
	}

	fadeout(pals);
}

void basicdemo()
{
	int mx, my;
	unsigned int counterb;
	unsigned char posnew = 1, posold = 1, buttons = 0, key = 0, r, g, b;

	loadpcx("basic1.pcx", VIDEO, pals);
	mousecursor(ON);
	fadein(pals);

	while(posnew != 8)
	{
		if (posnew == 1)
		{
			// Vgamode demo :
			mousecursor(ON);

			while(posnew == 1)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				if (buttons != 0)
				{
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;
				}

				// Check for keyboard press :
				key = 0;
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 8;
					if (key == 77)
						posnew++;
				}
			}
			loadpcx("basic1.pcx", array2, pals);
		}

		if (posnew == 2)
		{
			// Vgaexit demo :
			vgaexit();

			cout << "vgaexit();" << endl << endl << endl;
			cout << " 	This function *MUST* be run at the end of every EZVGA program" << endl;
			cout << " 	to switch back to text mode and clean up." << endl;
			cout << endl << endl << endl << endl << endl << endl << endl;
			cout << "Press a key..." << endl;
			getch();
			posnew = 3;
			posold = 3;
			vgainit();
                }

		if (posnew == 3)
		{
			// Cls demo :
			loadpcx("basic3.pcx", array1, pals);
                        setallpals(pals);
			scrollcheck(array1, array2, posnew, posold);
			putpic(0,0, array1);
			getpic (98, 68, 209, 134, array2);

			setborders(98, 68, 209, 134);
			counterb = 0;
			mousecursor(ON);

			while(posnew == 3)
			{
				counterb++;

				if (counterb == 5000)
					cls(0);

				if (counterb == 10000U)
				{
					putpic(98, 68, array2);
					counterb = 0;
				}

				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				if (buttons != 0)
				{
					if (mx >= 9 && my >= 159 && mx <= 33 && my <= 192)
						posnew--;
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;
				}

				// Check for keyboard press :
				key = 0;
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 8;
					if (key == 75)
						posnew--;
					if (key == 77)
						posnew++;
				}
			}
			setborders(0, 0, 319, 199);
			loadpcx("basic3.pcx", array2, pals);
		}

		if (posnew == 4)
		{
			// Setborders demo :
			loadpcx("basic4.pcx", array1, pals);
			scrollcheck(array1, array2, posnew, posold);

			getpic (86, 91, 220, 164, array2);
			setborders(86, 91, 220, 164);
			mousecursor(ON);

			while(posnew == 4)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				putpic ((rand() * 150) + 25, (rand() * 80) + 70, array2);

				if (buttons != 0)
				{
					if (mx >= 9 && my >= 159 && mx <= 33 && my <= 192)
						posnew--;
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;
				}

				// Check for keyboard press :
				key = 0;
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 8;
					if (key == 75)
						posnew--;
					if (key == 77)
						posnew++;
				}
			}
			loadpcx("basic4.pcx", array2, pals);
			setborders(0, 0, 319, 199);
		}

		if (posnew == 5)
		{
			// Putpix demo :
			loadpcx("basic5.pcx", array1, pals);
			scrollcheck(array1, array2, posnew, posold);

			setborders (82, 77, 229, 158);
			mousecursor(ON);

			while(posnew == 5)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				putpix((unsigned char)(rand() * 150) + 82, (unsigned char)(rand() * 90) + 77, (unsigned char)(rand() * 255));

				if (buttons != 0)
				{
					if (mx >= 9 && my >= 159 && mx <= 33 && my <= 192)
						posnew--;
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;
				}

				// Check for keyboard press :
				key = 0;
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 8;
					if (key == 75)
						posnew--;
					if (key == 77)
						posnew++;
				}
			}
			loadpcx("basic5.pcx", array2, pals);
			setborders(0, 0, 319, 199);
		}

		if (posnew == 6)
		{
			// Getpix demo :
			loadpcx("basic6.pcx", array1, pals);
			scrollcheck(array1, array2, posnew, posold);
			mousecursor(ON);

			while(posnew == 6)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				gotoxy(23, 21);
				counterb = getpix(mx - 1, my - 1);
				cout << counterb << "  " << endl;

				if (buttons != 0)
				{
					if (mx >= 9 && my >= 159 && mx <= 33 && my <= 192)
						posnew--;
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;
				}

				// Check for keyboard press :
				key = 0;
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 8;
					if (key == 75)
						posnew--;
					if (key == 77)
						posnew++;
				}
			}
			loadpcx("basic6.pcx", array2, pals);
		}

		if (posnew == 7)
		{
			// Palette demo :
			loadpcx("basic7.pcx", array1, pals);
			scrollcheck(array1, array2, posnew, posold);
			mousecursor(ON);

			while(posnew == 7)
			{
				// Cycle palette :
				r = pals[3];
				g = pals[4];
				b = pals[5];

				for (counterb = 1; counterb != 249; counterb++)
				{
					pals[counterb * 3] = pals[counterb * 3 + 3];
					pals[counterb * 3 + 1] = pals[counterb * 3 + 4];
					pals[counterb * 3 + 2] = pals[counterb * 3 + 5];
				}

				pals[249 * 3] = r;
				pals[249 * 3 + 1] = g;
				pals[249 * 3 + 2] = b;

				setallpals(pals);

				delay(15);

				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				if (buttons != 0)
				{
					if (mx >= 9 && my >= 159 && mx <= 33 && my <= 192)
						posnew--;
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;
				}

				// Check for keyboard press :
				key = 0;
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 8;
					if (key == 75)
						posnew--;
					if (key == 77)
						posnew++;
				}
			}
			loadpcx("basic7.pcx", array2, pals);
			setallpals(pals);
		}
	}

	fadeout (pals);
}

void advanceddemo()
{
	int mx, my;
	unsigned int counterb;
	unsigned char posnew = 1, posold = 1, buttons = 0, key = 0;
	loadpcx("advance1.pcx", VIDEO, pals);
	fadein(pals);

	while(posnew != 8)
	{
		if (posnew == 1)
		{
			// line demo :
			loadpcx("advance1.pcx", array1, pals);
			scrollcheck(array1, array2, posnew, posold);

			setborders(82, 77, 229, 158);
			mousecursor(ON);

			while(posnew == 1)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				line ((unsigned char)(rand() * 170) + 78, (unsigned char)(rand() * 90) + 70, (unsigned char)(rand() * 170) + 78, (unsigned char)(rand() * 90) + 70, (unsigned char)(rand() * 254) + 1);

				if (buttons != 0)
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;

				// Check for keyboard press :
				key = 0;
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 8;
					if (key == 77)
						posnew++;
				}
			}
			loadpcx("advance1.pcx", array2, pals);
			setborders(0, 0, 319, 199);
		}

		if (posnew == 2)
		{
			// Boxes demo :
			loadpcx("advance2.pcx", array1, pals);
			scrollcheck(array1, array2, posnew, posold);

			setborders(82, 77, 229, 158);
			mousecursor(ON);

			while(posnew == 2)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				box ((unsigned char)(rand() * 170) + 78, (unsigned char)(rand() * 90) + 70, (unsigned char)(rand() * 170) + 78, (unsigned char)(rand() * 90) + 70, (unsigned char)(rand() * 254) + 1, EMPTY);

				if (buttons != 0)
				{
					if (mx >= 9 && my >= 159 && mx <= 33 && my <= 192)
						posnew--;
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;
				}

				// Check for keyboard press :
				key = 0;
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 8;
					if (key == 75)
						posnew--;
					if (key == 77)
						posnew++;
				}
			}
			loadpcx("advance2.pcx", array2, pals);
			setborders(0, 0, 319, 199);
		}

		if (posnew == 3)
		{
			// Filled boxes demo :
			loadpcx("advance3.pcx", array1, pals);
			scrollcheck(array1, array2, posnew, posold);

			setborders(82, 77, 229, 158);
			mousecursor(ON);

			while(posnew == 3)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				box ((unsigned char)(rand() * 170) + 78, (unsigned char)(rand() * 90) + 70, (unsigned char)(rand() * 170) + 78, (unsigned char)(rand() * 90) + 70, (unsigned char)(rand() * 254) + 1, FILLED);

				if (buttons != 0)
				{
					if (mx >= 9 && my >= 159 && mx <= 33 && my <= 192)
						posnew--;
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;
				}

				// Check for keyboard press :
				key = 0;
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 8;
					if (key == 75)
						posnew--;
					if (key == 77)
						posnew++;
				}
			}
			loadpcx("advance3.pcx", array2, pals);
			setborders(0, 0, 319, 199);
		}

		if (posnew == 4)
		{
			// Circle demo :
			loadpcx("advance4.pcx", array1, pals);
			scrollcheck(array1, array2, posnew, posold);

			setborders(82, 77, 229, 158);
			mousecursor(ON);

			while(posnew == 4)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				circle ((unsigned char)(rand() * 170) + 78, (unsigned char)(rand() * 90) + 70, (unsigned char)(rand() * 50) + 3, (unsigned char)(rand() * 254) + 1);

				if (buttons != 0)
				{
					if (mx >= 9 && my >= 159 && mx <= 33 && my <= 192)
						posnew--;
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;
				}

				// Check for keyboard press :
				key = 0;
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 8;
					if (key == 75)
						posnew--;
					if (key == 77)
						posnew++;
				}
			}
			loadpcx("advance4.pcx", array2, pals);
			setborders(0, 0, 319, 199);
		}
		if (posnew == 5)
		{
			// ellipse demo :
			loadpcx("advance5.pcx", array1, pals);
			scrollcheck(array1, array2, posnew, posold);

			setborders(82, 77, 229, 158);
			mousecursor(ON);

			while(posnew == 5)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				ellipse((unsigned char)(rand() * 170) + 78, (unsigned char)(rand() * 90) + 70, (unsigned char)(rand() * 50) + 3, (unsigned char)(rand() * 50) + 3, (unsigned char)(rand() * 254) + 1);

				if (buttons != 0)
				{
					if (mx >= 9 && my >= 159 && mx <= 33 && my <= 192)
						posnew--;
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;
				}

				// Check for keyboard press :
				key = 0;
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 8;
					if (key == 75)
						posnew--;
					if (key == 77)
						posnew++;
				}
			}
			loadpcx("advance5.pcx", array2, pals);
			setborders(0, 0, 319, 199);
		}
		if (posnew == 6)
		{
			// Getpic & putpic demo :
			loadpcx("advance6.pcx", array1, pals);
			scrollcheck(array1, array2, posnew, posold);
			counterb = 0;
			mousecursor(ON);

			while(posnew == 6)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				counterb++;

				// Picture 1 :
				if (counterb == 8000)
				{
					mousecursor(OFF);
					box (91, 61, 230, 133, 0, FILLED);
					getpic (35, 65, 78, 128, array2);
					mousecursor(ON);
					box (35, 65, 78, 128, 150, FILLED);
				}

				if (counterb == 10000)
				{
					mousecursor(OFF);
					putpic(133, 68, array2);
					putpic(35, 65, array2);
					mousecursor(ON);
				}

				// Picture 2 :
				if (counterb == 18000)
				{
					mousecursor(OFF);
					box (91, 61, 230, 133, 0, FILLED);
					getpic (234, 68, 278, 127, array2);
					mousecursor(ON);
					box (234, 68, 278, 127, 150, EMPTY);
				}

				if (counterb == 20000)
				{
					mousecursor(OFF);
					putpic(133, 68, array2);
					putpic(234, 68, array2);
					mousecursor(ON);
				}

				// Picture 3 :
				if (counterb == 28000)
				{
					mousecursor(OFF);
					box (91, 61, 230, 133, 0, FILLED);
					getpic (137, 145, 174, 177, array2);
					mousecursor(ON);
					box (137, 145, 174, 177, 150, EMPTY);
				}

				if (counterb == 30000)
				{
					mousecursor(OFF);
					putpic(133, 68, array2);
					putpic(137, 145, array2);
					mousecursor(ON);
					counterb = 0;
				}

				if (buttons != 0)
				{
					if (mx >= 9 && my >= 159 && mx <= 33 && my <= 192)
						posnew--;
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;
				}

				// Check for keyboard press :
				key = 0;
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 8;
					if (key == 75)
						posnew--;
					if (key == 77)
						posnew++;
				}
			}
			loadpcx("advance6.pcx", array2, pals);
			setborders(0, 0, 319, 199);
		}

		if (posnew == 7)
		{
			// Putsprite demo :
			loadpcx("advance7.pcx", array1, pals);
			scrollcheck(array1, array2, posnew, posold);

			getpic(139, 91, 175, 146, array2);
			setborders(82, 77, 229, 158);
			mousecursor(ON);

			while(posnew == 7)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				putsprite((unsigned char)(rand() * 170) + 70, (unsigned char)(rand() * 90) + 70, array2, 0);

				if (buttons != 0)
				{
					if (mx >= 9 && my >= 159 && mx <= 33 && my <= 192)
						posnew--;
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;
				}

				// Check for keyboard press :
				key = 0;
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 8;
					if (key == 75)
						posnew--;
					if (key == 77)
						posnew++;
				}
			}
			loadpcx("advance7.pcx", array2, pals);
			setborders(0, 0, 319, 199);
		}
	}

	fadeout (pals);
}

void filedemo()
{
	int mx, my;
	unsigned char posnew = 1, posold = 1, buttons = 0, key = 0;
	loadpcx("file1.pcx", VIDEO, pals);
	fadein(pals);

	while(posnew != 4)
	{
		if (posnew == 1)
		{
			// RAW demo :
			loadpcx("file1.pcx", array1, pals);
			scrollcheck(array1, array2, posnew, posold);

			mousecursor(ON);

			while(posnew == 1)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				if (buttons != 0)
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;

				// Check for keyboard press :
				key = 0;
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 4;
					if (key == 77)
						posnew++;
				}
			}
			loadpcx("file1.pcx", array2, pals);
		}

		if (posnew == 2)
		{
			// .BLD demo :
			loadpcx("file2.pcx", array1, pals);
			scrollcheck(array1, array2, posnew, posold);

			mousecursor(ON);

			while(posnew == 2)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				if (buttons != 0)
				{
					if (mx >= 9 && my >= 159 && mx <= 33 && my <= 192)
						posnew--;
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;
				}

				// Check for keyboard press :
				key = 0;
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 4;
					if (key == 75)
						posnew--;
					if (key == 77)
						posnew++;
				}
			}
			loadpcx("file2.pcx", array2, pals);
		}

		if (posnew == 3)
		{
			// PCX file demo :
			loadpcx("file3.pcx", array1, pals);
			scrollcheck(array1, array2, posnew, posold);

			mousecursor(ON);

			while(posnew == 3)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				if (buttons != 0)
				{
					if (mx >= 9 && my >= 159 && mx <= 33 && my <= 192)
						posnew--;
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;
				}

				// Check for keyboard press :
				key = 0;
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 4;
					if (key == 75)
						posnew--;
					if (key == 77)
						posnew++;
				}
			}
			loadpcx("file3.pcx", array2, pals);
		}
	}

	fadeout (pals);
}

void mousedemo()
{
	int mx, my, counterb, counter;
	unsigned char posnew = 1, posold = 1, buttons = 0, key = 0;
	loadpcx("mouse1.pcx", VIDEO, pals);
	fadein(pals);

	while(posnew != 7)
	{
		if (posnew == 1)
		{
			// Mouseinit demo :
			loadpcx("mouse1.pcx", array1, pals);
			scrollcheck(array1, array2, posnew, posold);

			mousecursor(ON);

			while(posnew == 1)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				if (buttons != 0)
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;

				// Check for keyboard press :
				key = 0;
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 7;
					if (key == 77)
						posnew++;
				}
			}
			loadpcx("mouse1.pcx", array2, pals);
		}

		if (posnew == 2)
		{
			// Mousecursor demo :
			loadpcx("mouse2.pcx", array1, pals);
			scrollcheck(array1, array2, posnew, posold);
			counterb = 0;
			mousecursor(ON);

			while(posnew == 2)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				counterb++;

				if (counterb == 5000)
					mousecursor(OFF);

				if (counterb == 10000)
				{
					mousecursor(ON);
					counterb = 0;
				}

				if (buttons != 0)
				{
					if (mx >= 9 && my >= 159 && mx <= 33 && my <= 192)
						posnew--;
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;
				}

				// Check for keyboard press :
				key = 0;
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 7;
					if (key == 75)
						posnew--;
					if (key == 77)
						posnew++;
				}
			}
			loadpcx("mouse2.pcx", array2, pals);
		}

		if (posnew == 3)
		{
			// Get mouse position demo :
			loadpcx("mouse3.pcx", array1, pals);
			scrollcheck(array1, array2, posnew, posold);

			mousecursor(ON);

			while(posnew == 3)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				gotoxy(21, 21);
				cout << mx << "  " << endl;
				gotoxy(21, 23);
				cout << my << "  " << endl;

				if (buttons != 0)
				{
					if (mx >= 9 && my >= 159 && mx <= 33 && my <= 192)
						posnew--;
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;
				}

				// Check for keyboard press :
				key = 0;
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 7;
					if (key == 75)
						posnew--;
					if (key == 77)
						posnew++;
				}
			}
			loadpcx("mouse3.pcx", array2, pals);
		}

		if (posnew == 4)
		{
			// Set mouse position demo :
			loadpcx("mouse4.pcx", array1, pals);
			scrollcheck(array1, array2, posnew, posold);
			counterb = 0;
			counter = 1;
			mousecursor(ON);

			while(posnew == 4)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				counterb += counter;

				if (counterb <= 200)
					setmousepos ((unsigned char)(rand() * 319), (unsigned char)(rand() * 199));

				if (counterb == 200)
				{
					counterb = 201;
					counter = 0;
				}

				delay (3);

				if (buttons != 0)
				{
					if (mx >= 9 && my >= 159 && mx <= 33 && my <= 192)
						posnew--;
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;
				}

				// Check for keyboard press :
				key = 0;
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 7;
					if (key == 75)
						posnew--;
					if (key == 77)
						posnew++;
				}
			}
			loadpcx("mouse4.pcx", array2, pals);
		}

		if (posnew == 5)
		{
			// Mouse buttons demo :
			loadpcx("mouse5.pcx", array1, pals);
			setpal(253, 0, 0, 0);
			setpal(254, 0, 0, 0);
			scrollcheck(array1, array2, posnew, posold);
			counter = 0;
			counterb = 0;
			mousecursor(ON);

			while(posnew == 5)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				if (counter > 0)
					counter--;
				if (counter == 0)
					setpal(254, 0, 0, 0);

				if (counterb > 0)
					counterb--;
				if (counterb == 0)
					setpal(253, 0, 0, 0);

				if (buttons != 0)
				{
					if (buttons == 1)
					{
						setpal(254, 63, 0, 0);
						counter = 3000;
					}

					if (buttons == 2)
					{
						setpal(253, 63, 0, 0);
						counterb = 3000;
					}

					if (mx >= 9 && my >= 159 && mx <= 33 && my <= 192)
						posnew--;
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;
				}

				// Check for keyboard press :
				key = 0;
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 7;
					if (key == 75)
						posnew--;
					if (key == 77)
						posnew++;
				}
			}
			loadpcx("mouse5.pcx", array2, pals);
		}

		if (posnew == 6)
		{
			// Mouse borders demo :
			loadpcx("mouse6.pcx", array1, pals);
			scrollcheck(array1, array2, posnew, posold);
			setmouselimits (5, 170, 316, 180);
			mousecursor(ON);

			while(posnew == 6)
			{
				// Check for mouse press :
				buttons = mousebuttons();
				getmousepos(mx, my);

				if (buttons != 0)
				{
					if (mx >= 9 && my >= 159 && mx <= 33 && my <= 192)
						posnew--;
					if (mx >= 285 && my >= 159 && mx <= 309 && my <= 192)
						posnew++;
				}

				// Check for keyboard press :
				key = 0;
				if (kbhit())
				{
					key = getch();

					if (key == 27)
						posnew = 7;
					if (key == 75)
						posnew--;
					if (key == 77)
						posnew++;
				}
			}
			loadpcx("mouse6.pcx", array2, pals);
			setmouselimits(0, 0, 319, 199);
		}

	}

	fadeout (pals);
}


// ****** Main program : ******
void main()
{
	// Initialize arrays and variables:
	unsigned char positions[93], button;
	unsigned int counterb;
	int x, y, countera, r, g, b, key;
	time_t timer1;

	unsigned char stick1[3252];
	unsigned char stick2[3252];
	unsigned char stick3[3252];
	unsigned char stick4[3252];
	unsigned char stick5[3252];
	unsigned char stick6[3252];
	unsigned char stick7[3252];
	unsigned char stick8[3252];

	unsigned char stand1[2793];
	unsigned char stand2[2793];
	unsigned char stand3[2793];
	unsigned char stand4[2793];

	unsigned char spare[4400];

	// Tell the viewer whats going ON :
	cprintf("EZ-VGA graphics library demo program v1.1 By Matthew Bentley.\r\n");
	cprintf("-------------------------------------------------------------\r\n");
	cprintf("Press a key at any time during this demo to skip\r\n");
	cprintf("to the next bit.\r\n");
	cprintf("Loading graphics...\r\n");


	// Load graphics into the arrays :
	loadpcx("stick1.pcx", stick1, pals);
	loadpcx("stick2.pcx", stick2, pals);
	loadpcx("stick3.pcx", stick3, pals);
	loadpcx("stick4.pcx", stick4, pals);
	loadpcx("stick5.pcx", stick5, pals);
	loadpcx("stick6.pcx", stick6, pals);
	loadpcx("stick7.pcx", stick7, pals);
	loadpcx("stick8.pcx", stick8, pals);

	loadpcx("stickst1.pcx", stand1, pals);
	loadpcx("stickst2.pcx", stand2, pals);
	loadpcx("stickst3.pcx", stand3, pals);
	loadpcx("stickst4.pcx", stand4, pals);

	loadraw("posfile.raw", positions);
	loadbld("demopal1.plt", pals);

	cprintf("Graphics loaded...");

	// Check for mouse driver:
	countera = mouseinit();

	if (countera != 1)
	{
		// End program :
		// Change back to text mode and free up memory :
		cprintf("No mouse driver - I can't continue loading the program.");
		cprintf("Execution halted.");
                getch();
		exit(1);
	}

	cprintf("Mouse found.");

	// All clear - start program :

	// Fade to black :
	for (countera = 40; countera != -1; countera--)
	{
		for (counterb = 1; counterb != 16; counterb++)
			setpal(counterb, countera, countera, countera);

		delay(20);
	}

	// Switch to vga graphics mode :
	vgainit();

	// Animation :
	setallpals(pals);

	countera = 1;

	for (counterb = 0; counterb != 90; counterb += 3)
	{
		x = positions[counterb] + positions[counterb + 1];
		y = positions[counterb + 2];

		if (countera == 1)
			putpic(x, y, stick1);
		if (countera == 2)
			putpic(x, y, stick2);
		if (countera == 3)
			putpic(x, y, stick3);
		if (countera == 4)
			putpic(x, y, stick4);
		if (countera == 5)
			putpic(x, y, stick5);
		if (countera == 6)
			putpic(x, y, stick6);
		if (countera == 7)
			putpic(x, y, stick7);
		if (countera == 8)
			putpic(x, y, stick8);

		delay(30);

		countera++;
		if (countera == 9)
			countera = 1;

		box (x, y, x + 56, y + 56, 0, FILLED);
	}

	putpic(130, 141, stick7);
	delay(65);

	putpic(137, 136, stand2);
	delay(300);

	// Fade to white :
	for (counterb = 0; counterb != 64; counterb++)
	{
		for (countera = 0; countera != 256; countera++)
		{
			r = pals[countera * 3] + counterb;
			g = pals[countera * 3 + 1] + counterb;
			b = pals[countera * 3 + 2] + counterb;

			if (r >= 63)
				r = 63;
			if (g >= 63)
				g = 63;
			if (b >= 63)
				b = 63;

			setpal(countera, r, g, b);
		}
	delay(14);
	}

	// Load title :
	loadpcx("title.pcx", VIDEO, pals);
	putsprite(138, 136, stand1, 0);

	// Fade back down to normal :
	for (countera = 63; countera != -1; countera--)
	{
		for (counterb = 0; counterb != 256; counterb++)
		{
			r = pals[counterb * 3] + countera;
			g = pals[counterb * 3 + 1] + countera;
			b = pals[counterb * 3 + 2] + countera;

			if (r >= 63)
				r = 63;
			if (g >= 63)
				g = 63;
			if (b >= 63)
				b = 63;

			setpal(counterb, r, g, b);
		}

	delay(15);
	}

	countera = 1;
	counterb = 1;
	timer1 = time(NULL);

	while (timer1 + 10 > time(NULL))
	{
		if (kbhit())
		{
			getch();
			break;
		}
		if (counterb == 1)
			putsprite(138, 136, stand1, 0);
		if (counterb == 2)
			putsprite(138, 136, stand2, 0);
		if (counterb == 3)
			putsprite(138, 136, stand3, 0);
		if (counterb == 4)
			putsprite(138, 136, stand4, 0);

		counterb += countera;
		if (counterb == 5)
		{
			counterb = 3;
			countera = -1;
		}
		if (counterb == 0)
		{
			counterb = 2;
			countera = 1;
		}

		delay(65);
	}

	// Fade out :
	fadeout(pals);

	// *************************
	// ****** Main Menu : ******
	// *************************
	loadpcx("mainmenu.pcx", VIDEO, pals);
	mousecursor(ON);
	fadein(pals);
	key = 0;

	while(key != 27 && key != 69)
	{
		// Check for keypress :
		key = 0;
		if (kbhit())
		{
			key = getch();
			key = toupper(key);
		}

		// Check for button-press :
		button = mousebuttons();

		if (button != 0)
		{
			getmousepos(x, y);

			// Find out where the mouse clicked :
			if (x >= 57 && x <= 262)
			{
				if (y >= 34 && y <= 53)
					key = 73;
				if (y >= 57 && y <= 76)
					key = 66;
				if (y >= 80 && y <= 99)
					key = 65;
				if (y >= 103 && y <= 122)
					key = 70;
				if (y >= 126 && y <= 145)
					key = 77;
				if (y >= 149 && y <= 168)
					key = 69;
			}
		}

		// If a button or key was pressed, run the corresponding area :

		if (key == 73)
		{
			// Run the introduction :
			mousecursor(OFF);
			getpic(56, 33, 262, 53, spare);
			putpic(57, 34, spare);

			// Make "click" sound :
			for (countera = 4000; countera != 500; countera -= 4)
				sound(countera);

			nosound();
			delay(100);

			fadeout(pals);

			intro();

			mousecursor(OFF);
			loadpcx("mainmenu.pcx", VIDEO, pals);
			mousecursor(ON);
			fadein(pals);
			key = 0;
		}

		if (key == 66)
		{
			// Run the basic function demo :
			mousecursor(OFF);
			getpic(56, 56, 262, 76, spare);
			putpic(57, 57, spare);

			// Make "click" sound :
			for (countera = 4000; countera != 500; countera -= 4)
				sound(countera);

			nosound();
			delay(100);

			fadeout(pals);

			basicdemo();

			mousecursor(OFF);
			loadpcx("mainmenu.pcx", VIDEO, pals);
			mousecursor(ON);
			fadein(pals);
			key = 0;
		}

		if (key == 65)
		{
			// Run the advanced function demo :
			mousecursor(OFF);
			getpic(56, 79, 262, 99, spare);
			putpic(57, 80, spare);

			// Make "click" sound :
			for (countera = 4000; countera != 500; countera -= 4)
				sound(countera);

			nosound();
			delay(100);

			fadeout(pals);

			advanceddemo();

			mousecursor(OFF);
			loadpcx("mainmenu.pcx", VIDEO, pals);
			mousecursor(ON);
			fadein(pals);
			key = 0;
		}

		if (key == 70)
		{
			// Run the file function demo :
			mousecursor(OFF);
			getpic(56, 102, 262, 122, spare);
			putpic(57, 103, spare);

			// Make "click" sound :
			for (countera = 4000; countera != 500; countera -= 4)
				sound(countera);

			nosound();
			delay(100);

			fadeout(pals);

			filedemo();

			mousecursor(OFF);
			loadpcx("mainmenu.pcx", VIDEO, pals);
			mousecursor(ON);
			fadein(pals);
			key = 0;
		}

		if (key == 77)
		{
			// Run the mouse function demo :
			mousecursor(OFF);
			getpic(56, 125, 262, 146, spare);
			putpic(57, 126, spare);

			// Make "click" sound :
			for (countera = 4000; countera != 500; countera -= 4)
				sound(countera);

			nosound();
			delay(100);

			fadeout(pals);

			mousedemo();

			mousecursor(OFF);
			loadpcx("mainmenu.pcx", VIDEO, pals);

			mousecursor(ON);
			fadein(pals);
			key = 0;
		}
	}

	// End program :
	mousecursor(OFF);
	getpic(56, 148, 262, 168, spare);
	putpic(57, 149, spare);

	// Make "click" sound :
	for (countera = 4000; countera != 500; countera -= 4)
		sound(countera);

	nosound();
	delay(100);
	fadeout(pals);

	// Change back to text mode and free up memory :
	vgaexit();

        cout << "All graphics and code (c) Copyright Matthew Bentley 1996-1998." << endl;
}
