// DLX Dynamic Loading and eXecution V2.91
// Copyright (c) 1997-1998, Nanosoft, Inc.

#include <stdio.h>
#include <iostream.h>
#include <malloc.h>
#include <string.h>
#include "dlx.h"
class CDLXImports {
        protected:
                char** names;
                long* weakoff;
                long* numlocs;
                long** relocs;
                long numimports;
        public:
                CDLXImports(void* infile, long nums);
                ~CDLXImports();
                void Replace(char* data, char* name, char* placement);
                void ReplaceWeak(char* data, char* name, char* placement);
                long CheckEmpty();
};
class CDLX;
class CDLXListedLibraries {
        protected:
                friend CDLX;
                CDLX** libslist;
                long numlibs;
        public:
                CDLXListedLibraries();
                ~CDLXListedLibraries();
                CDLXListedLibraries& operator+=(CDLX* l);
                CDLXListedLibraries& operator-=(CDLX* l);
                CDLXListedLibraries& operator-=(CDLXListedLibraries& l);
                long Exist(CDLX* l);
                long Allow(hdlx_t toal);
                void Unload();
                void Finalize();
                void Increment();
                void Decrement();
};
class CDLXSymbolList {
        protected:
                char*** tosymbols;
                hdlx_t* ids;
                long numdlx;
        public:
                CDLXSymbolList();
                void AddExports(hdlx_t id, char** tosymbol);
                long Resolve(CDLXListedLibraries& ils, CDLXImports& ims, char* data);
                void RemoveExports(hdlx_t id);
};
static CDLXSymbolList GlobalSymbols;
class CEntryTracker {
        protected:
                void** functions;
                char** names;
                long numentries;
        public:
                CEntryTracker();
                ~CEntryTracker();
                void AddPoint(char* name, void* function);
                void AddEntries(char **data);
                void* GetEntry(char* name);
};
class CDLX {
        public:
                char* data;
                long datalen;
        protected:
                void (*LibMain)(int);
                char* name;
                long linstance;
                long rinstance;
                long lt;
                long libloadpos;
                CDLXImports* myimps;
                long derror;
                dlxiddesc versions;
                CEntryTracker myentries;
                CDLXListedLibraries mylibs;
        public:
                long FinishLoad();
                void FinalPass();
                void AddDependancies(CDLXListedLibraries& m);
                void CDLX::InstanceLoad();
                void CDLX::InstanceUnload();
                CDLX(char* iname, void* infile);
                ~CDLX();
                operator hdlx_t();
                int operator==(char*);
                int operator++();
                int operator--();
                int operator!();
                void* GetEntry(char* name);
};
static void* _DefaultOpen(char* name){return((void*)fopen(name,"rb"));}
static void _DefaultClose(void* fl){fclose((FILE*)fl); }
static void _DefaultRead(void* d, long l, void* fl){ fread(d,1,l,(FILE*)fl); }
static void* _DefaultMalloc(size_t s){return malloc(s);}
static void* _DefaultRealloc(void* m, size_t s){return realloc(m,s);}
static void _DefaultFree(void* m){free(m);}
static char* __dlxerrortbl[]= { "File Error:", "DLX Not In Memory:",
                                "Unresolved External:", "Error Unloading Named Symbols:",
                                "Invalid DLX:", "Illegal Operating System:",
                                "Load Error:" };
static void _DefaultError(long t,char *i){printf("DLX Error!\n%s\n  %s\n",__dlxerrortbl[t],i);}
static hdlx_t _DefaultGet(char*){ return 0; }
void* (*DLXOpenFile)(char*)=_DefaultOpen;
void (*DLXCloseFile)(void*)=_DefaultClose;
void (*DLXReadFile)(void*,long,void*)=_DefaultRead;
void (*DLXError)(long,char*)=_DefaultError;
void* (*DLXMalloc)(size_t)=_DefaultMalloc;
void (*DLXFree)(void*)=_DefaultFree;
void* (*DLXRealloc)(void*,size_t)=_DefaultRealloc;
hdlx_t (*DLXGetID)(char*)=_DefaultGet;
static CDLX** _dlxlist=(CDLX**)DLXMalloc(0);
static long _numdlx=0;

// begin of new changes...
static CDLXListedLibraries* tofinalize;
static CDLX* _DLXLoad(char* name)
{
        strlwr(name);
        for(long l=0; l<_numdlx; l++)
        {
                if(*_dlxlist[l]==name)
                {
                        return _dlxlist[l];
                }
        }
        hdlx_t test=DLXGetID(name);
        if(test!=0)
        {
                for(long l=0; l<_numdlx; l++)
                {
                        if((hdlx_t)*_dlxlist[l]==test)
                        {
                                return _dlxlist[l];
                        }
                }
        }
        void* me=DLXOpenFile(name);
        if(me==NULL)
        {
                DLXError(0,name);
                return NULL;
        }
        CDLX* ndlx=new CDLX(name,me);
        DLXCloseFile(me);

        (*tofinalize)+=ndlx;
        if(ndlx->FinishLoad())
        {
                (*tofinalize)-=ndlx;
                DLXError(6,name);
                return NULL;
        }
        _numdlx++;
        _dlxlist=(CDLX**)DLXRealloc(_dlxlist, sizeof(CDLX**)*_numdlx);
        _dlxlist[_numdlx-1]=ndlx;
        return ndlx;
}
hdlx_t DLXLoad(char* name)
{
        tofinalize=new CDLXListedLibraries;
        CDLX* myd=_DLXLoad(name);
        if(myd==NULL)
        {
                delete tofinalize;
                return 0;
        }
        hdlx_t mydlx=(hdlx_t)*myd;
        tofinalize->Finalize();
        myd->InstanceLoad();
        delete tofinalize;
        return mydlx;
}
static void _DLXUnload(CDLX* d)
{
        for(long l=0; l<_numdlx; l++)
        {
                if(_dlxlist[l]==d)
                {
                        delete(_dlxlist[l]);
                        _dlxlist[l]=_dlxlist[_numdlx-1];
                        _numdlx--;
                        _dlxlist=(CDLX**)DLXRealloc(_dlxlist, sizeof(CDLX**)*_numdlx);
                        return;
                }
        }
        DLXError(1,"(by pointer)");
}
void DLXUnload(hdlx_t handle)
{
        for(long l=0; l<_numdlx; l++)
        {
                if((hdlx_t)*_dlxlist[l]==handle)
                {
                        CDLX* tempdlx=_dlxlist[l];
                        tempdlx->InstanceUnload();
                        if(!*tempdlx)
                        {
                                CDLXListedLibraries m;
                                tempdlx->AddDependancies(m);
                                m-=tempdlx;
                                _DLXUnload(tempdlx);

                                m.Unload();
                        }
                        return;
                }
        }
        DLXError(1,"(by number)");
}
void DLXUnload(char* name)
{
        strlwr(name);
        for(long l=0; l<_numdlx; l++)
        {
                if(*_dlxlist[l]==name)
                {
                        CDLX* tempdlx=_dlxlist[l];
                        tempdlx->InstanceUnload();
                        if(!*tempdlx)
                        {
                                CDLXListedLibraries m;
                                tempdlx->AddDependancies(m);
                                m-=tempdlx;
                                _DLXUnload(tempdlx);

                                m.Unload();
                        }
                        return;
                }
        }
        DLXError(1,name);
}
void DLXImport(char** symbols)
{
        GlobalSymbols.AddExports(0,symbols);
}
void* DLXGetEntry(hdlx_t target, char* name)
{
        for(long l=0; l<_numdlx; l++)
        {
                if((hdlx_t)*_dlxlist[l]==target)
                {
                        return _dlxlist[l]->GetEntry(name);
                }
        }
        return NULL;
}
void* DLXGetMemoryBlock(hdlx_t target)
{
        for(long l=0; l<_numdlx; l++)
        {
                if((hdlx_t)*_dlxlist[l]==target)
                {
                        return _dlxlist[l]->data;
                }
        }
        return NULL;
}
long DLXGetMemoryBlockLength(hdlx_t target)
{
        for(long l=0; l<_numdlx; l++)
        {
                if((hdlx_t)*_dlxlist[l]==target)
                {
                        return _dlxlist[l]->datalen;
                }
        }
        return NULL;
}
CDLXImports::CDLXImports(void* infile, long nums)
{
        numimports=nums;
        names=(char**)DLXMalloc(sizeof(char *)*nums);
        numlocs=(long*)DLXMalloc(sizeof(long)*nums);
        relocs=(long**)DLXMalloc(sizeof(long*)*nums);
        weakoff=(long*)DLXMalloc(sizeof(long)*nums);
        long stlen;
        for(long l=0; l<nums; l++)
        {
                DLXReadFile(&stlen, sizeof(long),infile);
                names[l]=(char *)DLXMalloc(stlen);
                DLXReadFile(names[l],stlen,infile);
                weakoff[l]=0;
                DLXReadFile(&numlocs[l],sizeof(long),infile);
                relocs[l]=(long *)DLXMalloc(sizeof(long)*numlocs[l]);
                DLXReadFile(relocs[l],sizeof(long)*numlocs[l],infile);
        }
}
CDLXImports::~CDLXImports()
{
        DLXFree(numlocs);
        DLXFree(weakoff);
        for(long l=0; l<numimports; l++)
        {
                DLXFree(names[l]);
                DLXFree(relocs[l]);
        }
        DLXFree(names);
        DLXFree(relocs);
}
void CDLXImports::Replace(char* data, char* name, char* placement)
{
        if(strlen(name)==0) return;
        for(long l=0; l<numimports; l++)
                if(strcmp(name, names[l])==0)
                {
                        long adj=0;
                        if(weakoff[l])
                                adj=(char *)weakoff[l]-data;
                        names[l][0]=0;
                        for(long l2=0; l2<numlocs[l]; l2++)
                        {
                                *(long *)(data+relocs[l][l2])+=placement-data-adj;
                        }
                }
}
void CDLXImports::ReplaceWeak(char* data, char* name, char* placement)
{
        if(strlen(name)==0) return;
        for(long l=0; l<numimports; l++)
                if(strcmp(name, names[l])==0)
                {
                        long weakpos=weakoff[l];
                        weakoff[l]=(long)placement;
                        long adj=0;
                        if(weakpos)
                                adj=(char *)weakpos-data;
                        names[l][0]=0;
                        for(long l2=0; l2<numlocs[l]; l2++)
                        {
                                *(long *)(data+relocs[l][l2])+=placement-data-adj;
                        }
                }
}
long CDLXImports::CheckEmpty()
{
        for(long l=0; l<numimports; l++)
                if(strlen(names[l])!=0)
                {
                        if(weakoff[l]==0)
                        {
                                DLXError(2,names[l]);
                                return -1;
                        }
                }
        return 0;
}
CDLXSymbolList::CDLXSymbolList()
{
        numdlx=0;
        ids=(hdlx_t*)DLXMalloc(0);
        tosymbols=(char ***)DLXMalloc(0);
}
void CDLXSymbolList::AddExports(hdlx_t id, char** tosymbol)
{
        numdlx++;
        ids=(hdlx_t*)DLXRealloc(ids, sizeof(hdlx_t)*numdlx);
        tosymbols=(char***)DLXRealloc(tosymbols,sizeof(char**)*numdlx);
        ids[numdlx-1]=id;
        tosymbols[numdlx-1]=tosymbol;
}
void CDLXSymbolList::RemoveExports(hdlx_t id)
{
        for(long l=0; l<numdlx; l++)
                if(id==ids[l])
                {
                        ids[l]=ids[numdlx-1];
                        tosymbols[l]=tosymbols[numdlx-1];
                        numdlx--;
                        ids=(hdlx_t*)DLXRealloc(ids, sizeof(hdlx_t)*numdlx);
                        tosymbols=(char***)DLXRealloc(tosymbols,sizeof(char**)*numdlx);
                        return;
                }
        DLXError(3,"(by number)");
}
long CDLXSymbolList::Resolve(CDLXListedLibraries& ils, CDLXImports& ims, char* data)
{
        for(long l=0; l<numdlx; l++)
        {
                if(ils.Allow( ids[l] ) )
                {
                        char** stemps=tosymbols[l];
                        while(1)
                        {
                                if(*stemps==0)
                                { // entries and stuff...
                                        if( stemps[1] == 0 )
                                        {
                                                break;
                                        } else if( (long)stemps[1] == 1 )
                                        {
                                                stemps+=4;
                                        } else if( (long)stemps[1] == 2 )
                                        {
                                                ims.ReplaceWeak(data, stemps[2], stemps[3]);
                                                stemps+=4;
                                        }
                                } else {
                                        ims.Replace(data, stemps[0], stemps[1]);
                                        stemps+=2;
                                }
                        }
                }
        }
        return(ims.CheckEmpty());
}
CDLX::CDLX(char* iname, void* infile)
{
        derror=0;
        rinstance=0;
        linstance=0;
        name=(char*)DLXMalloc(strlen(iname)+1);
        strcpy(name,iname);
        dlxheader dh;
        DLXReadFile(&dh, sizeof(dh),infile);
        if( dh.magic != DLX2_MAGIC )
        {
                DLXError(4,iname);
                derror=1;
                return;
        }
        libloadpos=dh.libloadpos;
        long long platform;
        DLXReadFile(&platform,sizeof(long long),infile);
        if( platform != DLX_BUILD_DOS )
        {
                char a[9]={0,0,0,0,0,0,0,0,0};
                memcpy(a, &platform, 8);
                DLXError( 5, a );
                derror=1;
                return;
        }
        DLXReadFile( &versions, sizeof(dlxiddesc), infile );
        myimps=new CDLXImports(infile,dh.numimports);
        data=(char *)DLXMalloc(dh.prgsize);
        datalen=dh.prgsize;
        DLXReadFile(data, dh.prgsize, infile);
        for(long l=0; l<dh.numrelocs; l++)
        {
                long reloc;
                DLXReadFile(&reloc,sizeof(long),infile);
                *((long *)(data+reloc))+=(long)data;
        }
        LibMain=(void(*)(int))(data+dh.libmainpos);
        // export all exports...
        //GlobalSymbols.AddExports(name, (char **)(data+dh.extablepos));
        GlobalSymbols.AddExports(versions.UNID, (char **)(data+dh.extablepos));
        myentries.AddEntries( (char **)(data+dh.extablepos) );
        // load all libraries...
}
long CDLX::FinishLoad()
{
        if(derror)
        {
                //delete(myimps);
                delete(this);
                return 1;
        }
        lt=-1;
        char** myptr=(char **)(data+libloadpos);
        while( (**myptr) != 0)
        {
                CDLX* loh=_DLXLoad(*myptr);
                if(loh==0)
                {
                        (*tofinalize)-=mylibs;
                        mylibs.Unload();
                        derror=1;
                        delete(myimps);
                        delete(this);
                        return 1;
                }
                mylibs+=loh;
                myptr++;
        }
        lt=rinstance;
        // resolve all externals...
        if(GlobalSymbols.Resolve(mylibs,*myimps, data))
        {
                mylibs.Unload();
                derror=1;
                delete(myimps);
                delete(this);
                return 1;
        }
        delete(myimps);
        derror=-1;
        return 0;
}
void CDLX::FinalPass()
{
        if(derror==-1)
        {
                LibMain(0);
//                LibMain(2);
                derror=0;
        }
}
CDLX::~CDLX()
{
        if(!derror)
        {
                LibMain(1);
                // mylibs.Unload();
        }
        GlobalSymbols.RemoveExports(versions.UNID);
        DLXFree(data);
        DLXFree(name);
}
int CDLX::operator==(char*i)
{
        return (strcmp(name,i)==0);
}
int CDLX::operator++()
{
        rinstance++;
        if(lt!=-1)
                LibMain(2);
}
int CDLX::operator!()
{
        return(rinstance==lt && linstance==0);
}
int CDLX::operator--()
{
        if(rinstance>=lt)
                LibMain(3);
        rinstance--;
}
CDLX::operator hdlx_t()
{
        return( versions.UNID );
}
void* CDLX::GetEntry(char* name)
{
        return(myentries.GetEntry(name));
}
void CDLX::AddDependancies(CDLXListedLibraries& m)
{
        for(long l=0; l<mylibs.numlibs; l++)
                if(!m.Exist(mylibs.libslist[l]))
                {
                        m+=mylibs.libslist[l];
                        mylibs.libslist[l]->AddDependancies(m);
                }
}
void CDLX::InstanceLoad()
{
        CDLXListedLibraries m;
        AddDependancies(m);
        m-=this;
        linstance++;
        m.Increment();
}
void CDLX::InstanceUnload()
{
        if(linstance>0)
        {
                CDLXListedLibraries m;
                AddDependancies(m);
                m-=this;
                linstance--;
                m.Decrement();
        }
}
CEntryTracker::CEntryTracker()
{
        functions=(void **)DLXMalloc(0);
        names=(char **)DLXMalloc(0);
        numentries=0;
}
CEntryTracker::~CEntryTracker()
{
        DLXFree(functions);
        for(long a=0; a<numentries; a++)
                DLXFree( names[a] );
        DLXFree(names);
}
void CEntryTracker::AddPoint(char* name, void* function)
{
        numentries++;
        names=(char **)DLXRealloc(names, sizeof(char *)*numentries);
        names[numentries-1]=strcpy((char *)DLXMalloc(strlen(name)+1),name);
        functions=(void **)DLXRealloc(functions, sizeof(void *)*numentries);
        functions[numentries-1]=function;
}
void CEntryTracker::AddEntries(char **stemps)
{
        while(1)
        {
                if(*stemps==0)
                { // entries and stuff...
                        if( stemps[1] == 0 )
                        {
                                return;
                        } else if( (long)stemps[1] == 1 )
                        {
                                AddPoint( stemps[2], (void*)stemps[3] );
                                stemps+=4;
                        } else if( (long)stemps[1] == 2 )
                        {
                                stemps+=4;
                        }
                } else {
                        stemps+=2;
                }
        }
}
void* CEntryTracker::GetEntry(char* name)
{
        for(long l=0; l<numentries; l++)
                if( strcmp(names[l],name)==0 )
                        return(functions[l]);
        return NULL;
}
CDLXListedLibraries::CDLXListedLibraries()
{
        libslist=(CDLX**)DLXMalloc(0);
        numlibs=0;
}
CDLXListedLibraries::~CDLXListedLibraries()
{
        DLXFree(libslist);
}
CDLXListedLibraries& CDLXListedLibraries::operator+=(CDLX* l)
{
        libslist=(CDLX**)DLXRealloc(libslist, ++numlibs*sizeof(CDLX*));
        libslist[numlibs-1]=l;
        return *this;
}
CDLXListedLibraries& CDLXListedLibraries::operator-=(CDLX* l)
{
        for(long l2=0; l2<numlibs; l2++)
                if(libslist[l2]==l)
                {
                        if(l2<numlibs-1)
                                memmove( (char*)(libslist+l2+1),(char*)(libslist+l2),(numlibs-l2-1)*sizeof(CDLX*));
                        libslist=(CDLX**)DLXRealloc(libslist, --numlibs*sizeof(CDLX*));
                }
        return *this;
}
CDLXListedLibraries& CDLXListedLibraries::operator-=(CDLXListedLibraries& l)
{
        for(long l2=0; l2<l.numlibs; l2++)
                (*this)-=l.libslist[l2];
}
long CDLXListedLibraries::Allow(hdlx_t toal)
{
        if(toal==0)
                return 1;
        for(long l=0; l<numlibs; l++)
                if((hdlx_t)*libslist[l]==toal)
                        return 1;
        return 0;
}
void CDLXListedLibraries::Unload()
{
        for(long l=0; l<numlibs; l++)
                if(!*libslist[l])
                        _DLXUnload(libslist[l]);
}
void CDLXListedLibraries::Finalize()
{
        for(long l=0; l<numlibs; l++)
                libslist[l]->FinalPass();
}
long CDLXListedLibraries::Exist(CDLX* l)
{
        for(long l2=0; l2<numlibs; l2++)
                if(libslist[l2]==l)
                {
                        return 1;
                }
        return 0;
}
void CDLXListedLibraries::Increment()
{
        for(long l2=0; l2<numlibs; l2++)
                ++(*libslist[l2]);
}
void CDLXListedLibraries::Decrement()
{
        for(long l2=0; l2<numlibs; l2++)
                --(*libslist[l2]);
}
static void dlx_auto_unload() __attribute__((destructor));
static void dlx_auto_unload()
{
        long currentdlx=0;
        while(_numdlx>0)
        {
                DLXUnload((hdlx_t)*_dlxlist[currentdlx]);
                currentdlx=currentdlx+1;
                if(currentdlx>=_numdlx)
                        currentdlx=0;
        }
}
