#ifndef	__CDESKTOP_DLGOBJ_H__
#define	__CDESKTOP_DLGOBJ_H__

#include "event.h"

#ifdef	__cplusplus
extern "C" {
#endif

/*

	dlgobj.h

		Dialog box object stuff

		C-Desktop
		Copyright (C)1998, Brett Porter.

*/

/*
	MACROS
*/

#define	DECLARE_DESKTOP_OBJECT													\
	int		fWidth;																	\
	int		fHeight;																	\
	bool		( *fEventHandler )( void*, T_EventRec* );						\
	struct S_ObjectRec	*fOwner;													\
	bool		fFocused, fCanActivate


/*
	OBJECT STRUCTURES
*/

typedef struct	/* DO NOT change this object! Change the macro to add more... */
{
	DECLARE_DESKTOP_OBJECT;
} T_MinimumDesktopObject;

typedef struct
{
	DECLARE_DESKTOP_OBJECT;	/* essential that this comes first! */

	char	*fString;

	bool	fTextCentred;

	int	fColumns, fLines;

} T_DlgString;

typedef struct
{
	DECLARE_DESKTOP_OBJECT;

	char	*fText;
	int	fID;
	int	fHotKeyPosition;
	char	fHotKey;
	bool	fIsDefault;
} T_DlgButton;

typedef struct
{
	DECLARE_DESKTOP_OBJECT;

	char	*fText;
	int	fHotKeyPosition;
	char	fHotKey;

	T_MinimumDesktopObject	*fRelatedObject;
} T_DlgLabel;

typedef struct
{
	DECLARE_DESKTOP_OBJECT;

	char			*fText;
	int			fMaxChars, fCursorPosition, fStartLetter;
	const char	*fFilter;
	bool			fOverwrite;
} T_DlgInput;

typedef struct	S_StringList
{
	char	*fText;
	int	fID;

	struct S_StringList	*fNext;
} T_StringList;

typedef struct
{
	DECLARE_DESKTOP_OBJECT;

	int	fXStart, fYStart, fMaxWidth, fSelectedNum, fNumItems;

	struct S_ScrollBar		*fVertScroll, *fHorizScroll;

	T_StringList	*fItemList;
} T_DlgListBox;

typedef struct
{
	DECLARE_DESKTOP_OBJECT;

	int	fSelectedNum, fNumButtons;

	T_StringList	*fButtonList;
} T_DlgRadioButtons;

/*
	FUNCTION PROTOTYPES
*/

extern	T_DlgString			*DlgString_Initialise( const char *aString, bool aIsCentred );
extern	T_DlgButton			*DlgButton_Initialise( const char *aString, int aID, bool aIsDefault );
extern	T_DlgInput			*DlgInput_Initialise( const char *aDefault, int aMaxChars, const char *aFilter );
extern	T_DlgLabel			*DlgLabel_Initialise( const char *aText, char aHotKey, void *aObject );
extern	T_DlgRadioButtons	*DlgRadioButtons_Initialise( void );
extern	T_DlgListBox		*DlgListBox_Initialise( struct S_ScrollBar *aHorizScroll, struct S_ScrollBar *aVertScroll );

extern	void	DlgRadioButtons_AddButton( T_DlgRadioButtons *aRadioButtons, const char *aName, int aID );
extern	T_StringList	*DlgRadioButtons_GetSelectedItem( T_DlgRadioButtons *aRadioButtons );
extern	void	DlgListBox_AddItem( T_DlgListBox *aListBox, const char *aItem, int aID );
extern	T_StringList	*DlgListBox_GetSelectedItem( T_DlgListBox *aListBox );
extern	void	DlgInput_SetString( T_DlgInput *aInput, const char *aString );

/*
	FILTERS
*/

#define  FILTER_ALPHAUPPER  	"ABCDEFGHIJKLMNOPQRSTUVWXYZ"
#define  FILTER_ALPHALOWER  	"abcdefghijklmnopqrstuvwxyz"
#define  FILTER_ALPHA       	FILTER_ALPHALOWER FILTER_ALPHAUPPER
#define  FILTER_NUMERIC     	"1234567890-"
#define  FILTER_FILENAME    	FILTER_ALPHA FILTER_NUMERIC "."
#define  FILTER_PATHNAME    	FILTER_FILENAME "/\\*?"
#define  FILTER_FLOATPT     	FILTER_NUMERIC "."
#define	FILTER_ANYTHING		""

#ifdef	__cplusplus
}
#endif

#endif



