/*  Example programs for BETATRON game library. 
 ** Copyright (C) 1997 Liouros Thanasis, liouros@hotmail.com
 **
 ** ex1.cc:     This file is part of the example programs for BETATRON game 
 **             library and can be used and/or distributed only under the terms 
 **             of the GNU General Public License. See doc/examples.txt for 
 **             details.
 */
		


#include <string.h>
#include "world.h"
#include <stdlib.h>
#include <conio.h>

TOworld myworld;

#define        WLEN                 62
#define        WHEI                 52


// 2 tiles are enough for this example
char mytiles[2][256];

unsigned short letters[31*11]= {
1, 0, 0,  0, 1, 1, 1,  0, 0, 1, 0,  0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
1, 0, 0,  0, 1, 0, 0,  0, 0, 1, 0,  0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
1, 1, 1,  0, 1, 1, 0,  0, 1, 1, 1,  0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0,
1, 0, 1,  0, 1, 0, 0,  0, 0, 1, 0,  0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0,
1, 1, 1,  0, 1, 1, 1,  0, 0, 1, 1,  0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0,
0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0,  0, 0, 0, 0,  0, 0, 1, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0,  0, 0, 0, 0,  0, 1, 1, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0,  0, 0, 0, 0,  0, 0, 1, 0,  0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0,  0, 0, 0, 0,  0, 0, 1, 0,  0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0,  0, 0, 0, 0,  0, 1, 1, 1,  0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
			};

// the background layer
unsigned short mybacklayer[WLEN*WHEI];

// this action belongs to exitobj
void exitaction(TOobject *s)
{
 char ch;

  // scroll steps:    4 pixels/frame for horizontal scrolling
  //              and 3 pixels/frame for vertical scrolling
 static char ddx=4,ddy=3;
 TOworld *w=s->owner;	    // get a pointer to myworld

 if ( kbhit()) ch=getch(); else ch='\0';

 switch (ch)
 {
  case '\033': w->exitbit=1;           // if ESCAPE then set exitbit to 1
  case 'j' : ddx=-abs(ddx);break;      // scroll left
  case 'l' : ddx=abs(ddx);break;       // scroll right
  case 'i':  ddy=-abs(ddy);break;      // scroll up
  case 'k':  ddy=abs(ddy);break;       // scroll down
 };

 w->scrollR(ddx);
 w->scrollD(ddy);
};



void main(int c,char **v)
{
 char ch1,ch2;
 int i,j;
 TOobject exitobj;     // this is the exit object
		       // it is used to make TOworld::animate() exit
		       // and in this example to do some scrolling too

 int modenumber;       // the desired video mode number

 if (c!=2)
 {
  printf("Syntax: ex1 <modenumber>\n");
  exit(1);
 }

 // the mode number is a hex number
 sscanf(v[1],"%x",&modenumber);

 // set the dimensions of the world
 myworld.setdimensions(WLEN,WHEI);
 // set the background layer pointer to the external array 'mybacklayer'
 myworld.setlayer(LAY_BACK,mybacklayer);
 // fill the background layer with tile number 0
 memset(mybacklayer,WLEN*WHEI*sizeof(short),0);

 // put the red letters in the background layer
 for (i=0;i<31;i++)
 for (j=0;j<11;j++)
 myworld.setlayervalue(LAY_BACK,i+18,j+15,letters[j*31+i]);

 // make foreground layer
 // BETATRON always needs at least background and foreground layers
 // to work. So we create the foreground layer even if it is not used in
 // this example
 CHECK(myworld.makelayer(LAY_FORE));

 // reserve memory for 2 tile pointers
 CHECK(myworld.maketiles(2));

 // set color 246 to red
 myworld.rgbset(246,56,0,0);

 // fill tile 1 with red coll
 memset(mytiles[1],246,256);

 // make a funny image for tile 0
 for (i=0;i<16;i++)
 for (j=0;j<16;j++)
  mytiles[0][i*16+j]=67+j+i;


 // insert the tiles in the world
 for (i=0;i<2;i++) myworld.settile(i,mytiles[i]);

 // Convert the tiles to 4PLANES format if the mode is modex 320x200
 // (VESA 2.00 modes need the tiles in RAW format)
 if (modenumber==gmMODEX320x200) myworld.tilesto4PLANES();

 // initialize the exit object
 exitobj.init(0,0,0,0,0);
 // set the active action of the exit object to 'exitaction'
 exitobj.nextaction=exitaction;
 // add 'exitobj' to the world, in object list 0 and priority list 0
 myworld.addobj(0,&exitobj,0);


 printf("Example program 1. Copyright 1997 Liouros Thanasis\n");
 printf("--------------------------------------------------\n");
 printf("This program comes with NO WARRANTY.\n");
 printf("See doc/examples.txt for details.\n\n");
 printf("Use i,j,k,l to move the view window. ESC to exit.\n");
 printf("\nPress <ENTER> ...\n");
 getchar();

 // try to initialize the values for the desired mode
 CHECK( myworld.initmode(modenumber)  );
 // try to set the desired mode
 CHECK(myworld.setmode());
 // move the view window to pixel coordinates (0,0)
 myworld.jumpto(0,0);

 // and start the game engine                                                 
 myworld.animate();

 // set text mode
 pl_setvideomode(3);
}
