/*  Example programs for BETATRON game library.
 ** Copyright (C) 1997 Liouros Thanasis, liouros@hotmail.com
 **
 ** demo.cc:    This file is part of the example programs for BETATRON game 
 **             library and can be used and/or distributed only under the terms 
 **             of the GNU General Public License. See doc/examples.txt for 
 **             details.
 */
		
#include <stdio.h>
#include <mem.h>
#include "world.h"
#include "plkeys.h"
#include "pltimer.h"
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <ctype.h>
#include "plvesa.h"
#include "guyele.h"
#include "cloud.h"
#include "scroll.h"


#define DXSCROLL    4
#define DYSCROLL    3

#define BITMAPSNO   22




// --------------------------------------------------------------------------
// --------------------------------------------------------------------------



// loads a raw bitmap from the disk into a raw buffer

char loadraw(char *fname,char *&frame,unsigned short &l,unsigned short &h)
{
 FILE *f;

 if ( (f=fopen(fname,"rb")) == NULL ) return 0;
 fread(&l,2,1,f);
 fread(&h,2,1,f);
 if ( (frame = (char *)malloc(l*h)) == NULL )
 {
   fclose(f);
   return 0;
  }
 fread(frame,l*h,1,f);
 fclose(f);
 return 1;
}





// ---------------------- exit object's action function ---------------------
void exitaction(TOobject *s)
{
 TOworld *w=s->owner;

 // if ESCAPE was hit then finish.
 if ( pl_testkey(mcESC) ) w->exitbit=1;

 // if P was hit then pause until P is hit again
 if (pl_testkey(mcP) ) {
   for (;pl_testkey(mcP););
   for (;!pl_testkey(mcP););
   for (;pl_testkey(mcP););
  }

 if (pl_testkey(mcR) )
 {
   pl_restoreVESAstate();
   w->refresh();
   w->rgbset(0,0,0,0);
 }


};

//----------------------------------------------------------------------

//----------------- action function of the C 1997 logo -----------------

void stable(TOsprite *s)
{
 s->x=s->owner->x+274;
 s->y=s->owner->y+3;
};



//----------------------------------------------------------------------
void tileeffect(TOobject *o)
{
#define STX        43
#define STY        16
#define TIME       30

  TOworld *w=o->owner;
  static int i=STX,j=STY;
  static short dx=1,dy=0;
  static short til=0;

 o->time+=w->dticks;

  if ( (o->time)<TIME ) return;
  o->time-=TIME;

  w->puttilexy(LAY_BACK,i,j,65);
   i+=dx;
   j+=dy;

       if (i> STX+34) {i--;j++; dx=0; dy=1;}
  else if (i< STX)  { i++;j--; dx=0; dy=-1;}

      if (j>STY+2) { j--;i--; dy=0; dx=-1;}
 else if (j<STY) { j++;i++; dy=0; dx=1;}

  w->puttilexy(LAY_BACK,i,j,til++);
  if (til > 60) til=0;

}






//----------------------------------------------------------------------

void main()
{
 int i,j;
 char name[54];
 TOworld world;
 char *bmap;

unsigned short surf[]={128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
127,126,126,125,124,124,123,123,122,122,122,122,121,121,121,120,120,119,119,118,118,
117,117,116,116,116,115,114,113,113,112,112,111,110,110,109,108,108,107,107,106,106,
106,106,105,105,105,104,104,103,103,102,102,101,101,100,100,100,99,98,97,97,96,
96,95,94,94,93,92,92,91,91,90,90,90,90,89,89,89,88,88,87,87,86,
86,85,85,84,84,84,83,82,81,81,80,80,79,78,78,77,76,76,75,75,74,
74,74,74,73,73,73,72,72,71,71,70,70,69,69,68,68,68,67,66,65,65,
64,64,63,62,62,61,60,60,59,59,58,58,58,58,57,57,57,56,56,55,55,
54,54,53,53,52,52,52,51,50,49,49,48,48,47,46,46,45,44,44,43,43,
42,42,42,42,41,41,41,40,40,39,39,38,38,37,37,36,36,36,35,34,33,
33,32,32,31,30,30,29,28,28,27,27,26,26,26,26,25,25,25,24,24,23,
23,22,22,21,21,20,20,20,19,18,17,17,16,16,15,14,14,13,12,12,11,
11,10,10,10,10,9,9,9,8,8,7,7,6,6,5,5,4,4,4,3,2,
1,1,0,0};

unsigned short surf2[]={
0,1,3,4,4,5,6,6,7,7,7,8,8,8,8,8,8,8,8,8,7,
7,7,6,6,5,5,4,3,2,1,0,
0,1,3,4,4,5,6,6,7,7,7,8,8,8,8,8,8,8,8,8,7,
7,7,6,6,5,5,4,3,2,1,0
};


 TOguy myguy;
 TOobject exitobj;
 TOobject tiletrick;
 TOscroll scrollobj;
 TOele elevator[3];
 TOcloud clouds[3];
 TOsprite c1997;
 unsigned short modenumber;
 unsigned short l,h;
 Tplmode *modes;
 short modesno;


// load the bitmaps into memory
 world.makebitmaps(BITMAPSNO);
 for (i=1;i<=BITMAPSNO;i++)
 {
   sprintf(name,"..\\dat\\steal%.3d.bin",i);

   if (!loadraw(name,bmap,l,h))
   {
     printf("Could not load bitmap %s\n",name);
     exit(1);
   }

  world.setbitmap(i-1,bmap,l,h,DRFR_TRAW);
}

// load the level
 CHECK( world.loadlevel("..\\dat\\level0.wdd"));
 world.makelayer(LAY_ATTR2);
 world.makesurfaces(10);
 world.setsurface(0,surf,sizeof(surf)/ sizeof(short),(43<<4),(24<<4));
 world.setsurface(1,surf2,sizeof(surf2)/ sizeof(short),(64<<4),(24<<4));

 // tell the world object what bitmaps to use.
 // and make 1-bitmap frame descriptors
 world.makeframesdescrs(BITMAPSNO);

 for (i=0;i<19;i++)
   world.dprintf(i,"%b",i);

 for (i=19;i<BITMAPSNO;i++)
   world.make1bitmapdescr(i,i,0);


 // set the priorities of the back and fore layers
 world.setbackprior(6);
 world.setforeprior(6);

 myguy.init(1,0,(34<<4)-world.bitmaps[0].hei,0);
 world.addobj(0,&myguy,0);

 // add the scroll object to the world
 scrollobj.init(3,&myguy,DXSCROLL,DYSCROLL);
 world.addobj(1,&scrollobj,0);


 c1997.init(13,600,600,world.bitmaps[21].len,world.bitmaps[21].hei,21);
 c1997.nextaction=(TPaction)stable;
 world.addobj(0,&c1997,9);


 // add the elevators to the world
 elevator[0].init(6,500,245,18,1,&myguy,40,460);
 world.addobj(0,&elevator[0],0);
 elevator[1].init(7,300,100,18,1,&myguy,40,560);
 world.addobj(0,&elevator[1],0);
 elevator[2].init(8,73<<4,90,18,1,&myguy,50,500);
 world.addobj(0,&elevator[2],0);

 // add the clouds to the world
 clouds[0].init(7,20,320, 19,20, 1, 10,200);
 clouds[0].activebit=0;
 clouds[0].setrange(0,320,20,200);
 world.addobj(0,&clouds[0],6);

 clouds[1].init(8,70,110, 19,20, 1, 60,70<<4);
 world.addobj(0,&clouds[1],6);

 clouds[2].init(7,20,20,  19,20, 2, 10,75<<4);
 world.addobj(0,&clouds[2],6);


// add the exitobj to the world
 exitobj.init(0,0,0,0,0);
 exitobj.nextaction=exitaction;
 world.addobj(1,&exitobj,7);

 tiletrick.init(0,0,0, 1,1);
 tiletrick.nextaction=(TPaction) tileeffect;
 world.addobj(1,&tiletrick,1);


 modesno=0;
 if (pl_initvesa()==ERR_NOERR) 
 {
  CHECK(modesno=pl_getvesamodes(modes));
 }
 printf("Demo example. Copyright 1997 Liouros Thanasis\n");
 printf("--------------------------------------------------\n");
 printf("This program comes with NO WARRANTY.\n");
 printf("See doc/examples.txt for details.\n\n");
 printf("Use the arrows to move the little hero. ESC to exit.\n");
 printf("R to refresh the view. P to pause/unpause.\n\n");

 printf("Mode number   Xresolution   Yresolution\n");
 printf("0x%.3x         %d           %d\n",0,320,200);
 for (i=0;i<modesno;i++)
  printf("0x%.3x         %d           %d\n",modes[i].modeno,modes[i].Xres,modes[i].Yres);

 printf("Enter mode number: ");
 scanf("%x",&modenumber);


  CHECK( world.initmode(modenumber));
  if (!modenumber) world.tilesto4PLANES();

  CHECK (world.setmode());
  world.inittimer();
  world.definegridlists(0, 4,-1);
  printf("world.retraceticks: %d\n",world.retraceticks);


  if (modenumber!=gmMODEX320x200) pl_saveVESAstate();

  world.jumpto( 0,0);
 
  pl_installkeys();
  world.animate();
 
  // set text mode
  pl_setvideomode(03);
  // restore the original keyboard handler
  pl_keysdone();
  pl_donevesa();
}

