/*
 ** BETATRON high level library for platform and action arcade games.
 ** Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
 **
 ** SURFACE.CC: This file is part of the BETATRON library and can be used
 **             and/or distributed only under the terms of the GNU Library
 **             General Public License. See doc/readme.1st for details.
 */



#include "world.h"


short TOworld::makesurfaces(unsigned short surfacesno0)
{
  if (surfaces) return ERR_SURFACESMADE;
  if (!surfacesno0) return ERR_ZEROMEMALLOC;
  if ( !(surfaces= (Tsurface *) malloc(surfacesno0*sizeof(Tsurface))) )
  return ERR_OUTOFMEM;

  surfacesno=surfacesno0;
  for (int i=0;i<surfacesno;i++) surfaces[i].data=NULL; // arxikopoiisi deikton
  return ERR_NOERR;
};




short TOworld::destroysurfaces()
{
  if (!surfaces) return ERR_SURFACESNOTMADE;
  if (internalsurfacesloader)
  for (int i=0;i<surfacesno;i++) if (surfaces[i].data) free(surfaces[i].data);
  free(surfaces);
  surfaces=NULL;
  internalsurfacesloader=0;
  surfacesno=0;
  return ERR_NOERR;
}



unsigned short *TOworld::unsetsurface(unsigned short no)
{
 unsigned short *tmp;
 unsigned short sx0,sy0,sl0;

 if (!surfaces) return NULL;			      // ERR_SURFACESNOTMADE
 if (no>=surfacesno) return NULL;		      // ERR_OUTOFRANGE
 if ((!Pbackattr2) || (!Pbackattr)) return NULL;      // ERR_NOATTR2LAYER
 if (!surfaces[no].data) return NULL;

 tmp=surfaces[no].data;
 sx0=surfaces[no].sx;
 sy0=surfaces[no].sy;
 sl0=surfaces[no].sl;


 register unsigned short j;
 register unsigned short *tem=tmp;
 unsigned short *lay2=Pbackattr2;
 register unsigned short *lay2tmp;
 unsigned short *lay=Pbackattr;
 unsigned short *laytmp;
 unsigned short ending=sx0+sl0;
 unsigned short tx,ty;
 unsigned short layadd;


 for (j=sx0;j<ending;j++,tem++)
 {
   tx=j >> 4;
   ty= (sy0+(*tem)) >> 4;
   if (ty>=height) ty=height-1; 	// katakorifo clipping
   layadd=ty*length+tx;

   laytmp=&lay[layadd];
   (*laytmp)&=(~32768);       // midenise to bit 15 tou attr layer

   lay2tmp=&lay2[layadd];
   (*lay2tmp)|=SURFBITSMASK; // kane 1 ta SURFBITSNO low bits tou attr2
 }

  surfaces[no].data=NULL;
  return tmp;  // epestrepse to proigoumeno surface data tou pinaka
}







unsigned short *TOworld::setsurface(unsigned short i,unsigned short *surf,unsigned short sl0
			   ,unsigned short sx0,unsigned short sy0)
{
 unsigned short *tmp;
 unsigned short wl=length << 4,  wh=height << 4;

 if ( x>=wl || y>=wh ) return NULL;		      // ERR_OUTOFRANGE
 if (!surfaces) return NULL;			      // ERR_SURFACESNOTMADE
 if (i>=surfacesno) return NULL;		      // ERR_OUTOFRANGE
 if ((!Pbackattr2) || (!Pbackattr)) return NULL;      // ERR_NOATTR2LAYER

 // clip the surface if it is too large
 if ( sx0+sl0-1 >= wl ) sl0=wl-sx0;
 if (!sl0)  return NULL;			     // ERR_ZEROLEN

 if (sy0>=wh) return NULL;		     // ERR_OUTOFRANGE

 tmp=surfaces[i].data;
 surfaces[i].data=surf; 	  // put the new surface in the array
 surfaces[i].sx=sx0;
 surfaces[i].sy=sy0;
 surfaces[i].sl=sl0;

 register unsigned short j;
 register unsigned short *tem=surf;
 unsigned short *lay2=Pbackattr2;
 register unsigned short *lay2tmp;
 unsigned short *lay=Pbackattr;
 unsigned short ending=sx0+sl0;
 unsigned short tx,ty;
 unsigned short layadd;


 // midenise ta 16-SURFBITSNO ipsilotera bits tou i
 i&=SURFBITSMASK;

 for (j=sx0;j<ending;j++,tem++)
 {
   tx=j >> 4;
   ty= (sy0+(*tem)) >> 4;
   if (ty>=height) ty=height-1; 	// katakorifo clipping
   layadd=ty*length+tx;

   (*(lay+layadd))|=32768;

   lay2tmp=lay2+layadd;
// midenise ta SURFBITSNO xamilotera bits tou *lay2
   (*lay2tmp)&=~SURFBITSMASK;

// kane ta SURBITSNO xamilotera bits tou *lay2 idia me tou i
   (*lay2tmp)|=i;
 }

  return tmp;  // epestrepse to proigoumeno surface data tou pinaka
}


