/*****************************************************************************
 maketext.c - v1.2, by Chris La Mantia
              a utility to assist in creating text data objects
              For use with the Allegro library
              Last modified 19 May 1998 by Grzegorz Adam Hankiewicz
*****************************************************************************/


#include <dir.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define STRSIG "/* Allegro text data object defines */\n"

void helpme(void);
int main(int argc, char *argv[]);
void maketable(char *filename, char delimiter);
char **__crt0_glob_function(char *_argument);

int main(int argc, char *argv[])
{
   struct ffblk f;
   char inmask[256];
   char delimit=0;
   int done=0;

   if(argc<2) {
      helpme();
      return(0);
   }
   if(argc>2)
      delimit=argv[2][0];

   strcpy(inmask,argv[1]);


   if ( !findfirst(inmask, &f, FA_ARCH | FA_RDONLY )) {
      while(!done) {
         maketable(f.ff_name,delimit);
         done=findnext(&f);
      }
   } else {
      printf("MAKETEXT: No files found matching %s\n\n",inmask);
      return(EXIT_FAILURE);
   }
  return(EXIT_SUCCESS); 
}



void helpme(void)
{
   printf("MAKETEXT 1.2: A utility to build text data objects for Allegro\nBy Chris La Mantia\n\n");
   printf("Usage: MAKETEXT filespec [delimiter]\n\n");
   printf("filespec may include wildcards; it should point to one or more\n");
   printf("text data object source files.\n\n");
   printf("A text data object source file is simply a text file containing strings,");
   printf("one on each line.  Each string may be preceded by a label, separated\n");
   printf("from the string by [delimiter].\n\n");
   printf("Output files: MAKETEXT will create a .TDO file with the same name as\n");
   printf("the source file, and a .H file with any labels defined in it.\n\n");
}

void maketable(char *filename, char delimiter)
{
   char buf[40960];
   char *outstring;
   FILE *infile;
   FILE *outfile;
   FILE *hfile;
   char infilename[256];
   char outfilename[256];
   char hfilename[256];
   int  index;
   int  hflag;
   int  count;
   int result;

   printf("MAKETEXT: Building text data object from %s...\n",filename);
   strcpy(infilename, filename);
   strcpy(outfilename,infilename);
   for(index=strlen(outfilename);index>0;index--) {
      if(outfilename[index]=='.') {
         outfilename[index]=0;
         index=0;
      }
   }
   strcpy(hfilename,outfilename);
   strcat(outfilename,".TDO");
   strcat(hfilename,".h");
   if(delimiter>0) {
      hfile=fopen(hfilename,"rt");
      if(hfile!=NULL) {
         fgets(buf,4095,hfile);
         fclose(hfile);
         if(strcmp(STRSIG,buf)!=0) {
            printf("MAKETEXT Aborting: %s already exists and is not a text data object header!\n",hfilename);
            exit(EXIT_FAILURE);
         }
      }
   }
   hfile=NULL;
   infile=fopen(infilename,"rt");
   if(infile==NULL) {
      printf("MAKETEXT Aborting: Cannot open %s!\n",infilename);
      exit(EXIT_FAILURE);
   }
   outfile=fopen(outfilename,"wb");
   if(outfile==NULL) {
      printf("MAKETEXT Aborting: Cannot create %s!\n",outfilename);
      fclose(infile);
      exit(EXIT_FAILURE);
   }
   hflag=0;
   count=0;
   while(!feof(infile)) {
      /* Process text data object */
      outstring=fgets(buf,4095,infile);
      if(outstring!=NULL) {
         if(strlen(buf)>0) {
            if(buf[strlen(buf)-1]=='\n')
               buf[strlen(buf)-1]=0;
            if(delimiter>0) {
               /* Process labels */
               for(index=0;index<strlen(buf);index++) {
                  if(buf[index]==delimiter) {
                     buf[index]=0;
                     outstring=buf+index+1;
                     if(hflag==0) {
                        hflag=1;
                        hfile=fopen(hfilename,"wt");
                        if(hfile==NULL) {
                           printf("MAKETEXT Warning: Cannot create %s!\n",hfilename);
                        } else {
                           fprintf(hfile,STRSIG);
                        }
                     }
                     if(hfile!=NULL) {
                        fprintf(hfile,"#define %-16s %3d\n",buf,count);
                     }
                  }
               }
            }
         }

         result=fputs(outstring,outfile);
         if(result==EOF) {
            printf("MAKETEXT Aborting: Cannot write to %s.  Is the disk full?\n",outfilename);
            exit(EXIT_FAILURE);
         }
         fputc(0,outfile);
/*       printf("\"%s\"\n",outstring); */
         count++;
      }

   }
   printf("%s successfully built from %s; it contains %d string%c\n",
          outfilename,infilename,count,(count==1)?' ':'s');
   fclose(infile);
   fclose(outfile);
   if(hfile!=NULL)
      fclose(hfile);

}


char **__crt0_glob_function(char *_argument)
{
   return(NULL);

}
