/*
 * This file is part of Palantir.
 * Version : 0.4.1
 * Copyright (c) 1997 Dim Zegebart, Moscow Russia.
 * zager@post.comstar.ru
 * http://www.geocities.com/siliconvalley/pines/7817
 * file : dzdelim.c
 *
 */

#include "palantir.h"
#include <sys/stat.h>

//----------------------- COMM PORT WAIT DELIMITERS -------------------------

typedef struct
{ device *port;
  odlist *waiting_delimiters;
} port_waiting_delimiter;
#define pwdelimiter_(_str_) ({(port_waiting_delimiter*)(_str_);})
odlist *delimiters_list;
int waitdelimiter_handler(a_message code,int p1,int p2);
//extern log_file *copy_log_file_structure(log_file *lfile);
dz_app *wait_app;
static int delimiter_init=0;

//------------------------ WAITING DELIMITER INIT ---------------------------

int waiting_delimiter_init(void)
{ int tmp;

  if (delimiter_init) return(1); //already installed

  if ((delimiters_list=odlist_new())==NULL)
   {
     return(0);
   }

  if ((wait_app=dz_app_new("Wait delims (comm helper)",16384,1,waitdelimiter_handler))==NULL)
   { lwp_disable;
     free(delimiters_list);
     lwp_enable;
     return(0);
   }

  delimiter_init=1;
  return(1);
}

//---------------------- COMM_PORT_WAITDELIMITERS_ADD ------------------------

waiting_delimiter *comm_port_waitdelimiters_add(device *dev,dz_app *app,char *s1,char *s2)
{ comm_port *port=dev->device_user_data;
  odlist *cur_list;
  odelement *cur;
  int tmp;

  if (dev==NULL||port==NULL||s1==NULL||s1[0]==0||s2==NULL||s2[0]==0) return(NULL);

  { cur=delimiters_list->first;
    while (cur!=NULL) //check installed handlers
     { if (pwdelimiter_(cur->data)->port==dev) break;
       cur=cur->next;
     }
    if (cur==NULL) //add handler for new port
     { port_waiting_delimiter *new_port_list;

       lwp_disable;
       new_port_list=pwdelimiter_(calloc(sizeof(port_waiting_delimiter),1));
       lwp_enable;
       if (new_port_list==NULL) return(NULL);

       new_port_list->port=dev;
       if ((new_port_list->waiting_delimiters=odlist_new())==NULL)
        { lwp_disable;
          free(new_port_list);
          lwp_enable;
          return(NULL);
        }

       if (odlist_insert(delimiters_list,new_port_list)==NULL)
        { lwp_disable;
          free(new_port_list->waiting_delimiters);
          free(new_port_list);
          lwp_enable;
          return(NULL);
        }
       cur_list=new_port_list->waiting_delimiters;
       if (device_client_task_add(dev,wait_app,READ)==NULL) //add handler for new port
         { lwp_disable;
           free(new_port_list->waiting_delimiters);
           free(new_port_list);
           lwp_enable;
           return(NULL);
         }

     }
    else
     cur_list=pwdelimiter_(cur->data)->waiting_delimiters;
  }

  { waiting_delimiter *wd;
    cur=cur_list->first;
    while (cur!=NULL) //check installed delimiters
     { wd=wdelimiter_(cur->data);
       if (strcmp(wd->delimiter1,s1)==0&&strcmp(wd->delimiter2,s2)==0)
        { wd->status=0;
          return(wd);
        }
       cur=cur->next;
     }
  }

  {
  waiting_delimiter *wdlm;
  char *str1;
  char *str1_buf;
  char *str2;
  char *str2_buf;
  char *buffer;

  lwp_disable;
  wdlm=wdelimiter_(calloc(sizeof(waiting_delimiter),1));
  str1=(char*)malloc(strlen(s1)+1);
  str1_buf=(char*)malloc(strlen(s1)+1);
  str2=(char*)malloc(strlen(s2)+1);
  str2_buf=(char*)malloc(strlen(s2)+1);
  buffer=(char*)malloc(4096);

  if (wdlm==NULL||str1==NULL||str1_buf==NULL||str2==NULL||
      str2_buf==NULL||buffer==NULL)
   { free(wdlm);
     free(str1_buf);
     free(str1);
     free(str2_buf);
     free(str2);
     free(buffer);
     lwp_enable;
     return(NULL);
   }
  lwp_enable;

  wdlm->app=app;
  wdlm->delimiter1=str1;
  wdlm->delimiter1_len=strlen(s1);
  wdlm->delimiter1_buf_len=0;
  wdlm->delimiter1_buf=str1_buf;
  strcpy(str1,s1);

  wdlm->app=app;
  wdlm->delimiter2=str2;
  wdlm->delimiter2_len=strlen(s2);
  wdlm->delimiter2_buf_len=0;
  wdlm->delimiter2_buf=str2_buf;
  strcpy(str2,s2);

  wdlm->status=1;
  if (odlist_insert(cur_list,wdlm)==NULL)
   { lwp_disable;
     free(wdlm);
     free(str1_buf);
     free(str1);
     free(str2_buf);
     free(str2);
     free(buffer);
     lwp_enable;
     return(NULL);
   }

  wdlm->status=0;
  wdlm->buffer_status=BUF_CLOSED;
//  wdlm->buffer_status=BUF_OPEN;
  wdlm->buffer_len=0;
  wdlm->buffer_max_len=4096; //4K
  wdlm->buffer=buffer;
  wdlm->rcv_buffer=NULL;
  wdlm->dev=dev;
  return(wdlm);
  }
}

//------------------- WAIT DELIMITER HANDLER ---------------------

int waitdelimiter_handler(a_message code,int p1,int p2)
{ odelement *cur;
  waiting_delimiter *wdlm;
  int tmp;
//  dz_msg msg;
//  dz_app *app=(dz_app*)(dev->device_user_data);
  int c;

  switch (code)
   { case H_COMM_IN :
       c=p1;
       if (c==0) c=' ';

       cur=delimiters_list->first;
       while (cur!=NULL)
        { if (pwdelimiter_(cur->data)->port==dev_(p2)) break;
          cur=cur->next;
        }
       if (cur==NULL)
        { printf("Zero\n");
//          flush(cur_cxt);
          return(1);
        }

       cur=(pwdelimiter_(cur->data)->waiting_delimiters)->first;
       while (cur!=NULL)
         { wdlm=wdelimiter_(cur->data);//(waiting_delimiter*)cur->data;
           if (wdlm->status!=1)
            { //wdlm=wdelimiter_(cur->data);
//              printf("%d,%d\n",wdlm->buffer_status,BUF_OPEN);
              if (wdlm->buffer_status==BUF_OPEN)
               { //putch(c);
                 wdlm->buffer[wdlm->buffer_len]=c;
                 wdlm->buffer_len++;
                 if ((wdlm->buffer_len+1)==wdlm->buffer_max_len)
                   { char *tmpch;
                     lwp_disable;
                     if ((tmpch=(char*)realloc(wdlm->buffer,wdlm->buffer_max_len+1024))!=NULL)
                       { wdlm->buffer=tmpch;
                         wdlm->buffer_max_len+=1024;
                       }
                     else
                       {
                         #ifdef __DZ_AA__
                         aa_printf(cur_cxt,AA_NORMAL,"Error : Out of memory ! wdlm_resize\n");
                         aa_flush(cur_cxt);
                         #else
                         printf("Error : Out of memory ! wdlm_resize\n");
                         #endif
                         palantir_deinit();
                         return(0);
                       }
                     lwp_enable;
                   }
               } //end if wdlm->buffer_status==BUF_OPEN)
              lwp_disable;
              if (wdlm->delimiter1_buf_len==wdlm->delimiter1_len)
                { memmove(wdlm->delimiter1_buf,wdlm->delimiter1_buf+1,wdlm->delimiter1_len-1);
                  wdlm->delimiter1_buf_len--;
                }
              wdlm->delimiter1_buf[wdlm->delimiter1_buf_len]=c;
              wdlm->delimiter1_buf_len++;
              wdlm->delimiter1_buf[wdlm->delimiter1_buf_len]=0;
              if (strcmp(wdlm->delimiter1,wdlm->delimiter1_buf)==0)
               { //wdlm->status=1;
                 //app_msg_put(wdlm->app,E_COMM_DELIMITERS,(int)wdlm,(int)dev);
                 //return(0);
                 wdlm->buffer_len=0;
                 wdlm->buffer_status=BUF_OPEN;
//                 printf("open\n");
//                 printf("%d,%d\n",wdlm->buffer_status,BUF_OPEN);
//                 wdlm->delimiter1_buf[0]=0;
               }

              if (wdlm->delimiter2_buf_len==wdlm->delimiter2_len)
                { memmove(wdlm->delimiter2_buf,wdlm->delimiter2_buf+1,wdlm->delimiter2_len-1);
                  wdlm->delimiter2_buf_len--;
                }
              wdlm->delimiter2_buf[wdlm->delimiter2_buf_len]=c;
              wdlm->delimiter2_buf_len++;
              wdlm->delimiter2_buf[wdlm->delimiter2_buf_len]=0;
              if (strcmp(wdlm->delimiter2,wdlm->delimiter2_buf)==0)
               { //wdlm->status=1;
                 //app_msg_put(wdlm->app,E_COMM_DELIMITERS,(int)wdlm,(int)dev);
                 //return(0);
                 if (wdlm->buffer_status==BUF_OPEN)
                  { wdlm->buffer_status=BUF_CLOSED;
                    wdlm->buffer[wdlm->buffer_len-strlen(wdlm->delimiter2)]=0;
//                    printf("close\n");
//                    printf("%s\n",wdlm->buffer);
                    lwp_disable;
                    wdlm->rcv_buffer=strdup(wdlm->buffer);
                    app_msg_put(wdlm->app,E_COMM_DELIMITERS,(int)wdlm,(int)p2);
                    lwp_enable;
                    return(1);
                  }
               }
              lwp_enable;
             }

            cur=cur->next;
         }
      default :
        break;
    }
  return(1);
}

//------------------- COMM PORT DELIMITER WAIT REMOVE ---------------------

void comm_port_waitdelimiter_remove(device *dev,dz_app *task,char *s1,char *s2)
{ odelement *cur;
  odlist *wlist;
  int tmp;
  if (dev==NULL) return;

  cur=delimiters_list->first;
  while (cur!=NULL) //find port
   { if (pwdelimiter_(cur->data)->port==dev) break;
     else cur=cur->next;
   }
  if (cur==NULL) return;

  wlist=pwdelimiter_(cur->data)->waiting_delimiters;
  cur=wlist->first;

  while (cur!=NULL)
   { if (wdelimiter_(cur->data)->app==task)
      { if (strcmp(wdelimiter_(cur->data)->delimiter1,s1)==0&&
            strcmp(wdelimiter_(cur->data)->delimiter2,s2)==0)
         { lwp_disable;
           odlist_remove(wlist,cur->data);
           free(wdelimiter_(cur->data)->delimiter1);
           free(wdelimiter_(cur->data)->delimiter1_buf);
           free(wdelimiter_(cur->data)->delimiter2);
           free(wdelimiter_(cur->data)->delimiter2_buf);
           free(wdelimiter_(cur->data)->buffer);
           free(cur->data);
           lwp_enable;
           return;
         }
      }
     cur=cur->next;
   }
}

//--------------- READ DELIMITERS FROM FILE ----------------
/*
int read_delimiters_from_file(waiting_delimiter *wdlm,char *ini_name)
{
  FILE *ini;
  int l,i;
  char *buf,*s,v[MAXPATH];
  char fixed_name[MAXPATH];

  _fixpath(ini_name,fixed_name);

  if ((ini=fopen(fixed_name,"rt"))==NULL) return(0);
  l=filelength(fileno(ini));
  if ((buf=(char*)alloca(l))==NULL)
    { fclose(ini);
      return(0);
    }

  l=fread(buf,1,l,ini);
  fclose(ini);
  buf[l]=0;
  strlwr(buf);

  wdlm->delimiter1[0]=0;
  wdlm->delimiter2[0]=0;

  if ((s=strstr(buf,"beg_delim_code"))!=NULL)
   { if (not_commented(s)&&(s=strchr(s,'='))!=NULL)
      { s++;i=0;
        while ((*s!=';')&&(*s!='\n')&&(*s!=0)&&(i<9))
         if (!isspace(*s)) v[i++]=*s++;

        v[i]=0;
        if ((i=atoi(v))!=0)
         { wdlm->delimiter1[0]=i;
           wdlm->delimiter1[1]=0;
         }
      }
   }

  if ((s=strstr(buf,"end_delim_code"))!=NULL)
   { if (not_commented(s)&&(s=strchr(s,'='))!=NULL)
      { s++;i=0;
        while ((*s!=';')&&(*s!='\n')&&(*s!=0)&&(i<9))
         if (!isspace(*s)) v[i++]=*s++;

        v[i]=0;
        if ((i=atoi(v))!=0)
         { wdlm->delimiter2[0]=i;
           wdlm->delimiter2[1]=0;
         }
      }
   }

  if ((s=strstr(buf,"beg_delim_string"))!=NULL)
   { if (not_commented(s)&&(s=strchr(s,'='))!=NULL)
      { s++;i=0;
        while ((*s!=';')&&(*s!='\n')&&(*s!=0)&&(i<64))
         v[i++]=*s++;

        v[i]=0;
        strcpy(wdlm->delimiter1,v);
      }
   }

  if ((s=strstr(buf,"end_delim_string"))!=NULL)
   { if (not_commented(s)&&(s=strchr(s,'='))!=NULL)
      { s++;i=0;
        while ((*s!=';')&&(*s!='\n')&&(*s!=0)&&(i<64))
         v[i++]=*s++;

        v[i]=0;
        strcpy(wdlm->delimiter2,v);
      }
   }

  return(1);
}
*/
