


INDENT(1L)                                             INDENT(1L)


NNAAMMEE
       indent  - changes the appearance of a C program by insert-
       ing or deleting whitespace.

SSYYNNOOPPSSIISS
       indent [-bad] [-bap] [-bbb] [-bc] [-bl] [-bliN] [-br] [-cN] [-cdN] [-cdb]
            [-ce] [-ciN] [-cliN] [-cpN] [-cs] [-bs] [-dN] [-diN] [-fc1] [-fca]
            [-gnu] [-iN] [-ipN] [-kr] [-lN] [-lp] [-nbad] [-nbap] [-nbbb]
            [-nbc] [-ncdb] [-nce] [-ncs] [-nfc1] [-nfca] [-nip] [-nlp] [-npcs]
            [-npsl] [-nsc] [-nsob] [-nss] [-nv] [-orig] [-npro] [-pcs] [-psl]
            [-sc] [-sob] [-ss] [-st] [-T] [-tsN] [-v] [-version] [file]

DDEESSCCRRIIPPTTIIOONN
       This man page is based on the Info file indent.info,  pro-
       duced by Makeinfo-1.47 from the input file indent.texinfo.
       This is Edition 0.02, 5 May 1992, of The `indent'  Manual,
       for Indent Version 1.3.

       Copyright (C) 1989, 1992 Free Software Foundation, Inc.

CCOOPPYYIINNGG
       Permission  is  granted  to  make  and distribute verbatim
       copies of this manual provided the  copyright  notice  and
       this permission notice are preserved on all copies.

IINNTTRROODDUUCCTTIIOONN
       The  `indent'  program  can be used to make code easier to
       read.  It can also convert from one style of writing C  to
       another.

       `indent' understands a substantial amount about the syntax
       of C, but it also attempts to  cope  with  incomplete  and
       misformed syntax.

       In  version 1.2 and more recent versions, the GNU style of
       indenting is the default.

IINNVVOOKKIINNGG IINNDDEENNTT
       As of version 1.3, the format of the `indent' command is:

            indent [OPTIONS] [INPUT-FILES]

            indent [OPTIONS] [SINGLE-INPUT-FILE] [-o OUTPUT-FILE]

       This  format  is different from earlier versions and other
       versions of `indent'.

       In the first form, one or more input files are  specified.
       `indent'  makes a backup copy of each file, and the origi-
       nal file is replaced with  its  indented  version.   *Note
       Backup  files::,  for  an  explanation  of how backups are
       made.

       In the second form, only one input file is specified.   In



                                                                1





INDENT(1L)                                             INDENT(1L)


       this  case,  or  when  the standard input is used, you may
       specify an output file after the `-o' option.

       To cause `indent' to write to  standard  output,  use  the
       `-st' option.  This is only allowed when there is only one
       input file, or when the standard input is used.

       If no input files are named, the standard  input  is  read
       for  input.   Also,  if a filename named `-' is specified,
       then the standard input is read.

       As an example, each of the following commands  will  input
       the  program  `slithy_toves.c' and write its indented text
       to `slithy_toves.out':

            indent slithy_toves.c -o slithy_toves.out

            indent -st slithy_toves.c > slithy_toves.out

            cat slithy_toves.c | indent -o slithy_toves.out

       Most other options to `indent' control  how  programs  are
       formatted.   As of version 1.2, `indent' also recognizes a
       long name for each option name.  Long options are prefixed
       by either `--' or `+'.  `+' is being superseded by `--' to
       maintain consistency with the POSIX standard.  In most  of
       this  document,  the traditional, short names are used for
       the sake of brevity.

       Here is another example:

            indent -br test/metabolism.c -l85

       This will indent the program `test/metabolism.c' using the
       `-br'  and  `-l85'  options,  write  the  output  back  to
       `test/metabolism.c', and write the  original  contents  of
       `test/metabolism.c'  to  a  backup  file  in the directory
       `test'.

       Equivalent invocations using long option  names  for  this
       example would be:

            indent      --braces-on-if-line      --line-length185
            test/metabolism.c

            indent       +braces-on-if-line       +line-length185
            test/metabolism.c

       If  you  find  that  you  often use `indent' with the same
       options, you may put those  options  into  a  file  called
       `.indent.pro'.  `indent' will first look for `.indent.pro'
       in the current directory and use that  if  found.   Other-
       wise,   `indent'  will  search  your  home  directory  for
       `.indent.pro' and use that file  if  it  is  found.   This



                                                                2





INDENT(1L)                                             INDENT(1L)


       behaviour  is  different  from  that  of other versions of
       `indent', which load both files if they both exist.

       Command  line  switches  are  handled  *after*  processing
       `.indent.pro'.  Options specified later override arguments
       specified earlier, with one exception:  Explicitly  speci-
       fied  options  always  override  background options (*note
       Common styles::.).  You can prevent `indent' from  reading
       an `.indent.pro' file by specifying the `-npro' option.

BBAACCKKUUPP FFIILLEESS
       As  of  version  1.3, GNU `indent' makes GNU--style backup
       files, the same way  GNU  Emacs  does.   This  means  that
       either  "simple"  or  "numbered"  backup  filenames may be
       made.

       Simple backup file names are generated by appending a suf-
       fix  to  the original file name.  The default for the this
       suffix is the one-character string `~' (tilde).  Thus, the
       backup file for `python.c' would be `python.c~'.

       Instead  of  the  default, you may specify any string as a
       suffix  by  setting   the   environment   variable   `SIM-
       PLE_BACKUP_SUFFIX' to your preferred suffix.

       Numbered  backup versions of a file `momewraths' look like
       `momewraths.c.~23~', where 23 is the version of this  par-
       ticular backup.  When making a numbered backup of the file
       `src/momewrath.c',  the  backup   file   will   be   named
       `src/momewrath.c.~V~',  where  V  is  one greater than the
       highest version currently existing in the directory `src'.

       The type of backup file made is controlled by the value of
       the environment variable `VERSION_CONTROL'.  If it is  the
       string  `simple',  then  only simple backups will be made.
       If its value is the string `numbered', then numbered back-
       ups  will  be  made.  If its value is `numbered-existing',
       then numbered backups  will  be  made  if  there  *already
       exist*  numbered backups for the file being indented; oth-
       erwise, a simple backup is made.  If `VERSION_CONTROL'  is
       not set, then `indent' assumes the behaviour of `numbered-
       existing'.

       Other versions of `indent' use the suffix `.BAK' in naming
       backup  files.   This behaviour can be emulated by setting
       `SIMPLE_BACKUP_SUFFIX' to `.BAK'.

       Note also that other versions of `indent' make backups  in
       the current directory, rather than in the directory of the
       source file as GNU `indent' now does.

CCOOMMMMOONN SSTTYYLLEESS
       There are several common styles of C code,  including  the
       GNU style, the Kernighan & Ritchie style, and the original



                                                                3





INDENT(1L)                                             INDENT(1L)


       Berkeley style.  A style may be  selected  with  a  single
       "background"  option,  which specifies a set of values for
       all other options.  However, explicitly specified  options
       always override options implied by a background option.

       As  of  version  1.2, the default style of GNU `indent' is
       the GNU style.  Thus, it is no longer neccessary to  spec-
       ify  the  option  `-gnu'  to  obtain this format, although
       doing so will not cause an error.  Option  settings  which
       correspond to the GNU style are:

            -nbad -bap -nbbb -nbc -bl -bli2 -c33 -cd33 -ncdb -nce
            -cli0 -cp1 -di0 -nfc1 -nfca -i2 -ip5  -lp  -pcs  -psl
            -nsc -nsob -nss -ts8

       The GNU coding style is that preferred by the GNU project.
       It is the style that the GNU Emacs C mode  encourages  and
       which  is  used  in  the C portions of GNU Emacs.  (People
       interested in writing programs for Project GNU should  get
       a  copy  of  `The GNU Coding Standards', which also covers
       semantic and portability issues such as memory usage,  the
       size of integers, etc.)

       The  Kernighan  &  Ritchie  style is used throughout their
       well-known book  `The  C  Programming  Language'.   It  is
       enabled  with  the  `-kr' option.  The Kernighan & Ritchie
       style corresponds to the following set of options:

            -nbad -bap -nbbb -nbc -br -c33 -cd33 -ncdb  -ce  -ci4
            -cli0  -cp33  -d0  -di1 -nfc1 -nfca -i4 -ip0 -l75 -lp
            -npcs -npsl -nsc -nsob -nss -ts8

       Kernighan & Ritchie style does not  put  comments  to  the
       right of code in the same column at all times (nor does it
       use only one space to the right of the code), so for  this
       style `indent' has arbitrarily chosen column 33.

       The  style  of  the  original  Berkeley  `indent'  may  be
       obtained  by  specifying  `-orig'  (or   by   specifyfying
       `--original',  using the long option name).  This style is
       equivalent to the following settings:

            -nbap -nbad -nbbb -bc -br -c33 -cd33  -cdb  -ce  -ci4
            -cli0  -cp33  -d4  -di16  -fc1 -fca -i4 -ip4 -l75 -lp
            -npcs -psl -sc -nsob -nss -ts8


BBLLAANNKK LLIINNEESS
       Various programming styles use blank  lines  in  different
       places.   `indent'  has  a  number of options to insert or
       delete blank lines in specific places.

       The `-bad' option causes `indent' to force  a  blank  line
       after  every  block  of  declarations.  The `-nbad' option



                                                                4





INDENT(1L)                                             INDENT(1L)


       causes `indent' not to force such blank lines.

       The `-bap' option forces a blank line after  every  proce-
       dure  body.  The `-nbap' option forces no such blank line.

       The `-bbb' option forces a blank line before  every  block
       comment. A block comment is one which starts in column one
       when formatting of such comments is disabled, or one  with
       `-'  or  `*'  immediately following the `/*'.  The `-nbbb'
       option does not force such blank lines.

       The `-sob' option  causes  `indent'  to  swallow  optional
       blank  lines (that is, any optional blank lines present in
       the input will  be  removed  from  the  output).   If  the
       `-nsob' is specified, any blank lines present in the input
       file will be copied to the output file.

       The `-bad' option forces a blank line after every block of
       declarations.   The  `-nbad'  option does not add any such
       blank lines.

       For example, given the input

                 char *foo;
                 char *bar;
                 /* This separates blocks of declarations.  */
                 int baz;

       `indent -bad' produces


                 char *foo;
                 char *bar;

                 /* This separates blocks of declarations.  */
                 int baz;

       and `indent -nbad' produces

                 char *foo;
                 char *bar;
                 /* This separates blocks of declarations.  */
                 int baz;

       The `-bap' option forces a blank line after  every  proce-
       dure body.  For example, given the input

                 int
                 foo ()
                 {
                   puts("Hi");
                 }
                 /* The procedure bar is even less interesting.  */
                 char *



                                                                5





INDENT(1L)                                             INDENT(1L)


                 bar ()
                 {
                   puts("Hello");
                 }

       `indent -bap' produces

                 int
                 foo ()
                 {
                   puts ("Hi");
                 }

                 /* The procedure bar is even less interesting.  */
                 char *
                 bar ()
                 {
                   puts ("Hello");
                 }

       and `indent -nbap' produces

                 int
                 foo ()
                 {
                   puts ("Hi");
                 }
                 /* The procedure bar is even less interesting.  */
                 char *
                 bar ()
                 {
                   puts ("Hello");
                 }

       No blank line will be added after the procedure `foo'.

CCOOMMMMEENNTTSS
       Comments  are no longer formatted by default as of version
       1.2.  This can be enabled with the `-fca'  option.   Doing
       so  will  cause newlines in the comment text to be ignored
       and the line will be filled up to the  length  of  a  line
       (which  can  be  modified  with `-l').  When formatting is
       enabled, blank lines indicate paragraph breaks.

       The `-fc1' option enables the formatting of comments which
       begin  in  the  first column.  The `-nfc1' option disables
       the formatting of first  column  comments.   When  comment
       formatting  is  disabled,  overall comment indentation may
       still be adjusted.

       The indentation of comments which do  not  appear  to  the
       right  of  code is set by the `-d' option, which specifies
       the number of spaces to the left of the  surrounding  code
       that  the  comment  appears.   For  example,  `-d2' places



                                                                6





INDENT(1L)                                             INDENT(1L)


       comments two spaces to the left of code;  `-d0'  lines  up
       comments  with  the  code.   The  `-cdb'  option  controls
       whether the `/*' and `*/' are placed on blank lines.  With
       `-cdb', comments look like this:

                 /*
                  * this is a comment
                  */

       With `-ncdb', comments look like this:

                 /* this is a comment */

       `-cdb'  only  affects  block comments, not comments to the
       right of code.  The default is `-ncdb'.

       Comments which appear on the same line as code are  placed
       to  the  right. The column in which comments on code start
       is controlled by the `-c' option.   The  column  in  which
       comments  to the right of declarations start is controlled
       by the `-cd' option.  By default, they start in  the  same
       column  as  comments to the right of code, which is column
       33.  The column  number  for  comments  to  the  right  of
       `#else' and `#endif' statements is controlled by the `-cp'
       option.  If the code on a line extends  past  the  comment
       column,  the  comment starts further to the right, and the
       right margin may  be  automatically  extended  in  extreme
       cases.

       If  the  `-sc'  option  is specified, `*' is placed at the
       left edge of all comments.  For example:

                 /* This is a comment which extends from one line
                  * onto the next line, thus causing us to consider
                  * how it should continue.  */

       instead of

                 /* This is a comment which extends from one line
                    onto the next line, thus causing us to consider
                    how it should continue.  */


SSTTAATTEEMMEENNTTSS
       The `-br' or `-bl' option specifies how to format  braces.
       The `-br' option formats braces like this:

                 if (x > 0) {
                   x--;
                 }

       The `-bl' option formats them like this:

                 if (x > 0)



                                                                7





INDENT(1L)                                             INDENT(1L)


                   {
                     x--;
                   }

       If  you use the `-bl' option, you may also want to specify
       the `-bli' option.  This option specifies  the  number  of
       spaces   by  which  braces  are  indented.   `-bli2',  the
       default, gives the result shown above.  `-bli0' results in
       the following:

                 if (x > 0)
                 {
                   x--;
                 }

       If  you  are  using the `-br' option, you probably want to
       also use the `-ce' option.  This causes the `else'  in  an
       if-then-else  construct  to  cuddle  up to the immediately
       preceding `}'.  For example, with `-br -ce'  you  get  the
       following:

                 if (x > 0) {
                   x--;
                 } else {
                   fprintf (stderr, "...something wrong?0);
                 }

       With `-br -nce' that code would appear as

                 if (x > 0) {
                   x--;
                 }
                 else {
                   fprintf (stderr, "...something wrong?0);
                 }

       The `-cli' option specifies the number of spaces that case
       labels should be indented to the right of  the  containing
       `switch' statement.

       If  a  semicolon is on the same line as a `for' or `while'
       statement, the `-ss' option  will  cause  a  space  to  be
       placed  before  the  semicolon.  This emphasizes the semi-
       colon, making it clear that  the  body  of  the  `for'  or
       `while'  statement  is an empty statement. `-nss' disables
       this feature.

       The `-pcs' option causes a space to be placed between  the
       name  of the procedure being called and the `(' (for exam-
       ple,  `puts  ("Hi");'.   The  `-npcs'  option  would  give
       `puts("Hi");').

       If  the  `-cs'  option is specified, `indent' puts a space
       after a cast operator.



                                                                8





INDENT(1L)                                             INDENT(1L)


       The `-bs' option ensures that there is a space between the
       keyword `sizeof' and its argument.  In some versions, this
       is known as the `Bill_Shannon' option.

DDEECCLLAARRAATTIIOONNSS
       By default `indent' will line up identifiers, in the  col-
       umn  specified  by the `-di' option.  For example, `-di16'
       makes things look like:

                 int             foo;
                 char           *bar;

       Using a small value (such as one or  two)  for  the  `-di'
       option  can be used to cause the indentifiers to be placed
       in the first available position, for example

                 int foo;
                 char *bar;

       The value given to the  `-di'  option  will  still  affect
       variables  which  are  put  on  separate  lines from their
       types, for example `-di2' will lead to

                 int
                   foo;

       If the `-bc' option is  specified,  a  newline  is  forced
       after each comma in a declaration.  For example,

                 int a,
                   b,
                   c;

       With the `-nbc' option this would look like

                 int a, b, c;

       The  `-psl'  option  causes  the type of a procedure being
       defined to be placed on the line before the  name  of  the
       procedure.  This style is required for the `etags' program
       to work correctly, as well as some of the  `c-mode'  func-
       tions of Emacs.

       If  you are not using the `-di1' option to place variables
       being declared immediately after their type, you  need  to
       use  the  `-T' option to tell `indent' the name of all the
       typenames in your program that are defined  by  `typedef'.
       `-T' can be specified more than once, and all names speci-
       fied are used.  For example, if your program contains

                 typedef unsigned long CODE_ADDR;
                 typedef enum {red, blue, green} COLOR;

       you would use the options `-T CODE_ADDR -T COLOR'.



                                                                9





INDENT(1L)                                             INDENT(1L)


IINNDDEENNTTAATTIIOONN
       One issue in the formatting of code is how far  each  line
       should  be indented from the left margin.  When the begin-
       ning of a statement such as `if' or `for' is  encountered,
       the  indentation level is increased by the value specified
       by the `-i' option.  For example, use `-i8' to specify  an
       eight  character indentation for each level. When a state-
       ment is continued from a previous line, it is indented  by
       a  number  of  additional  spaces  specified  by the `-ci'
       option. `-ci' defaults to 0.  However, if the `-lp' option
       is  specified,  and a line has a left parenthesis which is
       not closed on that line, then continuation lines  will  be
       lined up to start at the character position just after the
       left parenthesis.  This processing also applies to `[' and
       applies  to  `{'  when  it occurs in initialization lists.
       For example, a piece of continued  code  might  look  like
       this with `-nlp -ci3' in effect:

                   p1 = first_procedure (second_procedure (p2, p3),
                      third_procedure (p4, p5));

       With `-lp' in effect the code looks somewhat clearer:

                   p1 = first_procedure (second_procedure (p2, p3),
                                         third_procedure (p4, p5));

       `indent' assumes that tabs are placed at regular intervals
       of both input and output character streams.  These  inter-
       vals  are  by  default  8 columns wide, but (as of version
       1.2) may be changed by the `-ts' option.  Tabs are treated
       as the equivalent number of spaces.

       The indentation of type declarations in old-style function
       definitions is controlled by the `-ip' parameter.  This is
       a  numeric  parameter specifying how many spaces to indent
       type declarations.  For example, the default `-ip5'  makes
       definitions look like this:

                 char *
                 create_world (x, y, scale)
                      int x;
                      int y;
                      float scale;
                 {
                   . . .
                 }

       For  compatibility  with  other  versions  of  indent, the
       option `-nip' is provided, which is equivalent to  `-ip0'.


MMIISSCCEELLLLAANNEEOOUUSS OOPPTTIIOONNSS
       To  find  out  what  version of `indent' you have, use the
       command `indent -version'.  This will report  the  version



                                                               10





INDENT(1L)                                             INDENT(1L)


       number  of  `indent', without doing any of the normal pro-
       cessing.

       The `-v' option can be used to turn on verbose mode.  When
       in  verbose mode, `indent' reports when it splits one line
       of input into two more more lines  of  output,  and  gives
       some size statistics at completion.

CCOOPPYYRRIIGGHHTT
       The  following  copyright  notice  applies to the `indent'
       program. The copyright and copying  permissions  for  this
       manual appear near the beginning of this document.
            Copyright (c) 1989, 1992 Free Software Foundation
            Copyright (c) 1985 Sun Microsystems, Inc.
            Copyright (c) 1980 The Regents of the University of California.
            Copyright (c) 1976 Board of Trustees of the University of Illinois.
            All rights reserved.

            Redistribution and use in source and binary forms are permitted
            provided that the above copyright notice and this paragraph are
            duplicated in all such forms and that any documentation,
            advertising materials, and other materials related to such
            distribution and use acknowledge that the software was developed
            by the University of California, Berkeley, the University of Illinois,
            Urbana, and Sun Microsystems, Inc.  The name of either University
            or Sun Microsystems may not be used to endorse or promote products
            derived from this software without specific prior written permission.
            THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
            IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
            WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
            PURPOSE.

OOPPTTIIOONNSS
       Here  is a list of all the options for `indent', alphabet-
       ized by short option.  It  is  followed  by  a  cross  key
       alphabetized by long option.

       `-bad'
       `--blank-lines-after-declarations'
            Force blank lines after the declarations.

       `-bap'
       `--blank-lines-after-procedures'
            Force blank lines after procedure bodies.

       `-bbb'
       `--blank-lines-after-block-comments'
            Force blank lines after block comments.

       `-bc'
       `--blank-lines-after-commas'
            Force newline after comma in declaration.

       `-bl'



                                                               11





INDENT(1L)                                             INDENT(1L)


       `--braces-after-if-line'
            Put braces on line after `if', etc.

       `-bliN'
       `--brace-indentN'
            Indent braces N spaces.

       `-br'
       `--braces-on-if-line'
            Put braces on line with `if', etc.

       `-cN'
       `--comment-indentationN'
            Put comments to the right of code in column N.

       `-cdN'
       `--declaration-comment-columnN'
            Put comments to the right of the declarations in column N.

       `-cdb'
       `--comment-delimiters-on-blank-lines'
            Put comment delimiters on blank lines.

       `-ce'
       `--cuddle-else'
            Cuddle else and preceeding `}'.

       `-ciN'
       `--continuation-indentationN'
            Continuation indent of N spaces.

       `-cliN'
       `--case-indentationN'
            Case label indent of N spaces.

       `-cpN'
       `--else-endif-columnN'
            Put comments to the right of `#else' and `#endif' statements in
            column N.

       `-cs'
       `--space-after-cast'
            Put a space after a cast operator.

       `-bs'
       `--blank-before-sizeof'
            Put a space between `sizeof' and its argument.

       `-dN'
       `--line-comments-indentationN'
            Set indentation of comments not to the right of code to N spaces.

       `-diN'
       `--declaration-indentationN'



                                                               12





INDENT(1L)                                             INDENT(1L)


            Put variables in column N.

       `-fc1'
       `--format-first-column-comments'
            Format comments in the first column.

       `-fca'
       `--format-all-comments'
            Do not disable all formatting of comments.

       `-gnu'
       `--gnu-style'
            Use GNU coding style.  This is the default.

       `-iN'
       `--indent-levelN'
            Set indentation level to N spaces.

       `-ipN'
       `--parameter-indentationN'
            Indent parameter types in old-style function definitions by N
            spaces.

       `-kr'
       `--k-and-r-style'
            Use Kernighan & Ritchie coding style.

       `-lN'
       `--line-lengthN'
            Set maximum line length to N.

       `-lp'
       `--continue-at-parentheses'
            Line up continued lines at parentheses.

       `-nbad'
       `--no-blank-lines-after-declarations'
            Do not force blank lines after declarations.

       `-nbap'
       `--no-blank-lines-after-procedures'
            Do not force blank lines after procedure bodies.

       `-nbbb'
       `--no-blank-lines-after-block-comments'
            Do not force blank-lines after block comments.

       `-nbc'
       `--no-blank-lines-after-commas'
            Do not force newlines after commas in declarations.

       `-ncdb'
       `--no-comment-delimiters-on-blank-lines'
            Do not put comment delimiters on blank lines.



                                                               13





INDENT(1L)                                             INDENT(1L)


       `-nce'
       `--dont-cuddle-else'
            Do not cuddle `}' and `else'.

       `-ncs'
       `--no-space-after-casts'
            Do not put a space after cast operators.

       `-nfc1'
       `--dont-format-first-column-comments'
            Do not format comments in the first column as normal.

       `-nfca'
       `--dont-format-comments'
            Do not format any comments.

       `-nip'
       `--no-parameter-indentation'
            Zero width indentation for parameters.

       `-nlp'
       `--dont-line-up-parentheses'
            Do not line up parentheses.

       `-npcs'
       `--no-space-after-function-call-names'
            Do not put space after the function in function calls.

       `-npsl'
       `--dont-break-procedure-type'
            Put the type of a procedure on the same line as its name.

       `-nsc'
       `--dont-star-comments'
            Do not put the `*' character at the left of comments.

       `-nsob'
       `--leave-optional-blank-lines'
            Do not swallow optional blank lines.

       `-nss'
       `--dont-space-special-semicolon'
            Do not force a space before the semicolon after certain statements.
            Disables `-ss'.

       `-nv'
       `--no-verbosity'

       `-orig'
       `--original'
            Use the original Berkeley coding style.

       `-npro'
       `--ignore-profile'



                                                               14





INDENT(1L)                                             INDENT(1L)


            Do not read `.indent.pro' files.

       `-pcs'
       `--space-after-procedure-calls'
            Insert a space between the name of the procedure being called and
            the `('.

       `-psl'
       `--procnames-start-lines'
            Put the type of a procedure on the line before its name.

       `-sc'
       `--start-left-side-of-comments'
            Put the `*' character at the left of comments.

       `-sob'
       `--swallow-optional-blank-lines'
            Swallow optional blank lines.

       `-ss'
       `--space-special-semicolon'
            On one-line `for' and `while' statments, force a blank before the
            semicolon.

       `-st'
       `--standard-output'
            Write to standard output.

       `-T'
            Tell `indent' the name of typenames.

       `-tsN'
       `--tab-sizeN'
            Set tab size to N spaces.

       `-v'
       `--verbose'
            Enable verbose mode.

       `-version'
            Output the version number of `indent'.


OOPPTTIIOONNSS CCRROOSSSS--RREEFFEERREENNCCEE
       Here  is a list of options alphabetized by long option, to
       help you find the corresponding short option.

                 --blank-lines-after-block-comments              -bbb
                 --blank-lines-after-commas                      -bc
                 --blank-lines-after-declarations                -bad
                 --blank-lines-after-procedures                  -bap
                 --braces-after-if-line                          -bl
                 --brace-indent                                  -bli
                 --braces-on-if-line                             -br



                                                               15





INDENT(1L)                                             INDENT(1L)


                 --case-indentation                              -cliN
                 --comment-delimiters-on-blank-lines             -cdb
                 --comment-indentation                           -cN
                 --continuation-indentation                      -ciN
                 --continue-at-parentheses                       -lp
                 --cuddle-else                                   -ce
                 --declaration-comment-column                    -cdN
                 --declaration-indentation                       -diN
                 --dont-break-procedure-type                     -npsl
                 --dont-cuddle-else                              -nce
                 --dont-format-comments                          -nfca
                 --dont-format-first-column-comments             -nfc1
                 --dont-line-up-parentheses                      -nlp
                 --dont-space-special-semicolon                  -nss
                 --dont-star-comments                            -nsc
                 --else-endif-column                             -cpN
                 --format-all-comments                           -fca
                 --format-first-column-comments                  -fc1
                 --gnu-style                                     -gnu
                 --ignore-profile                                -npro
                 --indent-level                                  -iN
                 --k-and-r-style                                 -kr
                 --leave-optional-blank-lines                    -nsob
                 --line-comments-indentation                     -dN
                 --line-length                                   -lN
                 --no-blank-lines-after-block-comments           -nbbb
                 --no-blank-lines-after-commas                   -nbc
                 --no-blank-lines-after-declarations             -nbad
                 --no-blank-lines-after-procedures               -nbap
                 --no-comment-delimiters-on-blank-lines          -ncdb
                 --no-space-after-casts                          -ncs
                 --no-parameter-indentation                      -nip
                 --no-space-after-function-call-names            -npcs
                 --no-verbosity                                  -nv
                 --original                                      -orig
                 --parameter-indentation                         -ipN
                 --procnames-start-lines                         -psl
                 --space-after-cast                              -cs
                 --space-after-procedure-calls                   -pcs
                 --space-special-semicolon                       -ss
                 --standard-output                               -st
                 --start-left-side-of-comments                   -sc
                 --swallow-optional-blank-lines                  -sob
                 --tab-size                                      -tsN
                 --verbose                                       -v


RREETTUURRNN VVAALLUUEE
       Unknown

FFIILLEESS
       _$_H_O_M_E_/_._i_n_d_e_n_t_._p_r_o          holds default options for indent.





                                                               16





INDENT(1L)                                             INDENT(1L)


AAUUTTHHOORR
       The Free Software Foundation.

HHIISSTTOORRYY
       Derived from the UCB program "indent".




















































                                                               17


