#if defined(DEFLOCDIR) || defined(DEFGNULOCDIR) || defined(DEFALIASPATH)

#include <stddef.h> // For NULL
#include <stdio.h>
#include <stdlib.h> // For malloc
#include <string.h>

char* strdup(const char* const); // Not in string.h beacause of POSIX

static const char* const _dir_suffix   = "/share/locale";
static const char* const _alias_suffix = ";.";

#ifdef DEFLOCDIR
// LOCALEDIR
char* _locale_dir = NULL;

void getlocaledir() __attribute__ ((constructor));

void
getlocaledir()
{
char* s = NULL;
  if(s = getenv("LOCALEDIR")) _locale_dir = strdup(s);
  else if(s = getenv("DJDIR")) {
    _locale_dir = (char*) malloc(strlen(s) + strlen(_dir_suffix) + 2);
    sprintf(_locale_dir, "%s%s", s, _dir_suffix);
  } else _locale_dir = DEFLOCDIR;
}
#endif

#ifdef DEFGNULOCDIR
// GNULOCALEDIR
char* _gnu_locale_dir = NULL;

void getgnulocaledir() __attribute__ ((constructor));

void
getgnulocaledir()
{
char* s = NULL;
  if(s = getenv("GNULOCALEDIR"))   _gnu_locale_dir = strdup(s);
  else if(s = getenv("LOCALEDIR")) _gnu_locale_dir = strdup(s);
  else if(s = getenv("DJDIR")) {
    _gnu_locale_dir = (char*) malloc(strlen(s) + strlen(_dir_suffix) + 2);
    sprintf(_gnu_locale_dir, "%s%s", s, _dir_suffix);
  } else _gnu_locale_dir = DEFGNULOCDIR;
}
#endif

#ifdef DEFALIASPATH
// LOCALE_ALIAS_PATH
char* _alias_path = NULL;

void getaliaspath() __attribute__ ((constructor));

void
getaliaspath()
{
char *s = NULL, *l = NULL, *gl = NULL, *dj = NULL;
  if(s = getenv("LOCALE_ALIAS_PATH")) _alias_path = strdup(s);
  else if(s = getenv("ALIASPATH"))    _alias_path = strdup(s);
  else {
    gl = getenv("GNULOCALEDIR");
    l  = getenv("LOCALEDIR");
    dj = getenv("DJDIR");

    if(!gl && !l && !dj) _alias_path = DEFALIASPATH;
    else {
      _alias_path = (char*)
	malloc((gl ? (strlen(gl) + 1) : 0) + (l ? (strlen(l) + 1) : 0)
	       + (dj ? (strlen(dj) + strlen(_dir_suffix)) : 0)
	       + (strlen(_alias_suffix)) + 2);
      sprintf(_alias_path, "%s%s%s%s%s%s%s",
	      // GNULOCALEDIR;
	      (gl ? gl : ""), ((gl && (l || dj)) ? ";"         : ""),
	      // GNULOCALEDIR;LOCALEDIR;
	      (l  ? l  : ""), ((l && dj)         ? ";"         : ""),
	      // GNULOCALEDIR;LOCALEDIR;DJDIR/share/locale
	      (dj ? dj : ""), (dj                ? _dir_suffix : ""),
	      // GNULOCALEDIR;LOCALEDIR;DJDIR/share/locale;.
	      _alias_suffix);
    }
  }
}
#endif

#endif
