/* C code produced by gperf version 2.5 (GNU C++ version) */
/* Command-line: gperf -g -o -j1 -t -p -N is_reserved_word  */ 
/* ISO Pascal 7185 && Extended Pascal (Jan 29, 1989 Draft) reserved words.

   Copyright (C) 1989, 1993, Free Software Foundation, Inc.

This file is part of GNU GPC.

GNU GPC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU GPC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GPC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/*
 * For GNU Pascal compiler (GPC) by Jukka Virtanen, jtv@hut.fi
 *
 * run this through the Doug Schmidt's gperf program
 * with command
 * gperf  -g -o -j1 -t -p -N is_reserved_word
 *
 * Thanks, Doug.
 */

/* ISO Pascal 7185 keywords are recognized as keywords.
 *
 * To treat PASCAL_EXTEND type keywords as keywords,
 * you must give -fextended-pascal when compiling.
 *
 * To treat PASCAL_OBJECT keywords as keywords, give
 * -fobject-pascal.
 *
 * To treat PASCAL_BORLAND keywords as keywords, give
 * -fborland-pascal.
 *
 * To treat PASCAL_SC keywords as keywords, give
 * -fpascal-sc
 *
 * Otherwise they are recognized, but may be redfined.
 * This violates Extended Pascal standard, but works anyhow,
 * if your program does not redefine them. And it also makes
 * ISO standard pascal program compile without modifications with GPC.
 *
 */

struct resword { char *name;
		 short token;
		 short iclass;
		 short informed;
                 short disabled;
	       };
;

#define TOTAL_KEYWORDS 71
#define MIN_WORD_LENGTH 2
#define MAX_WORD_LENGTH 14
#define MIN_HASH_VALUE 2
#define MAX_HASH_VALUE 103
/* maximum key range = 102, duplicates = 0 */

#ifdef __GNUC__
inline
#endif
static unsigned int
hash (str, len)
     register char *str;
     register int unsigned len;
{
  static unsigned char asso_values[] =
    {
     104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
     104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
     104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
     104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
     104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
     104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
     104, 104, 104, 104, 104,  28,  38,  47,  29,  43,
      38,  11, 104,   0, 104, 104,  23,  57,  26,  20,
       2,  36,  47,  10,  66,  52,   0,  21,   9, 104,
     104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
       9,   0,  21, 104,   0, 104, 104, 104,  46,  40,
       2,   0, 104, 104,   0,   0,   8, 104,   0,   3,
     104,   0, 104, 104, 104, 104, 104, 104,
    };
  return len + asso_values[str[len - 1]] + asso_values[str[0]];
}

#ifdef __GNUC__
inline
#endif
struct resword *
is_reserved_word (str, len)
     register char *str;
     register unsigned int len;
{
  static struct resword wordlist[] =
    {
      {"",}, {"",}, 
      {"Is", 		OP_IS,		PASCAL_OBJECT,	0, 0},
      {"Var", 		VAR,		PASCAL_ISO,	0, 0},
      {"In", 		IN,		PASCAL_ISO,	0, 0},
      {"Value",   	VALUE,  	PASCAL_EXTEND,	0, 0},
      {"Inline", 		BP_INLINE,	PASCAL_BORLAND, 0, 1},
      {"View", 		OP_VIEW,	PASCAL_OBJECT,	0, 0},
      {"Pow",     	POW,    	PASCAL_EXTEND,	0, 0},
      {"Interface", 	INTERFACE,	PASCAL_BORLAND, 0, 1},
      {"Property", 	OP_PROPERTY, 	PASCAL_OBJECT,	0, 0},
      {"Procedure",  	PROCEDURE, 	PASCAL_ISO,	0, 0},
      {"Xor", 		BP_XOR,		PASCAL_BORLAND, 0, 0},
      {"Shr", 		BP_SHR,		PASCAL_BORLAND, 0, 0},
      {"Import",  	IMPORT, 	PASCAL_EXTEND,	0, 0},
      {"Goto", 		GOTO,		PASCAL_ISO,	0, 0},
      {"Implementation", 	IMPLEMENTATION,	PASCAL_EXTEND,	0, 1},
      {"Packed", 		PACKED,		PASCAL_ISO,	0, 0},
      {"Inherited", 	OP_INHERITED,	PASCAL_EXTEND,	0, 1},
      {"",}, 
      {"Protected",  	PROTECTED, 	PASCAL_EXTEND,	0, 1},
      {"Set", 		SET,		PASCAL_ISO,	0, 0},
      {"Or", 		OR,		PASCAL_ISO,	0, 0},
      {"If", 		IF,		PASCAL_ISO,	0, 0},
      {"Only",    	ONLY,   	PASCAL_EXTEND,	0, 0},
      {"With", 		WITH,		PASCAL_ISO,	0, 0},
      {"While", 		WHILE,		PASCAL_ISO,	0, 0},
      {"Or_else",  	OR_ELSE, 	PASCAL_EXTEND,	0, 0},
      {"Operator", 	PXSC_OPERATOR,	PASCAL_SC,	0, 1},
      {"Otherwise",  	OTHERWISE, 	PASCAL_EXTEND,	0, 0},
      {"Library", 	BP_LIBRARY,	PASCAL_BORLAND, 0, 0},
      {"Do", 		DO,		PASCAL_ISO,	0, 0},
      {"Div", 		DIV,		PASCAL_ISO,	0, 0},
      {"Array", 		ARRAY,		PASCAL_ISO,	0, 0},
      {"Object", 		BP_OBJECT,	PASCAL_BORLAND,	0, 0},
      {"Downto",  	DOWNTO,		PASCAL_ISO,	0, 0},
      {"Absolute", 	BP_ABSOLUTE,	PASCAL_BORLAND,	0, 0},
      {"Not", 		NOT,		PASCAL_ISO,	0, 0},
      {"And_then",  	AND_THEN, 	PASCAL_EXTEND,	0, 0},
      {"Destructor", 	OP_DESTRUCTOR,	PASCAL_OBJECT,	0, 1},
      {"And", 		AND,		PASCAL_ISO,	0, 0},
      {"For", 		FOR,		PASCAL_ISO,	0, 0},
      {"File", 		FILE_,		PASCAL_ISO,	0, 0},
      {"Of", 		OF,		PASCAL_ISO,	0, 0},
      {"Abstract", 	OP_ABSTRACT,	PASCAL_OBJECT,	0, 0},
      {"Begin", 		BEGIN,		PASCAL_ISO,	0, 0},
      {"Bindable",  	BINDABLE,	PASCAL_EXTEND,	0, 0},
      {"Else", 		ELSE,		PASCAL_ISO,	0, 0},
      {"Function",  	FUNCTION, 	PASCAL_ISO,	0, 0},
      {"Program",    	PROGRAM,   	PASCAL_ISO,	0, 0},
      {"Exports",         BP_EXPORTS,     PASCAL_BORLAND, 0, 0},
      {"Case", 		CASE,		PASCAL_ISO,	0, 0},
      {"Class", 		OP_CLASS,	PASCAL_OBJECT,	0, 0},
      {"Virtual", 	BP_VIRTUAL,	PASCAL_BORLAND,	0, 1},
      {"Qualified",  	QUALIFIED, 	PASCAL_EXTEND,	0, 0},
      {"End", 		END,		PASCAL_ISO,	0, 0},
      {"Uses", 		BP_USES,	PASCAL_BORLAND, 0, 0},
      {"Export",  	EXPORT, 	PASCAL_EXTEND,	0, 0},
      {"Constructor", 	OP_CONSTRUCTOR,	PASCAL_OBJECT,	0, 1},
      {"Shl", 		BP_SHL,		PASCAL_BORLAND, 0, 0},
      {"Const", 		CONST,		PASCAL_ISO,	0, 0},
      {"Repeat", 		REPEAT,		PASCAL_ISO,	0, 0},
      {"Record", 		RECORD,		PASCAL_ISO,	0, 0},
      {"Module",  	MODULE, 	PASCAL_EXTEND,	0, 0},
      {"Unit", 		BP_UNIT,	PASCAL_BORLAND, 0, 0},
      {"",}, 
      {"Restricted",    	RESTRICTED,	PASCAL_EXTEND,	0, 0},
      {"",}, 
      {"To", 		TO,		PASCAL_ISO,	0, 0},
      {"Mod", 		MOD,		PASCAL_ISO,	0, 0},
      {"Type", 		TYPE,		PASCAL_ISO,	0, 0},
      {"Asm",             BP_ASM,         PASCAL_BORLAND, 0, 1},
      {"Then", 		THEN,		PASCAL_ISO,	0, 0},
      {"",}, 
      {"Label", 		LABEL,		PASCAL_ISO,	0, 0},
      {"Nil", 		NIL,		PASCAL_ISO,	0, 0},
      {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, 
      {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, 
      {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, 
      
      {"Until", 		UNTIL,		PASCAL_ISO,	0, 0},
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register char *s = wordlist[key].name;

          if (*s == *str && !strcmp (str + 1, s + 1))
            return &wordlist[key];
        }
    }
  return 0;
}
