/* Configuration for GNU C-compiler for Intel 80386 running GO32.
   Copyright (C) 1988, 1996, 1998 Free Software Foundation, Inc.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#define __MSDOS__ 1

#define NO_STAB_H

#include "i386/xm-i386.h"

/* Use semicolons to separate elements of a path.  */
#define PATH_SEPARATOR ';'

/* when building libgcc.a the following defines are needed to ignore
   the definitions in gansidecl.h, because they are defined already
   in the libc headers for DJGPP */
#define HAVE_BCOPY 1
#define HAVE_BZERO 1
#define HAVE_BCMP 1
#define HAVE_RINDEX 1
#define HAVE_INDEX 1


#define EXECUTABLE_SUFFIX ".exe"

/* This is required to make temporary file names unique on file
   systems which severely restrict the length of file names. */
#define MKTEMP_EACH_FILE

#define DIR_SEPARATOR '\\'
#define DIR_SEPARATOR_1 '/'

#define MD_EXEC_PREFIX "$DJDIR/bin/"

#undef CPP_SPEC
#define CPP_SPEC "%{posix:-D_POSIX_SOURCE}"

#undef LIB_SPEC
#define LIB_SPEC "-lc"

#undef STARTFILE_SPEC
#define STARTFILE_SPEC "crtf.o%s %{pg:gcrt0.o%s}%{!pg:crt0.o%s}"

#undef CPP_PREDEFINES
#define CPP_PREDEFINES "-Dunix -Di386 -DGO32 -DMSDOS -DDJGPP=2"

/* We need to override link_command_spec in gcc.c (this also required
   modification of gcc.c as such override were no supported before).
   We need this to add command line option -Tdjgpp.djl. This cannot be done
   in LINK_SPECS as that LINK_SPECS is processed before library search 
   directories are known by linker. This is to avoid problems when specs
   file is not available.
   An alternate way without editting gcc.c is to use SUBTARGET_EXTRA_SPECS
   suggested by Robert Hoehne.
   */ 
#undef LINK_COMMAND_SPEC
#define LINK_COMMAND_SPEC \
"%{!fsyntax-only: \
%{!c:%{!M:%{!MM:%{!E:%{!S:ld %l %X %{o*} %{A} %{d} %{e*} %{m} %{N} %{n} \
\t%{r} %{s} %{t} %{u*} %{x} %{z} %{Z}\
\t%{!A:%{!nostdlib:%{!nostartfiles:%S}}}\
\t%{static:} %{L*} %D %o\
\t%{!nostdlib:%{!nodefaultlibs:%G %L %G}}\
\t%{!A:%{!nostdlib:%{!nostartfiles:%E}}}\
\t-Tdjgpp.djl %{T*}}}}}}}\n\
%{!c:%{!M:%{!MM:%{!E:%{!S:stubify %{v} %{o*:%*} %{!o*:a.out} }}}}}"
