This is Info file g77.info, produced by Makeinfo version 1.67 from the
input file g77.texi.

   This file explains how to use the GNU Fortran system.

   Published by the Free Software Foundation 59 Temple Place - Suite 330
Boston, MA 02111-1307 USA

   Copyright (C) 1995, 1996 Free Software Foundation, Inc.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, provided also
that the sections entitled "GNU General Public License," "Funding for
Free Software," and "Protect Your Freedom--Fight `Look And Feel'" are
included exactly as in the original, and provided that the entire
resulting derived work is distributed under the terms of a permission
notice identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that the sections entitled "GNU General Public
License," "Funding for Free Software," and "Protect Your Freedom--Fight
`Look And Feel'", and this permission notice, may be included in
translations approved by the Free Software Foundation instead of in the
original English.

   Contributed by James Craig Burley (`burley@gnu.ai.mit.edu').
Inspired by a first pass at translating `g77-0.5.16/f/DOC' that was
contributed to Craig by David Ronis (`ronis@onsager.chem.mcgill.ca').


File: g77.info,  Node: News,  Next: Changes,  Prev: Invoking G77,  Up: Top

News About GNU Fortran
**********************

In 0.5.19:
==========

   * Fix `FORMAT' statement parsing so negative values for specifiers
     such as `P' (e.g. `FORMAT(-1PF8.1)') are correctly processed as
     negative.

   * Fix `SIGNAL' intrinsic so it once again accepts a procedure as its
     second argument.

   * A temporary kludge option provides bare-bones information on
     `COMMON' and `EQUIVALENCE' members at debug time.

   * New `-fonetrip' option specifies FORTRAN-66-style one-trip `DO'
     loops.

   * New `-fno-silent' option causes names of program units to be
     printed as they are compiled, in a fashion similar to UNIX `f77'
     and `f2c'.

   * New `-fugly-assumed' option specifies that arrays dimensioned via
     `DIMENSION X(1)', for example, are to be treated as assumed-size.

   * New `-fno-typeless-boz' option specifies that non-decimal-radix
     constants using the prefixed-radix form (such as `Z'1234'') are to
     be interpreted as `INTEGER' constants.

   * New `-ff66' option is a "shorthand" option that specifies
     behaviors considered appropriate for FORTRAN 66 programs.

   * New `-ff77' option is a "shorthand" option that specifies
     behaviors considered appropriate for UNIX `f77' programs.

   * New `-fugly-comma' and `-fugly-logint' options provided to perform
     some of what `-fugly' used to do.  `-fugly' and `-fno-ugly' are
     now "shorthand" options, in that they do nothing more than enable
     (or disable) other `-fugly-*' options.

   * Fix parsing of assignment statements involving targets that are
     substrings of elements of `CHARACTER' arrays having names such as
     `READ', `WRITE', `GOTO', and `REALFUNCTIONFOO'.

   * Fix crashes involving diagnosed code.

   * Fix handling of local `EQUIVALENCE' areas so certain cases of
     valid Fortran programs are not misdiagnosed as improperly
     extending the area backwards.

   * Support `gcc' version 2.7.2.1.

   * Upgrade to `libf2c' as of 1996-09-26, and fix up some of the build
     procedures.

   * Change code generation for list-directed I/O so it allows for new
     versions of `libf2c' that might return non-zero status codes for
     some operations previously assumed to always return zero.

     This change not only affects how `IOSTAT=' variables are set by
     list-directed I/O, it also affects whether `END=' and `ERR='
     labels are reached by these operations.

   * Add intrinsic support for new `FTELL' and `FSEEK' procedures in
     `libf2c'.

   * Modify `fseek_()' in `libf2c' to be more portable (though, in
     practice, there might be no systems where this matters) and to
     catch invalid `whence' arguments.

   * Some useless warnings from the `-Wunused' option have been
     eliminated.

   * Fix a problem building the `f771' executable on AIX systems by
     linking with the `-bbigtoc' option.

   * Abort configuration if `gcc' has not been patched using the patch
     file provided in the `gcc/f/gbe/' subdirectory.

   * Add options `--help' and `--version' to the `g77' command, to
     conform to GNU coding guidelines.  Also add printing of `g77'
     version number when the `--verbose' (`-v') option is used.

   * Change internally generated name for local `EQUIVALENCE' areas to
     one based on the alphabetically sorted first name in the list of
     names for entities placed at the beginning of the areas.

   * Improvements to documentation and indexing.

In 0.5.18:
==========

   * Add some rudimentary support for `INTEGER*1', `INTEGER*2',
     `INTEGER*8', and their `LOGICAL' equivalents.  (This support works
     on most, maybe all, `gcc' targets.)

     Thanks to Scott Snyder (`snyder@d0sgif.fnal.gov') for providing
     the patch for this!

     Among the missing elements from the support for these features are
     full intrinsic support and constants.

   * Add some rudimentary support for the `BYTE' and `WORD'
     type-declaration statements.  `BYTE' corresponds to `INTEGER*1',
     while `WORD' corresponds to `INTEGER*2'.

     Thanks to Scott Snyder (`snyder@d0sgif.fnal.gov') for providing
     the patch for this!

   * The compiler code handling intrinsics has been largely rewritten
     to accommodate the new types.  No new intrinsics or arguments for
     existing intrinsics have been added, so there is, at this point,
     no intrinsic to convert to `INTEGER*8', for example.

   * Support automatic arrays in procedures.

   * Reduce space/time requirements for handling large *sparsely*
     initialized aggregate arrays.  This improvement applies to only a
     subset of the general problem to be addressed in 0.6.

   * Treat initial values of zero as if they weren't specified (in DATA
     and type-declaration statements).  The initial values will be set
     to zero anyway, but the amount of compile time processing them
     will be reduced, in some cases significantly (though, again, this
     is only a subset of the general problem to be addressed in 0.6).

     A new option, `-fzeros', is introduced to enable the traditional
     treatment of zeros as any other value.

   * With `-ff90' in force, `g77' incorrectly interpreted `REAL(Z)' as
     returning a `REAL' result, instead of as a `DOUBLE PRECISION'
     result.  (Here, `Z' is `DOUBLE COMPLEX'.)

     With `-fno-f90' in force, the interpretation remains unchanged,
     since this appears to be how at least some F77 code using the
     `DOUBLE COMPLEX' extension expected it to work.

     Essentially, `REAL(Z)' in F90 is the same as `DBLE(Z)', while in
     extended F77, it appears to be the same as `REAL(REAL(Z))'.

   * An expression involving exponentiation, where both operands were
     type `INTEGER' and the right-hand operand was negative, was
     erroneously evaluated.

   * Fix bugs involving `DATA' implied-`DO' constructs (these involved
     an errant diagnostic and a crash, both on good code, one involving
     subsequent statement-function definition).

   * Close `INCLUDE' files after processing them, so compiling source
     files with lots of `INCLUDE' statements does not result in being
     unable to open `INCLUDE' files after all the available file
     descriptors are used up.

   * Speed up compiling, especially of larger programs, and perhaps
     slightly reduce memory utilization while compiling (this is *not*
     the improvement planned for 0.6 involving large aggregate
     areas)--these improvements result from simply turning off some
     low-level code to do self-checking that hasn't been triggered in a
     long time.

   * Introduce three new options that implement optimizations in the
     `gcc' back end (GBE).  These options are `-fmove-all-movables',
     `-freduce-all-givs', and `-frerun-loop-opt', which are enabled, by
     default, for Fortran compilations.  These optimizations are
     intended to help toon Fortran programs.

   * Patch the GBE to do a better job optimizing certain kinds of
     references to array elements.

   * Due to patches to the GBE, the version number of `gcc' also is
     patched to make it easier to manage installations, especially
     useful if it turns out a `g77' change to the GBE has a bug.

     The `g77'-modified version number is the `gcc' version number with
     the string `.f.N' appended, where `f' identifies the version as
     enhanced for Fortran, and N is `1' for the first Fortran patch for
     that version of `gcc', `2' for the second, and so on.

     So, this introduces version `2.7.2.f.1' of `gcc'.

   * Make several improvements and fixes to diagnostics, including the
     removal of two that were inappropriate or inadequate.

   * Warning about two successive arithmetic operators, produced by
     `-Wsurprising', now produced *only* when both operators are,
     indeed, arithmetic (not relational/boolean).

   * `-Wsurprising' now warns about the remaining cases of using
     non-integral variables for implied-`DO' loops, instead of these
     being rejected unless `-fpedantic' or `-fugly' specified.

   * Allow `SAVE' of a local variable or array, even after it has been
     given an initial value via `DATA', for example.

   * Introduce an Info version of `g77' documentation, which supercedes
     `gcc/f/CREDITS', `gcc/f/DOC', and `gcc/f/PROJECTS'.  These files
     will be removed in a future release.  The files `gcc/f/BUGS',
     `gcc/f/INSTALL', and `gcc/f/NEWS' now are automatically built from
     the texinfo source when distributions are made.

     This effort was inspired by a first pass at translating
     `g77-0.5.16/f/DOC' that was contributed to Craig by David Ronis
     (`ronis@onsager.chem.mcgill.ca').

   * New `-fno-second-underscore' option to specify that, when
     `-funderscoring' is in effect, a second underscore is not to be
     appended to Fortran names already containing an underscore.

   * Change the way iterative `DO' loops work to follow the F90
     standard.  In particular, calculation of the iteration count is
     still done by converting the start, end, and increment parameters
     to the type of the `DO' variable, but the result of the
     calculation is always converted to the default `INTEGER' type.

     (This should have no effect on existing code compiled by `g77',
     but code written to assume that use of a *wider* type for the `DO'
     variable will result in an iteration count being fully calculated
     using that wider type (wider than default `INTEGER') must be
     rewritten.)

   * Support `gcc' version 2.7.2.

   * Upgrade to `libf2c' as of 1996-03-23, and fix up some of the build
     procedures.

     Note that the email addresses related to `f2c' have changed--the
     distribution site now is named `netlib.bell-labs.com', and the
     maintainer's new address is `dmg@bell-labs.com'.

In 0.5.17:
==========

   * *Fix serious bug* in `g77 -v' command that can cause removal of a
     system's `/dev/null' special file if run by user `root'.

     *All users* of version 0.5.16 should ensure that they have not
     removed `/dev/null' or replaced it with an ordinary file (e.g. by
     comparing the output of `ls -l /dev/null' with `ls -l /dev/zero'.
     If the output isn't basically the same, contact your system
     administrator about restoring `/dev/null' to its proper status).

     This bug is particularly insidious because removing `/dev/null' as
     a special file can go undetected for quite a while, aside from
     various applications and programs exhibiting sudden, strange
     behaviors.

     I sincerely apologize for not realizing the implications of the
     fact that when `g77 -v' runs the `ld' command with `-o /dev/null'
     that `ld' tries to *remove* the executable it is supposed to build
     (especially if it reports unresolved references, which it should
     in this case)!

   * Fix crash on `CHARACTER*(*) FOO' in a main or block data program
     unit.

   * Fix crash that can occur when diagnostics given outside of any
     program unit (such as when input file contains `@foo').

   * Fix crashes, infinite loops (hangs), and such involving diagnosed
     code.

   * Fix `ASSIGN''ed variables so they can be `SAVE''d or dummy
     arguments, and issue clearer error message in cases where target
     of `ASSIGN' or `ASSIGN'ed `GOTO'/`FORMAT' is too small (which
     should never happen).

   * Make `libf2c' build procedures work on more systems again by
     eliminating unnecessary invocations of `ld -r -x' and `mv'.

   * Fix omission of `-funix-intrinsics-...' options in list of
     permitted options to compiler.

   * Fix failure to always diagnose missing type declaration for
     `IMPLICIT NONE'.

   * Fix compile-time performance problem (which could sometimes crash
     the compiler, cause a hang, or whatever, due to a bug in the back
     end) involving exponentiation with a large `INTEGER' constant for
     the right-hand operator (e.g. `I**32767').

   * Fix build procedures so cross-compiling `g77' (the `fini' utility
     in particular) is properly built using the host compiler.

   * Add new `-Wsurprising' option to warn about constructs that are
     interpreted by the Fortran standard (and `g77') in ways that are
     surprising to many programmers.

   * Add `ERF()' and `ERFC()' as generic intrinsics mapping to existing
     `ERF'/`DERF' and `ERFC'/`DERFC' specific intrinsics.

     *Note:* You should specify `INTRINSIC ERF,ERFC' in any code where
     you might use these as generic intrinsics, to improve likelihood
     of diagnostics (instead of subtle run-time bugs) when using a
     compiler that doesn't support these as intrinsics (e.g. `f2c').

   * Remove from `-fno-pedantic' the diagnostic about `DO' with
     non-`INTEGER' index variable; issue that under `-Wsurprising'
     instead.

   * Clarify some diagnostics that say things like "ignored" when that's
     misleading.

   * Clarify diagnostic on use of `.EQ.'/`.NE.' on `LOGICAL' operands.

   * Minor improvements to code generation for various operations on
     `LOGICAL' operands.

   * Minor improvement to code generation for some `DO' loops on some
     machines.

   * Support `gcc' version 2.7.1.

   * Upgrade to `libf2c' as of 1995-11-15.

In 0.5.16:
==========

   * Fix a code-generation bug involving complicated `EQUIVALENCE'
     statements not involving `COMMON'.

   * Fix code-generation bugs involving invoking "gratis" library
     procedures in `libf2c' from code compiled with `-fno-f2c' by
     making these procedures known to `g77' as intrinsics (not affected
     by -fno-f2c).  This is known to fix code invoking `ERF()',
     `ERFC()', `DERF()', and `DERFC()'.

   * Update `libf2c' to include netlib patches through 1995-08-16, and
     `#define' `WANT_LEAD_0' to 1 to make `g77'-compiled code more
     consistent with other Fortran implementations by outputting
     leading zeros in formatted and list-directed output.

   * Fix a code-generation bug involving adjustable dummy arrays with
     high bounds whose primaries are changed during procedure
     execution, and which might well improve code-generation
     performance for such arrays compared to `f2c' plus `gcc' (but
     apparently only when using `gcc-2.7.0' or later).

   * Fix a code-generation bug involving invocation of `COMPLEX' and
     `DOUBLE COMPLEX' `FUNCTION's and doing `COMPLEX' and `DOUBLE
     COMPLEX' divides, when the result of the invocation or divide is
     assigned directly to a variable that overlaps one or more of the
     arguments to the invocation or divide.

   * Fix crash by not generating new optimal code for `X**I' if `I' is
     nonconstant and the expression is used to dimension a dummy array,
     since the `gcc' back end does not support the necessary mechanics
     (and the `gcc' front end rejects the equivalent construct, as it
     turns out).

   * Fix crash on expressions like `COMPLEX**INTEGER'.

   * Fix crash on expressions like `(1D0,2D0)**2', i.e. raising a
     `DOUBLE COMPLEX' constant to an `INTEGER' constant power.

   * Fix crashes and such involving diagnosed code.

   * Diagnose, instead of crashing on, statement function definitions
     having duplicate dummy argument names.

   * Fix bug causing rejection of good code involving statement function
     definitions.

   * Fix bug resulting in debugger not knowing size of local equivalence
     area when any member of area has initial value (via `DATA', for
     example).

   * Fix installation bug that prevented installation of `g77' driver.
     Provide for easy selection of whether to install copy of `g77' as
     `f77' to replace the broken code.

   * Fix `gcc' driver (affects `g77' thereby) to not gratuitously
     invoke the `f771' program (e.g. when `-E' is specified).

   * Fix diagnostic to point to correct source line when it immediately
     follows an `INCLUDE' statement.

   * Support more compiler options in `gcc'/`g77' when compiling
     Fortran files.  These options include `-p', `-pg', `-aux-info',
     `-P', correct setting of version-number macros for preprocessing,
     full recognition of `-O0', and automatic insertion of
     configuration-specific linker specs.

   * Add new intrinsics that interface to existing routines in `libf2c':
     `ABORT', `DERF', `DERFC', `ERF', `ERFC', `EXIT', `FLUSH',
     `GETARG', `GETENV', `IARGC', `SIGNAL', and `SYSTEM'.  Note that
     `ABORT', `EXIT', `FLUSH', `SIGNAL', and `SYSTEM' are intrinsic
     subroutines, not functions (since they have side effects), so to
     get the return values from `SIGNAL' and `SYSTEM', append a final
     argument specifying an `INTEGER' variable or array element (e.g.
     `CALL SYSTEM('rm foo',ISTAT)').

   * Add new intrinsic group named `unix' to contain the new intrinsics,
     and by default enable this new group.

   * Move `LOC()' intrinsic out of the `vxt' group to the new `unix'
     group.

   * Improve `g77' so that `g77 -v' by itself (or with certain other
     options, including `-B', `-b', `-i', `-nostdlib', and `-V')
     reports lots more useful version info, and so that long-form
     options `gcc' accepts are understood by `g77' as well (even in
     truncated, unambiguous forms).

   * Add new `g77' option `--driver=name' to specify driver when
     default, `gcc', isn't appropriate.

   * Add support for `#' directives (as output by the preprocessor) in
     the compiler, and enable generation of those directives by the
     preprocessor (when compiling `.F' files) so diagnostics and
     debugging info are more useful to users of the preprocessor.

   * Produce better diagnostics, more like `gcc', with info such as `In
     function `foo':' and `In file included from...:'.

   * Support `gcc''s `-fident' and `-fno-ident' options.

   * When `-Wunused' in effect, don't warn about local variables used as
     statement-function dummy arguments or `DATA' implied-`DO' iteration
     variables, even though, strictly speaking, these are not uses of
     the variables themselves.

   * When `-W -Wunused' in effect, don't warn about unused dummy
     arguments at all, since there's no way to turn this off for
     individual cases (`g77' might someday start warning about
     these)--applies to `gcc' versions 2.7.0 and later, since earlier
     versions didn't warn about unused dummy arguments.

   * New option `-fno-underscoring' that inhibits transformation of
     names (by appending one or two underscores) so users may experiment
     with implications of such an environment.

   * Minor improvement to `gcc/f/info' module to make it easier to build
     `g77' using the native (non-`gcc') compiler on certain machines
     (but definitely not all machines nor all non-`gcc' compilers).
     Please do not report bugs showing problems compilers have with
     macros defined in `gcc/f/target.h' and used in places like
     `gcc/f/expr.c'.

   * Add warning to be printed for each invocation of the compiler if
     the target machine `INTEGER', REAL, or `LOGICAL' size is not 32
     bits, since `g77' is known to not work well for such cases (to be
     fixed in Version 0.6--*note Actual Bugs We Haven't Fixed Yet:
     Actual Bugs.).

   * Lots of new documentation (though work is still needed to put it
     into canonical GNU format).

   * Build `libf2c' with `-g0', not `-g2', in effect (by default), to
     produce smaller library without lots of debugging clutter.

In 0.5.15:
==========

   * Fix bad code generation involving `X**I' and temporary, internal
     variables generated by `g77' and the back end (such as for `DO'
     loops).

   * Fix crash given `CHARACTER A;DATA A/.TRUE./'.

   * Replace crash with diagnostic given `CHARACTER A;DATA A/1.0/'.

   * Fix crash or other erratic behavior when null character constant
     (`''') is encountered.

   * Fix crash or other erratic behavior involving diagnosed code.

   * Fix code generation for external functions returning type `REAL'
     when the `-ff2c' option is in force (which it is by default) so
     that `f2c' compatibility is indeed provided.

   * Disallow `COMMON I(10)' if `I' has previously been specified with
     an array declarator.

   * New `-ffixed-line-length-N' option, where N is the maximum length
     of a typical fixed-form line, defaulting to 72 columns, such that
     characters beyond column N are ignored, or N is `none', meaning no
     characters are ignored.  does not affect lines with `&' in column
     1, which are always processed as if `-ffixed-line-length-none' was
     in effect.

   * No longer generate better code for some kinds of array references,
     as `gcc' back end is to be fixed to do this even better, and it
     turned out to slow down some code in some cases after all.

   * In `COMMON' and `EQUIVALENCE' areas with any members given initial
     values (e.g. via `DATA'), uninitialized members now always
     initialized to binary zeros (though this is not required by the
     standard, and might not be done in future versions of `g77').
     Previously, in some `COMMON'/`EQUIVALENCE' areas (essentially
     those with members of more than one type), the uninitialized
     members were initialized to spaces, to cater to `CHARACTER' types,
     but it seems no existing code expects that, while much existing
     code expects binary zeros.

In 0.5.14:
==========

   * Don't emit bad code when low bound of adjustable array is
     nonconstant and thus might vary as an expression at run time.

   * Emit correct code for calculation of number of trips in `DO' loops
     for cases where the loop should not execute at all.  (This bug
     affected cases where the difference between the begin and end
     values was less than the step count, though probably not for
     floating-point cases.)

   * Fix crash when extra parentheses surround item in `DATA'
     implied-`DO' list.

   * Fix crash over minor internal inconsistencies in handling
     diagnostics, just substitute dummy strings where necessary.

   * Fix crash on some systems when compiling call to `MVBITS()'
     intrinsic.

   * Fix crash on array assignment `TYPEDDD(...)=...', where DDD is a
     string of one or more digits.

   * Fix crash on `DCMPLX()' with a single `INTEGER' argument.

   * Fix various crashes involving code with diagnosed errors.

   * Support `-I' option for `INCLUDE' statement, plus `gcc''s
     `header.gcc' facility for handling systems like MS-DOS.

   * Allow `INCLUDE' statement to be continued across multiple lines,
     even allow it to coexist with other statements on the same line.

   * Incorporate Bellcore fixes to `libf2c' through 1995-03-15--this
     fixes a bug involving infinite loops reading EOF with empty
     list-directed I/O list.

   * Remove all the `g77'-specific auto-configuration scripts, code,
     and so on, except for temporary substitutes for bsearch() and
     strtoul(), as too many configure/build problems were reported in
     these areas.  People will have to fix their systems' problems
     themselves, or at least somewhere other than `g77', which expects
     a working ANSI C environment (and, for now, a GNU C compiler to
     compile `g77' itself).

   * Complain if initialized common redeclared as larger in subsequent
     program unit.

   * Warn if blank common initialized, since its size can vary and hence
     related warnings that might be helpful won't be seen.

   * New `-fbackslash' option, on by default, that causes `\' within
     `CHARACTER' and Hollerith constants to be interpreted a la GNU C.
     Note that this behavior is somewhat different from `f2c''s, which
     supports only a limited subset of backslash (escape) sequences.

   * Make `-fugly-args' the default.

   * New `-fugly-init' option, on by default, that allows
     typeless/Hollerith to be specified as initial values for variables
     or named constants (`PARAMETER'), and also allows
     character<->numeric conversion in those contexts--turn off via
     `-fno-ugly-init'.

   * New `-finit-local-zero' option to initialize local variables to
     binary zeros.  This does not affect whether they are `SAVE'd, i.e.
     made automatic or static.

   * New `-Wimplicit' option to warn about implicitly typed variables,
     arrays, and functions.  (Basically causes all program units to
     default to `IMPLICIT NONE'.)

   * `-Wall' now implies `-Wuninitialized' as with `gcc' (i.e. unless
     `-O' not specified, since `-Wuninitialized' requires `-O'), and
     implies `-Wunused' as well.

   * `-Wunused' no longer gives spurious messages for unused `EXTERNAL'
     names (since they are assumed to refer to block data program
     units, to make use of libraries more reliable).

   * Support `%LOC()' and `LOC()' of character arguments.

   * Support null (zero-length) character constants and expressions.

   * Support `f2c''s `IMAG()' generic intrinsic.

   * Support `ICHAR()', `IACHAR()', and `LEN()' of character
     expressions that are valid in assignments but not normally as
     actual arguments.

   * Support `f2c'-style `&' in column 1 to mean continuation line.

   * Allow `NAMELIST', `EXTERNAL', `INTRINSIC', and `VOLATILE' in
     `BLOCK DATA', even though these are not allowed by the standard.

   * Allow `RETURN' in main program unit.

   * Changes to Hollerith-constant support to obey Appendix C of the
     standard:

        - Now padded on the right with zeros, not spaces.

        - Hollerith "format specifications" in the form of arrays of
          non-character allowed.

        - Warnings issued when non-blank truncation occurs when
          converting to another type.

        - When specified as actual argument, now passed by reference to
          `INTEGER' (padded on right with spaces if constant too small,
          otherwise fully intact if constant wider the `INTEGER' type)
          instead of by value.

     *Warning:* `f2c' differs on the interpretation of `CALL FOO(1HX)',
     which it treats exactly the same as `CALL FOO('X')', but which the
     standard and `g77' treat as `CALL FOO(%REF('X   '))' (padded with
     as many blanks as necessary to widen to `INTEGER'), essentially.

   * Changes and fixes to typeless-constant support:

        - Now treated as a typeless double-length `INTEGER' value.

        - Warnings issued when overflow occurs.

        - Padded on the left with zeros when converting to a larger
          type.

        - Should be properly aligned and ordered on the target machine
          for whatever type it is turned into.

        - When specified as actual argument, now passed as reference to
          a default `INTEGER' constant.

   * `%DESCR()' of a non-`CHARACTER' expression now passes a pointer to
     the expression plus a length for the expression just as if it were
     a `CHARACTER' expression.  For example, `CALL FOO(%DESCR(D))',
     where `D' is `REAL*8', is the same as `CALL FOO(D,%VAL(8)))'.

   * Name of multi-entrypoint master function changed to incorporate
     the name of the primary entry point instead of a decimal value, so
     the name of the master function for `SUBROUTINE X' with alternate
     entry points is now `__g77_masterfun_x'.

   * Remove redundant message about zero-step-count `DO' loops.

   * Clean up diagnostic messages, shortening many of them.

   * Fix typo in `g77' man page.

   * Clarify implications of constant-handling bugs in `f/BUGS'.

   * Generate better code for `**' operator with a right-hand operand of
     type `INTEGER'.

   * Generate better code for `SQRT()' and `DSQRT()', also when
     `-ffast-math' specified, enable better code generation for `SIN()'
     and `COS()'.

   * Generate better code for some kinds of array references.

   * Speed up lexing somewhat (this makes the compilation phase
     noticably faster).


File: g77.info,  Node: Changes,  Next: Language,  Prev: News,  Up: Top

User-visible Changes
********************

   To find out about existing bugs and ongoing plans for GNU Fortran,
on Internet do `finger -l fortran@gnu.ai.mit.edu' or whatever is the
equivalent on your system.  (You might need to use the address
`fortran@gate-1.gnu.ai.mit.edu' instead, or use `gate-2', `gate-3',
`gate-4', and so on, instead of `gate-1'.)

   Alternatively, retrieve `ftp://gnu.ai.mit.edu/g77.plan' via
anonymous ftp, or if you cannot do that, email `fortran@gnu.ai.mit.edu'
asking for a recent copy of the GNU Fortran `.plan' file.  (The
`finger' command shown above obtains the most recent copy of all these
methods.)

In 0.5.19:
==========

   * A temporary kludge option provides bare-bones information on
     `COMMON' and `EQUIVALENCE' members at debug time.  *Note Options
     for Code Generation Conventions: Code Gen Options, for information
     on the `-fdebug-kludge' option.

   * New `-fonetrip' option specifies FORTRAN-66-style one-trip `DO'
     loops.

   * New `-fno-silent' option causes names of program units to be
     printed as they are compiled, in a fashion similar to UNIX `f77'
     and `f2c'.

   * New `-fugly-assumed' option specifies that arrays dimensioned via
     `DIMENSION X(1)', for example, are to be treated as assumed-size.

   * New `-fno-typeless-boz' option specifies that non-decimal-radix
     constants using the prefixed-radix form (such as `Z'1234'') are to
     be interpreted as `INTEGER' constants.

   * New `-ff66' option is a "shorthand" option that specifies
     behaviors considered appropriate for FORTRAN 66 programs.

   * New `-ff77' option is a "shorthand" option that specifies
     behaviors considered appropriate for UNIX `f77' programs.

   * New `-fugly-comma' and `-fugly-logint' options provided to perform
     some of what `-fugly' used to do.  `-fugly' and `-fno-ugly' are
     now "shorthand" options, in that they do nothing more than enable
     (or disable) other `-fugly-*' options.

   * Change code generation for list-directed I/O so it allows for new
     versions of `libf2c' that might return non-zero status codes for
     some operations previously assumed to always return zero.

     This change not only affects how `IOSTAT=' variables are set by
     list-directed I/O, it also affects whether `END=' and `ERR='
     labels are reached by these operations.

   * Add intrinsic support for new `FTELL' and `FSEEK' procedures in
     `libf2c'.

   * Add options `--help' and `--version' to the `g77' command, to
     conform to GNU coding guidelines.  Also add printing of `g77'
     version number when the `--verbose' (`-v') option is used.

In 0.5.18:
==========

   * The `BYTE' and `WORD' statements now are supported, to a limited
     extent.

   * `INTEGER*1', `INTEGER*2', `INTEGER*8', and their `LOGICAL'
     equivalents, now are supported to a limited extent.  Among the
     missing elements are complete intrinsic and constant support.

   * Support automatic arrays in procedures.  For example, `REAL A(N)',
     where `A' is not a dummy argument, specifies that `A' is an
     automatic array.  The size of `A' is calculated from the value of
     `N' each time the procedure is called, that amount of space is
     allocated, and that space is freed when the procedure returns to
     its caller.

   * Add `-fno-zeros' option, enabled by default, to reduce
     compile-time CPU and memory usage for code that provides initial
     zero values for variables and arrays.

   * Introduce three new options that apply to all compilations by
     `g77'-aware GNU compilers--`-fmove-all-movables',
     `-freduce-all-givs', and `-frerun-loop-opt'--which can improve the
     run-time performance of some programs.

   * Replace much of the existing documentation with a single Info
     document.

   * New option `-fno-second-underscore'.

In 0.5.17:
==========

   * The `ERF()' and `ERFC()' intrinsics now are generic intrinsics,
     mapping to `ERF'/`DERF' and `ERFC'/`DERFC', respectively.  *Note:*
     Use `INTRINSIC ERF,ERFC' in any code that might reference these as
     generic intrinsics, to improve the likelihood of diagnostics
     (instead of subtle run-time bugs) when using compilers that don't
     support these as intrinsics.

   * New option `-Wsurprising'.

   * DO loops with non-`INTEGER' variables now diagnosed only when
     `-Wsurprising' specified.  Previously, this was diagnosed *unless*
     `-fpedantic' or `-fugly' was specified.

In 0.5.16:
==========

   * `libf2c' changed to output a leading zero (0) digit for
     floating-point values output via list-directed and formatted
     output (to bring `g77' more in line with many existing Fortran
     implementations--the ANSI FORTRAN 77 standard leaves this choice
     to the implementation).

   * `libf2c' no longer built with debugging information intact, making
     it much smaller.

   * Automatic installation of the `g77' command now works.

   * Diagnostic messages now more informative, a la `gcc', including
     messages like `In function `foo':' and `In file included from...:'.

   * New group of intrinsics called `unix', including `ABORT', `DERF',
     `DERFC', `ERF', `ERFC', `EXIT', `FLUSH', `GETARG', `GETENV',
     `SIGNAL', and `SYSTEM'.

   * `-funix-intrinsics-{delete,hide,disable,enable}' options added.

   * `-fno-underscoring' option added.

   * `--driver' option added to the `g77' command.

   * Support for the `gcc' options `-fident' and `-fno-ident' added.

   * `g77 -v' returns much more version info, making the submission of
     better bug reports easily.

   * Many improvements to the `g77' command to better fulfill its role
     as a front-end to the `gcc' driver.  For example, `g77' now
     recognizes `--verbose' as a verbose way of specifying `-v'.

   * Compiling preprocessed (`*.F' and `*.fpp') files now results in
     better diagnostics and debugging information, as the
     source-location info now is passed all the way through the
     compilation process instead of being lost.

In 0.5.15:
==========

   * `-ffixed-line-length-N' option introduced.

In 0.5.14:
==========

   * Support for gcc's `-I' option added.

   * `-fbackslash' option added.

   * `-fugly-args' option enabled by default (allows `CALL
     FOO(4HABCD)').

   * `-fugly-init' option added.

   * `-finit-local-zero' option added.

   * Support for the `gcc' option `-Wimplicit' added.

   * `-Wall' now implies `-Wunused' and, when `-O' is specified,
     `-Wuninitialized'.

   * Hollerith constants as actual arguments now are passed by reference
     instead of by value--so `CALL FOO(4HABCD)' now is compiled exactly
     the same as `CALL FOO(%REF('ABCD'))', instead of as `CALL
     FOO(%VAL('ABCD'))'.

   * Hollerith constants converted to larger types now are padded on the
     right with spaces.  When converted to smaller types, warnings are
     issued if non-spaces are truncated on the right.

   * Format specifications of arrays of types other than `CHARACTER' are
     allowed in I/O statements, such as when they contain Hollerith
     data.

   * Typeless constants as actual arguments now are passed by reference
     to an `INTEGER' version of the constant instead of by value.

   * Typeless constants converted to larger types are padded on the left
     with zeros.  When converted to smaller types, warnings are issued
     if non-zero bits are truncated on the left.

   * `%DESCR()' of a non-`CHARACTER' expression treats the expression
     as if it were `CHARACTER', passing both a pointer to the expression
     and the length of the type of the expression in bytes, by value,
     in the "hidden" list of lengths used for `CHARACTER' arguments.

   * The `ICHAR()', `IACHAR()', and `LEN()' intrinsics now accept
     character expressions involving concatenation of assumed-length
     dummy arguments.

   * Block data program units now may contain `NAMELIST', `EXTERNAL',
     and `INTRINSIC' statements.

   * Zero-length character expressions now supported.

   * Support for the `f2c' intrinsic `IMAG()' added.

   * `INCLUDE' statement restrictions, such as no continuation lines
     allowed, now lifted.


File: g77.info,  Node: Language,  Next: Installation,  Prev: Changes,  Up: Top

The GNU Fortran Language
************************

   GNU Fortran supports a variety of extensions to, and dialects of,
the Fortran language.  Its primary base is the ANSI FORTRAN 77
standard, currently available on the network at
`http://kumo.swcp.com/fortran/F77_std/f77_std.html' or in
`ftp://ftp.ast.cam.ac.uk/pub/michael/'.  It offers some extensions that
are popular among users of UNIX `f77' and `f2c' compilers, some that
are popular among users of other compilers (such as Digital products),
some that are popular among users of the newer Fortran 90 standard, and
some that are introduced by GNU Fortran.

   Part of what defines a particular implementation of a Fortran
system, such as `g77', is the particular characteristics of how it
supports types, constants, and so on.  Much of this is left up to the
implementation by the various Fortran standards and accepted practice
in the industry.

* Menu:

* Standard Support:: Degree of support for the ANSI FORTRAN 77 standard.
* Extensions::       Extensions to GNU Fortran.
* Types::            Data types.
* Constants::        Constants and their types.
* Source Form::      Form of source files (fixed, free, and so on).
* Pedantic Compilation::  Warnings about non-standard constructs.
* Case Sensitivity:: Uppercase and lowercase in source files.
* Intrinsics::       How intrinsics are grouped for easy management.
* Dialects::         Dialects supported by GNU Fortran.
* Object Compatibility::  Compatibility issues for code generated by `g77'.
* Distensions::      Misfeatures supported by GNU Fortran.


File: g77.info,  Node: Standard Support,  Next: Extensions,  Up: Language

ANSI FORTRAN 77 Standard Support
================================

   GNU Fortran supports ANSI FORTRAN 77 with the following caveats:

   * No passing of an external procedure as an actual argument if the
     procedure's type is declared `CHARACTER*(*)'.  For example:

          CHARACTER*(*) CFUNC
          EXTERNAL CFUNC
          CALL FOO(CFUNC)
          END

     It isn't clear whether the standard considers this conforming.

     Note that it is unlikely that any production Fortran code tries to
     use this unsupported construct.

   * No passing of a dummy procedure as an actual argument if the
     procedure's type is declared `CHARACTER*(*)'.

          SUBROUTINE BAR(CFUNC)
          CHARACTER*(*) CFUNC
          EXTERNAL CFUNC
          CALL FOO(CFUNC)
          END

     It isn't clear whether the standard considers this conforming.

     Note that it is unlikely that any production Fortran code tries to
     use this unsupported construct.

   * The `DO' variable for an implied-`DO' construct in a `DATA'
     statement may not be used as the `DO' variable for an outer
     implied-`DO' construct.  For example, this fragment is disallowed
     by `g77':

          DATA ((A(I, I), I= 1, 10), I= 1, 10)/.../

     This also is disallowed by Fortran 90, as it offers no additional
     capabilities and would have a variety of possible meanings.

     Note that it is *very* unlikely that any production Fortran code
     tries to use this unsupported construct.

   * An array element initializer in an implied-`DO' construct in a
     `DATA' statement must contain at least one reference to the `DO'
     variables of each outer implied-`DO' construct.  For example, this
     fragment is disallowed by `g77':

          DATA (A, I= 1, 1)/1./

     This also is disallowed by Fortran 90, as FORTRAN 77's more
     permissive requirements offer no additional capabilities.
     However, `g77' doesn't necessarily diagnose all cases where this
     requirement is not met.

     Note that it is *very* unlikely that any production Fortran code
     tries to use this unsupported construct.

   In summary, the only ANSI FORTRAN 77 features `g77' doesn't support
are those that are probably rarely used in actual code, some of which
are explicitly disallowed by the Fortran 90 standard.


File: g77.info,  Node: Extensions,  Next: Types,  Prev: Standard Support,  Up: Language

GNU Fortran Extensions
======================

   GNU Fortran supports ANSI FORTRAN 77 plus:

   * `LOC()', if `-funix-intrinsics-enable' is in force.

   * `%LOC', `%VAL', `%REF', and `%DESCR'--where `%DESCR' currently
     means the same thing as passing the argument as if it were a
     `CHARACTER' variable (with the phantom length argument appended to
     the argument list).

   * MIL-STD 1753 features (`IAND', `IOR', `MVBITS', `DO WHILE', `END
     DO', and so on).

   * `NAMELIST'.

   * Most `f2c' intrinsics (`AND', `OR', `LSHIFT', `RSHIFT', and so on).

   * `DOUBLE COMPLEX' and related intrinsics (standard and `f2c'
     varieties).

   * Various Fortran 90 features, such as `CYCLE', `EXIT', `SELECT
     CASE' (except for `CHARACTER' types).

   * Various DEC VAX/VMS FORTRAN v4.0 features (loosely called VXT
     extensions).

   * Various `f2c' features.

   * Source files that are uppercase-only (enforced), lowercase-only
     (enforced), caseless, and various other combinations as chosen via
     command-line options.

   * Arbitrary (limited only by available memory) number of
     continuation lines.

   * Use of `&' in column 1 to indicate a continuation line (as
     supported by `f2c').

   * Dollar signs (`$') in identifiers (other than as the first
     character) when the `-fdollar-ok' option is specified.

   When `-ff90' is specified, the language dialect changes as follows:

   * The type of `REAL(Z)', where `Z' is type `DOUBLE COMPLEX', is
     `DOUBLE PRECISION' instead of `REAL'.

   * Zero-length `CHARACTER' entities are accepted, even when
     `-fpedantic' is specified.

   * Zero-size array dimensions (as in `INTEGER I(10,20,4:2)') are
     accepted, although these are not supported by `libf2c', so
     diagnostics are nevertheless produced for `g77'.

   * `DOUBLE COMPLEX' (explicit or implicit) is accepted, even when
     `-fpedantic' is specified.

   * Substrings of constants (as in `'hello'(3:5)') are accepted, even
     when `-fpedantic' is specified.

   * `DATA' statements are allowed to precede executable statements,
     even when `-fpedantic' specified.

     Note that this does not allow all possible means of specifying
     further attributes via specification statements for a variable
     after it has been given an initial value via `DATA' or a
     type-declaration statement.  For example, after `DATA I/1/',
     `INTEGER I' is not permitted, but `INTEGER J' is permitted.

   * Use of a semicolon (`;') as a statement separator is accepted,
     even when `-fpedantic' specified (so `CALL FOO; CALL BAR' works).

   * Underscores (`_') are accepted in symbol names (except as the
     first character, since Fortran 90 provides a different
     interpretation for certain cases where that would occur--though
     `g77' does not yet support that interpretation).


File: g77.info,  Node: Types,  Next: Constants,  Prev: Extensions,  Up: Language

Types
=====

   Fortran implementations have a fair amount of freedom given them by
the standard as far as how much storage space is used and how much
precision is offered by the various types such as `LOGICAL', `INTEGER',
`REAL', `DOUBLE PRECISION', `COMPLEX', and `CHARACTER'.  Further, many
compilers offer so-called `*N' notation, but the interpretation of N
varies across compilers and target architectures.

   The standard requires that `LOGICAL', `INTEGER', and `REAL' occupy
the same amount of storage space, and that `COMPLEX' and `DOUBLE
PRECISION' take twice as much storage space as `REAL'.  Further, it
requires that `COMPLEX' entities be ordered such that when a `COMPLEX'
variable is storage-associated (such as via `EQUIVALENCE') with a
two-element `REAL' array named `R', `R(1)' corresponds to the real
element and `R(2)' to the imaginary element of the `COMPLEX' variable.
No particular requirements as to precision of any of these are placed on
the implementation, nor is the relationship of storage sizes of these
types to the `CHARACTER' type specified by the standard.

   `g77' follows the above requirements, warning when compiling a
program requires placement of items in memory that contradict the
requirements of the target architecture.  (For example, a program can
require placement of a `DOUBLE PRECISION' on a boundary that is not an
even multiple of its size, but still an even multiple of the size of a
`REAL' variable.  On some target architectures, using the canonical
mapping of Fortran types to underlying architectural types, such
placement is prohibited by the machine definition or the Application
Binary Interface (ABI) in force for the configuration defined for
building `gcc' and `g77'.  `g77' warns about such situations when it
encounters them.)

   `g77' follows consistent rules for configuring the mapping between
Fortran types, including the `*N' notation, and the underlying
architectural types as accessed by a similarly-configured applicable
version of the `gcc' compiler.  These rules offer a widely portable,
consistent Fortran/C environment, although they might well conflict
with the expectations of users of Fortran compilers designed and
written for particular architectures.

   These rules are based on the configuration that is in force for the
version of `gcc' built in the same release as `g77' (and which was
therefore used to build both the `g77' compiler components and the
`libf2c' run-time library):

`REAL'
     Same as `float' type.

`DOUBLE PRECISION'
     Same as whatever floating-point type that is twice the size of a
     `float'--usually, this is a `double'.

`INTEGER'
     Same as an integral type that is occupies the same amount of
     memory storage `float'--usually, this is either an `int' or a
     `long int'.

`LOGICAL'
     Same `gcc' type as `INTEGER'.

`COMPLEX'
     Two `REAL' scalars (one for the real part followed by one for the
     imaginary part).

`DOUBLE COMPLEX'
     Two `DOUBLE PRECISION' scalars.

`NUMERIC-TYPE*N'
     (Where NUMERIC-TYPE is any type other than `CHARACTER'.) Same as
     whatever `gcc' type occupies N times the storage space of a `gcc'
     `char' item.

`NUMERIC-TYPE(KIND=N)'
     N=1 corresponds to `REAL', `INTEGER', `LOGICAL', `COMPLEX'.  N=2
     corresponds to `DOUBLE PRECISION', `DOUBLE COMPLEX', and, for
     integral types, `char' (usually `INTEGER*1' and `LOGICAL*1').  N=3
     corresponds to `short' for integral types (usually `INTEGER*2' and
     `LOGICAL*2').  N=4 corresponds to `long long' for integral types
     (this usually means `INTEGER*8' and `LOGICAL*8').

     Note that these are proposed correspondences and might change in
     future versions of `g77'--avoid writing code depending on them.

   Other types supported by `g77' are derived from gcc types such as
`char', `short', `int', `long int', `long long int', `long double', and
so on.  That is, whatever types `gcc' already supports, `g77' supports
now or probably will support in a future version.  The rules for the
`NUMERIC-TYPE*N' notation apply to these types, and new values for
`NUMERIC-TYPE(KIND=N)' will be assigned in a way that encourages
clarity, consistency, and portability.


File: g77.info,  Node: Constants,  Next: Source Form,  Prev: Types,  Up: Language

Constants
=========

   `g77' strictly assigns types to all constants not documented as
"typeless" (typeless constants including `'1'Z', for example).  Context
is never a determining factor for the type, and hence the
interpretation, of a typed constant.  Examples: `1' is always type
`INTEGER', `9.435784839284958' is always type `REAL' (even if the
additional precision specified is lost, and even when used in a `DOUBLE
PRECISION' context), `1E0' is always type `REAL', and `1D0' is always
type `DOUBLE PRECISION'.

   Many other Fortran compilers attempt to assign types to typed
constants based on their context.  This results in hard-to-find bugs,
nonportable code, and is not in the spirit (though it strictly follows
the letter) of the 77 and 90 standards.  `g77' will not support these
dangerous semantics, but might offer, in a future release, explicit
constructs by which a wider variety of typeless constants may be
specified, and/or user-requested warnings indicating places where `g77'
might differ from how other compilers assign types to constants.

