


ED(1)                                                       ED(1)


NNAAMMEE
       ed, red - text editor

SSYYNNOOPPSSIISS
       ed [-] [-Gs] [-p _s_t_r_i_n_g] [_f_i_l_e]

       red [-] [-Gs] [-p _s_t_r_i_n_g] [_f_i_l_e]

DDEESSCCRRIIPPTTIIOONN
       eedd  is a line-oriented text editor.  It is used to create,
       display, modify and otherwise manipulate text files.   rreedd
       is  a restricted eedd: it can only edit files in the current
       directory and cannot execute shell commands.

       If invoked with a _f_i_l_e argument, then a copy  of  _f_i_l_e  is
       read  into  the editor's buffer.  Changes are made to this
       copy and not directly to _f_i_l_e itself.  Upon  quitting  eedd,
       any  changes  not explicitly saved  with a _`_w_' command are
       lost.

       Editing is done in two distinct modes: _c_o_m_m_a_n_d and  _i_n_p_u_t.
       When  first  invoked, eedd is in command mode.  In this mode
       commands are read from the standard input and executed  to
       manipulate  the  contents of the editor buffer.  A typical
       command might look like:

              ,s/_o_l_d/_n_e_w/g

       which replaces all occurences of the string _o_l_d with  _n_e_w.

       When  an input command, such as _`_a_' (append), _`_i_' (insert)
       or _`_c_' (change), is given, eedd enters input mode.  This  is
       the primary means of adding text to a file.  In this mode,
       no commands are available; instead, the standard input  is
       written  directly  to the editor buffer.  Lines consist of
       text up to and including a _n_e_w_l_i_n_e character.  Input  mode
       is  terminated by entering a single period  (_.) on a line.

       All eedd commands operate on whole lines or ranges of lines;
       e.g., the _`_d_' command deletes lines; the _`_m_' command moves
       lines, and so on.  It is possible to modify only a portion
       of  a  line  by  means  of  replacement, as in the example
       above.  However even here, the _`_s_' command is  applied  to
       whole lines at a time.

       In  general,  eedd  commands  consist  of  zero or more line
       addresses, followed by a single character command and pos-
       sibly  additional  parameters;  i.e.,  commands  have  the
       structure:

              _[_a_d_d_r_e_s_s _[_,_a_d_d_r_e_s_s_]_]_c_o_m_m_a_n_d_[_p_a_r_a_m_e_t_e_r_s_]

       The address(es) indicate the line or range of lines to  be
       affected  by  the  command.   If fewer addresses are given



                         10 November 1994                       1





ED(1)                                                       ED(1)


       than the command accepts, then default addresses are  sup-
       plied.


   OOPPTTIIOONNSS
       -G      Forces  backwards compatibility.  Affects the com-
               mands _`_G_', _`_V_', _`_f_', _`_l_', _`_m_', _`_t_', and _`_!_!_'.

       -s      Suppresses diagnostics. This  should  be  used  if
               eedd's standard input is from a script.


       -p _s_t_r_i_n_g
               Specifies  a  command prompt.  This may be toggled
               on and off with the _`_P_' command.


       _f_i_l_e    Specifies the name of a file to read.  If _f_i_l_e  is
               prefixed  with  a bang (!), then it is interpreted
               as a shell command.  In this case, what is read is
               the  standard  output  of _f_i_l_e executed via _s_h(1).
               To read a file whose name begins with a bang, pre-
               fix  the  name  with a backslash (\).  The default
               filename is set to _f_i_l_e only if it is not prefixed
               with a bang.


   LLIINNEE AADDDDRREESSSSIINNGG
       An  address represents the number of a line in the buffer.
       eedd maintains a _c_u_r_r_e_n_t _a_d_d_r_e_s_s which is typically supplied
       to commands as the default address when none is specified.
       When a file is first read,  the current address is set  to
       the  last  line  of  the  file.   In  general, the current
       address is set to the last line affected by a command.

       A line address is constructed from one of the bases in the
       list  below, optionally followed by a numeric offset.  The
       offset may include any combination  of  digits,  operators
       (i.e.,  _+,  _-  and  _^) and whitespace.  Addresses are read
       from left to right, and their values are computed relative
       to the current address.

       One  exception  to  the rule that addresses represent line
       numbers is the address _0 (zero).  This means  "before  the
       first line," and is legal wherever it makes sense.

       An  address  range  is two addresses separated either by a
       comma or semicolon. The value of the first  address  in  a
       range  cannot exceed the value of the the second.  If only
       one address is given in a range, then the  second  address
       is  set  to the given address.  If an _n_-tuple of addresses
       is given where _n _> _2_,  then  the  corresponding  range  is
       determined  by  the last two addresses in the _n_-tuple.  If
       only one address is expected, then  the  last  address  is



                         10 November 1994                       2





ED(1)                                                       ED(1)


       used.

       Each  address  in  a  comma-delimited range is interpreted
       relative to the current address.  In a semicolon-delimited
       range,  the  first  address  is  used  to  set the current
       address, and the second address is interpreted relative to
       the first.


       The following address symbols are recognized.


       .       The current line (address) in the buffer.


       $       The last line in the buffer.


       n       The _nth, line in the buffer where _n is a number in
               the range _[_0_,_$_]_.


       -

       ^       The previous line.  This is equivalent to  _-_1  and
               may be repeated with cumulative effect.


       -_n

       ^_n      The  _nth  previous line, where _n is a non-negative
               number.


       +       The next line.  This is equivalent to _+_1  and  may
               be repeated with cumulative effect.


       +_n

       whitespace _n
               The  _nth next line, where _n is a non-negative num-
               ber.  _W_h_i_t_e_s_p_a_c_e followed by a number _n is  inter-
               preted as _+_n.


       ,

       %       The  first through last lines in the buffer.  This
               is equivalent to the address range _1_,_$_.


       ;       The current through  last  lines  in  the  buffer.
               This is equivalent to the address range _._,_$_.



                         10 November 1994                       3





ED(1)                                                       ED(1)


       /_r_e_/    The  next  line  containing the regular expression
               _r_e.  The search wraps  to  the  beginning  of  the
               buffer  and continues down to the current line, if
               necessary.  // repeats the last search.


       ?_r_e_?    The previous line containing the  regular  expres-
               sion  _r_e.   The  search  wraps  to  the end of the
               buffer and continues up to the  current  line,  if
               necessary.  ?? repeats the last search.


       '_l_c     The  line  previously  marked by a _`_k_' (mark) com-
               mand, where _l_c is a lower case letter.


   RREEGGUULLAARR EEXXPPRREESSSSIIOONNSS
       Regular expressions are patterns used in  selecting  text.
       For example, the eedd command

              g/_s_t_r_i_n_g/

       prints  all  lines containing _s_t_r_i_n_g.  Regular expressions
       are also used by the _`_s_' command for selecting old text to
       be replaced with new.

       In  addition  to  a  specifying  string  literals, regular
       expressions can represent  classes  of  strings.   Strings
       thus represented are said to be matched by the correspond-
       ing regular expression.  If it is possible for  a  regular
       expression  to  match  several strings in a line, then the
       left-most longest match is the one selected.

       The following symbols are  used  in  constructing  regular
       expressions:


       c       Any  character  _c not listed below, including `{',
               '}', `(', `)', `<' and `>', matches itself.


       \_c      A backslash-escaped character _c  other  than  `{',
               '}',  `(', `)', `<', `>', `b', 'B', `w', `W', `+',
               and `?'  matches itself.


       Matches any single character.


       _[_c_h_a_r_-_c_l_a_s_s_]
               Matches any single character  in  _c_h_a_r_-_c_l_a_s_s.   To
               include a  `]' in _c_h_a_r_-_c_l_a_s_s, it must be the first
               character.  A range of characters may be specified
               by separating the end characters of the range with



                         10 November 1994                       4





ED(1)                                                       ED(1)


               a `-', e.g., `a-z' specifies the lower case  char-
               acters.   The  following  literal  expressions can
               also be used in  _c_h_a_r_-_c_l_a_s_s  to  specify  sets  of
               characters:

                 [:alnum:]  [:cntrl:]  [:lower:]  [:space:]
                 [:alpha:]  [:digit:]  [:print:]  [:upper:]
                 [:blank:]  [:graph:]  [:punct:]  [:xdigit:]

               If  `-'  appears as the first or last character of
               _c_h_a_r_-_c_l_a_s_s, then it  matches  itself.   All  other
               characters in _c_h_a_r_-_c_l_a_s_s match themselves.

               Patterns in _c_h_a_r_-_c_l_a_s_s of the form:

                 [._c_o_l_-_e_l_m.] or,   [=_c_o_l_-_e_l_m=]

               where  _c_o_l_-_e_l_m  is  a _c_o_l_l_a_t_i_n_g _e_l_e_m_e_n_t are inter-
               preted according to _l_o_c_a_l_e(5) (not currently  sup-
               ported).  See _r_e_g_e_x(3) for an explanation of these
               constructs.

       [^_c_h_a_r_-_c_l_a_s_s]
               Matches any single character, other than  newline,
               not  in  _c_h_a_r_-_c_l_a_s_s.   _c_h_a_r_-_c_l_a_s_s  is  defined  as
               above.

       ^       If `^' is the first character of a regular expres-
               sion,  then  it  anchors the regular expression to
               the beginning of a line.   Otherwise,  it  matches
               itself.

       $       If  `$' is the last character of a regular expres-
               sion, it anchors the regular expression to the end
               of a line.  Otherwise, it matches itself.

       \(_r_e\)  Defines   a   (possibly  null)  subexpression  _r_e.
               Subexpressions may be nested.  A subsequent  back-
               reference of the form `\_n', where _n is a number in
               the range [1,9], expands to the  text  matched  by
               the  _nth  subexpression.  For example, the regular
               expression   `\(a.c\)\1'   matches   the    string
               `abcabc',  but  not  `abcadc'.  Subexpressions are
               ordered relative to their left delimiter.

       *       Matches the single character regular expression or
               subexpression  immediately  preceding  it  zero or
               more times.  If '*' is the first  character  of  a
               regular   expression  or  subexpression,  then  it
               matches itself.  The `*' operator sometimes yields
               unexpected  results.   For  example,  the  regular
               expression  `b*'  matches  the  beginning  of  the
               string  `abbb', as opposed to the substring `bbb',
               since a null match is the only left-most match.



                         10 November 1994                       5





ED(1)                                                       ED(1)


       \{_n_,_m\}
       \{_n_,\}
       \{_n\}   Matches the single character regular expression or
               subexpression  immediately preceding it at least _n
               and at most _m times.  If _m  is  omitted,  then  it
               matches  at  least  _n times.  If the comma is also
               omitted, then it matches exactly _n times.  If  any
               of  these  forms occurs first in a regular expres-
               sion or subexpression, then it is interpreted lit-
               erally   (i.e.,  the  regular  expression  `\{2\}'
               matches the string `{2}', and so on).

       \<
       \>      Anchors the single character regular expression or
               subexpression  immediately  following  it  to  the
               beginning (\<) or ending (\>) of a _w_o_r_d, i.e.,  in
               ASCII,  a  maximal  string of alphanumeric charac-
               ters, including the underscore (_).


       The following extended operators are preceded by  a  back-
       slash  (\) to distinguish them from traditional eedd syntax.

       \`
       \'      Unconditionally matches the beginning (\`) or end-
               ing (\') of a line.

       \?      Optionally  matches  the  single character regular
               expression or subexpression immediately  preceding
               it.    For   example,   the   regular   expression
               `a[bd]\?c' matches the strings  `abc',  `adc'  and
               `ac'.   If \? occurs at the beginning of a regular
               expressions or subexpression, then  it  matches  a
               literal `?'.

       \+      Matches the single character regular expression or
               subexpression immediately preceding it one or more
               times.   So  the regular expression `a+' is short-
               hand for `aa*'.  If \+ occurs at the beginning  of
               a  regular  expression  or  subexpression, then it
               matches a literal `+'.


       \b      Matches the beginning or ending (null string) of a
               word.   Thus the regular expression `\bhello\b' is
               equivalent to `\<hello\>'.  However, `\b\b'  is  a
               valid regular expression whereas `\<\>' is not.

       \B      Matches (a null string) inside a word.

       \w      Matches any character in a word.

       \W      Matches any character not in a word.




                         10 November 1994                       6





ED(1)                                                       ED(1)


   CCOOMMMMAANNDDSS
       All eedd commands are single characters, though some require
       additonal parameters.  If a  command's  parameters  extend
       over  several  lines,  then  each line except for the last
       must be terminated with a backslash (\).

       In general, at most one command is allowed per line.  How-
       ever, most commands accept a print suffix, which is any of
       _`_p_' (print), _`_l_' (list) , or _`_n_' (enumerate), to print the
       last line affected by the command.

       An interrupt (typically ^C) has the effect of aborting the
       current command and returning the editor to command  mode.

       eedd  recognizes  the  following commands.  The commands are
       shown together with the default address or  address  range
       supplied if none is specified (in parenthesis).

       (.)a    Appends  text  to  the  buffer after the addressed
               line, which may be the address 0 (zero).  Text  is
               entered in input mode.  The current address is set
               to last line entered.

       (.,.)c  Changes lines in the buffer.  The addressed  lines
               are  deleted from the buffer, and text is appended
               in their place.  Text is entered  in  input  mode.
               The current address is set to last line entered.

       (.,.)d  Deletes  the  addressed lines from the buffer.  If
               there is a line after the deleted range, then  the
               current address is set to this line. Otherwise the
               current address is set  to  the  line  before  the
               deleted range.

       e _f_i_l_e  Edits  _f_i_l_e,  and  sets  the default filename.  If
               _f_i_l_e is not specified, then the  default  filename
               is  used.   Any  lines  in  the buffer are deleted
               before the new file is read.  The current  address
               is set to the last line read.

       e _!_c_o_m_m_a_n_d
               Edits  the  standard  output  of  _`_!_c_o_m_m_a_n_d_', (see
               !_c_o_m_m_a_n_d  below).    The   default   filename   is
               unchanged.   Any  lines  in the buffer are deleted
               before the output of _c_o_m_m_a_n_d is read.  The current
               address is set to the last line read.

       E _f_i_l_e  Edits  _f_i_l_e  unconditionally.   This is similar to
               the _e command, except that unwritten  changes  are
               discarded without warning.  The current address is
               set to the last line read.

       f _f_i_l_e  Sets the default filename to _f_i_l_e.  If _f_i_l_e is not
               specified,  then the default unescaped filename is



                         10 November 1994                       7





ED(1)                                                       ED(1)


               printed.

       (1,$)g_/_r_e_/_c_o_m_m_a_n_d_-_l_i_s_t
               Applies _c_o_m_m_a_n_d_-_l_i_s_t  to  each  of  the  addressed
               lines  matching a regular expression _r_e.  The cur-
               rent address is set to the line currently  matched
               before  _c_o_m_m_a_n_d_-_l_i_s_t  is  executed.  At the end of
               the _`_g_' command, the current address is set to the
               last line affected by _c_o_m_m_a_n_d_-_l_i_s_t.

               Each command in _c_o_m_m_a_n_d_-_l_i_s_t must be on a separate
               line, and every line except for the last  must  be
               terminated  by  a backslash (\).  Any commands are
               allowed, except for _`_g_', _`_G_',  _`_v_',  and  _`_V_'.   A
               newline  alone  in _c_o_m_m_a_n_d_-_l_i_s_t is equivalent to a
               _`_p_' command.

       (1,$)G_/_r_e_/
               Interactively edits the addressed lines matching a
               regular  expression  _r_e_.   For each matching line,
               the line is printed, the current address  is  set,
               and  the user is prompted to enter a _c_o_m_m_a_n_d_-_l_i_s_t.
               At the end of the _`_G_' command, the current address
               is  set  to  the  last line affected by (the last)
               _c_o_m_m_a_n_d_-_l_i_s_t.

               The format of _c_o_m_m_a_n_d_-_l_i_s_t is the same as that  of
               the  _`_g_'  command.  A newline alone acts as a null
               command list.  A single `&' repeats the last  non-
               null command list.

       H       Toggles  the  printing  of error explanations.  By
               default, explanations are not printed.  It is rec-
               ommended  that  ed scripts begin with this command
               to aid in debugging.

       h       Prints an explanation of the last error.

       (.)i    Inserts text in  the  buffer  before  the  current
               line.  Text is entered in input mode.  The current
               address is set to the last line entered.

       (.,.+1)j
               Joins the addressed lines.   The  addressed  lines
               are deleted from the buffer and replaced by a sin-
               gle line containing their joined text.   The  cur-
               rent address is set to the resultant line.

       (.)k_l_c  Marks  a  line  with  a lower case letter _l_c.  The
               line can then be addressed as _'_l_c (i.e., a  single
               quote  followed  by  _l_c  ) in subsequent commands.
               The mark is not cleared until the line is  deleted
               or otherwise modified.




                         10 November 1994                       8





ED(1)                                                       ED(1)


       (.,.)l  Prints  the  addressed  lines  unambiguously.   If
               invoked from a terminal, eedd pauses at the  end  of
               each page until a newline is entered.  The current
               address is set to the last line printed.

       (.,.)m(.)
               Moves lines in the buffer.   The  addressed  lines
               are  moved  to  after  the  right-hand destination
               address, which may be the address _0  (zero).   The
               current address is set to the last line moved.

       (.,.)n  Prints  the  addressed lines along with their line
               numbers.  The current address is set to  the  last
               line printed.

       (.,.)p  Prints  the  addressed lines.    If invoked from a
               terminal, eedd pauses at the end of each page  until
               a  newline is entered.  The current address is set
               to the last line printed.

       P       Toggles the command prompt on and off.   Unless  a
               prompt  was  specified by with command-line option
               _-_p _s_t_r_i_n_g, the command prompt is by default turned
               off.

       q       Quits ed.

       Q       Quits  ed unconditionally.  This is similar to the
               _q command, except that unwritten changes are  dis-
               carded without warning.

       ($)r _f_i_l_e
               Reads  _f_i_l_e  to after the addressed line.  If _f_i_l_e
               is not specified, then  the  default  filename  is
               used.   If  there was no default filename prior to
               the command, then the default filename is  set  to
               _f_i_l_e.    Otherwise,   the   default   filename  is
               unchanged.  The current address is set to the last
               line read.

       ($)r _!_c_o_m_m_a_n_d
               Reads  to  after  the  addressed line the standard
               output of _`_!_c_o_m_m_a_n_d_', (see  the  !_c_o_m_m_a_n_d  below).
               The  default  filename  is unchanged.  The current
               address is set to the last line read.

       (.,.)s_/_r_e_/_r_e_p_l_a_c_e_m_e_n_t_/
       (.,.)s_/_r_e_/_r_e_p_l_a_c_e_m_e_n_t_/g
       (.,.)s_/_r_e_/_r_e_p_l_a_c_e_m_e_n_t_/_n
               Replaces text in the addressed  lines  matching  a
               regular   expression   _r_e  with  _r_e_p_l_a_c_e_m_e_n_t.   By
               default, only the first  match  in  each  line  is
               replaced.   If  the  _`_g_' (global) suffix is given,
               then every match to be replaced.  The _`_n_'  suffix,



                         10 November 1994                       9





ED(1)                                                       ED(1)


               where  _n  is a postive number, causes only the _nth
               match to be replaced.  It is an error if  no  sub-
               stitutions  are  performed on any of the addressed
               lines.  The current address is set the  last  line
               affected.

               _r_e and _r_e_p_l_a_c_e_m_e_n_t may be delimited by any charac-
               ter other than space and newline (see the _`_s_' com-
               mand below).  If one or two of the last delimiters
               is omitted, then the last line affected is printed
               as though the print suffix _`_p_' were specified.


               An unescaped `&' in _r_e_p_l_a_c_e_m_e_n_t is replaced by the
               currently matched text.   The  character  sequence
               _`_\_m_',  where  _m is a number in the range [1,9], is
               replaced by the _mth  backreference  expression  of
               the  matched  text.   If _r_e_p_l_a_c_e_m_e_n_t consists of a
               single `%', then _r_e_p_l_a_c_e_m_e_n_t from the last substi-
               tution  is  used.   Newlines  may  be  embedded in
               _r_e_p_l_a_c_e_m_e_n_t if they are escaped with  a  backslash
               (\).

       (.,.)s  Repeats  the  last substitution.  This form of the
               _`_s_' command accepts a count  suffix  _`_n_',  or  any
               combination  of  the characters _`_r_', _`_g_', and _`_p_'.
               If a count suffix _`_n_' is given, then only the  _nth
               match is replaced.  The _`_r_' suffix causes the reg-
               ular expression of the  last  search  to  be  used
               instead of the that of the last substitution.  The
               _`_g_' suffix toggles the global suffix of  the  last
               substitution.   The  _`_p_'  suffix toggles the print
               suffix  of  the  last  substitution  The   current
               address is set to the last line affected.

       (.,.)t(.)
               Copies  (i.e.,  transfers)  the addressed lines to
               after the right-hand  destination  address,  which
               may  be the address _0 (zero).  The current address
               is set to the last line copied.

       u       Undoes the last command and restores  the  current
               address  to  what  it was before the command.  The
               global commands  _`_g_',  _`_G_',  _`_v_',  and  _`_V_'.   are
               treated  as  a single command by undo.  _`_u_' is its
               own inverse.

       (1,$)v_/_r_e_/_c_o_m_m_a_n_d_-_l_i_s_t
               Applies _c_o_m_m_a_n_d_-_l_i_s_t  to  each  of  the  addressed
               lines  not matching a regular expression _r_e.  This
               is similar to the _`_g_' command.

       (1,$)V_/_r_e_/
               Interactively  edits  the  addressed   lines   not



                         10 November 1994                      10





ED(1)                                                       ED(1)


               matching a regular expression _r_e_.  This is similar
               to the _`_G_' command.

       (1,$)w _f_i_l_e
               Writes the addressed lines to _f_i_l_e.  Any  previous
               contents  of  _f_i_l_e  is  lost  without warning.  If
               there is no default  filename,  then  the  default
               filename   is   set   to  _f_i_l_e_,  otherwise  it  is
               unchanged.  If no filename is specified, then  the
               default  filename is used.  The current address is
               unchanged.

       (1,$)wq _f_i_l_e
               Writes the addressed lines to _f_i_l_e, and then  exe-
               cutes a _`_q_' command.

       (1,$)w _!_c_o_m_m_a_n_d
               Writes  the  addressed lines to the standard input
               of _`_!_c_o_m_m_a_n_d_',  (see  the  !_c_o_m_m_a_n_d  below).   The
               default   filename   and   current   address   are
               unchanged.

       (1,$)W _f_i_l_e
               Appends the addressed lines to the  end  of  _f_i_l_e.
               This  is  similar  to the _`_w_' command, expect that
               the previous contents of file  is  not  clobbered.
               The current address is unchanged.

       (.)x    Copies  (puts)  the  contents of the cut buffer to
               after the addressed line.  The current address  is
               set to the last line copied.

       (.,.)y  Copies  (yanks)  the  addressed  lines  to the cut
               buffer.  The cut buffer is overwritten  by  subse-
               quent  _`_y_',  _`_s_',  _`_j_', _`_d_', or _`_c_' commands.  The
               current address is unchanged.

       (.+1)z_n Scrolls _n lines at a time  starting  at  addressed
               line.   If  _n  is  not specified, then the current
               window size is used.  The current address  is  set
               to the last line printed.

       !_c_o_m_m_a_n_d
               Executes  _c_o_m_m_a_n_d via _s_h(1).  If the first charac-
               ter of _c_o_m_m_a_n_d is `!', then it is replaced by text
               of  the  previous _`_!_c_o_m_m_a_n_d_'.  eedd does not process
               _c_o_m_m_a_n_d for backslash (\)  escapes.   However,  an
               unescaped _`_%_' is replaced by the default filename.
               When the shell returns from execution, a  `!'   is
               printed  to the standard output.  The current line
               is unchanged.

       (.,.)#  Begins a comment;  the rest of the line, up  to  a
               newline,  is  ignored.  If a line address followed



                         10 November 1994                      11





ED(1)                                                       ED(1)


               by a semicolon is given, then the current  address
               is  set  to  that address.  Otherwise, the current
               address is unchanged.

       ($)=    Prints the line number of the addressed line.

       (.+1)newline
               Prints the addressed line, and  sets  the  current
               address to that line.

FFIILLEESS
       /tmp/ed.*           Buffer file
       ed.hup              The file to which eedd attempts to write
                           the  buffer if the terminal hangs  up.

SSEEEE AALLSSOO
       _v_i(1), _s_e_d(1), _r_e_g_e_x(3), _s_h(1).

       USD:12-13

       B.  W. Kernighan and P. J. Plauger, _S_o_f_t_w_a_r_e _T_o_o_l_s _i_n _P_a_s_-
       _c_a_l _, Addison-Wesley, 1981.

LLIIMMIITTAATTIIOONNSS
       eedd processes _f_i_l_e arguments for backslash  escapes,  i.e.,
       in  a filename, any characters preceded by a backslash (\)
       are interpreted literally.

       If a text (non-binary) file is not terminated by a newline
       character,  then eedd appends one on reading/writing it.  In
       the case of a binary file, eedd does not append a newline on
       reading/writing.

       per line overhead: 4 ints

DDIIAAGGNNOOSSTTIICCSS
       When an error occurs, if eedd's input is from a regular file
       or here document, then it exits, otherwise it prints a `?'
       and  returns  to command mode.  An explanation of the last
       error can be printed with the _`_h_' (help) command.

       Attempting to quit eedd or edit another file before  writing
       a  modified buffer results in an error.  If the command is
       entered a second time, it succeeds, but any changes to the
       buffer are lost.

       eedd exits with 0 if no errors occurred; otherwise >0.










                         10 November 1994                      12


