This is Info file as.info, produced by Makeinfo-1.55 from the input
file ./as.texinfo.

START-INFO-DIR-ENTRY
* As: (as).                     The GNU assembler.
END-INFO-DIR-ENTRY

   This file documents the GNU Assembler "as".

   Copyright (C) 1991, 92, 93, 94, 95, 1996 Free Software Foundation,
Inc.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, provided that
the entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions.


File: as.info,  Node: Psize,  Next: Quad,  Prev: P2align,  Up: Pseudo Ops

`.psize LINES , COLUMNS'
========================

   Use this directive to declare the number of lines--and, optionally,
the number of columns--to use for each page, when generating listings.

   If you do not use `.psize', listings use a default line-count of 60.
You may omit the comma and COLUMNS specification; the default width is
200 columns.

   `as' generates formfeeds whenever the specified number of lines is
exceeded (or whenever you explicitly request one, using `.eject').

   If you specify LINES as `0', no formfeeds are generated save those
explicitly specified with `.eject'.


File: as.info,  Node: Quad,  Next: Rept,  Prev: Psize,  Up: Pseudo Ops

`.quad BIGNUMS'
===============

   `.quad' expects zero or more bignums, separated by commas.  For each
bignum, it emits an 8-byte integer.  If the bignum won't fit in 8
bytes, it prints a warning message; and just takes the lowest order 8
bytes of the bignum.

   The term "quad" comes from contexts in which a "word" is two bytes;
hence *quad*-word for 8 bytes.


File: as.info,  Node: Rept,  Next: Sbttl,  Prev: Quad,  Up: Pseudo Ops

`.rept COUNT'
=============

   Repeat the sequence of lines between the `.rept' directive and the
next `.endr' directive COUNT times.

   For example, assembling

             .rept   3
             .long   0
             .endr

   is equivalent to assembling

             .long   0
             .long   0
             .long   0


File: as.info,  Node: Sbttl,  Next: Scl,  Prev: Rept,  Up: Pseudo Ops

`.sbttl "SUBHEADING"'
=====================

   Use SUBHEADING as the title (third line, immediately after the title
line) when generating assembly listings.

   This directive affects subsequent pages, as well as the current page
if it appears within ten lines of the top of a page.


File: as.info,  Node: Scl,  Next: Section,  Prev: Sbttl,  Up: Pseudo Ops

`.scl CLASS'
============

   Set the storage-class value for a symbol.  This directive may only be
used inside a `.def'/`.endef' pair.  Storage class may flag whether a
symbol is static or external, or it may record further symbolic
debugging information.

   The `.scl' directive is primarily associated with COFF output; when
configured to generate `b.out' output format, `as' accepts this
directive but ignores it.


File: as.info,  Node: Section,  Next: Set,  Prev: Scl,  Up: Pseudo Ops

`.section NAME, SUBSECTION'
===========================

   Assemble the following code into end of subsection numbered
SUBSECTION in the COFF named section NAME.  If you omit SUBSECTION,
`as' uses subsection number zero.  `.section .text' is equivalent to
the `.text' directive; `.section .data' is equivalent to the `.data'
directive.  This directive is only supported for targets that actually
support arbitrarily named sections; on `a.out' targets, for example, it
is not accepted, even with a standard `a.out' section name as its
parameter.


File: as.info,  Node: Set,  Next: Short,  Prev: Section,  Up: Pseudo Ops

`.set SYMBOL, EXPRESSION'
=========================

   Set the value of SYMBOL to EXPRESSION.  This changes SYMBOL's value
and type to conform to EXPRESSION.  If SYMBOL was flagged as external,
it remains flagged. (*Note Symbol Attributes::.)

   You may `.set' a symbol many times in the same assembly.

   If you `.set' a global symbol, the value stored in the object file
is the last value stored into it.

   The syntax for `set' on the HPPA is `SYMBOL .set EXPRESSION'.


File: as.info,  Node: Short,  Next: Single,  Prev: Set,  Up: Pseudo Ops

`.short EXPRESSIONS'
====================

   `.short' is normally the same as `.word'.  *Note `.word': Word.

   In some configurations, however, `.short' and `.word' generate
numbers of different lengths; *note Machine Dependencies::..


File: as.info,  Node: Single,  Next: Size,  Prev: Short,  Up: Pseudo Ops

`.single FLONUMS'
=================

   This directive assembles zero or more flonums, separated by commas.
It has the same effect as `.float'.  The exact kind of floating point
numbers emitted depends on how `as' is configured.  *Note Machine
Dependencies::.


File: as.info,  Node: Size,  Next: Skip,  Prev: Single,  Up: Pseudo Ops

`.size'
=======

   This directive is generated by compilers to include auxiliary
debugging information in the symbol table.  It is only permitted inside
`.def'/`.endef' pairs.

   `.size' is only meaningful when generating COFF format output; when
`as' is generating `b.out', it accepts this directive but ignores it.


File: as.info,  Node: Skip,  Next: Space,  Prev: Size,  Up: Pseudo Ops

`.skip SIZE , FILL'
===================

   This directive emits SIZE bytes, each of value FILL.  Both SIZE and
FILL are absolute expressions.  If the comma and FILL are omitted, FILL
is assumed to be zero.  This is the same as `.space'.


File: as.info,  Node: Space,  Next: Stab,  Prev: Skip,  Up: Pseudo Ops

`.space SIZE , FILL'
====================

   This directive emits SIZE bytes, each of value FILL.  Both SIZE and
FILL are absolute expressions.  If the comma and FILL are omitted, FILL
is assumed to be zero.  This is the same as `.skip'.

     *Warning:* `.space' has a completely different meaning for HPPA
     targets; use `.block' as a substitute.  See `HP9000 Series 800
     Assembly Language Reference Manual' (HP 92432-90001) for the
     meaning of the `.space' directive.  *Note HPPA Assembler
     Directives: HPPA Directives, for a summary.

   On the AMD 29K, this directive is ignored; it is accepted for
compatibility with other AMD 29K assemblers.

     *Warning:* In most versions of the GNU assembler, the directive
     `.space' has the effect of `.block'  *Note Machine Dependencies::.


File: as.info,  Node: Stab,  Next: String,  Prev: Space,  Up: Pseudo Ops

`.stabd, .stabn, .stabs'
========================

   There are three directives that begin `.stab'.  All emit symbols
(*note Symbols::.), for use by symbolic debuggers.  The symbols are not
entered in the `as' hash table: they cannot be referenced elsewhere in
the source file.  Up to five fields are required:

STRING
     This is the symbol's name.  It may contain any character except
     `\000', so is more general than ordinary symbol names.  Some
     debuggers used to code arbitrarily complex structures into symbol
     names using this field.

TYPE
     An absolute expression.  The symbol's type is set to the low 8
     bits of this expression.  Any bit pattern is permitted, but `ld'
     and debuggers choke on silly bit patterns.

OTHER
     An absolute expression.  The symbol's "other" attribute is set to
     the low 8 bits of this expression.

DESC
     An absolute expression.  The symbol's descriptor is set to the low
     16 bits of this expression.

VALUE
     An absolute expression which becomes the symbol's value.

   If a warning is detected while reading a `.stabd', `.stabn', or
`.stabs' statement, the symbol has probably already been created; you
get a half-formed symbol in your object file.  This is compatible with
earlier assemblers!

`.stabd TYPE , OTHER , DESC'
     The "name" of the symbol generated is not even an empty string.
     It is a null pointer, for compatibility.  Older assemblers used a
     null pointer so they didn't waste space in object files with empty
     strings.

     The symbol's value is set to the location counter, relocatably.
     When your program is linked, the value of this symbol is the
     address of the location counter when the `.stabd' was assembled.

`.stabn TYPE , OTHER , DESC , VALUE'
     The name of the symbol is set to the empty string `""'.

`.stabs STRING ,  TYPE , OTHER , DESC , VALUE'
     All five fields are specified.


File: as.info,  Node: String,  Next: Tag,  Prev: Stab,  Up: Pseudo Ops

`.string' "STR"
===============

   Copy the characters in STR to the object file.  You may specify more
than one string to copy, separated by commas.  Unless otherwise
specified for a particular machine, the assembler marks the end of each
string with a 0 byte.  You can use any of the escape sequences
described in *Note Strings: Strings.


File: as.info,  Node: Tag,  Next: Text,  Prev: String,  Up: Pseudo Ops

`.tag STRUCTNAME'
=================

   This directive is generated by compilers to include auxiliary
debugging information in the symbol table.  It is only permitted inside
`.def'/`.endef' pairs.  Tags are used to link structure definitions in
the symbol table with instances of those structures.

   `.tag' is only used when generating COFF format output; when `as' is
generating `b.out', it accepts this directive but ignores it.


File: as.info,  Node: Text,  Next: Title,  Prev: Tag,  Up: Pseudo Ops

`.text SUBSECTION'
==================

   Tells `as' to assemble the following statements onto the end of the
text subsection numbered SUBSECTION, which is an absolute expression.
If SUBSECTION is omitted, subsection number zero is used.


File: as.info,  Node: Title,  Next: Type,  Prev: Text,  Up: Pseudo Ops

`.title "HEADING"'
==================

   Use HEADING as the title (second line, immediately after the source
file name and pagenumber) when generating assembly listings.

   This directive affects subsequent pages, as well as the current page
if it appears within ten lines of the top of a page.


File: as.info,  Node: Type,  Next: Val,  Prev: Title,  Up: Pseudo Ops

`.type INT'
===========

   This directive, permitted only within `.def'/`.endef' pairs, records
the integer INT as the type attribute of a symbol table entry.

   `.type' is associated only with COFF format output; when `as' is
configured for `b.out' output, it accepts this directive but ignores it.


File: as.info,  Node: Val,  Next: Word,  Prev: Type,  Up: Pseudo Ops

`.val ADDR'
===========

   This directive, permitted only within `.def'/`.endef' pairs, records
the address ADDR as the value attribute of a symbol table entry.

   `.val' is used only for COFF output; when `as' is configured for
`b.out', it accepts this directive but ignores it.


File: as.info,  Node: Word,  Next: Deprecated,  Prev: Val,  Up: Pseudo Ops

`.word EXPRESSIONS'
===================

   This directive expects zero or more EXPRESSIONS, of any section,
separated by commas.

   The size of the number emitted, and its byte order, depend on what
target computer the assembly is for.

     *Warning: Special Treatment to support Compilers*

   Machines with a 32-bit address space, but that do less than 32-bit
addressing, require the following special treatment.  If the machine of
interest to you does 32-bit addressing (or doesn't require it; *note
Machine Dependencies::.), you can ignore this issue.

   In order to assemble compiler output into something that works, `as'
occasionlly does strange things to `.word' directives.  Directives of
the form `.word sym1-sym2' are often emitted by compilers as part of
jump tables.  Therefore, when `as' assembles a directive of the form
`.word sym1-sym2', and the difference between `sym1' and `sym2' does
not fit in 16 bits, `as' creates a "secondary jump table", immediately
before the next label.  This secondary jump table is preceded by a
short-jump to the first byte after the secondary table.  This
short-jump prevents the flow of control from accidentally falling into
the new table.  Inside the table is a long-jump to `sym2'.  The
original `.word' contains `sym1' minus the address of the long-jump to
`sym2'.

   If there were several occurrences of `.word sym1-sym2' before the
secondary jump table, all of them are adjusted.  If there was a `.word
sym3-sym4', that also did not fit in sixteen bits, a long-jump to
`sym4' is included in the secondary jump table, and the `.word'
directives are adjusted to contain `sym3' minus the address of the
long-jump to `sym4'; and so on, for as many entries in the original
jump table as necessary.


File: as.info,  Node: Deprecated,  Prev: Word,  Up: Pseudo Ops

Deprecated Directives
=====================

   One day these directives won't work.  They are included for
compatibility with older assemblers.
.abort
.app-file
.line

File: as.info,  Node: Machine Dependencies,  Next: Acknowledgements,  Prev: Pseudo Ops,  Up: Top

Machine Dependent Features
**************************

   The machine instruction sets are (almost by definition) different on
each machine where `as' runs.  Floating point representations vary as
well, and `as' often supports a few additional directives or
command-line options for compatibility with other assemblers on a
particular platform.  Finally, some versions of `as' support special
pseudo-instructions for branch optimization.

   This chapter discusses most of these differences, though it does not
include details on any machine's instruction set.  For details on that
subject, see the hardware manufacturer's manual.

* Menu:


* AMD29K-Dependent::            AMD 29K Dependent Features

* H8/300-Dependent::            Hitachi H8/300 Dependent Features

* H8/500-Dependent::            Hitachi H8/500 Dependent Features

* HPPA-Dependent::              HPPA Dependent Features

* i386-Dependent::              Intel 80386 Dependent Features

* i960-Dependent::              Intel 80960 Dependent Features

* M68K-Dependent::              M680x0 Dependent Features

* MIPS-Dependent::              MIPS Dependent Features

* SH-Dependent::                Hitachi SH Dependent Features

* Sparc-Dependent::             SPARC Dependent Features

* Z8000-Dependent::             Z8000 Dependent Features

* Vax-Dependent::               VAX Dependent Features


File: as.info,  Node: AMD29K-Dependent,  Next: H8/300-Dependent,  Up: Machine Dependencies

AMD 29K Dependent Features
==========================

* Menu:

* AMD29K Options::              Options
* AMD29K Syntax::               Syntax
* AMD29K Floating Point::       Floating Point
* AMD29K Directives::           AMD 29K Machine Directives
* AMD29K Opcodes::              Opcodes


File: as.info,  Node: AMD29K Options,  Next: AMD29K Syntax,  Up: AMD29K-Dependent

Options
-------

   `as' has no additional command-line options for the AMD 29K family.


File: as.info,  Node: AMD29K Syntax,  Next: AMD29K Floating Point,  Prev: AMD29K Options,  Up: AMD29K-Dependent

Syntax
------

* Menu:

* AMD29K-Macros::		Macros
* AMD29K-Chars::                Special Characters
* AMD29K-Regs::                 Register Names


File: as.info,  Node: AMD29K-Macros,  Next: AMD29K-Chars,  Up: AMD29K Syntax

Macros
......

   The macro syntax used on the AMD 29K is like that described in the
AMD 29K Family Macro Assembler Specification.  Normal `as' macros
should still work.


File: as.info,  Node: AMD29K-Chars,  Next: AMD29K-Regs,  Prev: AMD29K-Macros,  Up: AMD29K Syntax

Special Characters
..................

   `;' is the line comment character.

   The character `?' is permitted in identifiers (but may not begin an
identifier).


File: as.info,  Node: AMD29K-Regs,  Prev: AMD29K-Chars,  Up: AMD29K Syntax

Register Names
..............

   General-purpose registers are represented by predefined symbols of
the form `GRNNN' (for global registers) or `LRNNN' (for local
registers), where NNN represents a number between `0' and `127',
written with no leading zeros.  The leading letters may be in either
upper or lower case; for example, `gr13' and `LR7' are both valid
register names.

   You may also refer to general-purpose registers by specifying the
register number as the result of an expression (prefixed with `%%' to
flag the expression as a register number):
     %%EXPRESSION

--where EXPRESSION must be an absolute expression evaluating to a
number between `0' and `255'.  The range [0, 127] refers to global
registers, and the range [128, 255] to local registers.

   In addition, `as' understands the following protected
special-purpose register names for the AMD 29K family:

       vab    chd    pc0
       ops    chc    pc1
       cps    rbp    pc2
       cfg    tmc    mmu
       cha    tmr    lru

   These unprotected special-purpose register names are also recognized:
       ipc    alu    fpe
       ipa    bp     inte
       ipb    fc     fps
       q      cr     exop


File: as.info,  Node: AMD29K Floating Point,  Next: AMD29K Directives,  Prev: AMD29K Syntax,  Up: AMD29K-Dependent

Floating Point
--------------

   The AMD 29K family uses IEEE floating-point numbers.


File: as.info,  Node: AMD29K Directives,  Next: AMD29K Opcodes,  Prev: AMD29K Floating Point,  Up: AMD29K-Dependent

AMD 29K Machine Directives
--------------------------

`.block SIZE , FILL'
     This directive emits SIZE bytes, each of value FILL.  Both SIZE
     and FILL are absolute expressions.  If the comma and FILL are
     omitted, FILL is assumed to be zero.

     In other versions of the GNU assembler, this directive is called
     `.space'.

`.cputype'
     This directive is ignored; it is accepted for compatibility with
     other AMD 29K assemblers.

`.file'
     This directive is ignored; it is accepted for compatibility with
     other AMD 29K assemblers.

          *Warning:* in other versions of the GNU assembler, `.file' is
          used for the directive called `.app-file' in the AMD 29K
          support.

`.line'
     This directive is ignored; it is accepted for compatibility with
     other AMD 29K assemblers.

`.sect'
     This directive is ignored; it is accepted for compatibility with
     other AMD 29K assemblers.

`.use SECTION NAME'
     Establishes the section and subsection for the following code;
     SECTION NAME may be one of `.text', `.data', `.data1', or `.lit'.
     With one of the first three SECTION NAME options, `.use' is
     equivalent to the machine directive SECTION NAME; the remaining
     case, `.use .lit', is the same as `.data 200'.


File: as.info,  Node: AMD29K Opcodes,  Prev: AMD29K Directives,  Up: AMD29K-Dependent

Opcodes
-------

   `as' implements all the standard AMD 29K opcodes.  No additional
pseudo-instructions are needed on this family.

   For information on the 29K machine instruction set, see `Am29000
User's Manual', Advanced Micro Devices, Inc.


File: as.info,  Node: H8/300-Dependent,  Next: H8/500-Dependent,  Prev: AMD29K-Dependent,  Up: Machine Dependencies

H8/300 Dependent Features
=========================

* Menu:

* H8/300 Options::              Options
* H8/300 Syntax::               Syntax
* H8/300 Floating Point::       Floating Point
* H8/300 Directives::           H8/300 Machine Directives
* H8/300 Opcodes::              Opcodes


File: as.info,  Node: H8/300 Options,  Next: H8/300 Syntax,  Up: H8/300-Dependent

Options
-------

   `as' has no additional command-line options for the Hitachi H8/300
family.


File: as.info,  Node: H8/300 Syntax,  Next: H8/300 Floating Point,  Prev: H8/300 Options,  Up: H8/300-Dependent

Syntax
------

* Menu:

* H8/300-Chars::                Special Characters
* H8/300-Regs::                 Register Names
* H8/300-Addressing::           Addressing Modes


File: as.info,  Node: H8/300-Chars,  Next: H8/300-Regs,  Up: H8/300 Syntax

Special Characters
..................

   `;' is the line comment character.

   `$' can be used instead of a newline to separate statements.
Therefore *you may not use `$' in symbol names* on the H8/300.


File: as.info,  Node: H8/300-Regs,  Next: H8/300-Addressing,  Prev: H8/300-Chars,  Up: H8/300 Syntax

Register Names
..............

   You can use predefined symbols of the form `rNh' and `rNl' to refer
to the H8/300 registers as sixteen 8-bit general-purpose registers.  N
is a digit from `0' to `7'); for instance, both `r0h' and `r7l' are
valid register names.

   You can also use the eight predefined symbols `rN' to refer to the
H8/300 registers as 16-bit registers (you must use this form for
addressing).

   On the H8/300H, you can also use the eight predefined symbols `erN'
(`er0' ... `er7') to refer to the 32-bit general purpose registers.

   The two control registers are called `pc' (program counter; a 16-bit
register, except on the H8/300H where it is 24 bits) and `ccr'
(condition code register; an 8-bit register).  `r7' is used as the
stack pointer, and can also be called `sp'.


File: as.info,  Node: H8/300-Addressing,  Prev: H8/300-Regs,  Up: H8/300 Syntax

Addressing Modes
................

   as understands the following addressing modes for the H8/300:
`rN'
     Register direct

`@rN'
     Register indirect

`@(D, rN)'
`@(D:16, rN)'
`@(D:24, rN)'
     Register indirect: 16-bit or 24-bit displacement D from register
     N.  (24-bit displacements are only meaningful on the H8/300H.)

`@rN+'
     Register indirect with post-increment

`@-rN'
     Register indirect with pre-decrement

``@'AA'
``@'AA:8'
``@'AA:16'
``@'AA:24'
     Absolute address `aa'.  (The address size `:24' only makes sense
     on the H8/300H.)

`#XX'
`#XX:8'
`#XX:16'
`#XX:32'
     Immediate data XX.  You may specify the `:8', `:16', or `:32' for
     clarity, if you wish; but `as' neither requires this nor uses
     it--the data size required is taken from context.

``@'`@'AA'
``@'`@'AA:8'
     Memory indirect.  You may specify the `:8' for clarity, if you
     wish; but `as' neither requires this nor uses it.


File: as.info,  Node: H8/300 Floating Point,  Next: H8/300 Directives,  Prev: H8/300 Syntax,  Up: H8/300-Dependent

Floating Point
--------------

   The H8/300 family has no hardware floating point, but the `.float'
directive generates IEEE floating-point numbers for compatibility with
other development tools.


File: as.info,  Node: H8/300 Directives,  Next: H8/300 Opcodes,  Prev: H8/300 Floating Point,  Up: H8/300-Dependent

H8/300 Machine Directives
-------------------------

   `as' has only one machine-dependent directive for the H8/300:

`.h8300h'
     Recognize and emit additional instructions for the H8/300H
     variant, and also make `.int' emit 32-bit numbers rather than the
     usual (16-bit) for the H8/300 family.

   On the H8/300 family (including the H8/300H) `.word' directives
generate 16-bit numbers.


File: as.info,  Node: H8/300 Opcodes,  Prev: H8/300 Directives,  Up: H8/300-Dependent

Opcodes
-------

   For detailed information on the H8/300 machine instruction set, see
`H8/300 Series Programming Manual' (Hitachi ADE-602-025).  For
information specific to the H8/300H, see `H8/300H Series Programming
Manual' (Hitachi).

   `as' implements all the standard H8/300 opcodes.  No additional
pseudo-instructions are needed on this family.

   The following table summarizes the H8/300 opcodes, and their
arguments.  Entries marked `*' are opcodes used only on the H8/300H.

              Legend:
                 Rs   source register
                 Rd   destination register
                 abs  absolute address
                 imm  immediate data
              disp:N  N-bit displacement from a register
             pcrel:N  N-bit displacement relative to program counter
     
        add.b #imm,rd              *  andc #imm,ccr
        add.b rs,rd                   band #imm,rd
        add.w rs,rd                   band #imm,@rd
     *  add.w #imm,rd                 band #imm,@abs:8
     *  add.l rs,rd                   bra  pcrel:8
     *  add.l #imm,rd              *  bra  pcrel:16
        adds #imm,rd                  bt   pcrel:8
        addx #imm,rd               *  bt   pcrel:16
        addx rs,rd                    brn  pcrel:8
        and.b #imm,rd              *  brn  pcrel:16
        and.b rs,rd                   bf   pcrel:8
     *  and.w rs,rd                *  bf   pcrel:16
     *  and.w #imm,rd                 bhi  pcrel:8
     *  and.l #imm,rd              *  bhi  pcrel:16
     *  and.l rs,rd                   bls  pcrel:8
     
     *  bls  pcrel:16                 bld  #imm,rd
        bcc  pcrel:8                  bld  #imm,@rd
     *  bcc  pcrel:16                 bld  #imm,@abs:8
        bhs  pcrel:8                  bnot #imm,rd
     *  bhs  pcrel:16                 bnot #imm,@rd
        bcs  pcrel:8                  bnot #imm,@abs:8
     *  bcs  pcrel:16                 bnot rs,rd
        blo  pcrel:8                  bnot rs,@rd
     *  blo  pcrel:16                 bnot rs,@abs:8
        bne  pcrel:8                  bor  #imm,rd
     *  bne  pcrel:16                 bor  #imm,@rd
        beq  pcrel:8                  bor  #imm,@abs:8
     *  beq  pcrel:16                 bset #imm,rd
        bvc  pcrel:8                  bset #imm,@rd
     *  bvc  pcrel:16                 bset #imm,@abs:8
        bvs  pcrel:8                  bset rs,rd
     *  bvs  pcrel:16                 bset rs,@rd
        bpl  pcrel:8                  bset rs,@abs:8
     *  bpl  pcrel:16                 bsr  pcrel:8
        bmi  pcrel:8                  bsr  pcrel:16
     *  bmi  pcrel:16                 bst  #imm,rd
        bge  pcrel:8                  bst  #imm,@rd
     *  bge  pcrel:16                 bst  #imm,@abs:8
        blt  pcrel:8                  btst #imm,rd
     *  blt  pcrel:16                 btst #imm,@rd
        bgt  pcrel:8                  btst #imm,@abs:8
     *  bgt  pcrel:16                 btst rs,rd
        ble  pcrel:8                  btst rs,@rd
     *  ble  pcrel:16                 btst rs,@abs:8
        bclr #imm,rd                  bxor #imm,rd
        bclr #imm,@rd                 bxor #imm,@rd
        bclr #imm,@abs:8              bxor #imm,@abs:8
        bclr rs,rd                    cmp.b #imm,rd
        bclr rs,@rd                   cmp.b rs,rd
        bclr rs,@abs:8                cmp.w rs,rd
        biand #imm,rd                 cmp.w rs,rd
        biand #imm,@rd             *  cmp.w #imm,rd
        biand #imm,@abs:8          *  cmp.l #imm,rd
        bild #imm,rd               *  cmp.l rs,rd
        bild #imm,@rd                 daa  rs
        bild #imm,@abs:8              das  rs
        bior #imm,rd                  dec.b rs
        bior #imm,@rd              *  dec.w #imm,rd
        bior #imm,@abs:8           *  dec.l #imm,rd
        bist #imm,rd                  divxu.b rs,rd
        bist #imm,@rd              *  divxu.w rs,rd
        bist #imm,@abs:8           *  divxs.b rs,rd
        bixor #imm,rd              *  divxs.w rs,rd
        bixor #imm,@rd                eepmov
        bixor #imm,@abs:8          *  eepmovw
     
     *  exts.w rd                     mov.w rs,@abs:16
     *  exts.l rd                  *  mov.l #imm,rd
     *  extu.w rd                  *  mov.l rs,rd
     *  extu.l rd                  *  mov.l @rs,rd
        inc  rs                    *  mov.l @(disp:16,rs),rd
     *  inc.w #imm,rd              *  mov.l @(disp:24,rs),rd
     *  inc.l #imm,rd              *  mov.l @rs+,rd
        jmp  @rs                   *  mov.l @abs:16,rd
        jmp  abs                   *  mov.l @abs:24,rd
        jmp  @@abs:8               *  mov.l rs,@rd
        jsr  @rs                   *  mov.l rs,@(disp:16,rd)
        jsr  abs                   *  mov.l rs,@(disp:24,rd)
        jsr  @@abs:8               *  mov.l rs,@-rd
        ldc  #imm,ccr              *  mov.l rs,@abs:16
        ldc  rs,ccr                *  mov.l rs,@abs:24
     *  ldc  @abs:16,ccr              movfpe @abs:16,rd
     *  ldc  @abs:24,ccr              movtpe rs,@abs:16
     *  ldc  @(disp:16,rs),ccr        mulxu.b rs,rd
     *  ldc  @(disp:24,rs),ccr     *  mulxu.w rs,rd
     *  ldc  @rs+,ccr              *  mulxs.b rs,rd
     *  ldc  @rs,ccr               *  mulxs.w rs,rd
     *  mov.b @(disp:24,rs),rd        neg.b rs
     *  mov.b rs,@(disp:24,rd)     *  neg.w rs
        mov.b @abs:16,rd           *  neg.l rs
        mov.b rs,rd                   nop
        mov.b @abs:8,rd               not.b rs
        mov.b rs,@abs:8            *  not.w rs
        mov.b rs,rd                *  not.l rs
        mov.b #imm,rd                 or.b #imm,rd
        mov.b @rs,rd                  or.b rs,rd
        mov.b @(disp:16,rs),rd     *  or.w #imm,rd
        mov.b @rs+,rd              *  or.w rs,rd
        mov.b @abs:8,rd            *  or.l #imm,rd
        mov.b rs,@rd               *  or.l rs,rd
        mov.b rs,@(disp:16,rd)        orc  #imm,ccr
        mov.b rs,@-rd                 pop.w rs
        mov.b rs,@abs:8            *  pop.l rs
        mov.w rs,@rd                  push.w rs
     *  mov.w @(disp:24,rs),rd     *  push.l rs
     *  mov.w rs,@(disp:24,rd)        rotl.b rs
     *  mov.w @abs:24,rd           *  rotl.w rs
     *  mov.w rs,@abs:24           *  rotl.l rs
        mov.w rs,rd                   rotr.b rs
        mov.w #imm,rd              *  rotr.w rs
        mov.w @rs,rd               *  rotr.l rs
        mov.w @(disp:16,rs),rd        rotxl.b rs
        mov.w @rs+,rd              *  rotxl.w rs
        mov.w @abs:16,rd           *  rotxl.l rs
        mov.w rs,@(disp:16,rd)        rotxr.b rs
        mov.w rs,@-rd              *  rotxr.w rs
     
     *  rotxr.l rs                 *  stc  ccr,@(disp:24,rd)
        bpt                        *  stc  ccr,@-rd
        rte                        *  stc  ccr,@abs:16
        rts                        *  stc  ccr,@abs:24
        shal.b rs                     sub.b rs,rd
     *  shal.w rs                     sub.w rs,rd
     *  shal.l rs                  *  sub.w #imm,rd
        shar.b rs                  *  sub.l rs,rd
     *  shar.w rs                  *  sub.l #imm,rd
     *  shar.l rs                     subs #imm,rd
        shll.b rs                     subx #imm,rd
     *  shll.w rs                     subx rs,rd
     *  shll.l rs                  *  trapa #imm
        shlr.b rs                     xor  #imm,rd
     *  shlr.w rs                     xor  rs,rd
     *  shlr.l rs                  *  xor.w #imm,rd
        sleep                      *  xor.w rs,rd
        stc  ccr,rd                *  xor.l #imm,rd
     *  stc  ccr,@rs               *  xor.l rs,rd
     *  stc  ccr,@(disp:16,rd)        xorc #imm,ccr

   Four H8/300 instructions (`add', `cmp', `mov', `sub') are defined
with variants using the suffixes `.b', `.w', and `.l' to specify the
size of a memory operand.  `as' supports these suffixes, but does not
require them; since one of the operands is always a register, `as' can
deduce the correct size.

   For example, since `r0' refers to a 16-bit register,
     mov    r0,@foo
is equivalent to
     mov.w  r0,@foo

   If you use the size suffixes, `as' issues a warning when the suffix
and the register size do not match.


File: as.info,  Node: H8/500-Dependent,  Next: HPPA-Dependent,  Prev: H8/300-Dependent,  Up: Machine Dependencies

H8/500 Dependent Features
=========================

* Menu:

* H8/500 Options::              Options
* H8/500 Syntax::               Syntax
* H8/500 Floating Point::       Floating Point
* H8/500 Directives::           H8/500 Machine Directives
* H8/500 Opcodes::              Opcodes


File: as.info,  Node: H8/500 Options,  Next: H8/500 Syntax,  Up: H8/500-Dependent

Options
-------

   `as' has no additional command-line options for the Hitachi H8/500
family.


File: as.info,  Node: H8/500 Syntax,  Next: H8/500 Floating Point,  Prev: H8/500 Options,  Up: H8/500-Dependent

Syntax
------

* Menu:

* H8/500-Chars::                Special Characters
* H8/500-Regs::                 Register Names
* H8/500-Addressing::           Addressing Modes


File: as.info,  Node: H8/500-Chars,  Next: H8/500-Regs,  Up: H8/500 Syntax

Special Characters
..................

   `!' is the line comment character.

   `;' can be used instead of a newline to separate statements.

   Since `$' has no special meaning, you may use it in symbol names.


File: as.info,  Node: H8/500-Regs,  Next: H8/500-Addressing,  Prev: H8/500-Chars,  Up: H8/500 Syntax

Register Names
..............

   You can use the predefined symbols `r0', `r1', `r2', `r3', `r4',
`r5', `r6', and `r7' to refer to the H8/500 registers.

   The H8/500 also has these control registers:

`cp'
     code pointer

`dp'
     data pointer

`bp'
     base pointer

`tp'
     stack top pointer

`ep'
     extra pointer

`sr'
     status register

`ccr'
     condition code register

   All registers are 16 bits long.  To represent 32 bit numbers, use two
adjacent registers; for distant memory addresses, use one of the segment
pointers (`cp' for the program counter; `dp' for `r0'-`r3'; `ep' for
`r4' and `r5'; and `tp' for `r6' and `r7'.


File: as.info,  Node: H8/500-Addressing,  Prev: H8/500-Regs,  Up: H8/500 Syntax

Addressing Modes
................

   as understands the following addressing modes for the H8/500:
`RN'
     Register direct

`@RN'
     Register indirect

`@(d:8, RN)'
     Register indirect with 8 bit signed displacement

`@(d:16, RN)'
     Register indirect with 16 bit signed displacement

`@-RN'
     Register indirect with pre-decrement

`@RN+'
     Register indirect with post-increment

`@AA:8'
     8 bit absolute address

`@AA:16'
     16 bit absolute address

`#XX:8'
     8 bit immediate

`#XX:16'
     16 bit immediate


File: as.info,  Node: H8/500 Floating Point,  Next: H8/500 Directives,  Prev: H8/500 Syntax,  Up: H8/500-Dependent

Floating Point
--------------

   The H8/500 family has no hardware floating point, but the `.float'
directive generates IEEE floating-point numbers for compatibility with
other development tools.


File: as.info,  Node: H8/500 Directives,  Next: H8/500 Opcodes,  Prev: H8/500 Floating Point,  Up: H8/500-Dependent

H8/500 Machine Directives
-------------------------

   `as' has no machine-dependent directives for the H8/500.  However,
on this platform the `.int' and `.word' directives generate 16-bit
numbers.


File: as.info,  Node: H8/500 Opcodes,  Prev: H8/500 Directives,  Up: H8/500-Dependent

Opcodes
-------

   For detailed information on the H8/500 machine instruction set, see
`H8/500 Series Programming Manual' (Hitachi M21T001).

   `as' implements all the standard H8/500 opcodes.  No additional
pseudo-instructions are needed on this family.

   The following table summarizes H8/500 opcodes and their operands:

     Legend:
     abs8      8-bit absolute address
     abs16     16-bit absolute address
     abs24     24-bit absolute address
     crb       `ccr', `br', `ep', `dp', `tp', `dp'
     disp8     8-bit displacement
     ea        `rn', `@rn', `@(d:8, rn)', `@(d:16, rn)',
               `@-rn', `@rn+', `@aa:8', `@aa:16',
               `#xx:8', `#xx:16'
     ea_mem    `@rn', `@(d:8, rn)', `@(d:16, rn)',
               `@-rn', `@rn+', `@aa:8', `@aa:16'
     ea_noimm  `rn', `@rn', `@(d:8, rn)', `@(d:16, rn)',
               `@-rn', `@rn+', `@aa:8', `@aa:16'
     fp        r6
     imm4      4-bit immediate data
     imm8      8-bit immediate data
     imm16     16-bit immediate data
     pcrel8    8-bit offset from program counter
     pcrel16   16-bit offset from program counter
     qim       `-2', `-1', `1', `2'
     rd        any register
     rs        a register distinct from rd
     rlist     comma-separated list of registers in parentheses;
               register ranges `rd-rs' are allowed
     sp        stack pointer (`r7')
     sr        status register
     sz        size; `.b' or `.w'.  If omitted, default `.w'
     
     ldc[.b] ea,crb                 bcc[.w] pcrel16
     ldc[.w] ea,sr                  bcc[.b] pcrel8
     add[:q] sz qim,ea_noimm        bhs[.w] pcrel16
     add[:g] sz ea,rd               bhs[.b] pcrel8
     adds sz ea,rd                  bcs[.w] pcrel16
     addx sz ea,rd                  bcs[.b] pcrel8
     and sz ea,rd                   blo[.w] pcrel16
     andc[.b] imm8,crb              blo[.b] pcrel8
     andc[.w] imm16,sr              bne[.w] pcrel16
     bpt                            bne[.b] pcrel8
     bra[.w] pcrel16                beq[.w] pcrel16
     bra[.b] pcrel8                 beq[.b] pcrel8
     bt[.w] pcrel16                 bvc[.w] pcrel16
     bt[.b] pcrel8                  bvc[.b] pcrel8
     brn[.w] pcrel16                bvs[.w] pcrel16
     brn[.b] pcrel8                 bvs[.b] pcrel8
     bf[.w] pcrel16                 bpl[.w] pcrel16
     bf[.b] pcrel8                  bpl[.b] pcrel8
     bhi[.w] pcrel16                bmi[.w] pcrel16
     bhi[.b] pcrel8                 bmi[.b] pcrel8
     bls[.w] pcrel16                bge[.w] pcrel16
     bls[.b] pcrel8                 bge[.b] pcrel8
     
     blt[.w] pcrel16                mov[:g][.b] imm8,ea_mem
     blt[.b] pcrel8                 mov[:g][.w] imm16,ea_mem
     bgt[.w] pcrel16                movfpe[.b] ea,rd
     bgt[.b] pcrel8                 movtpe[.b] rs,ea_noimm
     ble[.w] pcrel16                mulxu sz ea,rd
     ble[.b] pcrel8                 neg sz ea
     bclr sz imm4,ea_noimm          nop
     bclr sz rs,ea_noimm            not sz ea
     bnot sz imm4,ea_noimm          or sz ea,rd
     bnot sz rs,ea_noimm            orc[.b] imm8,crb
     bset sz imm4,ea_noimm          orc[.w] imm16,sr
     bset sz rs,ea_noimm            pjmp abs24
     bsr[.b] pcrel8                 pjmp @rd
     bsr[.w] pcrel16                pjsr abs24
     btst sz imm4,ea_noimm          pjsr @rd
     btst sz rs,ea_noimm            prtd imm8
     clr sz ea                      prtd imm16
     cmp[:e][.b] imm8,rd            prts
     cmp[:i][.w] imm16,rd           rotl sz ea
     cmp[:g].b imm8,ea_noimm        rotr sz ea
     cmp[:g][.w] imm16,ea_noimm     rotxl sz ea
     Cmp[:g] sz ea,rd               rotxr sz ea
     dadd rs,rd                     rtd imm8
     divxu sz ea,rd                 rtd imm16
     dsub rs,rd                     rts
     exts[.b] rd                    scb/f rs,pcrel8
     extu[.b] rd                    scb/ne rs,pcrel8
     jmp @rd                        scb/eq rs,pcrel8
     jmp @(imm8,rd)                 shal sz ea
     jmp @(imm16,rd)                shar sz ea
     jmp abs16                      shll sz ea
     jsr @rd                        shlr sz ea
     jsr @(imm8,rd)                 sleep
     jsr @(imm16,rd)                stc[.b] crb,ea_noimm
     jsr abs16                      stc[.w] sr,ea_noimm
     ldm @sp+,(rlist)               stm (rlist),@-sp
     link fp,imm8                   sub sz ea,rd
     link fp,imm16                  subs sz ea,rd
     mov[:e][.b] imm8,rd            subx sz ea,rd
     mov[:i][.w] imm16,rd           swap[.b] rd
     mov[:l][.w] abs8,rd            tas[.b] ea
     mov[:l].b abs8,rd              trapa imm4
     mov[:s][.w] rs,abs8            trap/vs
     mov[:s].b rs,abs8              tst sz ea
     mov[:f][.w] @(disp8,fp),rd     unlk fp
     mov[:f][.w] rs,@(disp8,fp)     xch[.w] rs,rd
     mov[:f].b @(disp8,fp),rd       xor sz ea,rd
     mov[:f].b rs,@(disp8,fp)       xorc.b imm8,crb
     mov[:g] sz rs,ea_mem           xorc.w imm16,sr
     mov[:g] sz ea,rd


File: as.info,  Node: HPPA-Dependent,  Next: i386-Dependent,  Prev: H8/500-Dependent,  Up: Machine Dependencies

HPPA Dependent Features
=======================

* Menu:

* HPPA Notes::                Notes
* HPPA Options::              Options
* HPPA Syntax::               Syntax
* HPPA Floating Point::       Floating Point
* HPPA Directives::           HPPA Machine Directives
* HPPA Opcodes::              Opcodes


File: as.info,  Node: HPPA Notes,  Next: HPPA Options,  Up: HPPA-Dependent

Notes
-----

   As a back end for GNU CC `as' has been throughly tested and should
work extremely well.  We have tested it only minimally on hand written
assembly code and no one has tested it much on the assembly output from
the HP compilers.

   The format of the debugging sections has changed since the original
`as' port (version 1.3X) was released; therefore, you must rebuild all
HPPA objects and libraries with the new assembler so that you can debug
the final executable.

   The HPPA `as' port generates a small subset of the relocations
available in the SOM and ELF object file formats.  Additional relocation
support will be added as it becomes necessary.


File: as.info,  Node: HPPA Options,  Next: HPPA Syntax,  Prev: HPPA Notes,  Up: HPPA-Dependent

Options
-------

   `as' has no machine-dependent command-line options for the HPPA.


File: as.info,  Node: HPPA Syntax,  Next: HPPA Floating Point,  Prev: HPPA Options,  Up: HPPA-Dependent

Syntax
------

   The assembler syntax closely follows the HPPA instruction set
reference manual; assembler directives and general syntax closely
follow the HPPA assembly language reference manual, with a few
noteworthy differences.

   First, a colon may immediately follow a label definition.  This is
simply for compatibility with how most assembly language programmers
write code.

   Some obscure expression parsing problems may affect hand written
code which uses the `spop' instructions, or code which makes significant
use of the `!' line separator.

   `as' is much less forgiving about missing arguments and other
similar oversights than the HP assembler.  `as' notifies you of missing
arguments as syntax errors; this is regarded as a feature, not a bug.

   Finally, `as' allows you to use an external symbol without
explicitly importing the symbol.  *Warning:* in the future this will be
an error for HPPA targets.

   Special characters for HPPA targets include:

   `;' is the line comment character.

   `!' can be used instead of a newline to separate statements.

   Since `$' has no special meaning, you may use it in symbol names.


File: as.info,  Node: HPPA Floating Point,  Next: HPPA Directives,  Prev: HPPA Syntax,  Up: HPPA-Dependent

Floating Point
--------------

   The HPPA family uses IEEE floating-point numbers.


File: as.info,  Node: HPPA Directives,  Next: HPPA Opcodes,  Prev: HPPA Floating Point,  Up: HPPA-Dependent

HPPA Assembler Directives
-------------------------

   `as' for the HPPA supports many additional directives for
compatibility with the native assembler.  This section describes them
only briefly.  For detailed information on HPPA-specific assembler
directives, see `HP9000 Series 800 Assembly Language Reference Manual'
(HP 92432-90001).

   `as' does *not* support the following assembler directives described
in the HP manual:

     .endm           .liston
     .enter          .locct
     .leave          .macro
     .listoff

   Beyond those implemented for compatibility, `as' supports one
additional assembler directive for the HPPA: `.param'.  It conveys
register argument locations for static functions.  Its syntax closely
follows the `.export' directive.

   These are the additional directives in `as' for the HPPA:

`.block N'
`.blockz N'
     Reserve N bytes of storage, and initialize them to zero.

`.call'
     Mark the beginning of a procedure call.  Only the special case
     with *no arguments* is allowed.

`.callinfo [ PARAM=VALUE, ... ]  [ FLAG, ... ]'
     Specify a number of parameters and flags that define the
     environment for a procedure.

     PARAM may be any of `frame' (frame size), `entry_gr' (end of
     general register range), `entry_fr' (end of float register range),
     `entry_sr' (end of space register range).

     The values for FLAG are `calls' or `caller' (proc has
     subroutines), `no_calls' (proc does not call subroutines),
     `save_rp' (preserve return pointer), `save_sp' (proc preserves
     stack pointer), `no_unwind' (do not unwind this proc), `hpux_int'
     (proc is interrupt routine).

`.code'
     Assemble into the standard section called `$TEXT$', subsection
     `$CODE$'.

`.copyright "STRING"'
     In the SOM object format, insert STRING into the object code,
     marked as a copyright string.

`.copyright "STRING"'
     In the ELF object format, insert STRING into the object code,
     marked as a version string.

`.enter'
     Not yet supported; the assembler rejects programs containing this
     directive.

`.entry'
     Mark the beginning of a procedure.

`.exit'
     Mark the end of a procedure.

`.export NAME [ ,TYP ]  [ ,PARAM=R ]'
     Make a procedure NAME available to callers.  TYP, if present, must
     be one of `absolute', `code' (ELF only, not SOM), `data', `entry',
     `data', `entry', `millicode', `plabel', `pri_prog', or `sec_prog'.

     PARAM, if present, provides either relocation information for the
     procedure arguments and result, or a privilege level.  PARAM may be
     `argwN' (where N ranges from `0' to `3', and indicates one of four
     one-word arguments); `rtnval' (the procedure's result); or
     `priv_lev' (privilege level).  For arguments or the result, R
     specifies how to relocate, and must be one of `no' (not
     relocatable), `gr' (argument is in general register), `fr' (in
     floating point register), or `fu' (upper half of float register).
     For `priv_lev', R is an integer.

`.half N'
     Define a two-byte integer constant N; synonym for the portable
     `as' directive `.short'.

`.import NAME [ ,TYP ]'
     Converse of `.export'; make a procedure available to call.  The
     arguments use the same conventions as the first two arguments for
     `.export'.

`.label NAME'
     Define NAME as a label for the current assembly location.

`.leave'
     Not yet supported; the assembler rejects programs containing this
     directive.

`.origin LC'
     Advance location counter to LC. Synonym for the `{No Value For
     "as"}' portable directive `.org'.

`.param NAME [ ,TYP ]  [ ,PARAM=R ]'
     Similar to `.export', but used for static procedures.

`.proc'
     Use preceding the first statement of a procedure.

`.procend'
     Use following the last statement of a procedure.

`LABEL .reg EXPR'
     Synonym for `.equ'; define LABEL with the absolute expression EXPR
     as its value.

`.space SECNAME [ ,PARAMS ]'
     Switch to section SECNAME, creating a new section by that name if
     necessary.  You may only use PARAMS when creating a new section,
     not when switching to an existing one.  SECNAME may identify a
     section by number rather than by name.

     If specified, the list PARAMS declares attributes of the section,
     identified by keywords.  The keywords recognized are `spnum=EXP'
     (identify this section by the number EXP, an absolute expression),
     `sort=EXP' (order sections according to this sort key when linking;
     EXP is an absolute expression), `unloadable' (section contains no
     loadable data), `notdefined' (this section defined elsewhere), and
     `private' (data in this section not available to other programs).

`.spnum SECNAM'
     Allocate four bytes of storage, and initialize them with the
     section number of the section named SECNAM.  (You can define the
     section number with the HPPA `.space' directive.)

`.string "STR"'
     Copy the characters in the string STR to the object file.  *Note
     Strings: Strings, for information on escape sequences you can use
     in `as' strings.

     *Warning!* The HPPA version of `.string' differs from the usual
     `as' definition: it does *not* write a zero byte after copying STR.

`.stringz "STR"'
     Like `.string', but appends a zero byte after copying STR to object
     file.

`.subspa NAME [ ,PARAMS ]'
`.nsubspa NAME [ ,PARAMS ]'
     Similar to `.space', but selects a subsection NAME within the
     current section.  You may only specify PARAMS when you create a
     subsection (in the first instance of `.subspa' for this NAME).

     If specified, the list PARAMS declares attributes of the
     subsection, identified by keywords.  The keywords recognized are
     `quad=EXPR' ("quadrant" for this subsection), `align=EXPR'
     (alignment for beginning of this subsection; a power of two),
     `access=EXPR' (value for "access rights" field), `sort=EXPR'
     (sorting order for this subspace in link), `code_only' (subsection
     contains only code), `unloadable' (subsection cannot be loaded
     into memory), `common' (subsection is common block), `dup_comm'
     (initialized data may have duplicate names), or `zero' (subsection
     is all zeros, do not write in object file).

     `.nsubspa' always creates a new subspace with the given name, even
     if one with the same name already exists.

`.version "STR"'
     Write STR as version identifier in object code.


File: as.info,  Node: HPPA Opcodes,  Prev: HPPA Directives,  Up: HPPA-Dependent

Opcodes
-------

   For detailed information on the HPPA machine instruction set, see
`PA-RISC Architecture and Instruction Set Reference Manual' (HP
09740-90039).


File: as.info,  Node: i386-Dependent,  Next: i960-Dependent,  Prev: HPPA-Dependent,  Up: Machine Dependencies

80386 Dependent Features
========================

* Menu:

* i386-Options::                Options
* i386-Syntax::                 AT&T Syntax versus Intel Syntax
* i386-Opcodes::                Opcode Naming
* i386-Regs::                   Register Naming
* i386-prefixes::               Opcode Prefixes
* i386-Memory::                 Memory References
* i386-jumps::                  Handling of Jump Instructions
* i386-Float::                  Floating Point
* i386-16bit::                  Writing 16-bit Code
* i386-Notes::                  Notes


File: as.info,  Node: i386-Options,  Next: i386-Syntax,  Up: i386-Dependent

Options
-------

   The 80386 has no machine dependent options.

