#ifdef Uses_SETAppAll
#define Uses_SETAppConst
#define Uses_TSetEditorApp
#define Uses_SETAppDialogs
#define Uses_SETAppVarious
#define Uses_SETAppProject
#define Uses_SETAppFiles
#endif

#if defined(Uses_SETAppConst) && !defined(__SETAppConst__)
#define __SETAppConst__
const ushort
  cmOpen       = 100,
  cmNew        = 101,
  cmChangeDrct = 102,
  cmDosShell   = 103,
  cmCalculator = 104,
  cmShowClip   = 105,
  cmMacros     = 106;

const cmInfView        = 106,
      cmListWin        = 107,
      cmLastHelp       = 108,
      cmUserScreen     = 109,
      cmAnotherInfView = 110,
      cmOpenPrj        = 111,
      cmClosePrj       = 112,
      cmSDG            = 113,
      cmSDGDialog      = 114;
#endif

#if defined(Uses_TSetEditorApp) && !defined(__TSetEditorApp__)
#define __TSetEditorApp__
class TMenuBar;
class TStatusLine;
class TEditWindow;
class TDialog;
class fpstream;

class TSetEditorApp : public TApplication
{
public:
    TSetEditorApp();

    virtual void handleEvent( TEvent& event );
    static TMenuBar *initMenuBar( TRect );
    static TStatusLine *initStatusLine( TRect );
    virtual void outOfMemory();
    virtual TPalette& getPalette() const;
    TCEditWindow *openEditor(char *fileName, Boolean visible, EditorResume *res=NULL);

    void retrieveDesktop(const char *name);
    void saveDesktop(char *fName);
    void storeDesktop(fpstream& s);
    void loadDesktop(fpstream& s);
    void ShowUserScreen(TEvent &event);
    void createClipBoard(void);

    unsigned long deskTopVersion;

protected:

    virtual void fileOpen();
    void fileNew();
    void changeDir();
    virtual void dosShell();
    void showClip();
    void tile();
    void cascade();
};

extern TSetEditorApp *editorApp;
extern TCEditWindow *clipWindow;
#endif

#ifdef Uses_SETAppDialogs
ushort execDialog( TDialog *d, void *data );
TDialog *createFindDialog();
TDialog *createReplaceDialog();
unsigned doEditDialog( int dialog, ... );
TDialog *createSetLocalOptions();
TDialog *createGotoLineDialog();
TDialog *createSetGlobalOptions();
extern void executeCalc(char *startVal=NULL);
#endif

#ifdef Uses_SETAppVarious
extern TView *setFocusTo;
extern Boolean focusChanged;
extern void CopyHelp2Clip(char *b, long l);
extern void closeView(TView *p, void *p1);
#endif

#ifdef Uses_SETAppProject
extern void OpenProject(char *name=NULL);
extern void CloseProject(int openDesktop);
extern void SaveProject(void);
#endif

#ifdef Uses_SETAppFiles
extern int FileOpenDialog(char *title, char *file);
#define DeskTopFileName "tcedit.dst"
extern const char *cDeskTopFileName;
#define ProjectFileExt  ".epr"
#define DeskTopFileExt  ".dst"
extern int edTestForFile(const char *name);
#endif

#ifdef Uses_SETAppHelper
int SearchInHelper(int ,void *);
void AddNonEditorToHelper(TDskWin *p);
#endif

