#include <stdio.h>
#include <string.h>

#define Uses_TCEditor_Internal
#define Uses_TCEditor_External
#define Uses_TCEditor
#include <ceditor.h>

static stkHandler *ConvTable;

extern Boolean SETSECreateTables(strSETSE &st, int CaseSens,
                                 TNoCaseSOSStringCollection *TSC);

static void ReplaceCRby0(char *s)
{
 for (; *s && *s!='\n' && *s!='\r'; s++);
 *s=0;
}

static char *MoveAfterEqual(char *s)
{
 for (; *s && *s!='='; s++);
 if (*s) s++;
 for (; *s && isspace(*s); s++);
 return s;
}

static void GetUpTo(int len, char *s, char *d, int &l)
{
 for (l=0; *s && *s!='\n' && *s!='\r' && l<len; s++,l++) d[l]=*s;
}

static void FillTableWith(char *s, ushort *t, int mask)
{
 for (; *s && *s!='\n' && *s!='\r'; s++) t[*s]|=mask;
}

int SHLConvValToPos(int a)
{
 return ConvTable[a];
}

int SHLConvPosToVal(int a)
{
 int i=0;

 while (ConvTable[i]!=(unsigned)a) i++;
 return i;
}

static void PutInTables(int len, char *s, unsigned flag, ushort *Table, int Case)
{
 int i;

 if (len)
   {
    if (!Case)
      {
       for (i=0; i<len; i++)
           s[i]=toupper(s[i]);
       Table[tolower(*s)]|=flag;
      }
    Table[*s]|=flag;
   }
}

int LoadSyntaxHighLightFile(char *name, strSHL *&hl, SOStack &so,
                            TNoCaseSOSStringCollection *list,int &Cant)
{
 FILE *f;
 char b[maxSHLFileWidth];
 int  defs,def,end,i,isCase;
 char *pos,*s;

 Cant=0;
 if ((f=fopen(name,"rb"))==NULL)
    return 1;

 // Meassure the number of definitions
 for (defs=0; !feof(f); )
    {
     fgets(b,maxSHLFileWidth,f);
     if (!feof(f) && strncasecmp(b,"End",3)==0)
        defs++;
    }

 Cant=defs;
 if (!defs)
    return 2;

 // Allocate enough memory
 hl=new strSHL[defs];
 if (!hl)
    return 3;
 memset(hl,0,sizeof(strSHL)*defs);
 ConvTable=new stkHandler[defs];
 if (!ConvTable)
    return 3;

 // Load and parse all
 rewind(f);
 for (def=0; def<defs && !feof(f); def++)
    {
     hl[def].Keywords=new TNoCaseSOSStringCollection(84,12,&so);
     hl[def].PMacros=stkNULL;
     hl[def].PM=0;
     hl[def].Flags1=0;
     isCase=0;
     if (!hl[def].Keywords)
        return 3;
     for (i=0; i<256; i++)
         if (isalnum(i) || i=='_')
            hl[def].SymbolT[i]|=shl_INSNAME | shl_BEGNAME;
     do
       {
        do
          {
           fgets(b,maxSHLFileWidth,f);
          }
        while (*b=='#' || isspace(*b));

        if (strncasecmp(b,"Name",4)==0)
          {
           pos=MoveAfterEqual(b);
           ReplaceCRby0(pos);
           list->insert(ConvTable[def]=so.addStr(pos));
          }
        else
        if (strncasecmp(b,"Files",5)==0)
          {
           pos=MoveAfterEqual(b);
           ReplaceCRby0(pos);
           hl[def].Extentions=so.addStr(pos);
          }
        else
        if (strncasecmp(b,"OpenComment1",12)==0)
          {
           pos=MoveAfterEqual(b);
           GetUpTo(4,pos,hl[def].OpenCom1,hl[def].lOpenCom1);
           PutInTables(hl[def].lOpenCom1,hl[def].OpenCom1,shl_OPC1,hl[def].SymbolT,isCase);
          }
        else
        if (strncasecmp(b,"CloseComment1",13)==0)
          {
           pos=MoveAfterEqual(b);
           GetUpTo(4,pos,hl[def].CloseCom1,hl[def].lCloseCom1);
           PutInTables(hl[def].lCloseCom1,hl[def].CloseCom1,shl_CLOSE1,hl[def].SymbolT,isCase);
          }
        else
        if (strncasecmp(b,"OpenComment2",12)==0)
          {
           pos=MoveAfterEqual(b);
           GetUpTo(4,pos,hl[def].OpenCom2,hl[def].lOpenCom2);
           PutInTables(hl[def].lOpenCom2,hl[def].OpenCom2,shl_OPC2,hl[def].SymbolT,isCase);
          }
        else
        if (strncasecmp(b,"CloseComment2",13)==0)
          {
           pos=MoveAfterEqual(b);
           GetUpTo(4,pos,hl[def].CloseCom2,hl[def].lCloseCom2);
           PutInTables(hl[def].lCloseCom2,hl[def].CloseCom2,shl_CLOSE2,hl[def].SymbolT,isCase);
          }
        else
        if (strncasecmp(b,"EOLComment1",11)==0)
          {
           pos=MoveAfterEqual(b);
           GetUpTo(4,pos,hl[def].EOLCom1,hl[def].lEOLCom1);
           PutInTables(hl[def].lEOLCom1,hl[def].EOLCom1,shl_EOL,hl[def].SymbolT,isCase);
          }
        else
        if (strncasecmp(b,"EOLComment2",11)==0)
          {
           pos=MoveAfterEqual(b);
           GetUpTo(4,pos,hl[def].EOLCom2,hl[def].lEOLCom2);
           PutInTables(hl[def].lEOLCom2,hl[def].EOLCom2,shl_EOL,hl[def].SymbolT,isCase);
          }
        else
        if (strncasecmp(b,"HexMarker",9)==0)
          {
           pos=MoveAfterEqual(b);
           GetUpTo(4,pos,hl[def].HexStart,hl[def].lHexStart);
          }
        else
        if (strncasecmp(b,"Symbols1",8)==0)
          {
           pos=MoveAfterEqual(b);
           FillTableWith(pos,hl[def].SymbolT,shl_SYM1);
          }
        else
        if (strncasecmp(b,"Symbols2",8)==0)
          {
           pos=MoveAfterEqual(b);
           FillTableWith(pos,hl[def].SymbolT,shl_SYM2);
          }
        else
        if (strncasecmp(b,"String1",7)==0)
          {
           pos=MoveAfterEqual(b);
           FillTableWith(pos,hl[def].SymbolT,shl_STR1);
          }
        else
        if (strncasecmp(b,"String2",7)==0)
          {
           pos=MoveAfterEqual(b);
           FillTableWith(pos,hl[def].SymbolT,shl_STR2);
          }
        else
        if (strncasecmp(b,"Escape",6)==0)
          {
           pos=MoveAfterEqual(b);
           if (*pos && *pos!='\r' && *pos!='\r')
              hl[def].Escape=*pos;
          }
        else
        if (strncasecmp(b,"Preprocessor",12)==0)
          {
           pos=MoveAfterEqual(b);
           if (*pos && *pos!='\r' && *pos!='\r')
              hl[def].Preprocessor=*pos;
          }
        else
        if (strncasecmp(b,"Case",4)==0)
          {
           pos=MoveAfterEqual(b);
           if (*pos=='1')
             {
              isCase=1;
              hl[def].Flags1|=FG1_CaseSensitive;
             }
          }
        else
        if (strncasecmp(b,"UseInternal",11)==0)
          {
           int i;
           pos=MoveAfterEqual(b);
           i=atoi(pos);
           if (i<0 || i>3)
              i=0;
           TCEditor::SHLTableUse[i]=def;
           hl[def].UseInternal=i;
          }
        else
        if (strncasecmp(b,"Keywords",8)==0)
          {
           pos=MoveAfterEqual(b);
           end=0;
           while (!end)
             {
              for (s=pos; *s && *s!='\n' && *s!='\r' && *s!=','; s++);
              if (*s!=',')
                 end=1;
              if (s!=pos)
                {
                 *s=0;
                 hl[def].Keywords->insert(so.addStr(pos));
                }
              pos=s+1;
             }
          }
        else
        if (strncasecmp(b,"AllowedInsideNames",18)==0)
          {
           pos=MoveAfterEqual(b);
           FillTableWith(pos,hl[def].SymbolT,shl_INSNAME);
          }
        else
        if (strncasecmp(b,"CanStartAName",13)==0)
          {
           pos=MoveAfterEqual(b);
           FillTableWith(pos,hl[def].SymbolT,shl_BEGNAME);
          }
        else
        if (strncasecmp(b,"PMacros",7)==0)
          {
           pos=MoveAfterEqual(b);
           ReplaceCRby0(pos);
           hl[def].PMacros=so.addStr(pos);
          }
        else
        if (strncasecmp(b,"NoCheckNumbers",14)==0)
          {
           pos=MoveAfterEqual(b);
           if (*pos=='1')
              hl[def].Flags1|=FG1_NoNumbers;
          }
        else
        if (strncasecmp(b,"EOLCInFirstCol",14)==0)
          {
           pos=MoveAfterEqual(b);
           if (*pos=='1')
              hl[def].Flags1|=FG1_EOLCInFirstCol;
          }
       }
     while (!feof(f) && strncasecmp(b,"End",3)!=0);
    }
 fclose(f);

 for (def=0; def<defs; def++)
    {
     SETSECreateTables(hl[def].Search,hl[def].Flags1 & FG1_CaseSensitive,hl[def].Keywords);
     for (i=0; i<defs; i++)
         if ((stkHandler)list->at(i)==ConvTable[def])
           {
            ConvTable[def]=i;
            break;
           }
    }

 return 0;
}

static char *TakeExtention(char *file)
{
 char *s=file,*e=NULL;
 int wasExt=0;

 for (; *s; s++)
     if (*s=='/' || *s=='\\')
        wasExt=0;
     else
        if (*s=='.')
          {
           wasExt=1;
           e=s;
          }
 return wasExt ? e+1 : (char *)NULL;
}


static int IsInList(char *list, char *val)
{
 char buf[80];
 strncpy(buf,list,79); // Because strtok fucks the string

 char *tok=strtok(buf,",");

 while (tok)
   {
    if (strcmp(tok,val)==0)
       return 1;
    tok=strtok(NULL,",");
   }
 return 0;
}

#define MaxExtention 20
extern const char *GetVariable(const char *variable);

int SHLSelectByExtention(TCEditor &e)
{
 int i,found=0;
 char *ext=TakeExtention(e.fileName);
 char EnvName[MaxExtention+10];
 const char *v;

 e.SHLValueSelected=-1;
 if (ext==NULL)
    e.SetHighlightTo(shlNoSyntax);
 else
   {
    // Search if the user overwritten the roules with an envirom. var.
    if (strlen(ext)<MaxExtention)
      {
       strcpy(EnvName,"SET_SHL.");
       strcat(EnvName,ext);
       if ((v=GetVariable(EnvName))!=NULL)
         {
          for (i=0; i<e.SHLCant && !found; i++)
             {
              if (strcmp(e.SHLGenList->atStr(ConvTable[i]),(char *)v)==0)
                {
                 if (e.SHLArray[i].UseInternal)
                    e.SetHighlightTo((shlState)e.SHLArray[i].UseInternal);
                 else
                    e.SetHighlightTo(shlGenericSyntax,i);
                 e.SHLValueSelected=i;
                 found=1;
                }
             }
         }
      }
    // User defined
    for (i=0; i<e.SHLCant && !found; i++)
       {
        if (IsInList(e.SHLSOStack->GetStrOf(e.SHLArray[i].Extentions),ext))
          {
           if (e.SHLArray[i].UseInternal)
              e.SetHighlightTo((shlState)e.SHLArray[i].UseInternal);
           else
              e.SetHighlightTo(shlGenericSyntax,i);
           e.SHLValueSelected=i;
           found=1;
          }
       }
    if (!found)
       e.SetHighlightTo(shlNoSyntax);
   }
 return found;
}

PMacroStr *SHLSearchPMTrigger(char *trg);

