/************************** Keyboard Scan Codes *****************************/
/*
   German version, created by Christian Domp

   There are at least one key missing (that has a keycode) :
   the <,>,| key has keycode 86
   (the ^, key has no (german) keycode, with US-layout it is 41)

   problems : - some codes are not unique : openbrace == n8,
                                            closebrace == n9,
                                            tilde == asterisk
              - some keys don't return a keycode :
                                            CTRL 0,1,3,4,5,7,8,9
                                            (CTRL 2 and 6 work fine !?)
                                            `,^

   Note [by SET]: The following keys are not reported by BIOS in a US kbd:
   '`','1','4','5','7','8','9','0','=',';','\'',',','.','/'
                                            
   on a german keyboard there are up to 3 ascii codes assigned to one key :
   one normal, one with shift and one with AltGr (a special combination of
   Alt+Ctrl, the shiftstate for AltGr is 0x0808)

*/

#define ESC         1
#define N1          2
#define N2          3
#define N3          4
#define N4          5
#define N5          6
#define N6          7
#define N7          8
#define N8          9
#define N9          10
#define N0          11
#define MINUS       53		/* keycode 12 is ?,\,sz (Umlaut) */
#define EQUALS      11		/* keycode 13 can not be triggerd, the key
                                   is used to create french accents, the
                                   equal sign is shift 0 */
#define BACKSPACE   14
#define TAB         15
#define Q           16
#define W           17
#define E           18
#define R           19
#define T           20
#define Y           44		/* Y(ger)==Z(us) */
#define U           22
#define I           23
#define O           24
#define P           25
#define OPENBRACE   9		/* ( = shift 8, keycode 26 is u umlaut */
#define CLOSEBRACE  10          /* ) = shift 9, keycode 27 is +,*,~ */
#define ENTER       28
#define CTRL        29
#define A           30
#define S           31
#define D           32
#define F           33
#define G           34
#define H           35
#define J           36
#define K           37
#define L           38
#define COLON       51		/* keycode 39 is o umlaut */
#define QUOTE       43          /* keycode 40 is a umlaut */
#define TILDE       27          /* keycode 41 is ????????, tilde = AltGr + */
#define LSHIFT      42
#define Z           21		/* Z(ger)==Y(us) */
#define X           45
#define C           46
#define V           47
#define B           48
#define N           49
#define M           50
#define COMMA       51
#define STOP        52
#define SLASH       8		/* slash = shift 7, keycode 53 is -,_ */
#define RSHIFT      54
#define ASTERISK    27		/* * = Shift +, keycode 55 is ??????? */
#define ALT         56
#define SPACE       57
#define CAPSLOCK    58
#define F1          59
#define F2          60
#define F3          61
#define F4          62
#define F5          63
#define F6          64
#define F7          65
#define F8          66
#define F9          67
#define F10         68
#define NUMLOCK     69
#define SCRLOCK     70
#define HOME        71
#define UP          72
#define PGUP        73
#define MINUS_PAD   74
#define LEFT        75
#define PAD_5       76
#define RIGHT       77
#define PLUS_PAD    78
#define END         79
#define DOWN        80
#define PGDN        81
#define INSERT      82
#define DEL         83
#define F11        133
#define F12        134
#define MACRO      111		/* which key is this ?????? */


