/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
#include <rhide.h>

#define Uses_tvutilFunctions
#include <libtvuti.h>

#include <string.h>

#if 0

void AbsToRelPath(char *ref_path,char *& ret)
{
  if (!ref_path || !*ref_path) return;
  char *tmp=ref_path,*temp,*t;
  FExpand(ret);
  /* This is the most case */
  temp = strstr(ret,ref_path);
  if (temp && temp == ret)
  {
    temp += strlen(ref_path);
    // here is a sample: compare o:/rhide/test1 with o:/rhide/test
    if (*temp == '/' || *temp == 0)
    {
      /* When comparing s:/rhide with s:/rhide/ideutil.cc we will get /ideutil.cc
         but when comparing s:/ with s:/ideutil.cc we will get ideutil.cc */
      if (*temp == '/') temp++;
      string_free(ret);
      string_dup(ret,temp);
      return;
    }
  }
  // now the specail case, that ref_path is part of ret
  temp = strstr(ref_path,ret);
  if (temp && temp == ref_path)
  {
    temp += strlen(ret);
    if (*temp == '/' || *temp == 0)
    {
      if (*temp == '/') temp++;
      string_free(ret);
      string_dup(ret,"..");
      while ( (temp = strchr(temp,'/')) != NULL)
      {
        string_cat(ret,"/..");
        temp++;
      }
      return;
    }
  }
  temp = ret;
  while (*tmp && *temp && *tmp == *temp)
  {
    temp++;
    tmp++;
  }
  if (tmp == ref_path) return;
  if (!*tmp && *temp == '/')
  {
    string_dup(tmp,temp+1);
    string_free(ret);
    ret = tmp;
    return;
  }
  tmp--;
  temp--;
  while (*tmp != '/')
  {
    tmp--;
    temp--;
  }
  tmp++;
  temp++;
  string_dup(t,"../");
  while ( (tmp = strchr(tmp,'/')) != NULL)
  {
    string_cat(t,"../");
    tmp++;
  }
  string_cat(t,temp);
  string_free(ret);
  ret = t;
}

#else

/*
  This functions makes ret_path relative to ref_path
  It assumes that ref_path is an absolute path which can
  optionally have a slash appended
*/

void AbsToRelPath(char *ref_path,char *& ret_path)
{
  char *ref = ref_path;
  char *ret;
  char *ret_val;
  // Just in case, that ret_pat is not absolute, make it now absolute
  // relative to the current directory
  if (!ref_path || !*ref_path) return;
#if 0
/* I hope, I can assume that this is called only with an absolute
   name ret_path */
  FExpand(ret_path);
#endif
  ret = ret_path;
  while (*ret && *ret == *ref)
  {
    ret++;
    ref++;
  }
  // total different
  if (ret == ret_path)
    return;
  // ref is part of ret
  if (!*ref)
  {
    // they are equal (can happen only when comparing directories)
    if (!*ret)
    {
      string_free(ret_path);
      string_dup(ret_path,"");
      return;
    }
    // ref is completely a directory part of ret
    if (*ret == '/' || ref[-1] == '/' /* ref had a slash as last char */)
    {
      // do no copy the slash
      if (*ret == '/') ret++;
      string_dup(ret_val,ret);
      string_free(ret_path);
      ret_path = ret_val;
      return;
    }
    // ref was only a sub_string of ret
    while (*ret != '/')
    {
      ret--;
      ref--;
    }
    ret++;
    ref++;
  }
  // ret is part of ref
  if (!*ret)
  {
    // ret is completely a directoy part of ref
    if (*ref == '/')
    {
      ref++;
      string_dup(ret_val,"..");
      while ((ref = strchr(ref,'/')) != NULL)
      {
        ref++;
        string_cat(ret_val,"/..");
      }
      string_free(ret_path);
      ret_path = ret_val;
      return;
    }
    // ret was simply a substring of ref
    while (*ret != '/')
    {
      ref--;
      ret--;
    }
    ref++;
    ret++;
  }
  while (*ref != '/' || *ret != '/')
  {
    ref--;
    ret--;
  }
  ref++;
  ret++;
  string_dup(ret_val,"..");
  while ((ref = strchr(ref,'/')) != NULL)
  {
    string_cat(ret_val,"/..");
    ref++;
  }
  if (*ret)
  {
    string_cat(ret_val,"/");
    string_cat(ret_val,ret);
  }
  string_free(ret_path);
  ret_path = ret_val;
}

#endif

#ifdef TEST

int main(int argc,char *argv[])
{
  char *ref;
  char *ret;
  if (argc < 3) return -1;
  string_dup(ref,argv[1]);
  string_dup(ret,argv[2]);
  printf("%s relative to %s is ",ret,ref);
  AbsToRelPath(ref,ret);
  printf("%s\n",ret);
  return 0;
}

#endif

