/*    EPZip - the simple free distribution preparing tool
**    Copyright (C) 1997  Esa Peuha

**    This program is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation; either version 2 of the License, or
**    (at your option) any later version.

**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.

**    You should have received a copy of the GNU General Public License
**    along with this program; if not, write to the Free Software
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

struct file_el
{
  FILE *fp;
  unsigned int elements;
};

/* in epzip.c */

/* in process_file.c */

void begin_process(FILE *);
void process_file(FILE *, char *);
void end_process(FILE *);

/* in crc.c */

void initialize_crc(void);
unsigned int get_crc(char *, unsigned int);
void terminate_crc(void);

/* in deflate.c */

void deflate(char *, char **, unsigned int, unsigned int *);

/* in substitute.c */

void substitute(char *, unsigned int, struct file_el *);

/* in codify.c */

FILE *codify(struct file_el *);

/* in bit_io.c */

void bwrite_begin(FILE *);
void bwrite(unsigned int, unsigned char);
void bwrite_end(void);
void bread_begin(FILE *);
unsigned int bread(unsigned char);
void bread_end(void);
