/* z.c v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "effects.h"
/*---------------------------------------------------------------------------*/
/* #define */
#define Z_DELAY_MIN 0
#define Z_DELAY_MAX 3000
#define Z_DELAY_STEP 100

#define Z_SORT_MIN 0
#define Z_SORT_MAX 10
#define Z_SORT_STEP 1
/*---------------------------------------------------------------------------*/
/* variables */
long z_delay = Z_DELAY_MIN;
int z_sort = Z_SORT_MIN;

static tkeyparse
  see_f10_0 = {K_0, keysee_f10_0}, /* z.c specific */
  see_f10_1 = {K_1, keysee_f10_1},
  see_f10_2 = {K_2, keysee_f10_2},
  see_f10_3 = {K_3, keysee_f10_3},
  see_f10_4 = {K_4, keysee_f10_4},
  see_f10_5 = {K_5, keysee_f10_5},
  see_f10_6 = {K_6, keysee_f10_6},
  see_f10_7 = {K_7, keysee_f10_7},
  see_f10_8 = {K_8, keysee_f10_8},
  see_f10_9 = {K_9, keysee_f10_9},
  see_f10_d = {K_d, keysee_f10_d},
  see_f10_D = {K_D, keysee_f10_D},
  see_f10_s = {K_s, keysee_f10_s},
  see_f10_S = {K_S, keysee_f10_S}
;

tkeyparse* tkeyparsetbl_z[] =
{
  TKEYPARSETBL_SEE, /* see.c specific */
  &see_f10_0, /* z.c specific */
  &see_f10_1,
  &see_f10_2,
  &see_f10_3,
  &see_f10_4,
  &see_f10_5,
  &see_f10_6,
  &see_f10_7,
  &see_f10_8,
  &see_f10_9,
  &see_f10_d,
  &see_f10_D,
  &see_f10_s,
  &see_f10_S,
  NULL
};
/*---------------------------------------------------------------------------*/
/* prototypes */
void pbleed(int x, int y, BITMAP *apbmp, int adelay, int dropletwidth, int masked);
void pdospiral(int count1, int count2, int x, int y, BITMAP *apbmp, int spiralwidth, int adelay, int masked);
void poverwritezap(int x, int y, BITMAP *apbmp, int adelay, int masked);
void ppushzap(int x, int y, BITMAP *apbmp, int adelay);
void pshake(int x, int y, BITMAP *apbmp, int maxshake, int numshake, int adelay, int masked);
void pspiralin(int x, int y, BITMAP *apbmp, int spiralwidth, int adelay, int masked);
void pspiralout(int x, int y, BITMAP *apbmp, int spiralwidth, int adelay, int masked);
void pwipebottomtotop(int x, int y, BITMAP *apbmp, int adelay, int masked);
void pwipefromcentrehorizontally(int x, int y, BITMAP *apbmp, int adelay, int masked);
void pwipefromcentrevertically(int x, int y, BITMAP *apbmp, int adelay, int masked);
void pwipelefttoright(int x, int y, BITMAP *apbmp, int adelay, int masked);
void pwiperighttoleft(int x, int y, BITMAP *apbmp, int adelay, int masked);
void pwipetocentrehorizontally(int x, int y, BITMAP *apbmp, int adelay, int masked);
void pwipetocentrevertically(int x, int y, BITMAP *apbmp, int adelay, int masked);
void pwipetoptobottom(int x, int y, BITMAP *apbmp, int adelay, int masked);
/*---------------------------------------------------------------------------*/
void bleed()
{
  pbleed(0, 0, pbmp, 10, 2, FALSE);
  rest(z_delay);
  clear(screen);
  key_scan();
}
/*---------------------------------------------------------------------------*/
void flip()
{
  draw_sprite(screen, pbmp, 0, 0);
  rest(z_delay);
  draw_sprite_v_flip(screen, pbmp, 0, 0);
  rest(z_delay);
  draw_sprite_vh_flip(screen, pbmp, 0, 0);
  rest(z_delay);
  draw_sprite_h_flip(screen, pbmp, 0, 0);
  rest(z_delay);
  key_scan();
}
/*---------------------------------------------------------------------------*/
void keysee_f10_0()
{
  int pi;
  char **tps;

  tps = get_config_argv("[See]", "f10_0", &pi);
  z_delay = atoi(tps[1]);
  z_sort = atoi(tps[2]);
  z();
}
/*---------------------------------------------------------------------------*/
void keysee_f10_1()
{
  int pi;
  char **tps;

  tps = get_config_argv("[See]", "f10_1", &pi);
  z_delay = atoi(tps[1]);
  z_sort = atoi(tps[2]);
  z();
}
/*---------------------------------------------------------------------------*/
void keysee_f10_2()
{
  int pi;
  char **tps;

  tps = get_config_argv("[See]", "f10_2", &pi);
  z_delay = atoi(tps[1]);
  z_sort = atoi(tps[2]);
  z();
}
/*---------------------------------------------------------------------------*/
void keysee_f10_3()
{
  int pi;
  char **tps;

  tps = get_config_argv("[See]", "f10_3", &pi);
  z_delay = atoi(tps[1]);
  z_sort = atoi(tps[2]);
  z();
}
/*---------------------------------------------------------------------------*/
void keysee_f10_4()
{
  int pi;
  char **tps;

  tps = get_config_argv("[See]", "f10_4", &pi);
  z_delay = atoi(tps[1]);
  z_sort = atoi(tps[2]);
  z();
}
/*---------------------------------------------------------------------------*/
void keysee_f10_5()
{
  int pi;
  char **tps;

  tps = get_config_argv("[See]", "f10_5", &pi);
  z_delay = atoi(tps[1]);
  z_sort = atoi(tps[2]);
  z();
}
/*---------------------------------------------------------------------------*/
void keysee_f10_6()
{
  int pi;
  char **tps;

  tps = get_config_argv("[See]", "f10_6", &pi);
  z_delay = atoi(tps[1]);
  z_sort = atoi(tps[2]);
  z();
}
/*---------------------------------------------------------------------------*/
void keysee_f10_7()
{
  int pi;
  char **tps;

  tps = get_config_argv("[See]", "f10_7", &pi);
  z_delay = atoi(tps[1]);
  z_sort = atoi(tps[2]);
  z();
}
/*---------------------------------------------------------------------------*/
void keysee_f10_8()
{
  int pi;
  char **tps;

  tps = get_config_argv("[See]", "f10_8", &pi);
  z_delay = atoi(tps[1]);
  z_sort = atoi(tps[2]);
  z();
}
/*---------------------------------------------------------------------------*/
void keysee_f10_9()
{
  int pi;
  char **tps;

  tps = get_config_argv("[See]", "f10_9", &pi);
  z_delay = atoi(tps[1]);
  z_sort = atoi(tps[2]);
  z();
}
/*---------------------------------------------------------------------------*/
void keysee_f10_d()
{
  paralong(&z_delay, Z_DELAY_MIN, Z_DELAY_MAX, Z_DELAY_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f10_D()
{
  paralong(&z_delay, Z_DELAY_MIN, Z_DELAY_MAX, Z_DELAY_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f10_s()
{
  paraint(&z_sort, Z_SORT_MIN, Z_SORT_MAX, Z_SORT_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f10_S()
{
  paraint(&z_sort, Z_SORT_MIN, Z_SORT_MAX, Z_SORT_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void pbleed(int x, int y, BITMAP *apbmp, int adelay, int dropletwidth, int masked)
{
  int *counter, i, j, k, l, loopcheck, m;

  counter = malloc(apbmp->w * sizeof(int));
  assert(counter);

  if (dropletwidth < 1)
    {
      dropletwidth = 1;
    }
  while (apbmp->w % dropletwidth)
    {
      dropletwidth--;
    }
  for (i = apbmp->w / dropletwidth; i--;)
    {
      counter[i] = 1;
    }
  do
    {
      loopcheck = TRUE;
      for (i = (apbmp->w / dropletwidth); i--;)
	{
	  j = random0tm(10) + 1;
	  if (j + counter[i] > apbmp->h)
	    {
	      j = apbmp->h - counter[i];
	    }
	  for (k = counter[i] - 1; k < counter[i] + j; k++)
	    {
	      for (l = dropletwidth; l--;)
		{
		  m = apbmp->line[k][i * dropletwidth + l];
		  if ((m) || (!masked))
		    {
		      putpixel(screen, i * dropletwidth + l + x, k + y, m);
		    }
		}
	    }
	  counter[i] += j;
	  if (counter[i] < apbmp->h)
	    {
	      loopcheck = FALSE;
	    }
	}
      delay(adelay);
    }
  while (!loopcheck);
  free(counter);
  counter = NULL;
}
/*---------------------------------------------------------------------------*/
void pdospiral(int count1, int count2, int x, int y, BITMAP *apbmp, int spiralwidth, int adelay, int masked)
{
  int i, j, k;

  for (i = 0; i < apbmp->w / spiralwidth; i++)
    {
      for (j = 0; j < apbmp->h / spiralwidth; j++)
	{
	  k = apbmp->line[j * spiralwidth + count1][i * spiralwidth + count2];
	  if ((k) || (!masked))
	    {
	      putpixel(screen, i * spiralwidth + count2 + x, j * spiralwidth + count1 + y, k);
	    }
	}
    }
  delay(adelay);
}
/*---------------------------------------------------------------------------*/
void poverwritezap(int x, int y, BITMAP *apbmp, int adelay, int masked)
{
  int ax, i, j, k;

  for (i = 0; i < apbmp->w; i++)
    {
      for (j = apbmp->h; j--;)
	{
	  if (j % 2 == 0)
	    {
	      ax = i;
	    }
	  else
	    {
	      ax = apbmp->w - i - 1;
	    }
	  k = apbmp->line[j][ax];
	  if ((k) || (!masked))
	    {
	      putpixel(screen, x + ax, y + j, k);
	    }
	}
      delay(adelay);
    }
}
/*---------------------------------------------------------------------------*/
void ppushzap(int x, int y, BITMAP *apbmp, int adelay)
{
  int i, j;

  while (apbmp->w % adelay)
    {
      adelay--;
    }
  for (i = 1; i <= apbmp->w / adelay; i++)
    {
      for (j = 1; j <= apbmp->h / 2; j++)
	{
	  blit(screen, screen, x, y + j * 2 - 1, x + adelay, y + j * 2 - 1, apbmp->w - adelay,1);
	  blit(apbmp, screen, apbmp->w - (i * adelay), j * 2 - 1, x, y + j * 2 - 1, adelay, 1);
	}
      for (j = 1; j <= apbmp->h / 2; j++)
	{
	  blit(screen, screen, x + adelay, y + j * 2 - 2, x, y + j * 2 - 2, apbmp->w - adelay,1);
	  blit(apbmp, screen, (i - 1) * adelay, j * 2 - 2, x + apbmp->w - adelay, y + j * 2 - 2,
	       adelay, 1);
	}
    }
}
/*---------------------------------------------------------------------------*/
void pshake(int x, int y, BITMAP *apbmp, int maxshake, int numshake, int adelay, int masked)
{
  int i, xshake, yshake;
  BITMAP *pbmpbuffer, *pbmpoldscreen;

  pbmpbuffer = NULL;
  x -= maxshake;
  y -= maxshake;
  maxshake *= 2;
  pbmpoldscreen = create_bitmap(apbmp->w + maxshake, apbmp->h + maxshake);
  blit(screen, pbmpoldscreen, x, y, 0, 0, pbmpoldscreen->w, pbmpoldscreen->h);
  if (masked)
    {
      pbmpbuffer = create_bitmap(apbmp->w + maxshake, apbmp->h + maxshake);
    }
  maxshake--;
  xshake = (maxshake + 1) / 2; /* centre it */
  yshake = (maxshake + 1) / 2;
  for (i = numshake; i--;)
    {
      if (!i)
	{
	  xshake = (maxshake + 1) / 2; /* centre it again */
	  yshake = (maxshake + 1) / 2;
	}
      if (masked)
	{
	  blit(pbmpoldscreen, pbmpbuffer, 0, 0, 0, 0, pbmpoldscreen->w, pbmpoldscreen->h);
	  draw_sprite(pbmpbuffer, apbmp, xshake, yshake);
	  blit(pbmpbuffer, screen, 0, 0, x, y, pbmpbuffer->w, pbmpbuffer->h);
	}
      else
	{
	  blit(pbmpoldscreen, screen, 0, 0, x, y, pbmpoldscreen->w, pbmpoldscreen->h);
	  blit(apbmp, screen, 0, 0, x + xshake, y + yshake, apbmp->w, apbmp->h);
	}
      delay(adelay);
      xshake = random0tm(maxshake);
      yshake = random0tm(maxshake);
    }
  destroy_bitmap(pbmpoldscreen);
  if (masked)
    {
      destroy_bitmap(pbmpbuffer);
    }
}
/*---------------------------------------------------------------------------*/
void pspiralin(int x, int y, BITMAP *apbmp, int spiralwidth, int adelay, int masked)
{
  int i, j;

  while ((apbmp->w % spiralwidth) || (apbmp->h % spiralwidth))
    {
      spiralwidth--;
    }
  if (spiralwidth == 1)
    {
      blit(apbmp, screen, 0, 0, x, y, apbmp->w, apbmp->h);
    }
  for (i = 0; i < spiralwidth / 2; i++)
    {
      for (j = i; j < spiralwidth - i; j++)
	{
	  pdospiral(i, j, x, y, apbmp, spiralwidth, adelay, masked);
	}
      for (j = i; j < spiralwidth - i; j++)
	{
	  pdospiral(j, spiralwidth - i - 1, x, y, apbmp, spiralwidth, adelay, masked);
	}
      for (j = spiralwidth - i - 1; j >= i; j--)
	{
	  pdospiral(spiralwidth - i - 1, j, x, y, apbmp, spiralwidth, adelay, masked);
	}
      for (j = spiralwidth - i - 1; j >= i; j--)
	{
	  pdospiral(j, i, x, y, apbmp, spiralwidth, adelay, masked);
	}
    }
}
/*---------------------------------------------------------------------------*/
void pspiralout(int x, int y, BITMAP *apbmp, int spiralwidth, int adelay, int masked)
{
  int i, j;

  while ((apbmp->w % spiralwidth) || (apbmp->h % spiralwidth))
    {
      spiralwidth--;
    }
  if (spiralwidth == 1)
    {
      blit(apbmp, screen, 0, 0, x, y, apbmp->w, apbmp->h);
    }
  for (i = (spiralwidth / 2) - 1; i >= 0; i--)
    {
      for (j = i + 1; j < spiralwidth - i; j++)
	{
	  pdospiral(i, j, x, y, apbmp, spiralwidth, adelay, masked);
	}
      for (j = i; j < spiralwidth - i; j++)
	{
	  pdospiral(j, spiralwidth - i - 1, x, y, apbmp, spiralwidth, adelay, masked);
	}
      for (j = spiralwidth - i - 1; j >= i; j--)
	{
	  pdospiral(spiralwidth - i - 1, j, x, y, apbmp, spiralwidth, adelay, masked);
	}
      for (j = spiralwidth - i - 1; j >= i; j--)
	{
	  pdospiral(j, i, x, y, apbmp, spiralwidth, adelay, masked);
	}
    }
}
/*---------------------------------------------------------------------------*/
void pwipebottomtotop(int x, int y, BITMAP *apbmp, int adelay, int masked)
{
  int i, j, k;

  for (j = apbmp->h; j--;)
    {
      for (i = apbmp->w; i--;)
	{
	  k = apbmp->line[j][i];
	  if ((k) || (!masked))
	    {
	      putpixel(screen, i + x, j + y, k);
	    }
	}
      delay(adelay);
    }
}
/*---------------------------------------------------------------------------*/
void pwipefromcentrehorizontally(int x, int y, BITMAP *apbmp, int adelay, int masked)
{
  int i, j, jtarget, k, oddflag;

  jtarget = apbmp->w / 2;
  oddflag = 0;
  if (apbmp->w % 2)
    {
      jtarget++;
      oddflag = 1;
    }
  for (j = jtarget; j--;)
    {
      for (i = apbmp->h; i--;)
	{
	  k = apbmp->line[i][j];
	  if ((k) || (!masked))
	    {
	      putpixel(screen, j + x, i + y, k);
	    }
	}
      if ((j) || (!oddflag))
	{
	  for (i = apbmp->h; i--;)
	    {
	      k = apbmp->line[i][apbmp->w - j - 1];
	      if ((k) || (!masked))
		{
		  putpixel(screen, apbmp->w - j - 1 + x, i + y, k);
		}
	    }
	}
      delay(adelay);
    }
}
/*---------------------------------------------------------------------------*/
void pwipefromcentrevertically(int x, int y, BITMAP *apbmp, int adelay, int masked)
{
  int i, j, k, jtarget, oddflag;

  jtarget = apbmp->h / 2;
  oddflag = 0;
  if (apbmp->h % 2)
    {
      jtarget++;
      oddflag = 1;
    }
  for (j = jtarget; j--;)
    {
      for (i = apbmp->w; i--;)
	{
	  k = apbmp->line[j][i];
	  if ((k) || (!masked))
	    {
	      putpixel(screen, i + x, j + y, k);
	    }
	}
      if ((j) || (!oddflag))
	{
	  for (i = apbmp->w; i--;)
	    {
	      k = apbmp->line[apbmp->h - j - 1][i];
	      if ((k) || (!masked))
		{
		  putpixel(screen, i + x, apbmp->h - j - 1 + y, k);
		}
	    }
	}
      delay(adelay);
    }
}
/*---------------------------------------------------------------------------*/
void pwipelefttoright(int x, int y, BITMAP *apbmp, int adelay, int masked)
{
  int i, j, k;

  for (i = 0; i < apbmp->w; i++)
    {
      for (j = apbmp->h; j--;)
	{
	  k = apbmp->line[j][i];
	  if ((k) || (!masked))
	    {
	      putpixel(screen, i + x, j + y, k);
	    }
	}
      delay(adelay);
    }
}
/*---------------------------------------------------------------------------*/
void pwiperighttoleft(int x, int y, BITMAP *apbmp, int adelay, int masked)
{
  int i, j, k;

  for (i = apbmp->w; i--;)
    {
      for (j = apbmp->h; j--;)
	{
	  k = apbmp->line[j][i];
	  if ((k) || (!masked))
	    {
	      putpixel(screen, i + x, j + y, k);
	    }
	}
      delay(adelay);
    }
}
/*---------------------------------------------------------------------------*/
void pwipetocentrehorizontally(int x, int y, BITMAP *apbmp, int adelay, int masked)
{
  int i, j, k, jtarget, oddflag;

  jtarget = apbmp->w / 2;
  oddflag = 0;

  if (apbmp->w % 2)
    {
      jtarget++;
      oddflag = 1;
    }
  for (j = 0; j < jtarget; j++)
    {
      for (i = apbmp->h; i--;)
	{
	  k = apbmp->line[i][j];
	  if ((k) || (!masked))
	    {
	      putpixel(screen, j + x, i + y, k);
	    }
	}
      if ((j) || (!oddflag))
	{
	  for (i = apbmp->h; i--;)
	    {
	      k = apbmp->line[i][apbmp->w - j - 1];
	      if ((k) || (!masked))
		{
		  putpixel(screen, apbmp->w - j - 1 + x, i + y, k);
		}
	    }
	}
      delay(adelay);
    }
}
/*---------------------------------------------------------------------------*/
void pwipetocentrevertically(int x, int y, BITMAP *apbmp, int adelay, int masked)
{
  int i, j, jtarget, k, oddflag;

  jtarget = apbmp->h / 2;
  oddflag = 0;

  if (apbmp->h % 2)
    {
      jtarget++;
      oddflag = 1;
    }
  for (j = 0; j < jtarget; j++)
    {
      for (i = apbmp->w; i--;)
	{
	  k = apbmp->line[j][i];
	  if ((k) || (!masked))
	    {
	      putpixel(screen, i + x, j + y, k);
	    }
	}
      if ((j) || (!oddflag))
	{
	  for (i = apbmp->w; i--;)
	    {
	      k = apbmp->line[apbmp->h - j - 1][i];
	      if ((k) || (!masked))
		{
		  putpixel(screen, i + x, apbmp->h - j - 1 + y, k);
		}
	    }
	}
      delay(adelay);
    }
}
/*---------------------------------------------------------------------------*/
void pwipetoptobottom(int x, int y, BITMAP *apbmp, int adelay, int masked)
{
  int i, j, k;

  for (j = 0; j < apbmp->h; j++)
    {
      for (i = apbmp->w; i--;)
	{
	  k = apbmp->line[j][i];
	  if ((k) || (!masked))
	    {
	      putpixel(screen, i + x, j + y, k);
	    }
	}
      delay(adelay);
    }
}
/*---------------------------------------------------------------------------*/
void shaker()
{
  pshake(0, 0, pbmp, 10, 20, 100, FALSE);
  key_scan();
}
/*---------------------------------------------------------------------------*/
void spiral()
{
  pspiralin(0, 0, pbmp, 10, 5, FALSE);
  rest(z_delay);
  clear(screen);
  pspiralout(0, 0, pbmp, 10, 5, FALSE);
  rest(z_delay);
  clear(screen);
  key_scan();
}
/*---------------------------------------------------------------------------*/
void twist()
{
  draw_sprite(screen, pbmp, 0, 0);
  rest(z_delay);
  draw_sprite_h_flip(screen, pbmp, 0, 0);
  rest(z_delay);
  key_scan();
}
/*---------------------------------------------------------------------------*/
void wiperh()
{
  pwipelefttoright(0, 0, pbmp, 1, FALSE);
  rest(z_delay);
  clear(screen);
  pwiperighttoleft(0, 0, pbmp, 1, FALSE);
  rest(z_delay);
  clear(screen);
  key_scan();
}
/*---------------------------------------------------------------------------*/
void wiperh2()
{
  pwipetocentrevertically(0, 0, pbmp, 1, FALSE);
  rest(z_delay);
  clear(screen);
  pwipefromcentrevertically(0, 0, pbmp, 1, FALSE);
  rest(z_delay);
  clear(screen);
  key_scan();
}
/*---------------------------------------------------------------------------*/
void wiperv()
{
  pwipetoptobottom(0, 0, pbmp, 1, FALSE);
  rest(z_delay);
  clear(screen);
  pwipebottomtotop(0, 0, pbmp, 1, FALSE);
  rest(z_delay);
  clear(screen);
  key_scan();
}
/*---------------------------------------------------------------------------*/
void wiperv2()
{
  pwipetocentrehorizontally(0, 0, pbmp, 1, FALSE);
  rest(z_delay);
  clear(screen);
  pwipefromcentrehorizontally(0, 0, pbmp, 1, FALSE);
  rest(z_delay);
  clear(screen);
  key_scan();
}
/*---------------------------------------------------------------------------*/
void z()
{
  lastkey = K_d;
  clear(screen);
  do
    {
      ptkeyparsetbl = tkeyparsetbl_z;

      switch (z_sort)
	{
	case 0:
	  bleed();
	  break;
	case 1:
	  flip();
	  break;
	case 2:
	  shaker();
	  break;
	case 3:
	  spiral();
	  break;
	case 4:
	  wiperh();
	  break;
	case 5:
	  wiperh2();
	  break;
	case 6:
	  wiperv();
	  break;
	case 7:
	  wiperv2();
	  break;
	case 8:
	  twist();
	  break;
	case 9:
	  zap();
	  break;
	default:
	  break;
	}
      key_scan();
    }
  while ((lastkey == K_d) || (lastkey == K_D) ||
	 (lastkey == K_s) || (lastkey == K_S));
  if (lastkey == K_ESC)
    {
      esc_hit = 1;
    }
}
/*---------------------------------------------------------------------------*/
void zap()
{
  ppushzap(0, 0, pbmp, 8);
  rest(z_delay);
  clear(screen);
  poverwritezap(0, 0, pbmp, 1, FALSE);
  rest(z_delay);
  clear(screen);
  key_scan();
}
